/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.modelling.productfactory;

import java.time.LocalDate;
import net.finmath.marketdata.products.AnalyticProduct;
import net.finmath.marketdata.products.Swap;
import net.finmath.marketdata.products.SwapLeg;
import net.finmath.modelling.DescribedProduct;
import net.finmath.modelling.InterestRateProductDescriptor;
import net.finmath.modelling.ProductDescriptor;
import net.finmath.modelling.ProductFactory;
import net.finmath.modelling.descriptor.InterestRateSwapLegProductDescriptor;
import net.finmath.modelling.descriptor.InterestRateSwapProductDescriptor;

public class InterestRateAnalyticProductFactory
implements ProductFactory<InterestRateProductDescriptor> {
    private final LocalDate referenceDate;

    public InterestRateAnalyticProductFactory(LocalDate referenceDate) {
        this.referenceDate = referenceDate;
    }

    @Override
    public DescribedProduct<? extends InterestRateProductDescriptor> getProductFromDescriptor(ProductDescriptor descriptor) {
        if (descriptor instanceof InterestRateSwapLegProductDescriptor) {
            InterestRateSwapLegProductDescriptor swapLeg = (InterestRateSwapLegProductDescriptor)descriptor;
            SwapLeg product = new SwapLeg(swapLeg.getLegScheduleDescriptor().getSchedule(this.referenceDate), swapLeg.getForwardCurveName(), swapLeg.getNotionals(), swapLeg.getSpreads(), swapLeg.getDiscountCurveName(), swapLeg.isNotionalExchanged());
            return product;
        }
        if (descriptor instanceof InterestRateSwapProductDescriptor) {
            InterestRateSwapProductDescriptor swap = (InterestRateSwapProductDescriptor)descriptor;
            InterestRateProductDescriptor legDescriptor = swap.getLegReceiver();
            AnalyticProduct legReceiver = (AnalyticProduct)((Object)this.getProductFromDescriptor(legDescriptor));
            legDescriptor = swap.getLegPayer();
            AnalyticProduct legPayer = (AnalyticProduct)((Object)this.getProductFromDescriptor(legDescriptor));
            Swap product = new Swap(legReceiver, legPayer);
            return product;
        }
        String name = descriptor.name();
        throw new IllegalArgumentException("Unsupported product type " + name);
    }
}

