/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.modelling.productfactory;

import java.time.LocalDate;
import java.util.Arrays;
import java.util.function.DoubleFunction;
import net.finmath.exception.CalculationException;
import net.finmath.modelling.DescribedProduct;
import net.finmath.modelling.InterestRateProductDescriptor;
import net.finmath.modelling.ProductDescriptor;
import net.finmath.modelling.ProductFactory;
import net.finmath.modelling.descriptor.InterestRateSwapLegProductDescriptor;
import net.finmath.modelling.descriptor.InterestRateSwapProductDescriptor;
import net.finmath.modelling.descriptor.InterestRateSwaptionProductDescriptor;
import net.finmath.montecarlo.RandomVariableFromDoubleArray;
import net.finmath.montecarlo.interestrate.TermStructureMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.montecarlo.interestrate.products.SwapLeg;
import net.finmath.montecarlo.interestrate.products.TermStructureMonteCarloProduct;
import net.finmath.montecarlo.interestrate.products.components.Notional;
import net.finmath.montecarlo.interestrate.products.components.NotionalFromConstant;
import net.finmath.montecarlo.interestrate.products.components.Option;
import net.finmath.montecarlo.interestrate.products.indices.AbstractIndex;
import net.finmath.montecarlo.interestrate.products.indices.LIBORIndex;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.FloatingpointDate;
import net.finmath.time.Schedule;

public class InterestRateMonteCarloProductFactory
implements ProductFactory<InterestRateProductDescriptor> {
    private final LocalDate referenceDate;

    public InterestRateMonteCarloProductFactory(LocalDate referenceDate) {
        this.referenceDate = referenceDate;
    }

    @Override
    public DescribedProduct<? extends InterestRateProductDescriptor> getProductFromDescriptor(ProductDescriptor descriptor) {
        if (descriptor instanceof InterestRateSwapLegProductDescriptor) {
            InterestRateSwapLegProductDescriptor swapLeg = (InterestRateSwapLegProductDescriptor)descriptor;
            SwapLegMonteCarlo product = new SwapLegMonteCarlo(swapLeg, this.referenceDate);
            return product;
        }
        if (descriptor instanceof InterestRateSwapProductDescriptor) {
            InterestRateSwapProductDescriptor swap = (InterestRateSwapProductDescriptor)descriptor;
            SwapMonteCarlo product = new SwapMonteCarlo(swap, this.referenceDate);
            return product;
        }
        if (descriptor instanceof InterestRateSwaptionProductDescriptor) {
            InterestRateSwaptionProductDescriptor swaption = (InterestRateSwaptionProductDescriptor)descriptor;
            SwaptionPhysicalMonteCarlo product = new SwaptionPhysicalMonteCarlo(swaption, this.referenceDate);
            return product;
        }
        String name = descriptor.name();
        throw new IllegalArgumentException("Unsupported product type " + name);
    }

    private static AbstractIndex constructLiborIndex(String forwardCurveName, Schedule schedule) {
        if (forwardCurveName != null) {
            double fixingOffset = 0.0;
            double periodLength = 0.0;
            for (int i = 0; i < schedule.getNumberOfPeriods(); ++i) {
                fixingOffset *= (double)i / (double)(i + 1);
                fixingOffset += (schedule.getPeriodStart(i) - schedule.getFixing(i)) / (double)(i + 1);
                periodLength *= (double)i / (double)(i + 1);
                periodLength += schedule.getPeriodLength(i) / (double)(i + 1);
            }
            return new LIBORIndex(forwardCurveName, fixingOffset, periodLength);
        }
        return null;
    }

    public static class SwaptionPhysicalMonteCarlo
    extends AbstractLIBORMonteCarloProduct
    implements DescribedProduct<InterestRateSwaptionProductDescriptor> {
        private final InterestRateSwaptionProductDescriptor descriptor;
        private final Option swaption;

        public SwaptionPhysicalMonteCarlo(InterestRateSwaptionProductDescriptor descriptor, LocalDate referenceDate) {
            this.descriptor = descriptor;
            double excercise = FloatingpointDate.getFloatingPointDateFromDate(referenceDate, descriptor.getExcerciseDate());
            AbstractLIBORMonteCarloProduct swap = (AbstractLIBORMonteCarloProduct)((Object)new InterestRateMonteCarloProductFactory(referenceDate).getProductFromDescriptor(descriptor.getUnderlyingSwap()));
            this.swaption = new Option(excercise, descriptor.getStrikeRate(), swap);
        }

        @Override
        public InterestRateSwaptionProductDescriptor getDescriptor() {
            return this.descriptor;
        }

        @Override
        public RandomVariable getValue(double evaluationTime, TermStructureMonteCarloSimulationModel model) throws CalculationException {
            return this.swaption.getValue(evaluationTime, model);
        }
    }

    public static class SwapMonteCarlo
    extends AbstractLIBORMonteCarloProduct
    implements DescribedProduct<InterestRateSwapProductDescriptor> {
        private final TermStructureMonteCarloProduct legReceiver;
        private final TermStructureMonteCarloProduct legPayer;

        public SwapMonteCarlo(InterestRateSwapProductDescriptor descriptor, LocalDate referenceDate) {
            InterestRateMonteCarloProductFactory factory = new InterestRateMonteCarloProductFactory(referenceDate);
            InterestRateProductDescriptor legDescriptor = descriptor.getLegReceiver();
            this.legReceiver = (TermStructureMonteCarloProduct)((Object)factory.getProductFromDescriptor(legDescriptor));
            legDescriptor = descriptor.getLegPayer();
            this.legPayer = (TermStructureMonteCarloProduct)((Object)factory.getProductFromDescriptor(legDescriptor));
        }

        @Override
        public RandomVariable getValue(double evaluationTime, TermStructureMonteCarloSimulationModel model) throws CalculationException {
            RandomVariable value = new RandomVariableFromDoubleArray(0.0);
            if (this.legPayer != null) {
                value = value.add(this.legReceiver.getValue(evaluationTime, model));
            }
            if (this.legPayer != null) {
                value = value.sub(this.legPayer.getValue(evaluationTime, model));
            }
            return value;
        }

        @Override
        public InterestRateSwapProductDescriptor getDescriptor() {
            if (!(this.legReceiver instanceof DescribedProduct) || !(this.legPayer instanceof DescribedProduct)) {
                throw new RuntimeException("One or both of the legs of this swap do not support extraction of a descriptor.");
            }
            InterestRateProductDescriptor receiverDescriptor = (InterestRateProductDescriptor)((DescribedProduct)((Object)this.legReceiver)).getDescriptor();
            InterestRateProductDescriptor payerDescriptor = (InterestRateProductDescriptor)((DescribedProduct)((Object)this.legPayer)).getDescriptor();
            return new InterestRateSwapProductDescriptor(receiverDescriptor, payerDescriptor);
        }
    }

    public static class SwapLegMonteCarlo
    extends SwapLeg
    implements DescribedProduct<InterestRateSwapLegProductDescriptor> {
        private static final boolean couponFlow = true;
        private final InterestRateSwapLegProductDescriptor descriptor;

        public SwapLegMonteCarlo(InterestRateSwapLegProductDescriptor descriptor, LocalDate referenceDate) {
            super(descriptor.getLegScheduleDescriptor().getSchedule(referenceDate), (Notional[])Arrays.stream(descriptor.getNotionals()).mapToObj(new DoubleFunction<NotionalFromConstant>(){

                @Override
                public NotionalFromConstant apply(double x) {
                    return new NotionalFromConstant(x);
                }
            }).toArray(NotionalFromConstant[]::new), InterestRateMonteCarloProductFactory.constructLiborIndex(descriptor.getForwardCurveName(), descriptor.getLegScheduleDescriptor().getSchedule(referenceDate)), descriptor.getSpreads(), true, descriptor.isNotionalExchanged());
            this.descriptor = descriptor;
        }

        @Override
        public InterestRateSwapLegProductDescriptor getDescriptor() {
            return this.descriptor;
        }
    }
}

