/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.modelling.productfactory;

import java.util.ArrayList;
import java.util.List;
import net.finmath.modelling.DescribedProduct;
import net.finmath.modelling.ProductDescriptor;
import net.finmath.modelling.ProductFactory;

public class ProductFactoryCascade<T extends ProductDescriptor>
implements ProductFactory<T> {
    private final ArrayList<ProductFactory<? extends T>> factories;

    public ProductFactoryCascade() {
        this.factories = new ArrayList(0);
    }

    public ProductFactoryCascade(List<ProductFactory<? extends T>> factories) {
        this.factories = new ArrayList();
        this.factories.addAll(factories);
    }

    public ProductFactoryCascade<T> addFactoryBefore(ProductFactory<? extends T> factory) {
        ArrayList<ProductFactory<T>> factories = new ArrayList<ProductFactory<T>>(this.factories.size() + 1);
        factories.addAll(this.factories);
        factories.add(0, factory);
        return new ProductFactoryCascade<T>(factories);
    }

    public ProductFactoryCascade<T> addFactoryAfter(ProductFactory<? extends T> factory) {
        ArrayList<ProductFactory<T>> factories = new ArrayList<ProductFactory<T>>(this.factories.size() + 1);
        factories.addAll(this.factories);
        factories.add(factory);
        return new ProductFactoryCascade<T>(factories);
    }

    @Override
    public DescribedProduct<? extends T> getProductFromDescriptor(ProductDescriptor productDescriptor) {
        DescribedProduct<? extends T> product = null;
        for (ProductFactory<T> factory : this.factories) {
            try {
                product = factory.getProductFromDescriptor(productDescriptor);
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            if (product == null) continue;
            return product;
        }
        throw new IllegalArgumentException("Unsupported product type " + productDescriptor.name());
    }
}

