/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import net.finmath.functions.NormalDistribution;
import net.finmath.montecarlo.BrownianMotion;
import net.finmath.montecarlo.RandomVariableFactory;
import net.finmath.montecarlo.RandomVariableFromArrayFactory;
import net.finmath.randomnumbers.RandomNumberGenerator;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.TimeDiscretization;
import org.apache.commons.lang3.Validate;

public class BrownianMotionFromRandomNumberGenerator
implements BrownianMotion,
Serializable {
    private static final long serialVersionUID = -5430067621669213475L;
    private final TimeDiscretization timeDiscretization;
    private final int numberOfFactors;
    private final int numberOfPaths;
    private final RandomNumberGenerator randomNumberGenerator;
    private final RandomVariableFactory randomVariableFactory;
    private transient RandomVariable[][] brownianIncrements;
    private transient Object brownianIncrementsLazyInitLock = new Object();

    public BrownianMotionFromRandomNumberGenerator(TimeDiscretization timeDiscretization, int numberOfFactors, int numberOfPaths, RandomNumberGenerator randomNumberGenerator, RandomVariableFactory randomVariableFactory) {
        this.timeDiscretization = timeDiscretization;
        this.numberOfFactors = numberOfFactors;
        this.numberOfPaths = numberOfPaths;
        this.randomNumberGenerator = randomNumberGenerator;
        this.randomVariableFactory = randomVariableFactory;
        this.brownianIncrements = null;
        Validate.notNull((Object)timeDiscretization);
        Validate.notNull((Object)randomNumberGenerator);
        int requiredDimension = numberOfFactors * timeDiscretization.getNumberOfTimeSteps();
        Validate.isTrue((randomNumberGenerator.getDimension() >= requiredDimension ? 1 : 0) != 0, (String)"Dimension of RandomNumberGenerator required to be at least %d.", (long)requiredDimension);
    }

    public BrownianMotionFromRandomNumberGenerator(TimeDiscretization timeDiscretization, int numberOfFactors, int numberOfPaths, RandomNumberGenerator randomNumberGenerator) {
        this(timeDiscretization, numberOfFactors, numberOfPaths, randomNumberGenerator, new RandomVariableFromArrayFactory());
    }

    @Override
    public BrownianMotion getCloneWithModifiedSeed(int seed) {
        return new BrownianMotionFromRandomNumberGenerator(this.getTimeDiscretization(), this.getNumberOfFactors(), this.getNumberOfPaths(), this.randomNumberGenerator);
    }

    @Override
    public BrownianMotion getCloneWithModifiedTimeDiscretization(TimeDiscretization newTimeDiscretization) {
        return new BrownianMotionFromRandomNumberGenerator(newTimeDiscretization, this.getNumberOfFactors(), this.getNumberOfPaths(), this.randomNumberGenerator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RandomVariable getBrownianIncrement(int timeIndex, int factor) {
        Object object = this.brownianIncrementsLazyInitLock;
        synchronized (object) {
            if (this.brownianIncrements == null) {
                this.doGenerateBrownianMotion();
            }
        }
        return this.brownianIncrements[timeIndex][factor];
    }

    private void doGenerateBrownianMotion() {
        int timeIndex;
        if (this.brownianIncrements != null) {
            return;
        }
        double[][][] brownianIncrementsArray = new double[this.timeDiscretization.getNumberOfTimeSteps()][this.numberOfFactors][this.numberOfPaths];
        double[] sqrtOfTimeStep = new double[this.timeDiscretization.getNumberOfTimeSteps()];
        for (timeIndex = 0; timeIndex < sqrtOfTimeStep.length; ++timeIndex) {
            sqrtOfTimeStep[timeIndex] = Math.sqrt(this.timeDiscretization.getTimeStep(timeIndex));
        }
        for (int path = 0; path < this.numberOfPaths; ++path) {
            double[] randomNumbers = this.randomNumberGenerator.getNext();
            for (int timeIndex2 = 0; timeIndex2 < this.timeDiscretization.getNumberOfTimeSteps(); ++timeIndex2) {
                double sqrtDeltaT = sqrtOfTimeStep[timeIndex2];
                for (int factor = 0; factor < this.numberOfFactors; ++factor) {
                    double uniformIncrement = randomNumbers[timeIndex2 * this.numberOfFactors + factor];
                    brownianIncrementsArray[timeIndex2][factor][path] = NormalDistribution.inverseCumulativeDistribution(uniformIncrement) * sqrtDeltaT;
                }
            }
        }
        this.brownianIncrements = new RandomVariable[this.timeDiscretization.getNumberOfTimeSteps()][this.numberOfFactors];
        for (timeIndex = 0; timeIndex < this.timeDiscretization.getNumberOfTimeSteps(); ++timeIndex) {
            double time = this.timeDiscretization.getTime(timeIndex + 1);
            for (int factor = 0; factor < this.numberOfFactors; ++factor) {
                this.brownianIncrements[timeIndex][factor] = this.randomVariableFactory.createRandomVariable(time, brownianIncrementsArray[timeIndex][factor]);
            }
        }
    }

    @Override
    public TimeDiscretization getTimeDiscretization() {
        return this.timeDiscretization;
    }

    @Override
    public int getNumberOfFactors() {
        return this.numberOfFactors;
    }

    @Override
    public int getNumberOfPaths() {
        return this.numberOfPaths;
    }

    @Override
    public RandomVariable getRandomVariableForConstant(double value) {
        return this.randomVariableFactory.createRandomVariable(value);
    }

    public String toString() {
        return super.toString() + "\ntimeDiscretizationFromArray: " + this.timeDiscretization.toString() + "\nnumberOfPaths: " + this.numberOfPaths + "\nnumberOfFactors: " + this.numberOfFactors + "\nrandomNumberGenerator: " + this.randomNumberGenerator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BrownianMotionFromRandomNumberGenerator that = (BrownianMotionFromRandomNumberGenerator)o;
        if (this.numberOfFactors != that.numberOfFactors) {
            return false;
        }
        if (this.numberOfPaths != that.numberOfPaths) {
            return false;
        }
        if (this.randomNumberGenerator != that.randomNumberGenerator) {
            return false;
        }
        return this.timeDiscretization.equals(that.timeDiscretization);
    }

    @Override
    public RandomVariable getIncrement(int timeIndex, int factor) {
        return this.getBrownianIncrement(timeIndex, factor);
    }

    public int hashCode() {
        int result = this.timeDiscretization.hashCode();
        result = 31 * result + this.numberOfFactors;
        result = 31 * result + this.numberOfPaths;
        result = 31 * result + this.randomNumberGenerator.hashCode();
        return result;
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.brownianIncrementsLazyInitLock = new Object();
    }
}

