/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo;

import java.util.HashMap;
import java.util.Map;
import net.finmath.montecarlo.BrownianMotion;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.TimeDiscretization;

public class BrownianMotionWithControlVariate
implements BrownianMotion {
    private final BrownianMotion brownianMotion;
    private transient Map<Integer, Double> averages = new HashMap<Integer, Double>();
    private transient Map<Integer, Double> scalings = new HashMap<Integer, Double>();

    public BrownianMotionWithControlVariate(BrownianMotion brownianMotion) {
        this.brownianMotion = brownianMotion;
    }

    @Override
    public RandomVariable getBrownianIncrement(int timeIndex, int factorIndex) {
        RandomVariable brownianIncrement = this.brownianMotion.getBrownianIncrement(timeIndex, factorIndex);
        int mapIndex = timeIndex * this.brownianMotion.getNumberOfFactors() + factorIndex;
        double average = this.averages.computeIfAbsent(mapIndex, index -> brownianIncrement.getAverage());
        double scaling = this.scalings.computeIfAbsent(mapIndex, index -> Math.sqrt(this.brownianMotion.getTimeDiscretization().getTimeStep(timeIndex)) / brownianIncrement.getStandardDeviation());
        RandomVariable brownianIncrementControlled = brownianIncrement;
        if (average != 0.0) {
            brownianIncrementControlled = brownianIncrementControlled.sub(average);
        }
        if (Double.isFinite(scaling) && scaling != 1.0) {
            brownianIncrementControlled = brownianIncrementControlled.mult(scaling);
        }
        return brownianIncrementControlled;
    }

    @Override
    public TimeDiscretization getTimeDiscretization() {
        return this.brownianMotion.getTimeDiscretization();
    }

    @Override
    public int getNumberOfFactors() {
        return this.brownianMotion.getNumberOfFactors();
    }

    @Override
    public int getNumberOfPaths() {
        return this.brownianMotion.getNumberOfPaths();
    }

    @Override
    public RandomVariable getRandomVariableForConstant(double value) {
        return this.brownianMotion.getRandomVariableForConstant(value);
    }

    @Override
    public BrownianMotion getCloneWithModifiedSeed(int seed) {
        return new BrownianMotionWithControlVariate(this.brownianMotion.getCloneWithModifiedSeed(seed));
    }

    @Override
    public BrownianMotion getCloneWithModifiedTimeDiscretization(TimeDiscretization newTimeDiscretization) {
        return new BrownianMotionWithControlVariate(this.brownianMotion.getCloneWithModifiedTimeDiscretization(newTimeDiscretization));
    }

    @Override
    public RandomVariable getIncrement(int timeIndex, int factor) {
        return this.getBrownianIncrement(timeIndex, factor);
    }
}

