/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo;

import net.finmath.stochastic.RandomVariable;

public interface RandomVariableFactory {
    public static RandomVariable getRandomVariableOrDefault(RandomVariableFactory randomVariableFactory, Object value, RandomVariable defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof RandomVariable) {
            return (RandomVariable)value;
        }
        if (value instanceof Number) {
            if (randomVariableFactory == null) {
                throw new NullPointerException("Object value of type Number but nor randomVariableFactory given.");
            }
            return randomVariableFactory.createRandomVariable(((Number)value).doubleValue());
        }
        throw new IllegalArgumentException("Object value must be of type Number or RandomVariable.");
    }

    public RandomVariable createRandomVariable(double var1);

    public RandomVariable createRandomVariable(double var1, double var3);

    public RandomVariable createRandomVariable(double var1, double[] var3);

    default public RandomVariable createRandomVariable(double[] values) {
        return this.createRandomVariable(0.0, values);
    }

    public RandomVariable[] createRandomVariableArray(double[] var1);

    public RandomVariable[][] createRandomVariableMatrix(double[][] var1);
}

