/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleSupplier;
import java.util.function.DoubleUnaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntToDoubleFunction;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import net.finmath.functions.DoubleTernaryOperator;
import net.finmath.stochastic.ConditionalExpectationEstimator;
import net.finmath.stochastic.RandomVariable;

public class RandomVariableFromDoubleArray
implements RandomVariable {
    private static final long serialVersionUID = -1352953450936857742L;
    private static final int typePriorityDefault = 1;
    private final int typePriority;
    private final double time;
    private final double[] realizations;
    private final double valueIfNonStochastic;

    public RandomVariableFromDoubleArray(RandomVariable value) {
        this.time = value.getFiltrationTime();
        this.realizations = value.isDeterministic() ? null : value.getRealizations();
        this.valueIfNonStochastic = value.isDeterministic() ? value.doubleValue() : Double.NaN;
        this.typePriority = 1;
    }

    public RandomVariableFromDoubleArray(double value) {
        this(Double.NEGATIVE_INFINITY, value, 1);
    }

    public RandomVariableFromDoubleArray(RandomVariable value, DoubleUnaryOperator function) {
        this.time = value.getFiltrationTime();
        this.realizations = value.isDeterministic() ? null : value.getRealizationsStream().map(function).toArray();
        this.valueIfNonStochastic = value.isDeterministic() ? function.applyAsDouble(value.doubleValue()) : Double.NaN;
        this.typePriority = 1;
    }

    public RandomVariableFromDoubleArray(double time, double value, int typePriority) {
        this.time = time;
        this.realizations = null;
        this.valueIfNonStochastic = value;
        this.typePriority = typePriority;
    }

    public RandomVariableFromDoubleArray(double time, double value) {
        this(time, value, 1);
    }

    @Deprecated
    public RandomVariableFromDoubleArray(double time, int numberOfPath, double value) {
        this.time = time;
        this.realizations = new double[numberOfPath];
        Arrays.fill(this.realizations, value);
        this.valueIfNonStochastic = Double.NaN;
        this.typePriority = 1;
    }

    public RandomVariableFromDoubleArray(double time, double[] realisations, int typePriority) {
        this.time = time;
        this.realizations = realisations;
        this.valueIfNonStochastic = Double.NaN;
        this.typePriority = typePriority;
    }

    public RandomVariableFromDoubleArray(double time, double[] realisations) {
        this(time, realisations, 1);
    }

    public RandomVariableFromDoubleArray(double time, final IntToDoubleFunction realizations, int size, int typePriority) {
        this.time = time;
        this.realizations = size == 1 ? null : new double[size];
        double d = this.valueIfNonStochastic = size == 1 ? realizations.applyAsDouble(0) : Double.NaN;
        if (size > 1) {
            IntStream.range(0, size).parallel().forEach(new IntConsumer(){

                @Override
                public void accept(int i) {
                    RandomVariableFromDoubleArray.this.realizations[i] = realizations.applyAsDouble(i);
                }
            });
        }
        this.typePriority = typePriority;
    }

    public RandomVariableFromDoubleArray(double time, IntToDoubleFunction realizations, int size) {
        this(time, realizations, size, 1);
    }

    @Override
    public boolean equals(RandomVariable randomVariable) {
        if (this.time != randomVariable.getFiltrationTime()) {
            return false;
        }
        if (this.isDeterministic() && randomVariable.isDeterministic()) {
            return this.valueIfNonStochastic == randomVariable.doubleValue();
        }
        if (this.isDeterministic() != randomVariable.isDeterministic()) {
            return false;
        }
        for (int i = 0; i < this.realizations.length; ++i) {
            if (this.realizations[i] == randomVariable.get(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public double getFiltrationTime() {
        return this.time;
    }

    @Override
    public int getTypePriority() {
        return this.typePriority;
    }

    @Override
    public double get(int pathOrState) {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        return this.realizations[pathOrState];
    }

    @Override
    public int size() {
        if (this.isDeterministic()) {
            return 1;
        }
        return this.realizations.length;
    }

    @Override
    public double getMin() {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        double min = Double.MAX_VALUE;
        if (this.realizations.length != 0) {
            min = this.realizations[0];
        }
        for (int i = 0; i < this.realizations.length; ++i) {
            min = Math.min(this.realizations[i], min);
        }
        return min;
    }

    @Override
    public double getMax() {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        double max = -1.7976931348623157E308;
        if (this.realizations.length != 0) {
            max = this.realizations[0];
        }
        for (int i = 0; i < this.realizations.length; ++i) {
            max = Math.max(this.realizations[i], max);
        }
        return max;
    }

    @Override
    public double getAverage() {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        double sum = 0.0;
        double error = 0.0;
        for (int i = 0; i < this.realizations.length; ++i) {
            double value = this.realizations[i] - error;
            double newSum = sum + value;
            error = newSum - sum - value;
            sum = newSum;
        }
        return sum / (double)this.realizations.length;
    }

    @Override
    public double getAverage(RandomVariable probabilities) {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic * probabilities.getAverage();
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        double sum = 0.0;
        double error = 0.0;
        for (int i = 0; i < this.realizations.length; ++i) {
            double value = this.realizations[i] * probabilities.get(i) - error;
            double newSum = sum + value;
            error = newSum - sum - value;
            sum = newSum;
        }
        return sum / (double)this.realizations.length;
    }

    @Override
    public double getVariance() {
        if (this.isDeterministic() || this.size() == 1) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        double average = this.getAverage();
        double sum = 0.0;
        double errorOfSum = 0.0;
        for (int i = 0; i < this.realizations.length; ++i) {
            double value = (this.realizations[i] - average) * (this.realizations[i] - average) - errorOfSum;
            double newSum = sum + value;
            errorOfSum = newSum - sum - value;
            sum = newSum;
        }
        return sum / (double)this.realizations.length;
    }

    @Override
    public double getVariance(RandomVariable probabilities) {
        if (this.isDeterministic()) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        double average = this.getAverage(probabilities);
        double sum = 0.0;
        double errorOfSum = 0.0;
        for (int i = 0; i < this.realizations.length; ++i) {
            double value = (this.realizations[i] - average) * (this.realizations[i] - average) * probabilities.get(i) - errorOfSum;
            double newSum = sum + value;
            errorOfSum = newSum - sum - value;
            sum = newSum;
        }
        return sum;
    }

    @Override
    public double getSampleVariance() {
        if (this.isDeterministic() || this.size() == 1) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        return this.getVariance() * (double)this.size() / (double)(this.size() - 1);
    }

    @Override
    public double getStandardDeviation() {
        if (this.isDeterministic()) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        return Math.sqrt(this.getVariance());
    }

    @Override
    public double getStandardDeviation(RandomVariable probabilities) {
        if (this.isDeterministic()) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        return Math.sqrt(this.getVariance(probabilities));
    }

    @Override
    public double getStandardError() {
        if (this.isDeterministic()) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        return this.getStandardDeviation() / Math.sqrt(this.size());
    }

    @Override
    public double getStandardError(RandomVariable probabilities) {
        if (this.isDeterministic()) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        return this.getStandardDeviation(probabilities) / Math.sqrt(this.size());
    }

    @Override
    public double getQuantile(double quantile) {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        double[] realizationsSorted = (double[])this.realizations.clone();
        Arrays.sort(realizationsSorted);
        int indexOfQuantileValue = Math.min(Math.max((int)Math.round((double)(this.size() + 1) * quantile - 1.0), 0), this.size() - 1);
        return realizationsSorted[indexOfQuantileValue];
    }

    @Override
    public double getQuantile(double quantile, RandomVariable probabilities) {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        throw new RuntimeException("Method not implemented.");
    }

    @Override
    public double getQuantileExpectation(double quantileStart, double quantileEnd) {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        if (quantileStart > quantileEnd) {
            return this.getQuantileExpectation(quantileEnd, quantileStart);
        }
        double[] realizationsSorted = (double[])this.realizations.clone();
        Arrays.sort(realizationsSorted);
        int indexOfQuantileValueStart = Math.min(Math.max((int)Math.round((double)(this.size() + 1) * quantileStart - 1.0), 0), this.size() - 1);
        int indexOfQuantileValueEnd = Math.min(Math.max((int)Math.round((double)(this.size() + 1) * quantileEnd - 1.0), 0), this.size() - 1);
        double quantileExpectation = 0.0;
        for (int i = indexOfQuantileValueStart; i <= indexOfQuantileValueEnd; ++i) {
            quantileExpectation += realizationsSorted[i];
        }
        return quantileExpectation /= (double)(indexOfQuantileValueEnd - indexOfQuantileValueStart + 1);
    }

    @Override
    public double[] getHistogram(double[] intervalPoints) {
        double[] histogramValues = new double[intervalPoints.length + 1];
        if (this.isDeterministic()) {
            Arrays.fill(histogramValues, 0.0);
            for (int intervalIndex = 0; intervalIndex < intervalPoints.length; ++intervalIndex) {
                if (!(this.valueIfNonStochastic > intervalPoints[intervalIndex])) continue;
                histogramValues[intervalIndex] = 1.0;
                break;
            }
            histogramValues[intervalPoints.length] = 1.0;
        } else {
            double[] realizationsSorted = (double[])this.realizations.clone();
            Arrays.sort(realizationsSorted);
            int sampleIndex = 0;
            for (int intervalIndex = 0; intervalIndex < intervalPoints.length; ++intervalIndex) {
                int sampleCount = 0;
                while (sampleIndex < realizationsSorted.length && realizationsSorted[sampleIndex] <= intervalPoints[intervalIndex]) {
                    ++sampleIndex;
                    ++sampleCount;
                }
                histogramValues[intervalIndex] = sampleCount;
            }
            histogramValues[intervalPoints.length] = realizationsSorted.length - sampleIndex;
            if (realizationsSorted.length > 0) {
                int i = 0;
                while (i < histogramValues.length) {
                    int n = i++;
                    histogramValues[n] = histogramValues[n] / (double)realizationsSorted.length;
                }
            }
        }
        return histogramValues;
    }

    @Override
    public double[][] getHistogram(int numberOfPoints, double standardDeviations) {
        double[] intervalPoints = new double[numberOfPoints];
        double[] anchorPoints = new double[numberOfPoints + 1];
        double center = this.getAverage();
        double radius = standardDeviations * this.getStandardDeviation();
        double stepSize = (double)(numberOfPoints - 1) / 2.0;
        for (int i = 0; i < numberOfPoints; ++i) {
            double alpha = (-((double)(numberOfPoints - 1)) / 2.0 + (double)i) / stepSize;
            intervalPoints[i] = center + alpha * radius;
            anchorPoints[i] = center + alpha * radius - radius / (2.0 * stepSize);
        }
        anchorPoints[numberOfPoints] = center + 1.0 * radius + radius / (2.0 * stepSize);
        double[][] result = new double[][]{anchorPoints, this.getHistogram(intervalPoints)};
        return result;
    }

    @Override
    public boolean isDeterministic() {
        return this.realizations == null;
    }

    @Override
    public RandomVariable cache() {
        return this;
    }

    @Override
    public DoubleStream getRealizationsStream() {
        if (this.isDeterministic()) {
            return DoubleStream.generate(new DoubleSupplier(){

                @Override
                public double getAsDouble() {
                    return RandomVariableFromDoubleArray.this.valueIfNonStochastic;
                }
            });
        }
        return Arrays.stream(this.realizations);
    }

    @Override
    public double[] getRealizations() {
        if (this.isDeterministic()) {
            double[] result = new double[]{this.doubleValue()};
            return result;
        }
        return (double[])this.realizations.clone();
    }

    @Override
    public Double doubleValue() {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        if (this.size() == 1) {
            return this.getAverage();
        }
        throw new UnsupportedOperationException("The random variable is non-deterministic");
    }

    @Override
    public IntToDoubleFunction getOperator() {
        if (this.isDeterministic()) {
            return new IntToDoubleFunction(){

                @Override
                public double applyAsDouble(int i) {
                    return RandomVariableFromDoubleArray.this.valueIfNonStochastic;
                }
            };
        }
        return new IntToDoubleFunction(){

            @Override
            public double applyAsDouble(int i) {
                return RandomVariableFromDoubleArray.this.realizations[i];
            }
        };
    }

    @Override
    public RandomVariable apply(DoubleUnaryOperator operator) {
        if (this.isDeterministic()) {
            return new RandomVariableFromDoubleArray(this.time, operator.applyAsDouble(this.valueIfNonStochastic));
        }
        double[] result = new double[this.realizations.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = operator.applyAsDouble(this.realizations[i]);
        }
        return new RandomVariableFromDoubleArray(this.time, result);
    }

    @Override
    public RandomVariable apply(final DoubleBinaryOperator operator, RandomVariable argument) {
        double newTime = Math.max(this.time, argument.getFiltrationTime());
        if (this.isDeterministic() && argument.isDeterministic()) {
            return new RandomVariableFromDoubleArray(newTime, operator.applyAsDouble(this.valueIfNonStochastic, argument.doubleValue()));
        }
        if (this.isDeterministic() && !argument.isDeterministic()) {
            double[] result = new double[argument.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = operator.applyAsDouble(this.valueIfNonStochastic, argument.get(i));
            }
            return new RandomVariableFromDoubleArray(newTime, result);
        }
        if (!this.isDeterministic() && argument.isDeterministic()) {
            double[] result = new double[this.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = operator.applyAsDouble(this.realizations[i], argument.doubleValue());
            }
            return new RandomVariableFromDoubleArray(newTime, result);
        }
        if (!this.isDeterministic() && !argument.isDeterministic()) {
            double[] result = new double[this.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = operator.applyAsDouble(this.realizations[i], argument.get(i));
            }
            return new RandomVariableFromDoubleArray(newTime, result);
        }
        int newSize = Math.max(this.size(), argument.size());
        final IntToDoubleFunction argument0Operator = this.getOperator();
        final IntToDoubleFunction argument1Operator = argument.getOperator();
        IntToDoubleFunction result = new IntToDoubleFunction(){

            @Override
            public double applyAsDouble(int i) {
                return operator.applyAsDouble(argument0Operator.applyAsDouble(i), argument1Operator.applyAsDouble(i));
            }
        };
        return new RandomVariableFromDoubleArray(newTime, result, newSize);
    }

    @Override
    public RandomVariable apply(final DoubleTernaryOperator operator, RandomVariable argument1, RandomVariable argument2) {
        double newTime = Math.max(this.time, argument1.getFiltrationTime());
        newTime = Math.max(newTime, argument2.getFiltrationTime());
        int newSize = Math.max(Math.max(this.size(), argument1.size()), argument2.size());
        final IntToDoubleFunction argument0Operator = this.getOperator();
        final IntToDoubleFunction argument1Operator = argument1.getOperator();
        final IntToDoubleFunction argument2Operator = argument2.getOperator();
        IntToDoubleFunction result = new IntToDoubleFunction(){

            @Override
            public double applyAsDouble(int i) {
                return operator.applyAsDouble(argument0Operator.applyAsDouble(i), argument1Operator.applyAsDouble(i), argument2Operator.applyAsDouble(i));
            }
        };
        return new RandomVariableFromDoubleArray(newTime, result, newSize);
    }

    public RandomVariable apply(final DoubleBinaryOperator operatorOuter, final DoubleBinaryOperator operatorInner, RandomVariable argument1, RandomVariable argument2) {
        return this.apply(new DoubleTernaryOperator(){

            @Override
            public double applyAsDouble(double x, double y, double z) {
                return operatorOuter.applyAsDouble(x, operatorInner.applyAsDouble(y, z));
            }
        }, argument1, argument2);
    }

    @Override
    public RandomVariable cap(double cap) {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = Math.min(this.valueIfNonStochastic, cap);
            return new RandomVariableFromDoubleArray(this.time, newValueIfNonStochastic);
        }
        double[] newRealizations = new double[this.realizations.length];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = Math.min(this.realizations[i], cap);
        }
        return new RandomVariableFromDoubleArray(this.time, newRealizations);
    }

    @Override
    public RandomVariable floor(double floor) {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = Math.max(this.valueIfNonStochastic, floor);
            return new RandomVariableFromDoubleArray(this.time, newValueIfNonStochastic);
        }
        double[] newRealizations = new double[this.realizations.length];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = Math.max(this.realizations[i], floor);
        }
        return new RandomVariableFromDoubleArray(this.time, newRealizations);
    }

    @Override
    public RandomVariable add(double value) {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic + value;
            return new RandomVariableFromDoubleArray(this.time, newValueIfNonStochastic);
        }
        double[] newRealizations = new double[this.realizations.length];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = this.realizations[i] + value;
        }
        return new RandomVariableFromDoubleArray(this.time, newRealizations);
    }

    @Override
    public RandomVariable sub(double value) {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic - value;
            return new RandomVariableFromDoubleArray(this.time, newValueIfNonStochastic);
        }
        double[] newRealizations = new double[this.realizations.length];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = this.realizations[i] - value;
        }
        return new RandomVariableFromDoubleArray(this.time, newRealizations);
    }

    @Override
    public RandomVariable bus(double value) {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = value - this.valueIfNonStochastic;
            return new RandomVariableFromDoubleArray(this.time, newValueIfNonStochastic);
        }
        double[] newRealizations = new double[this.realizations.length];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = value - this.realizations[i];
        }
        return new RandomVariableFromDoubleArray(this.time, newRealizations);
    }

    @Override
    public RandomVariable mult(double value) {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic * value;
            return new RandomVariableFromDoubleArray(this.time, newValueIfNonStochastic);
        }
        double[] newRealizations = new double[this.realizations.length];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = this.realizations[i] * value;
        }
        return new RandomVariableFromDoubleArray(this.time, newRealizations);
    }

    @Override
    public RandomVariable div(double value) {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic / value;
            return new RandomVariableFromDoubleArray(this.time, newValueIfNonStochastic);
        }
        double[] newRealizations = new double[this.realizations.length];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = this.realizations[i] / value;
        }
        return new RandomVariableFromDoubleArray(this.time, newRealizations);
    }

    @Override
    public RandomVariable vid(double value) {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = value / this.valueIfNonStochastic;
            return new RandomVariableFromDoubleArray(this.time, newValueIfNonStochastic);
        }
        double[] newRealizations = new double[this.realizations.length];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = value / this.realizations[i];
        }
        return new RandomVariableFromDoubleArray(this.time, newRealizations);
    }

    @Override
    public RandomVariable pow(double exponent) {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = Math.pow(this.valueIfNonStochastic, exponent);
            return new RandomVariableFromDoubleArray(this.time, newValueIfNonStochastic);
        }
        double[] newRealizations = new double[this.realizations.length];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = Math.pow(this.realizations[i], exponent);
        }
        return new RandomVariableFromDoubleArray(this.time, newRealizations);
    }

    @Override
    public RandomVariable average() {
        return new RandomVariableFromDoubleArray(this.getAverage());
    }

    @Override
    public RandomVariable getConditionalExpectation(ConditionalExpectationEstimator conditionalExpectationOperator) {
        return conditionalExpectationOperator.getConditionalExpectation(this);
    }

    @Override
    public RandomVariable squared() {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic * this.valueIfNonStochastic;
            return new RandomVariableFromDoubleArray(this.time, newValueIfNonStochastic);
        }
        double[] newRealizations = new double[this.realizations.length];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = this.realizations[i] * this.realizations[i];
        }
        return new RandomVariableFromDoubleArray(this.time, newRealizations);
    }

    @Override
    public RandomVariable sqrt() {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = Math.sqrt(this.valueIfNonStochastic);
            return new RandomVariableFromDoubleArray(this.time, newValueIfNonStochastic);
        }
        double[] newRealizations = new double[this.realizations.length];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = Math.sqrt(this.realizations[i]);
        }
        return new RandomVariableFromDoubleArray(this.time, newRealizations);
    }

    @Override
    public RandomVariable invert() {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = 1.0 / this.valueIfNonStochastic;
            return new RandomVariableFromDoubleArray(this.time, newValueIfNonStochastic);
        }
        double[] newRealizations = new double[this.realizations.length];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = 1.0 / this.realizations[i];
        }
        return new RandomVariableFromDoubleArray(this.time, newRealizations);
    }

    @Override
    public RandomVariable abs() {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = Math.abs(this.valueIfNonStochastic);
            return new RandomVariableFromDoubleArray(this.time, newValueIfNonStochastic);
        }
        double[] newRealizations = new double[this.realizations.length];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = Math.abs(this.realizations[i]);
        }
        return new RandomVariableFromDoubleArray(this.time, newRealizations);
    }

    @Override
    public RandomVariableFromDoubleArray exp() {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = Math.exp(this.valueIfNonStochastic);
            return new RandomVariableFromDoubleArray(this.time, newValueIfNonStochastic);
        }
        double[] newRealizations = new double[this.realizations.length];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = Math.exp(this.realizations[i]);
        }
        return new RandomVariableFromDoubleArray(this.time, newRealizations);
    }

    @Override
    public RandomVariableFromDoubleArray expm1() {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = Math.expm1(this.valueIfNonStochastic);
            return new RandomVariableFromDoubleArray(this.time, newValueIfNonStochastic);
        }
        double[] newRealizations = new double[this.realizations.length];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = Math.expm1(this.realizations[i]);
        }
        return new RandomVariableFromDoubleArray(this.time, newRealizations);
    }

    @Override
    public RandomVariableFromDoubleArray log() {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = Math.log(this.valueIfNonStochastic);
            return new RandomVariableFromDoubleArray(this.time, newValueIfNonStochastic);
        }
        double[] newRealizations = new double[this.realizations.length];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = Math.log(this.realizations[i]);
        }
        return new RandomVariableFromDoubleArray(this.time, newRealizations);
    }

    @Override
    public RandomVariable sin() {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = Math.sin(this.valueIfNonStochastic);
            return new RandomVariableFromDoubleArray(this.time, newValueIfNonStochastic);
        }
        double[] newRealizations = new double[this.realizations.length];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = Math.sin(this.realizations[i]);
        }
        return new RandomVariableFromDoubleArray(this.time, newRealizations);
    }

    @Override
    public RandomVariable cos() {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = Math.cos(this.valueIfNonStochastic);
            return new RandomVariableFromDoubleArray(this.time, newValueIfNonStochastic);
        }
        double[] newRealizations = new double[this.realizations.length];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = Math.cos(this.realizations[i]);
        }
        return new RandomVariableFromDoubleArray(this.time, newRealizations);
    }

    @Override
    public RandomVariable add(RandomVariable randomVariable) {
        if (randomVariable.getTypePriority() > this.getTypePriority()) {
            return randomVariable.add(this);
        }
        double newTime = Math.max(this.time, randomVariable.getFiltrationTime());
        if (this.isDeterministic() && randomVariable.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic + randomVariable.doubleValue();
            return new RandomVariableFromDoubleArray(newTime, newValueIfNonStochastic);
        }
        if (this.isDeterministic()) {
            double[] newRealizations = new double[Math.max(this.size(), randomVariable.size())];
            for (int i = 0; i < newRealizations.length; ++i) {
                newRealizations[i] = this.valueIfNonStochastic + randomVariable.get(i);
            }
            return new RandomVariableFromDoubleArray(newTime, newRealizations);
        }
        if (randomVariable.isDeterministic()) {
            return this.add(randomVariable.doubleValue());
        }
        double[] newRealizations = new double[Math.max(this.size(), randomVariable.size())];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = this.realizations[i] + randomVariable.get(i);
        }
        return new RandomVariableFromDoubleArray(newTime, newRealizations);
    }

    @Override
    public RandomVariable sub(RandomVariable randomVariable) {
        if (randomVariable.getTypePriority() > this.getTypePriority()) {
            return randomVariable.bus(this);
        }
        double newTime = Math.max(this.time, randomVariable.getFiltrationTime());
        if (this.isDeterministic() && randomVariable.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic - randomVariable.doubleValue();
            return new RandomVariableFromDoubleArray(newTime, newValueIfNonStochastic);
        }
        if (this.isDeterministic()) {
            double[] newRealizations = new double[Math.max(this.size(), randomVariable.size())];
            for (int i = 0; i < newRealizations.length; ++i) {
                newRealizations[i] = this.valueIfNonStochastic - randomVariable.get(i);
            }
            return new RandomVariableFromDoubleArray(newTime, newRealizations);
        }
        if (randomVariable.isDeterministic()) {
            return this.sub(randomVariable.doubleValue());
        }
        double[] newRealizations = new double[Math.max(this.size(), randomVariable.size())];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = this.realizations[i] - randomVariable.get(i);
        }
        return new RandomVariableFromDoubleArray(newTime, newRealizations);
    }

    @Override
    public RandomVariable bus(RandomVariable randomVariable) {
        if (randomVariable.getTypePriority() > this.getTypePriority()) {
            return randomVariable.sub(this);
        }
        double newTime = Math.max(this.time, randomVariable.getFiltrationTime());
        if (this.isDeterministic() && randomVariable.isDeterministic()) {
            double newValueIfNonStochastic = randomVariable.doubleValue() - this.valueIfNonStochastic;
            return new RandomVariableFromDoubleArray(newTime, newValueIfNonStochastic);
        }
        if (this.isDeterministic()) {
            double[] newRealizations = new double[Math.max(this.size(), randomVariable.size())];
            for (int i = 0; i < newRealizations.length; ++i) {
                newRealizations[i] = randomVariable.get(i) - this.valueIfNonStochastic;
            }
            return new RandomVariableFromDoubleArray(newTime, newRealizations);
        }
        double[] newRealizations = new double[Math.max(this.size(), randomVariable.size())];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = randomVariable.get(i) - this.realizations[i];
        }
        return new RandomVariableFromDoubleArray(newTime, newRealizations);
    }

    @Override
    public RandomVariable mult(RandomVariable randomVariable) {
        if (randomVariable.getTypePriority() > this.getTypePriority()) {
            return randomVariable.mult(this);
        }
        double newTime = Math.max(this.time, randomVariable.getFiltrationTime());
        if (this.isDeterministic() && randomVariable.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic * randomVariable.doubleValue();
            return new RandomVariableFromDoubleArray(newTime, newValueIfNonStochastic);
        }
        if (randomVariable.isDeterministic()) {
            return this.mult(randomVariable.doubleValue());
        }
        if (this.isDeterministic()) {
            double[] newRealizations = new double[Math.max(this.size(), randomVariable.size())];
            for (int i = 0; i < newRealizations.length; ++i) {
                newRealizations[i] = this.valueIfNonStochastic * randomVariable.get(i);
            }
            return new RandomVariableFromDoubleArray(newTime, newRealizations);
        }
        double[] newRealizations = new double[Math.max(this.size(), randomVariable.size())];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = this.realizations[i] * randomVariable.get(i);
        }
        return new RandomVariableFromDoubleArray(newTime, newRealizations);
    }

    @Override
    public RandomVariable div(RandomVariable randomVariable) {
        if (randomVariable.getTypePriority() > this.getTypePriority()) {
            return randomVariable.vid(this);
        }
        double newTime = Math.max(this.time, randomVariable.getFiltrationTime());
        if (this.isDeterministic() && randomVariable.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic / randomVariable.doubleValue();
            return new RandomVariableFromDoubleArray(newTime, newValueIfNonStochastic);
        }
        if (this.isDeterministic()) {
            double[] newRealizations = new double[Math.max(this.size(), randomVariable.size())];
            for (int i = 0; i < newRealizations.length; ++i) {
                newRealizations[i] = this.valueIfNonStochastic / randomVariable.get(i);
            }
            return new RandomVariableFromDoubleArray(newTime, newRealizations);
        }
        double[] newRealizations = new double[Math.max(this.size(), randomVariable.size())];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = this.realizations[i] / randomVariable.get(i);
        }
        return new RandomVariableFromDoubleArray(newTime, newRealizations);
    }

    @Override
    public RandomVariable vid(RandomVariable randomVariable) {
        if (randomVariable.getTypePriority() > this.getTypePriority()) {
            return randomVariable.div(this);
        }
        double newTime = Math.max(this.time, randomVariable.getFiltrationTime());
        if (this.isDeterministic() && randomVariable.isDeterministic()) {
            double newValueIfNonStochastic = randomVariable.doubleValue() / this.valueIfNonStochastic;
            return new RandomVariableFromDoubleArray(newTime, newValueIfNonStochastic);
        }
        if (this.isDeterministic()) {
            double[] newRealizations = new double[Math.max(this.size(), randomVariable.size())];
            for (int i = 0; i < newRealizations.length; ++i) {
                newRealizations[i] = randomVariable.get(i) / this.valueIfNonStochastic;
            }
            return new RandomVariableFromDoubleArray(newTime, newRealizations);
        }
        double[] newRealizations = new double[Math.max(this.size(), randomVariable.size())];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = randomVariable.get(i) / this.realizations[i];
        }
        return new RandomVariableFromDoubleArray(newTime, newRealizations);
    }

    @Override
    public RandomVariable cap(RandomVariable randomVariable) {
        if (randomVariable.getTypePriority() > this.getTypePriority()) {
            return randomVariable.cap(this);
        }
        double newTime = Math.max(this.time, randomVariable.getFiltrationTime());
        if (this.isDeterministic() && randomVariable.isDeterministic()) {
            double newValueIfNonStochastic = Math.min(this.valueIfNonStochastic, randomVariable.doubleValue());
            return new RandomVariableFromDoubleArray(newTime, newValueIfNonStochastic);
        }
        if (this.isDeterministic()) {
            double[] newRealizations = new double[Math.max(this.size(), randomVariable.size())];
            for (int i = 0; i < newRealizations.length; ++i) {
                newRealizations[i] = Math.min(this.valueIfNonStochastic, randomVariable.get(i));
            }
            return new RandomVariableFromDoubleArray(newTime, newRealizations);
        }
        double[] newRealizations = new double[Math.max(this.size(), randomVariable.size())];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = Math.min(this.realizations[i], randomVariable.get(i));
        }
        return new RandomVariableFromDoubleArray(newTime, newRealizations);
    }

    @Override
    public RandomVariable floor(RandomVariable randomVariable) {
        if (randomVariable.getTypePriority() > this.getTypePriority()) {
            return randomVariable.floor(this);
        }
        double newTime = Math.max(this.time, randomVariable.getFiltrationTime());
        if (this.isDeterministic() && randomVariable.isDeterministic()) {
            double newValueIfNonStochastic = Math.max(this.valueIfNonStochastic, randomVariable.doubleValue());
            return new RandomVariableFromDoubleArray(newTime, newValueIfNonStochastic);
        }
        if (this.isDeterministic()) {
            double[] newRealizations = new double[Math.max(this.size(), randomVariable.size())];
            for (int i = 0; i < newRealizations.length; ++i) {
                newRealizations[i] = Math.max(this.valueIfNonStochastic, randomVariable.get(i));
            }
            return new RandomVariableFromDoubleArray(newTime, newRealizations);
        }
        if (randomVariable.isDeterministic()) {
            return this.floor(randomVariable.doubleValue());
        }
        double[] newRealizations = new double[Math.max(this.size(), randomVariable.size())];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = Math.max(this.realizations[i], randomVariable.get(i));
        }
        return new RandomVariableFromDoubleArray(newTime, newRealizations);
    }

    @Override
    public RandomVariable accrue(RandomVariable rate, double periodLength) {
        if (rate.getTypePriority() > this.getTypePriority()) {
            return rate.mult(periodLength).add(1.0).mult(this);
        }
        double newTime = Math.max(this.time, rate.getFiltrationTime());
        if (rate.isDeterministic()) {
            return this.mult(1.0 + rate.doubleValue() * periodLength);
        }
        if (this.isDeterministic() && !rate.isDeterministic()) {
            double[] newRealizations = new double[Math.max(this.size(), rate.size())];
            for (int i = 0; i < newRealizations.length; ++i) {
                newRealizations[i] = this.valueIfNonStochastic * (1.0 + rate.get(i) * periodLength);
            }
            return new RandomVariableFromDoubleArray(newTime, newRealizations);
        }
        double[] newRealizations = new double[Math.max(this.size(), rate.size())];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = this.realizations[i] * (1.0 + rate.get(i) * periodLength);
        }
        return new RandomVariableFromDoubleArray(newTime, newRealizations);
    }

    @Override
    public RandomVariable discount(RandomVariable rate, double periodLength) {
        if (rate.getTypePriority() > this.getTypePriority()) {
            return rate.mult(periodLength).add(1.0).invert().mult(this);
        }
        double newTime = Math.max(this.time, rate.getFiltrationTime());
        if (rate.isDeterministic()) {
            return this.div(1.0 + rate.doubleValue() * periodLength);
        }
        if (this.isDeterministic() && !rate.isDeterministic()) {
            double[] newRealizations = new double[Math.max(this.size(), rate.size())];
            for (int i = 0; i < newRealizations.length; ++i) {
                newRealizations[i] = this.valueIfNonStochastic / (1.0 + rate.get(i) * periodLength);
            }
            return new RandomVariableFromDoubleArray(newTime, newRealizations);
        }
        double[] newRealizations = new double[Math.max(this.size(), rate.size())];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = this.realizations[i] / (1.0 + rate.get(i) * periodLength);
        }
        return new RandomVariableFromDoubleArray(newTime, newRealizations);
    }

    @Override
    public RandomVariable choose(RandomVariable valueIfTriggerNonNegative, RandomVariable valueIfTriggerNegative) {
        double newTime = this.time;
        newTime = Math.max(newTime, valueIfTriggerNonNegative.getFiltrationTime());
        newTime = Math.max(newTime, valueIfTriggerNegative.getFiltrationTime());
        if (this.isDeterministic()) {
            if (this.valueIfNonStochastic >= 0.0) {
                return valueIfTriggerNonNegative;
            }
            return valueIfTriggerNegative;
        }
        int numberOfPaths = this.size();
        double[] newRealizations = new double[numberOfPaths];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = this.realizations[i] >= 0.0 ? valueIfTriggerNonNegative.get(i) : valueIfTriggerNegative.get(i);
        }
        return new RandomVariableFromDoubleArray(newTime, newRealizations);
    }

    @Override
    public RandomVariable addProduct(RandomVariable factor1, double factor2) {
        if (factor1.getTypePriority() > this.getTypePriority()) {
            return factor1.mult(factor2).add(this);
        }
        double newTime = Math.max(this.time, factor1.getFiltrationTime());
        if (factor1.isDeterministic()) {
            return this.add(factor1.doubleValue() * factor2);
        }
        if (this.isDeterministic() && !factor1.isDeterministic()) {
            double[] newRealizations = new double[Math.max(this.size(), factor1.size())];
            for (int i = 0; i < newRealizations.length; ++i) {
                newRealizations[i] = this.valueIfNonStochastic + factor1.get(i) * factor2;
            }
            return new RandomVariableFromDoubleArray(newTime, newRealizations);
        }
        double[] newRealizations = new double[Math.max(this.size(), factor1.size())];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = this.realizations[i] + factor1.get(i) * factor2;
        }
        return new RandomVariableFromDoubleArray(newTime, newRealizations);
    }

    @Override
    public RandomVariable addProduct(RandomVariable factor1, RandomVariable factor2) {
        if (factor1.getTypePriority() > this.getTypePriority() || factor2.getTypePriority() > this.getTypePriority()) {
            return factor1.mult(factor2).add(this);
        }
        double newTime = Math.max(Math.max(this.time, factor1.getFiltrationTime()), factor2.getFiltrationTime());
        if (this.isDeterministic() && factor1.isDeterministic() && factor2.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic + factor1.doubleValue() * factor2.doubleValue();
            return new RandomVariableFromDoubleArray(newTime, newValueIfNonStochastic);
        }
        if (factor1.isDeterministic() && factor2.isDeterministic()) {
            return this.add(factor1.doubleValue() * factor2.doubleValue());
        }
        if (factor2.isDeterministic()) {
            return this.addProduct(factor1, factor2.doubleValue());
        }
        if (factor1.isDeterministic()) {
            return this.addProduct(factor2, factor1.doubleValue());
        }
        if (!(this.isDeterministic() || factor1.isDeterministic() || factor2.isDeterministic())) {
            double[] newRealizations = new double[Math.max(Math.max(this.size(), factor1.size()), factor2.size())];
            for (int i = 0; i < newRealizations.length; ++i) {
                newRealizations[i] = this.realizations[i] + factor1.get(i) * factor2.get(i);
            }
            return new RandomVariableFromDoubleArray(newTime, newRealizations);
        }
        return this.add(factor1.mult(factor2));
    }

    @Override
    public RandomVariable addSumProduct(List<RandomVariable> factor1, List<RandomVariable> factor2) {
        RandomVariable result = this;
        for (int i = 0; i < factor1.size(); ++i) {
            result = result.addProduct(factor1.get(i), factor2.get(i));
        }
        return result;
    }

    @Override
    public RandomVariable addRatio(RandomVariable numerator, RandomVariable denominator) {
        if (numerator.getTypePriority() > this.getTypePriority() || denominator.getTypePriority() > this.getTypePriority()) {
            return numerator.div(denominator).add(this);
        }
        double newTime = Math.max(Math.max(this.time, numerator.getFiltrationTime()), denominator.getFiltrationTime());
        if (this.isDeterministic() && numerator.isDeterministic() && denominator.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic + numerator.doubleValue() / denominator.doubleValue();
            return new RandomVariableFromDoubleArray(newTime, newValueIfNonStochastic);
        }
        double[] newRealizations = new double[Math.max(Math.max(this.size(), numerator.size()), denominator.size())];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = this.get(i) + numerator.get(i) / denominator.get(i);
        }
        return new RandomVariableFromDoubleArray(newTime, newRealizations);
    }

    @Override
    public RandomVariable subRatio(RandomVariable numerator, RandomVariable denominator) {
        if (numerator.getTypePriority() > this.getTypePriority() || denominator.getTypePriority() > this.getTypePriority()) {
            return numerator.div(denominator).mult(-1.0).add(this);
        }
        double newTime = Math.max(Math.max(this.time, numerator.getFiltrationTime()), denominator.getFiltrationTime());
        if (this.isDeterministic() && numerator.isDeterministic() && denominator.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic - numerator.doubleValue() / denominator.doubleValue();
            return new RandomVariableFromDoubleArray(newTime, newValueIfNonStochastic);
        }
        double[] newRealizations = new double[Math.max(Math.max(this.size(), numerator.size()), denominator.size())];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = this.get(i) - numerator.get(i) / denominator.get(i);
        }
        return new RandomVariableFromDoubleArray(newTime, newRealizations);
    }

    @Override
    public RandomVariable isNaN() {
        if (this.isDeterministic()) {
            return new RandomVariableFromDoubleArray(this.time, Double.isNaN(this.valueIfNonStochastic) ? 1.0 : 0.0);
        }
        double[] newRealizations = new double[this.size()];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = Double.isNaN(this.get(i)) ? 1.0 : 0.0;
        }
        return new RandomVariableFromDoubleArray(this.time, newRealizations);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [time=" + this.time + ", realizations=" + (Serializable)(this.isDeterministic() ? Double.valueOf(this.valueIfNonStochastic) : Arrays.toString(this.realizations)) + ", isDeterministic()=" + this.isDeterministic() + ", typePriority=" + this.typePriority + "]";
    }
}

