/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo;

import java.util.Arrays;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleSupplier;
import java.util.function.DoubleUnaryOperator;
import java.util.function.IntToDoubleFunction;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import net.finmath.functions.DoubleTernaryOperator;
import net.finmath.montecarlo.RandomVariableFromDoubleArray;
import net.finmath.stochastic.RandomVariable;

public class RandomVariableLazyEvaluation
implements RandomVariable {
    private static final long serialVersionUID = 8413020544732461630L;
    private final double time;
    private IntToDoubleFunction realizations;
    private final int size;
    private final double valueIfNonStochastic;
    private transient double[] realizationsArray = null;

    public RandomVariableLazyEvaluation(RandomVariable value) {
        this.time = value.getFiltrationTime();
        this.realizations = value.isDeterministic() ? null : value::get;
        this.size = value.size();
        this.valueIfNonStochastic = value.isDeterministic() ? value.get(0) : Double.NaN;
    }

    public RandomVariableLazyEvaluation(double value) {
        this(0.0, value);
    }

    public RandomVariableLazyEvaluation(final RandomVariable value, final DoubleUnaryOperator function) {
        this.time = value.getFiltrationTime();
        this.realizations = value.isDeterministic() ? null : new IntToDoubleFunction(){

            @Override
            public double applyAsDouble(int i) {
                return function.applyAsDouble(value.get(i));
            }
        };
        this.size = value.size();
        this.valueIfNonStochastic = value.isDeterministic() ? function.applyAsDouble(value.get(0)) : Double.NaN;
    }

    public RandomVariableLazyEvaluation(double time, double value) {
        this.time = time;
        this.realizations = null;
        this.size = 1;
        this.valueIfNonStochastic = value;
    }

    public RandomVariableLazyEvaluation(double time, int numberOfPath, final double value) {
        this.time = time;
        this.size = numberOfPath;
        this.realizations = new IntToDoubleFunction(){

            @Override
            public double applyAsDouble(int i) {
                return value;
            }
        };
        this.valueIfNonStochastic = Double.NaN;
    }

    public RandomVariableLazyEvaluation(double time, final double[] realisations) {
        this.time = time;
        this.size = realisations.length;
        this.realizations = new IntToDoubleFunction(){

            @Override
            public double applyAsDouble(int i) {
                return realisations[i];
            }
        };
        this.valueIfNonStochastic = Double.NaN;
        this.realizationsArray = realisations;
    }

    public RandomVariableLazyEvaluation(double time, IntToDoubleFunction realisations, int size) {
        this.time = time;
        this.realizations = realisations;
        this.size = size;
        this.valueIfNonStochastic = Double.NaN;
    }

    @Override
    public boolean equals(RandomVariable randomVariable) {
        if (this.time != randomVariable.getFiltrationTime()) {
            return false;
        }
        if (this.isDeterministic() && randomVariable.isDeterministic()) {
            return this.valueIfNonStochastic == randomVariable.get(0);
        }
        if (this.isDeterministic() != randomVariable.isDeterministic()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i) == randomVariable.get(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public double getFiltrationTime() {
        return this.time;
    }

    @Override
    public int getTypePriority() {
        return 0;
    }

    @Override
    public double get(int pathOrState) {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        this.cache();
        return this.realizationsArray[pathOrState];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public double getMin() {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        return this.getRealizationsStream().min().getAsDouble();
    }

    @Override
    public double getMax() {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        return this.getRealizationsStream().max().getAsDouble();
    }

    @Override
    public double getAverage() {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        return this.getRealizationsStream().sum() / (double)this.size();
    }

    @Override
    public double getAverage(RandomVariable probabilities) {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic * probabilities.getAverage();
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        return this.cache().mult(probabilities).getRealizationsStream().sum();
    }

    @Override
    public double getVariance() {
        if (this.isDeterministic()) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        double sum = 0.0;
        double sumOfSquared = 0.0;
        for (double realization : this.getRealizations()) {
            sum += realization;
            sumOfSquared += realization * realization;
        }
        return sumOfSquared / (double)this.size() - sum / (double)this.size() * sum / (double)this.size();
    }

    @Override
    public double getVariance(RandomVariable probabilities) {
        if (this.isDeterministic()) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        double mean = 0.0;
        double secondMoment = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            mean += this.get(i) * probabilities.get(i);
            secondMoment += this.get(i) * this.get(i) * probabilities.get(i);
        }
        return secondMoment - mean * mean;
    }

    @Override
    public double getSampleVariance() {
        if (this.isDeterministic() || this.size() == 1) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        return this.getVariance() * (double)this.size() / (double)(this.size() - 1);
    }

    @Override
    public double getStandardDeviation() {
        if (this.isDeterministic()) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        return Math.sqrt(this.getVariance());
    }

    @Override
    public double getStandardDeviation(RandomVariable probabilities) {
        if (this.isDeterministic()) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        return Math.sqrt(this.getVariance(probabilities));
    }

    @Override
    public double getStandardError() {
        if (this.isDeterministic()) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        return this.getStandardDeviation() / Math.sqrt(this.size());
    }

    @Override
    public double getStandardError(RandomVariable probabilities) {
        if (this.isDeterministic()) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        return this.getStandardDeviation(probabilities) / (double)this.size();
    }

    @Override
    public double getQuantile(double quantile) {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        double[] realizationsSorted = (double[])this.getRealizations().clone();
        Arrays.sort(realizationsSorted);
        int indexOfQuantileValue = Math.min(Math.max((int)Math.round((double)(this.size() + 1) * quantile - 1.0), 0), this.size() - 1);
        return realizationsSorted[indexOfQuantileValue];
    }

    @Override
    public double getQuantile(double quantile, RandomVariable probabilities) {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        throw new RuntimeException("Method not implemented.");
    }

    @Override
    public double getQuantileExpectation(double quantileStart, double quantileEnd) {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        if (quantileStart > quantileEnd) {
            return this.getQuantileExpectation(quantileEnd, quantileStart);
        }
        double[] realizationsSorted = (double[])this.getRealizations().clone();
        Arrays.sort(realizationsSorted);
        int indexOfQuantileValueStart = Math.min(Math.max((int)Math.round((double)(this.size() + 1) * quantileStart - 1.0), 0), this.size() - 1);
        int indexOfQuantileValueEnd = Math.min(Math.max((int)Math.round((double)(this.size() + 1) * quantileEnd - 1.0), 0), this.size() - 1);
        double quantileExpectation = 0.0;
        for (int i = indexOfQuantileValueStart; i <= indexOfQuantileValueEnd; ++i) {
            quantileExpectation += realizationsSorted[i];
        }
        return quantileExpectation /= (double)(indexOfQuantileValueEnd - indexOfQuantileValueStart + 1);
    }

    @Override
    public double[] getHistogram(double[] intervalPoints) {
        double[] histogramValues = new double[intervalPoints.length + 1];
        if (this.isDeterministic()) {
            Arrays.fill(histogramValues, 0.0);
            for (int intervalIndex = 0; intervalIndex < intervalPoints.length; ++intervalIndex) {
                if (!(this.valueIfNonStochastic > intervalPoints[intervalIndex])) continue;
                histogramValues[intervalIndex] = 1.0;
                break;
            }
            histogramValues[intervalPoints.length] = 1.0;
        } else {
            double[] realizationsSorted = (double[])this.getRealizations().clone();
            Arrays.sort(realizationsSorted);
            int sampleIndex = 0;
            for (int intervalIndex = 0; intervalIndex < intervalPoints.length; ++intervalIndex) {
                int sampleCount = 0;
                while (sampleIndex < realizationsSorted.length && realizationsSorted[sampleIndex] <= intervalPoints[intervalIndex]) {
                    ++sampleIndex;
                    ++sampleCount;
                }
                histogramValues[intervalIndex] = sampleCount;
            }
            histogramValues[intervalPoints.length] = realizationsSorted.length - sampleIndex;
            if (realizationsSorted.length > 0) {
                int i = 0;
                while (i < histogramValues.length) {
                    int n = i++;
                    histogramValues[n] = histogramValues[n] / (double)realizationsSorted.length;
                }
            }
        }
        return histogramValues;
    }

    @Override
    public double[][] getHistogram(int numberOfPoints, double standardDeviations) {
        double[] intervalPoints = new double[numberOfPoints];
        double[] anchorPoints = new double[numberOfPoints + 1];
        double center = this.getAverage();
        double radius = standardDeviations * this.getStandardDeviation();
        double stepSize = (double)(numberOfPoints - 1) / 2.0;
        for (int i = 0; i < numberOfPoints; ++i) {
            double alpha = (-((double)(numberOfPoints - 1)) / 2.0 + (double)i) / stepSize;
            intervalPoints[i] = center + alpha * radius;
            anchorPoints[i] = center + alpha * radius - radius / (2.0 * stepSize);
        }
        anchorPoints[numberOfPoints] = center + 1.0 * radius + radius / (2.0 * stepSize);
        double[][] result = new double[][]{anchorPoints, this.getHistogram(intervalPoints)};
        return result;
    }

    @Override
    public boolean isDeterministic() {
        return this.realizations == null;
    }

    public RandomVariable expand(int numberOfPaths) {
        if (this.isDeterministic()) {
            double[] clone = new double[numberOfPaths];
            Arrays.fill(clone, this.valueIfNonStochastic);
            return new RandomVariableFromDoubleArray(this.time, clone);
        }
        return new RandomVariableFromDoubleArray(this.time, this.getRealizations());
    }

    @Override
    public double[] getRealizations() {
        if (this.isDeterministic()) {
            double[] result = new double[]{this.get(0)};
            return result;
        }
        this.cache();
        return this.realizationsArray;
    }

    @Override
    public Double doubleValue() {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        throw new UnsupportedOperationException("The random variable is non-deterministic");
    }

    @Override
    public IntToDoubleFunction getOperator() {
        return this.realizations;
    }

    public RandomVariableFromDoubleArray getRandomVariable() {
        if (this.isDeterministic()) {
            return new RandomVariableFromDoubleArray(this.time, this.valueIfNonStochastic);
        }
        return new RandomVariableFromDoubleArray(this.time, this.getRealizations());
    }

    @Override
    public DoubleStream getRealizationsStream() {
        if (this.isDeterministic()) {
            return DoubleStream.generate(new DoubleSupplier(){

                @Override
                public double getAsDouble() {
                    return RandomVariableLazyEvaluation.this.valueIfNonStochastic;
                }
            });
        }
        return IntStream.range(0, this.size()).mapToDouble(this.realizations).parallel();
    }

    @Override
    public RandomVariable apply(final DoubleUnaryOperator operator) {
        if (this.isDeterministic()) {
            return new RandomVariableLazyEvaluation(this.time, operator.applyAsDouble(this.valueIfNonStochastic));
        }
        IntToDoubleFunction newRealizations = new IntToDoubleFunction(){

            @Override
            public double applyAsDouble(int i) {
                return operator.applyAsDouble(RandomVariableLazyEvaluation.this.realizations.applyAsDouble(i));
            }
        };
        return new RandomVariableLazyEvaluation(this.time, newRealizations, this.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RandomVariable cache() {
        RandomVariableLazyEvaluation randomVariableLazyEvaluation = this;
        synchronized (randomVariableLazyEvaluation) {
            if (this.realizationsArray == null) {
                this.realizationsArray = this.getRealizationsStream().toArray();
                this.realizations = new IntToDoubleFunction(){

                    @Override
                    public double applyAsDouble(int i) {
                        return RandomVariableLazyEvaluation.this.realizationsArray[i];
                    }
                };
            }
        }
        return this;
    }

    @Override
    public RandomVariable apply(final DoubleBinaryOperator operator, final RandomVariable argument) {
        double newTime = Math.max(this.time, argument.getFiltrationTime());
        if (this.isDeterministic() && argument.isDeterministic()) {
            return new RandomVariableLazyEvaluation(newTime, operator.applyAsDouble(this.valueIfNonStochastic, argument.get(0)));
        }
        if (!this.isDeterministic() && argument.isDeterministic()) {
            IntToDoubleFunction newRealizations = new IntToDoubleFunction(){

                @Override
                public double applyAsDouble(int i) {
                    return operator.applyAsDouble(RandomVariableLazyEvaluation.this.realizations.applyAsDouble(i), argument.get(0));
                }
            };
            return new RandomVariableLazyEvaluation(newTime, newRealizations, this.size());
        }
        if (this.isDeterministic() && !argument.isDeterministic()) {
            final double[] argumentRealizations = argument.getRealizations();
            IntToDoubleFunction newRealizations = new IntToDoubleFunction(){

                @Override
                public double applyAsDouble(int i) {
                    return operator.applyAsDouble(RandomVariableLazyEvaluation.this.valueIfNonStochastic, argumentRealizations[i]);
                }
            };
            return new RandomVariableLazyEvaluation(newTime, newRealizations, argument.size());
        }
        final double[] argumentRealizations = argument.getRealizations();
        IntToDoubleFunction newRealizations = new IntToDoubleFunction(){

            @Override
            public double applyAsDouble(int i) {
                return operator.applyAsDouble(RandomVariableLazyEvaluation.this.realizations.applyAsDouble(i), argumentRealizations[i]);
            }
        };
        return new RandomVariableLazyEvaluation(newTime, newRealizations, this.size());
    }

    public RandomVariable apply(final DoubleBinaryOperator operatorOuter, final DoubleBinaryOperator operatorInner, RandomVariable argument1, RandomVariable argument2) {
        IntToDoubleFunction innerResult;
        double newTime = Math.max(this.time, argument1.getFiltrationTime());
        newTime = Math.max(newTime, argument2.getFiltrationTime());
        if (this.isDeterministic() && argument1.isDeterministic() && argument2.isDeterministic()) {
            return new RandomVariableLazyEvaluation(newTime, operatorOuter.applyAsDouble(this.valueIfNonStochastic, operatorInner.applyAsDouble(argument1.get(0), argument2.get(0))));
        }
        int newSize = Math.max(Math.max(this.size(), argument1.size()), argument2.size());
        if (argument1.isDeterministic() && argument2.isDeterministic()) {
            final double argument1Realization = argument1.get(0);
            final double argument2Realization = argument2.get(0);
            innerResult = new IntToDoubleFunction(){

                @Override
                public double applyAsDouble(int i) {
                    return operatorInner.applyAsDouble(argument1Realization, argument2Realization);
                }
            };
        } else if (argument1.isDeterministic() && !argument2.isDeterministic()) {
            final double argument1Realization = argument1.get(0);
            final double[] argument2Realizations = argument2.getRealizations();
            innerResult = new IntToDoubleFunction(){

                @Override
                public double applyAsDouble(int i) {
                    return operatorInner.applyAsDouble(argument1Realization, argument2Realizations[i]);
                }
            };
        } else if (!argument1.isDeterministic() && argument2.isDeterministic()) {
            final double[] argument1Realizations = argument1.getRealizations();
            final double argument2Realization = argument2.get(0);
            innerResult = new IntToDoubleFunction(){

                @Override
                public double applyAsDouble(int i) {
                    return operatorInner.applyAsDouble(argument1Realizations[i], argument2Realization);
                }
            };
        } else {
            final double[] argument1Realizations = argument1.getRealizations();
            final double[] argument2Realizations = argument2.getRealizations();
            innerResult = new IntToDoubleFunction(){

                @Override
                public double applyAsDouble(int i) {
                    return operatorInner.applyAsDouble(argument1Realizations[i], argument2Realizations[i]);
                }
            };
        }
        if (this.isDeterministic()) {
            return new RandomVariableLazyEvaluation(newTime, new IntToDoubleFunction(){

                @Override
                public double applyAsDouble(int i) {
                    return operatorOuter.applyAsDouble(RandomVariableLazyEvaluation.this.valueIfNonStochastic, innerResult.applyAsDouble(i));
                }
            }, newSize);
        }
        return new RandomVariableLazyEvaluation(newTime, new IntToDoubleFunction(){

            @Override
            public double applyAsDouble(int i) {
                return operatorOuter.applyAsDouble(RandomVariableLazyEvaluation.this.realizations.applyAsDouble(i), innerResult.applyAsDouble(i));
            }
        }, newSize);
    }

    @Override
    public RandomVariable apply(final DoubleTernaryOperator operator, RandomVariable argument1, RandomVariable argument2) {
        IntToDoubleFunction result;
        double newTime = Math.max(this.time, argument1.getFiltrationTime());
        newTime = Math.max(newTime, argument2.getFiltrationTime());
        if (this.isDeterministic() && argument1.isDeterministic() && argument2.isDeterministic()) {
            return new RandomVariableLazyEvaluation(newTime, operator.applyAsDouble(this.valueIfNonStochastic, argument1.get(0), argument2.get(0)));
        }
        int newSize = Math.max(Math.max(this.size(), argument1.size()), argument2.size());
        if (argument1.isDeterministic() && argument2.isDeterministic()) {
            final double argument1Realization = argument1.get(0);
            final double argument2Realization = argument2.get(0);
            result = this.isDeterministic() ? new IntToDoubleFunction(){

                @Override
                public double applyAsDouble(int i) {
                    return operator.applyAsDouble(RandomVariableLazyEvaluation.this.valueIfNonStochastic, argument1Realization, argument2Realization);
                }
            } : new IntToDoubleFunction(){

                @Override
                public double applyAsDouble(int i) {
                    return operator.applyAsDouble(RandomVariableLazyEvaluation.this.realizations.applyAsDouble(i), argument1Realization, argument2Realization);
                }
            };
        } else if (argument1.isDeterministic() && !argument2.isDeterministic()) {
            final double argument1Realization = argument1.get(0);
            final double[] argument2Realizations = argument2.getRealizations();
            result = this.isDeterministic() ? new IntToDoubleFunction(){

                @Override
                public double applyAsDouble(int i) {
                    return operator.applyAsDouble(RandomVariableLazyEvaluation.this.valueIfNonStochastic, argument1Realization, argument2Realizations[i]);
                }
            } : new IntToDoubleFunction(){

                @Override
                public double applyAsDouble(int i) {
                    return operator.applyAsDouble(RandomVariableLazyEvaluation.this.realizations.applyAsDouble(i), argument1Realization, argument2Realizations[i]);
                }
            };
        } else if (!argument1.isDeterministic() && argument2.isDeterministic()) {
            final double[] argument1Realizations = argument1.getRealizations();
            final double argument2Realization = argument2.get(0);
            result = this.isDeterministic() ? new IntToDoubleFunction(){

                @Override
                public double applyAsDouble(int i) {
                    return operator.applyAsDouble(RandomVariableLazyEvaluation.this.valueIfNonStochastic, argument1Realizations[i], argument2Realization);
                }
            } : new IntToDoubleFunction(){

                @Override
                public double applyAsDouble(int i) {
                    return operator.applyAsDouble(RandomVariableLazyEvaluation.this.realizations.applyAsDouble(i), argument1Realizations[i], argument2Realization);
                }
            };
        } else {
            final double[] argument1Realizations = argument1.getRealizations();
            final double[] argument2Realizations = argument2.getRealizations();
            result = this.isDeterministic() ? new IntToDoubleFunction(){

                @Override
                public double applyAsDouble(int i) {
                    return operator.applyAsDouble(RandomVariableLazyEvaluation.this.valueIfNonStochastic, argument1Realizations[i], argument2Realizations[i]);
                }
            } : new IntToDoubleFunction(){

                @Override
                public double applyAsDouble(int i) {
                    return operator.applyAsDouble(RandomVariableLazyEvaluation.this.realizations.applyAsDouble(i), argument1Realizations[i], argument2Realizations[i]);
                }
            };
        }
        return new RandomVariableLazyEvaluation(newTime, result, newSize);
    }

    @Override
    public RandomVariable cap(final double cap) {
        return this.apply(new DoubleUnaryOperator(){

            @Override
            public double applyAsDouble(double x) {
                return Math.min(x, cap);
            }
        });
    }

    @Override
    public RandomVariable floor(final double floor) {
        return this.apply(new DoubleUnaryOperator(){

            @Override
            public double applyAsDouble(double x) {
                return Math.max(x, floor);
            }
        });
    }

    @Override
    public RandomVariable add(final double value) {
        return this.apply(new DoubleUnaryOperator(){

            @Override
            public double applyAsDouble(double x) {
                return x + value;
            }
        });
    }

    @Override
    public RandomVariable sub(final double value) {
        return this.apply(new DoubleUnaryOperator(){

            @Override
            public double applyAsDouble(double x) {
                return x - value;
            }
        });
    }

    @Override
    public RandomVariable mult(final double value) {
        return this.apply(new DoubleUnaryOperator(){

            @Override
            public double applyAsDouble(double x) {
                return x * value;
            }
        });
    }

    @Override
    public RandomVariable div(final double value) {
        return this.apply(new DoubleUnaryOperator(){

            @Override
            public double applyAsDouble(double x) {
                return x / value;
            }
        });
    }

    @Override
    public RandomVariable pow(final double exponent) {
        return this.apply(new DoubleUnaryOperator(){

            @Override
            public double applyAsDouble(double x) {
                return Math.pow(x, exponent);
            }
        });
    }

    @Override
    public RandomVariable average() {
        return new RandomVariableLazyEvaluation(this.getAverage());
    }

    @Override
    public RandomVariable squared() {
        return this.apply(new DoubleUnaryOperator(){

            @Override
            public double applyAsDouble(double x) {
                return x * x;
            }
        });
    }

    @Override
    public RandomVariable sqrt() {
        return this.apply(Math::sqrt);
    }

    @Override
    public RandomVariable exp() {
        return this.apply(Math::exp);
    }

    @Override
    public RandomVariable log() {
        return this.apply(Math::log);
    }

    @Override
    public RandomVariable sin() {
        return this.apply(Math::sin);
    }

    @Override
    public RandomVariable cos() {
        return this.apply(Math::cos);
    }

    @Override
    public RandomVariable add(RandomVariable randomVariable) {
        return this.apply(new DoubleBinaryOperator(){

            @Override
            public double applyAsDouble(double x, double y) {
                return x + y;
            }
        }, randomVariable);
    }

    @Override
    public RandomVariable sub(RandomVariable randomVariable) {
        return this.apply(new DoubleBinaryOperator(){

            @Override
            public double applyAsDouble(double x, double y) {
                return x - y;
            }
        }, randomVariable);
    }

    @Override
    public RandomVariable bus(RandomVariable randomVariable) {
        return this.apply(new DoubleBinaryOperator(){

            @Override
            public double applyAsDouble(double x, double y) {
                return -x + y;
            }
        }, randomVariable);
    }

    @Override
    public RandomVariable mult(RandomVariable randomVariable) {
        return this.apply(new DoubleBinaryOperator(){

            @Override
            public double applyAsDouble(double x, double y) {
                return x * y;
            }
        }, randomVariable);
    }

    @Override
    public RandomVariable div(RandomVariable randomVariable) {
        return this.apply(new DoubleBinaryOperator(){

            @Override
            public double applyAsDouble(double x, double y) {
                return x / y;
            }
        }, randomVariable);
    }

    @Override
    public RandomVariable vid(RandomVariable randomVariable) {
        return this.apply(new DoubleBinaryOperator(){

            @Override
            public double applyAsDouble(double x, double y) {
                return y / x;
            }
        }, randomVariable);
    }

    @Override
    public RandomVariable cap(RandomVariable cap) {
        return this.apply(Math::min, cap);
    }

    @Override
    public RandomVariable floor(RandomVariable floor) {
        return this.apply(Math::max, floor);
    }

    @Override
    public RandomVariable accrue(RandomVariable rate, final double periodLength) {
        return this.apply(new DoubleBinaryOperator(){

            @Override
            public double applyAsDouble(double x, double y) {
                return x * (1.0 + y * periodLength);
            }
        }, rate);
    }

    @Override
    public RandomVariable discount(RandomVariable rate, final double periodLength) {
        return this.apply(new DoubleBinaryOperator(){

            @Override
            public double applyAsDouble(double x, double y) {
                return x / (1.0 + y * periodLength);
            }
        }, rate);
    }

    @Override
    public RandomVariable choose(RandomVariable valueIfTriggerNonNegative, RandomVariable valueIfTriggerNegative) {
        return this.apply(new DoubleTernaryOperator(){

            @Override
            public double applyAsDouble(double x, double y, double z) {
                return x >= 0.0 ? y : z;
            }
        }, valueIfTriggerNonNegative, valueIfTriggerNegative);
    }

    @Override
    public RandomVariable invert() {
        return this.apply(new DoubleUnaryOperator(){

            @Override
            public double applyAsDouble(double x) {
                return 1.0 / x;
            }
        });
    }

    @Override
    public RandomVariable abs() {
        return this.apply(Math::abs);
    }

    @Override
    public RandomVariable addProduct(RandomVariable factor1, final double factor2) {
        return this.apply(new DoubleBinaryOperator(){

            @Override
            public double applyAsDouble(double x, double y) {
                return x + y * factor2;
            }
        }, factor1);
    }

    @Override
    public RandomVariable addProduct(RandomVariable factor1, RandomVariable factor2) {
        return this.apply(new DoubleBinaryOperator(){

            @Override
            public double applyAsDouble(double x, double y) {
                return x + y;
            }
        }, new DoubleBinaryOperator(){

            @Override
            public double applyAsDouble(double x, double y) {
                return x * y;
            }
        }, factor1, factor2);
    }

    @Override
    public RandomVariable addRatio(RandomVariable numerator, RandomVariable denominator) {
        return this.apply(new DoubleBinaryOperator(){

            @Override
            public double applyAsDouble(double x, double y) {
                return x + y;
            }
        }, new DoubleBinaryOperator(){

            @Override
            public double applyAsDouble(double x, double y) {
                return x / y;
            }
        }, numerator, denominator);
    }

    @Override
    public RandomVariable subRatio(RandomVariable numerator, RandomVariable denominator) {
        return this.apply(new DoubleBinaryOperator(){

            @Override
            public double applyAsDouble(double x, double y) {
                return x - y;
            }
        }, new DoubleBinaryOperator(){

            @Override
            public double applyAsDouble(double x, double y) {
                return x / y;
            }
        }, numerator, denominator);
    }

    @Override
    public RandomVariable isNaN() {
        if (this.isDeterministic()) {
            return new RandomVariableLazyEvaluation(this.time, Double.isNaN(this.valueIfNonStochastic) ? 1.0 : 0.0);
        }
        double[] newRealizations = new double[this.size()];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = Double.isNaN(this.get(i)) ? 1.0 : 0.0;
        }
        return new RandomVariableLazyEvaluation(this.time, newRealizations);
    }
}

