/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo;

import java.io.Serializable;
import net.finmath.montecarlo.BrownianMotion;
import net.finmath.montecarlo.BrownianMotionFromMersenneRandomNumbers;
import net.finmath.montecarlo.GammaProcess;
import net.finmath.montecarlo.IndependentIncrements;
import net.finmath.montecarlo.RandomVariableFactory;
import net.finmath.montecarlo.RandomVariableFromArrayFactory;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.TimeDiscretization;

public class VarianceGammaProcess
implements IndependentIncrements,
Serializable {
    private static final long serialVersionUID = -338038617011804530L;
    private final double sigma;
    private final double nu;
    private final double theta;
    private final TimeDiscretization timeDiscretization;
    private final int numberOfFactors;
    private final int numberOfPaths;
    private final int seed;
    private GammaProcess myGammaProcess;
    private BrownianMotion myBrownianMotion;
    private final RandomVariableFactory randomVariableFactory = new RandomVariableFromArrayFactory();
    private transient RandomVariable[][] varianceGammaIncrements;

    public VarianceGammaProcess(double sigma, double nu, double theta, TimeDiscretization timeDiscretization, int numberOfFactors, int numberOfPaths, int seed) {
        this.sigma = sigma;
        this.nu = nu;
        this.theta = theta;
        this.timeDiscretization = timeDiscretization;
        this.numberOfFactors = numberOfFactors;
        this.numberOfPaths = numberOfPaths;
        this.seed = seed;
        this.varianceGammaIncrements = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RandomVariable getIncrement(int timeIndex, int factor) {
        VarianceGammaProcess varianceGammaProcess = this;
        synchronized (varianceGammaProcess) {
            if (this.varianceGammaIncrements == null) {
                this.doGenerateVarianceGammaIncrements();
            }
        }
        return this.varianceGammaIncrements[timeIndex][factor];
    }

    private void doGenerateVarianceGammaIncrements() {
        if (this.varianceGammaIncrements != null) {
            return;
        }
        this.myGammaProcess = new GammaProcess(this.timeDiscretization, this.numberOfFactors, this.numberOfPaths, this.seed, 1.0 / this.nu, this.nu);
        this.myBrownianMotion = new BrownianMotionFromMersenneRandomNumbers(this.timeDiscretization, this.numberOfFactors, this.numberOfPaths, this.seed + 1);
        this.varianceGammaIncrements = new RandomVariable[this.timeDiscretization.getNumberOfTimeSteps()][this.numberOfFactors];
        for (int timeIndex = 0; timeIndex < this.timeDiscretization.getNumberOfTimeSteps(); ++timeIndex) {
            for (int factor = 0; factor < this.numberOfFactors; ++factor) {
                this.varianceGammaIncrements[timeIndex][factor] = this.myGammaProcess.getIncrement(timeIndex, factor).mult(this.theta).add(this.myGammaProcess.getIncrement(timeIndex, factor).sqrt().mult(this.myBrownianMotion.getBrownianIncrement(timeIndex, factor).mult(this.sigma / Math.sqrt(this.timeDiscretization.getTimeStep(timeIndex)))));
            }
        }
    }

    public double getSigma() {
        return this.sigma;
    }

    public double getNu() {
        return this.nu;
    }

    public double getTheta() {
        return this.theta;
    }

    public BrownianMotion getBrownianMotion() {
        return this.myBrownianMotion;
    }

    public GammaProcess getGammaProcess() {
        return this.myGammaProcess;
    }

    @Override
    public TimeDiscretization getTimeDiscretization() {
        return this.timeDiscretization;
    }

    @Override
    public int getNumberOfFactors() {
        return this.numberOfFactors;
    }

    @Override
    public int getNumberOfPaths() {
        return this.numberOfPaths;
    }

    @Override
    public RandomVariable getRandomVariableForConstant(double value) {
        return this.randomVariableFactory.createRandomVariable(value);
    }

    @Override
    public IndependentIncrements getCloneWithModifiedSeed(int seed) {
        return new VarianceGammaProcess(this.sigma, this.nu, this.theta, this.timeDiscretization, this.numberOfFactors, this.numberOfPaths, seed);
    }

    @Override
    public IndependentIncrements getCloneWithModifiedTimeDiscretization(TimeDiscretization newTimeDiscretization) {
        return new VarianceGammaProcess(this.sigma, this.nu, this.theta, newTimeDiscretization, this.numberOfFactors, this.numberOfPaths, this.seed);
    }
}

