/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.finmath.exception.CalculationException;
import net.finmath.functions.LinearAlgebra;
import net.finmath.montecarlo.BrownianMotion;
import net.finmath.montecarlo.BrownianMotionFromMersenneRandomNumbers;
import net.finmath.montecarlo.RandomVariableFactory;
import net.finmath.montecarlo.RandomVariableFromArrayFactory;
import net.finmath.montecarlo.assetderivativevaluation.AssetModelMonteCarloSimulationModel;
import net.finmath.montecarlo.model.AbstractProcessModel;
import net.finmath.montecarlo.process.EulerSchemeFromProcessModel;
import net.finmath.montecarlo.process.MonteCarloProcess;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.TimeDiscretization;

public class MonteCarloMultiAssetBlackScholesModel
extends AbstractProcessModel
implements AssetModelMonteCarloSimulationModel {
    private final MonteCarloProcess process;
    private final RandomVariableFactory randomVariableFactory;
    private final double[] initialValues;
    private final double riskFreeRate;
    private final double[][] factorLoadings;
    private static final int defaultSeed = 3141;
    private final RandomVariable[] initialStates;
    private final RandomVariable[] drift;
    private final RandomVariable[][] factorLoadingOnPaths;

    public MonteCarloMultiAssetBlackScholesModel(RandomVariableFactory randomVariableFactory, BrownianMotion brownianMotion, double[] initialValues, double riskFreeRate, double[][] factorLoadings) {
        this.randomVariableFactory = randomVariableFactory;
        this.initialValues = initialValues;
        this.riskFreeRate = riskFreeRate;
        this.factorLoadings = factorLoadings;
        this.initialStates = new RandomVariable[this.getNumberOfComponents()];
        this.drift = new RandomVariable[this.getNumberOfComponents()];
        this.factorLoadingOnPaths = new RandomVariable[this.getNumberOfComponents()][];
        for (int underlyingIndex = 0; underlyingIndex < initialValues.length; ++underlyingIndex) {
            double volatilitySquaredForUnderlying = 0.0;
            this.factorLoadingOnPaths[underlyingIndex] = new RandomVariable[factorLoadings[underlyingIndex].length];
            for (int factorIndex = 0; factorIndex < factorLoadings[underlyingIndex].length; ++factorIndex) {
                volatilitySquaredForUnderlying += factorLoadings[underlyingIndex][factorIndex] * factorLoadings[underlyingIndex][factorIndex];
                this.factorLoadingOnPaths[underlyingIndex][factorIndex] = this.getRandomVariableForConstant(factorLoadings[underlyingIndex][factorIndex]);
            }
            this.initialStates[underlyingIndex] = this.getRandomVariableForConstant(Math.log(initialValues[underlyingIndex]));
            this.drift[underlyingIndex] = this.getRandomVariableForConstant(riskFreeRate - volatilitySquaredForUnderlying / 2.0);
        }
        this.process = new EulerSchemeFromProcessModel(this, brownianMotion, EulerSchemeFromProcessModel.Scheme.EULER_FUNCTIONAL);
    }

    public MonteCarloMultiAssetBlackScholesModel(BrownianMotion brownianMotion, double[] initialValues, double riskFreeRate, double[] volatilities, double[][] correlations) {
        this(new RandomVariableFromArrayFactory(), brownianMotion, initialValues, riskFreeRate, MonteCarloMultiAssetBlackScholesModel.getFactorLoadingsFromVolatilityAnCorrelation(volatilities, correlations));
    }

    private static double[][] getFactorLoadingsFromVolatilityAnCorrelation(double[] volatilities, double[][] correlations) {
        double[][] factorLoadings = LinearAlgebra.getFactorMatrix(correlations, correlations.length);
        for (int underlyingIndex = 0; underlyingIndex < factorLoadings.length; ++underlyingIndex) {
            double volatility = volatilities[underlyingIndex];
            for (int factorIndex = 0; factorIndex < factorLoadings[underlyingIndex].length; ++factorIndex) {
                factorLoadings[underlyingIndex][factorIndex] = factorLoadings[underlyingIndex][factorIndex] * volatility;
            }
        }
        return factorLoadings;
    }

    public MonteCarloMultiAssetBlackScholesModel(TimeDiscretization timeDiscretization, int numberOfPaths, double[] initialValues, double riskFreeRate, double[] volatilities, double[][] correlations) {
        this(timeDiscretization, numberOfPaths, 3141, initialValues, riskFreeRate, volatilities, correlations);
    }

    public MonteCarloMultiAssetBlackScholesModel(TimeDiscretization timeDiscretization, int numberOfPaths, int seed, double[] initialValues, double riskFreeRate, double[] volatilities, double[][] correlations) {
        this(new BrownianMotionFromMersenneRandomNumbers(timeDiscretization, initialValues.length, numberOfPaths, seed), initialValues, riskFreeRate, volatilities, correlations);
    }

    @Override
    public RandomVariable[] getInitialState(MonteCarloProcess process) {
        return this.initialStates;
    }

    @Override
    public RandomVariable[] getDrift(MonteCarloProcess process, int timeIndex, RandomVariable[] realizationAtTimeIndex, RandomVariable[] realizationPredictor) {
        return this.drift;
    }

    @Override
    public RandomVariable[] getFactorLoading(MonteCarloProcess process, int timeIndex, int component, RandomVariable[] realizationAtTimeIndex) {
        return this.factorLoadingOnPaths[component];
    }

    @Override
    public RandomVariable applyStateSpaceTransform(MonteCarloProcess process, int timeIndex, int componentIndex, RandomVariable randomVariable) {
        return randomVariable.exp();
    }

    @Override
    public RandomVariable applyStateSpaceTransformInverse(MonteCarloProcess process, int timeIndex, int componentIndex, RandomVariable randomVariable) {
        return randomVariable.log();
    }

    @Override
    public RandomVariable getAssetValue(double time, int assetIndex) throws CalculationException {
        int timeIndex = this.getTimeIndex(time);
        if (timeIndex < 0) {
            timeIndex = -timeIndex - 1;
        }
        return this.getAssetValue(timeIndex, assetIndex);
    }

    @Override
    public RandomVariable getAssetValue(int timeIndex, int assetIndex) throws CalculationException {
        return this.process.getProcessValue(timeIndex, assetIndex);
    }

    @Override
    public RandomVariable getMonteCarloWeights(double time) throws CalculationException {
        return this.process.getMonteCarloWeights(this.getTimeIndex(time));
    }

    @Override
    public RandomVariable getNumeraire(MonteCarloProcess process, double time) {
        double numeraireValue = Math.exp(this.riskFreeRate * time);
        return this.getRandomVariableForConstant(numeraireValue);
    }

    @Override
    public RandomVariable getNumeraire(int timeIndex) throws CalculationException {
        double time = this.process.getTime(timeIndex);
        return this.getNumeraire(this.process, time);
    }

    @Override
    public RandomVariable getNumeraire(double time) throws CalculationException {
        return this.getNumeraire(this.process, time);
    }

    @Override
    public RandomVariable getRandomVariableForConstant(double value) {
        return this.randomVariableFactory.createRandomVariable(value);
    }

    @Override
    public int getNumberOfComponents() {
        return this.initialValues.length;
    }

    @Override
    public int getNumberOfAssets() {
        return this.getNumberOfComponents();
    }

    public String toString() {
        return "MonteCarloMultiAssetBlackScholesModel [initialValues=" + Arrays.toString(this.initialValues) + ", riskFreeRate=" + this.riskFreeRate + ", factorLoadings=" + Arrays.toString((Object[])this.factorLoadings) + "]";
    }

    public double getRiskFreeRate() {
        return this.riskFreeRate;
    }

    public double[][] getFactorLoadings() {
        return this.factorLoadings;
    }

    public double[] getVolatilities() {
        double[] volatilities = new double[this.factorLoadings.length];
        for (int underlyingIndex = 0; underlyingIndex < this.factorLoadings.length; ++underlyingIndex) {
            double volatilitySquaredOfUnderlying = 0.0;
            for (int factorIndex = 0; factorIndex < this.factorLoadings[underlyingIndex].length; ++factorIndex) {
                double factorLoading = this.factorLoadings[underlyingIndex][factorIndex];
                volatilitySquaredOfUnderlying += factorLoading * factorLoading;
            }
            volatilities[underlyingIndex] = Math.sqrt(volatilitySquaredOfUnderlying);
        }
        return volatilities;
    }

    public double[][] getCorrelations() {
        double[] volatilities = this.getVolatilities();
        double[][] correlations = new double[this.factorLoadings.length][this.factorLoadings.length];
        for (int underlyingIndex1 = 0; underlyingIndex1 < this.factorLoadings.length; ++underlyingIndex1) {
            for (int underlyingIndex2 = 0; underlyingIndex2 < this.factorLoadings.length; ++underlyingIndex2) {
                double covariance = 0.0;
                for (int factorIndex = 0; factorIndex < this.factorLoadings[underlyingIndex1].length; ++factorIndex) {
                    covariance += this.factorLoadings[underlyingIndex1][factorIndex] * this.factorLoadings[underlyingIndex2][factorIndex];
                }
                double correlation = volatilities[underlyingIndex1] != 0.0 && volatilities[underlyingIndex2] != 0.0 ? covariance / volatilities[underlyingIndex1] / volatilities[underlyingIndex2] : (underlyingIndex1 == underlyingIndex2 ? 1.0 : 0.0);
                correlations[underlyingIndex1][underlyingIndex2] = correlation;
            }
        }
        return correlations;
    }

    @Override
    public int getNumberOfPaths() {
        return this.process.getNumberOfPaths();
    }

    @Override
    public MonteCarloMultiAssetBlackScholesModel getCloneWithModifiedData(Map<String, Object> dataModified) {
        BrownianMotion newBrownianMotion = (BrownianMotion)this.process.getStochasticDriver();
        RandomVariableFactory newRandomVariableFactory = (RandomVariableFactory)dataModified.getOrDefault("randomVariableFactory", this.randomVariableFactory);
        double[] newInitialValues = (double[])dataModified.getOrDefault("initialValues", this.initialValues);
        double newRiskFreeRate = (Double)dataModified.getOrDefault("riskFreeRate", this.riskFreeRate);
        double[][] newFactorLoadings = (double[][])dataModified.getOrDefault("factorLoadings", this.factorLoadings);
        if (dataModified.containsKey("volatilities") || dataModified.containsKey("correlations")) {
            if (dataModified.containsKey("factorLoadings")) {
                throw new IllegalArgumentException("Inconsistend parameters. Cannot specify volatility or corellation and factorLoadings at the same time.");
            }
            double[] newVolatilities = (double[])dataModified.getOrDefault("volatilities", this.getVolatilities());
            double[][] newCorrelations = (double[][])dataModified.getOrDefault("correlations", this.getCorrelations());
            newFactorLoadings = MonteCarloMultiAssetBlackScholesModel.getFactorLoadingsFromVolatilityAnCorrelation(newVolatilities, newCorrelations);
        }
        if (dataModified.containsKey("seed")) {
            newBrownianMotion = newBrownianMotion.getCloneWithModifiedSeed((Integer)dataModified.get("seed"));
        }
        if (dataModified.containsKey("timeDiscretization")) {
            newBrownianMotion = newBrownianMotion.getCloneWithModifiedTimeDiscretization((TimeDiscretization)dataModified.get("timeDiscretization"));
        }
        return new MonteCarloMultiAssetBlackScholesModel(newRandomVariableFactory, newBrownianMotion, newInitialValues, newRiskFreeRate, newFactorLoadings);
    }

    @Override
    public AssetModelMonteCarloSimulationModel getCloneWithModifiedSeed(int seed) {
        HashMap<String, Integer> dataModified = new HashMap<String, Integer>();
        dataModified.put("seed", seed);
        return this.getCloneWithModifiedData(dataModified);
    }

    @Override
    public TimeDiscretization getTimeDiscretization() {
        return this.process.getTimeDiscretization();
    }

    @Override
    public double getTime(int timeIndex) {
        return this.process.getTime(timeIndex);
    }

    @Override
    public int getTimeIndex(double time) {
        return this.process.getTimeIndex(time);
    }

    @Override
    public RandomVariable getMonteCarloWeights(int timeIndex) throws CalculationException {
        return this.process.getMonteCarloWeights(timeIndex);
    }

    @Override
    public int getNumberOfFactors() {
        return this.process.getNumberOfFactors();
    }
}

