/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.VarianceGammaProcess;
import net.finmath.montecarlo.assetderivativevaluation.AssetModelMonteCarloSimulationModel;
import net.finmath.montecarlo.assetderivativevaluation.models.VarianceGammaModel;
import net.finmath.montecarlo.process.EulerSchemeFromProcessModel;
import net.finmath.montecarlo.process.MonteCarloProcess;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.TimeDiscretization;

public class MonteCarloVarianceGammaModel
implements AssetModelMonteCarloSimulationModel {
    private final VarianceGammaModel model;
    private final MonteCarloProcess process;
    private final double initialValue;
    private final int seed;

    public MonteCarloVarianceGammaModel(TimeDiscretization timeDiscretization, int numberOfPaths, int seed, double initialValue, double riskFreeRate, double sigma, double theta, double nu) {
        this.initialValue = initialValue;
        this.seed = seed;
        this.model = new VarianceGammaModel(initialValue, riskFreeRate, sigma, theta, nu);
        this.process = new EulerSchemeFromProcessModel(this.model, new VarianceGammaProcess(sigma, nu, theta, timeDiscretization, 1, numberOfPaths, seed));
    }

    @Override
    public LocalDateTime getReferenceDate() {
        throw new UnsupportedOperationException("This model does not provide a reference date. Reference dates will be mandatory in a future version.");
    }

    @Override
    public RandomVariable getAssetValue(double time, int assetIndex) throws CalculationException {
        return this.getAssetValue(this.getTimeIndex(time), assetIndex);
    }

    @Override
    public RandomVariable getAssetValue(int timeIndex, int assetIndex) throws CalculationException {
        return this.process.getProcessValue(timeIndex, assetIndex);
    }

    @Override
    public RandomVariable getNumeraire(int timeIndex) throws CalculationException {
        double time = this.getTime(timeIndex);
        return this.model.getNumeraire(this.process, time);
    }

    @Override
    public RandomVariable getNumeraire(double time) throws CalculationException {
        return this.model.getNumeraire(this.process, time);
    }

    @Override
    public RandomVariable getMonteCarloWeights(double time) throws CalculationException {
        return this.getMonteCarloWeights(this.getTimeIndex(time));
    }

    @Override
    public int getNumberOfAssets() {
        return 1;
    }

    @Override
    public AssetModelMonteCarloSimulationModel getCloneWithModifiedData(Map<String, Object> dataModified) {
        double newInitialTime = dataModified.get("initialTime") != null ? ((Number)dataModified.get("initialTime")).doubleValue() : this.getTime(0);
        double newInitialValue = dataModified.get("initialValue") != null ? ((Number)dataModified.get("initialValue")).doubleValue() : this.initialValue;
        double newRiskFreeRate = dataModified.get("riskFreeRate") != null ? ((Number)dataModified.get("riskFreeRate")).doubleValue() : this.model.getRiskFreeRate().doubleValue().doubleValue();
        double newSigma = dataModified.get("sigma") != null ? ((Number)dataModified.get("sigma")).doubleValue() : this.model.getSigma().doubleValue().doubleValue();
        double newTheta = dataModified.get("theta") != null ? ((Number)dataModified.get("theta")).doubleValue() : this.model.getTheta().doubleValue().doubleValue();
        double newNu = dataModified.get("nu") != null ? ((Number)dataModified.get("nu")).doubleValue() : this.model.getNu().doubleValue().doubleValue();
        int newSeed = dataModified.get("seed") != null ? ((Number)dataModified.get("seed")).intValue() : this.seed;
        return new MonteCarloVarianceGammaModel(this.process.getTimeDiscretization().getTimeShiftedTimeDiscretization(newInitialTime - this.getTime(0)), this.process.getNumberOfPaths(), newSeed, newInitialValue, newRiskFreeRate, newSigma, newTheta, newNu);
    }

    @Override
    public AssetModelMonteCarloSimulationModel getCloneWithModifiedSeed(int seed) {
        HashMap<String, Integer> dataModified = new HashMap<String, Integer>();
        dataModified.put("seed", new Integer(seed));
        return this.getCloneWithModifiedData(dataModified);
    }

    @Override
    public int getNumberOfPaths() {
        return this.process.getNumberOfPaths();
    }

    @Override
    public TimeDiscretization getTimeDiscretization() {
        return this.process.getTimeDiscretization();
    }

    @Override
    public double getTime(int timeIndex) {
        return this.process.getTime(timeIndex);
    }

    @Override
    public int getTimeIndex(double time) {
        return this.process.getTimeIndex(time);
    }

    @Override
    public RandomVariable getRandomVariableForConstant(double value) {
        return this.model.getRandomVariableForConstant(value);
    }

    @Override
    public RandomVariable getMonteCarloWeights(int timeIndex) throws CalculationException {
        return this.process.getMonteCarloWeights(timeIndex);
    }
}

