/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation.models;

import java.util.Map;
import net.finmath.marketdata.model.curves.DiscountCurve;
import net.finmath.montecarlo.RandomVariableFactory;
import net.finmath.montecarlo.model.AbstractProcessModel;
import net.finmath.montecarlo.process.MonteCarloProcess;
import net.finmath.stochastic.RandomVariable;

public class BlackScholesModelWithCurves
extends AbstractProcessModel {
    private final RandomVariable initialValue;
    private final RandomVariable volatility;
    private final DiscountCurve discountCurveForForwardRate;
    private final DiscountCurve discountCurveForDiscountRate;
    private final RandomVariableFactory randomVariableFactory;
    private final RandomVariable[] initialState;
    private final RandomVariable driftAdjustment;
    private final RandomVariable[] factorLoadings;

    public BlackScholesModelWithCurves(RandomVariable initialValue, DiscountCurve discountCurveForForwardRate, RandomVariable volatility, DiscountCurve discountCurveForDiscountRate, RandomVariableFactory randomVariableFactory) {
        this.initialValue = initialValue;
        this.volatility = volatility;
        this.discountCurveForForwardRate = discountCurveForForwardRate;
        this.discountCurveForDiscountRate = discountCurveForDiscountRate;
        this.randomVariableFactory = randomVariableFactory;
        this.initialState = new RandomVariable[]{initialValue.log()};
        this.driftAdjustment = volatility.squared().div(-2.0);
        this.factorLoadings = new RandomVariable[]{volatility};
    }

    public BlackScholesModelWithCurves(Double initialValue, DiscountCurve discountCurveForForwardRate, Double volatility, DiscountCurve discountCurveForDiscountRate, RandomVariableFactory randomVariableFactory) {
        this(randomVariableFactory.createRandomVariable(initialValue), discountCurveForForwardRate, randomVariableFactory.createRandomVariable(volatility), discountCurveForDiscountRate, randomVariableFactory);
    }

    @Override
    public RandomVariable[] getInitialState(MonteCarloProcess process) {
        return this.initialState;
    }

    @Override
    public RandomVariable[] getDrift(MonteCarloProcess process, int timeIndex, RandomVariable[] realizationAtTimeIndex, RandomVariable[] realizationPredictor) {
        double time = process.getTime(timeIndex);
        double timeNext = process.getTime(timeIndex + 1);
        double rate = Math.log(this.discountCurveForForwardRate.getDiscountFactor(time) / this.discountCurveForForwardRate.getDiscountFactor(timeNext)) / (timeNext - time);
        return new RandomVariable[]{this.driftAdjustment.add(rate)};
    }

    @Override
    public RandomVariable[] getFactorLoading(MonteCarloProcess process, int timeIndex, int component, RandomVariable[] realizationAtTimeIndex) {
        return this.factorLoadings;
    }

    @Override
    public RandomVariable applyStateSpaceTransform(MonteCarloProcess process, int timeIndex, int componentIndex, RandomVariable randomVariable) {
        return randomVariable.exp();
    }

    @Override
    public RandomVariable applyStateSpaceTransformInverse(MonteCarloProcess process, int timeIndex, int componentIndex, RandomVariable randomVariable) {
        return randomVariable.log();
    }

    @Override
    public RandomVariable getNumeraire(MonteCarloProcess process, double time) {
        double discounFactorForDiscounting = this.discountCurveForDiscountRate.getDiscountFactor(time);
        return this.randomVariableFactory.createRandomVariable(1.0 / discounFactorForDiscounting);
    }

    @Override
    public int getNumberOfComponents() {
        return 1;
    }

    @Override
    public int getNumberOfFactors() {
        return 1;
    }

    @Override
    public RandomVariable getRandomVariableForConstant(double value) {
        return this.randomVariableFactory.createRandomVariable(value);
    }

    @Override
    public BlackScholesModelWithCurves getCloneWithModifiedData(Map<String, Object> dataModified) {
        RandomVariable newInitialValue = dataModified.get("initialValue") != null ? (RandomVariable)dataModified.get("initialValue") : this.initialValue;
        RandomVariable newVolatility = dataModified.get("volatility") != null ? (RandomVariable)dataModified.get("volatility") : this.volatility;
        return new BlackScholesModelWithCurves(newInitialValue, this.discountCurveForForwardRate, newVolatility, this.discountCurveForDiscountRate, this.randomVariableFactory);
    }

    public String toString() {
        return super.toString() + "\nBlackScholesModel:\n  initial value...:" + this.initialValue + "\n  forward curve...:" + this.discountCurveForForwardRate + "\n  discount curve..:" + this.discountCurveForDiscountRate + "\n  volatiliy.......:" + this.getVolatility();
    }

    @Override
    public RandomVariable[] getInitialValue(MonteCarloProcess process) {
        return new RandomVariable[]{this.initialValue};
    }

    public RandomVariable getVolatility() {
        return this.factorLoadings[0];
    }
}

