/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation.products;

import java.util.Iterator;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.assetderivativevaluation.AssetModelMonteCarloSimulationModel;
import net.finmath.montecarlo.assetderivativevaluation.products.AbstractAssetMonteCarloProduct;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.TimeDiscretization;

public class AsianOption
extends AbstractAssetMonteCarloProduct {
    private final double maturity;
    private final double strike;
    private final TimeDiscretization timesForAveraging;
    private final Integer underlyingIndex;

    public AsianOption(double maturity, double strike, TimeDiscretization timesForAveraging, Integer underlyingIndex) {
        this.maturity = maturity;
        this.strike = strike;
        this.timesForAveraging = timesForAveraging;
        this.underlyingIndex = underlyingIndex;
    }

    public AsianOption(double maturity, double strike, TimeDiscretization timesForAveraging) {
        this(maturity, strike, timesForAveraging, 0);
    }

    @Override
    public RandomVariable getValue(double evaluationTime, AssetModelMonteCarloSimulationModel model) throws CalculationException {
        RandomVariable average = model.getRandomVariableForConstant(0.0);
        Iterator iterator = this.timesForAveraging.iterator();
        while (iterator.hasNext()) {
            double time = (Double)iterator.next();
            RandomVariable underlying = model.getAssetValue(time, (int)this.underlyingIndex);
            average = average.add(underlying);
        }
        average = average.div(this.timesForAveraging.getNumberOfTimes());
        RandomVariable values = average.sub(this.strike).floor(0.0);
        RandomVariable numeraireAtMaturity = model.getNumeraire(this.maturity);
        RandomVariable monteCarloWeights = model.getMonteCarloWeights(this.maturity);
        values = values.div(numeraireAtMaturity).mult(monteCarloWeights);
        RandomVariable numeraireAtEvalTime = model.getNumeraire(evaluationTime);
        RandomVariable monteCarloWeightsAtEvalTime = model.getMonteCarloWeights(evaluationTime);
        values = values.mult(numeraireAtEvalTime).div(monteCarloWeightsAtEvalTime);
        return values;
    }

    public double getMaturity() {
        return this.maturity;
    }

    public double getStrike() {
        return this.strike;
    }

    public TimeDiscretization getTimesForAveraging() {
        return this.timesForAveraging;
    }

    public Integer getUnderlyingIndex() {
        return this.underlyingIndex;
    }
}

