/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation.products;

import java.util.Map;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.RandomVariableFromDoubleArray;
import net.finmath.montecarlo.assetderivativevaluation.AssetModelMonteCarloSimulationModel;
import net.finmath.montecarlo.assetderivativevaluation.products.AbstractAssetMonteCarloProduct;
import net.finmath.montecarlo.conditionalexpectation.MonteCarloConditionalExpectationRegression;
import net.finmath.optimizer.GoldenSectionSearch;
import net.finmath.stochastic.RandomVariable;
import net.finmath.stochastic.Scalar;

public class BermudanDigitalOption
extends AbstractAssetMonteCarloProduct {
    private final double[] exerciseDates;
    private final double[] notionals;
    private final double[] strikes;
    private int orderOfRegressionPolynomial = 4;
    private final boolean intrinsicValueAsBasisFunction = true;
    private ExerciseMethod exerciseMethod = ExerciseMethod.ESTIMATE_COND_EXPECTATION;

    public BermudanDigitalOption(double[] exerciseDates, double[] notionals, double[] strikes, ExerciseMethod exerciseMethod, Map<String, Object> properties) {
        this.exerciseDates = exerciseDates;
        this.notionals = notionals;
        this.strikes = strikes;
        this.exerciseMethod = exerciseMethod;
        this.orderOfRegressionPolynomial = (Integer)properties.getOrDefault("orderOfRegressionPolynomial", 4);
    }

    @Override
    public RandomVariable getValue(double evaluationTime, AssetModelMonteCarloSimulationModel model) throws CalculationException {
        if (this.exerciseMethod == ExerciseMethod.UPPER_BOUND_METHOD) {
            GoldenSectionSearch optimizer = new GoldenSectionSearch(-1.0, 1.0);
            while (!optimizer.isDone()) {
                double lambda = optimizer.getNextPoint();
                double value = this.getValues(evaluationTime, model, lambda).getAverage();
                optimizer.setValue(value);
            }
            return this.getValues(evaluationTime, model, optimizer.getBestPoint());
        }
        return this.getValues(evaluationTime, model, 0.0);
    }

    private RandomVariable getValues(double evaluationTime, AssetModelMonteCarloSimulationModel model, double lambda) throws CalculationException {
        RandomVariable value = model.getRandomVariableForConstant(0.0);
        RandomVariable exerciseTime = model.getRandomVariableForConstant(this.exerciseDates[this.exerciseDates.length - 1] + 1.0);
        RandomVariable one = model.getRandomVariableForConstant(1.0);
        for (int exerciseDateIndex = this.exerciseDates.length - 1; exerciseDateIndex >= 0; --exerciseDateIndex) {
            double exerciseDate = this.exerciseDates[exerciseDateIndex];
            double notional = this.notionals[exerciseDateIndex];
            double strike = this.strikes[exerciseDateIndex];
            RandomVariable underlyingAtExercise = model.getAssetValue(exerciseDate, 0);
            RandomVariable numeraireAtPayment = model.getNumeraire(exerciseDate);
            RandomVariable monteCarloWeights = model.getMonteCarloWeights(exerciseDate);
            RandomVariable valueOfPaymentsIfExercised = one.mult(notional).div(numeraireAtPayment).mult(monteCarloWeights);
            MonteCarloConditionalExpectationRegression condExpEstimator = new MonteCarloConditionalExpectationRegression(this.getRegressionBasisFunctions(underlyingAtExercise));
            RandomVariable underlying = null;
            RandomVariable trigger = null;
            switch (this.exerciseMethod) {
                case ESTIMATE_COND_EXPECTATION: {
                    RandomVariable valueIfNotExcercisedEstimated = value.getConditionalExpectation(condExpEstimator);
                    underlying = underlyingAtExercise.sub(strike).mult(notional).div(numeraireAtPayment).mult(monteCarloWeights);
                    trigger = underlying.sub(valueIfNotExcercisedEstimated);
                    break;
                }
                case UPPER_BOUND_METHOD: {
                    throw new UnsupportedOperationException(this.exerciseMethod + " is currently not supported.");
                }
                default: {
                    throw new IllegalArgumentException("Unknown exerciseMethod " + this.exerciseMethod + ".");
                }
            }
            value = trigger.choose(valueOfPaymentsIfExercised, value);
            exerciseTime = trigger.choose(exerciseTime, new Scalar(exerciseDate));
        }
        RandomVariable numeraireAtEvalTime = model.getNumeraire(evaluationTime);
        RandomVariable monteCarloWeightsAtEvalTime = model.getMonteCarloWeights(evaluationTime);
        value = value.mult(numeraireAtEvalTime).div(monteCarloWeightsAtEvalTime);
        return value;
    }

    private RandomVariable[] getRegressionBasisFunctions(RandomVariable underlying) {
        RandomVariable[] basisFunctions = new RandomVariable[this.orderOfRegressionPolynomial + 1];
        basisFunctions[0] = new RandomVariableFromDoubleArray(1.0);
        basisFunctions[1] = underlying;
        for (int powerOfRegressionMonomial = 2; powerOfRegressionMonomial <= this.orderOfRegressionPolynomial; ++powerOfRegressionMonomial) {
            basisFunctions[powerOfRegressionMonomial] = underlying.pow(powerOfRegressionMonomial);
        }
        return basisFunctions;
    }

    public static enum ExerciseMethod {
        ESTIMATE_COND_EXPECTATION,
        UPPER_BOUND_METHOD;

    }
}

