/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation.products;

import java.util.ArrayList;
import java.util.Arrays;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.RandomVariableFromDoubleArray;
import net.finmath.montecarlo.assetderivativevaluation.AssetModelMonteCarloSimulationModel;
import net.finmath.montecarlo.assetderivativevaluation.products.AbstractAssetMonteCarloProduct;
import net.finmath.montecarlo.conditionalexpectation.MonteCarloConditionalExpectationRegression;
import net.finmath.optimizer.GoldenSectionSearch;
import net.finmath.stochastic.RandomVariable;
import net.finmath.stochastic.Scalar;

public class BermudanOption
extends AbstractAssetMonteCarloProduct {
    private final double[] exerciseDates;
    private final double[] notionals;
    private final double[] strikes;
    private final int orderOfRegressionPolynomial = 4;
    private final boolean intrinsicValueAsBasisFunction = false;
    private final ExerciseMethod exerciseMethod;
    private RandomVariable lastValuationExerciseTime;

    public BermudanOption(double[] exerciseDates, double[] notionals, double[] strikes, ExerciseMethod exerciseMethod) {
        this.exerciseDates = exerciseDates;
        this.notionals = notionals;
        this.strikes = strikes;
        this.exerciseMethod = exerciseMethod;
    }

    public BermudanOption(double[] exerciseDates, double[] notionals, double[] strikes) {
        this(exerciseDates, notionals, strikes, ExerciseMethod.ESTIMATE_COND_EXPECTATION);
    }

    @Override
    public RandomVariable getValue(double evaluationTime, AssetModelMonteCarloSimulationModel model) throws CalculationException {
        if (this.exerciseMethod == ExerciseMethod.UPPER_BOUND_METHOD) {
            GoldenSectionSearch optimizer = new GoldenSectionSearch(-1.0, 1.0);
            while (!optimizer.isDone()) {
                double lambda = optimizer.getNextPoint();
                double value = this.getValues(evaluationTime, model, lambda).getAverage();
                optimizer.setValue(value);
            }
            return this.getValues(evaluationTime, model, optimizer.getBestPoint());
        }
        return this.getValues(evaluationTime, model, 0.0);
    }

    private RandomVariable getValues(double evaluationTime, AssetModelMonteCarloSimulationModel model, double lambda) throws CalculationException {
        RandomVariable value = model.getRandomVariableForConstant(0.0);
        RandomVariable exerciseTime = model.getRandomVariableForConstant(this.exerciseDates[this.exerciseDates.length - 1] + 1.0);
        for (int exerciseDateIndex = this.exerciseDates.length - 1; exerciseDateIndex >= 0; --exerciseDateIndex) {
            double exerciseDate = this.exerciseDates[exerciseDateIndex];
            double notional = this.notionals[exerciseDateIndex];
            double strike = this.strikes[exerciseDateIndex];
            RandomVariable underlyingAtExercise = model.getAssetValue(exerciseDate, 0);
            RandomVariable numeraireAtPayment = model.getNumeraire(exerciseDate);
            RandomVariable monteCarloWeights = model.getMonteCarloWeights(exerciseDate);
            RandomVariable valueOfPaymentsIfExercised = underlyingAtExercise.sub(strike).mult(notional).div(numeraireAtPayment).mult(monteCarloWeights);
            RandomVariable exerciseValue = null;
            RandomVariable exerciseCriteria = null;
            switch (this.exerciseMethod) {
                case ESTIMATE_COND_EXPECTATION: {
                    ArrayList<RandomVariable> basisFunctions = this.getRegressionBasisFunctions(underlyingAtExercise);
                    MonteCarloConditionalExpectationRegression condExpEstimator = new MonteCarloConditionalExpectationRegression(basisFunctions.toArray(new RandomVariable[0]));
                    RandomVariable valueIfNotExcercisedEstimated = value.getConditionalExpectation(condExpEstimator);
                    exerciseValue = valueOfPaymentsIfExercised;
                    exerciseCriteria = valueIfNotExcercisedEstimated.sub(exerciseValue);
                    break;
                }
                case UPPER_BOUND_METHOD: {
                    RandomVariable martingale = model.getAssetValue(this.exerciseDates[exerciseDateIndex], 0).div(model.getNumeraire(this.exerciseDates[exerciseDateIndex]));
                    martingale = martingale.sub(martingale.getAverage()).mult(lambda);
                    if (exerciseDateIndex == this.exerciseDates.length - 1) {
                        value = value.sub(martingale);
                    }
                    exerciseValue = valueOfPaymentsIfExercised.sub(martingale);
                    exerciseCriteria = value.sub(exerciseValue);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown exerciseMethod " + this.exerciseMethod + ".");
                }
            }
            value = exerciseCriteria.choose(value, exerciseValue);
            exerciseTime = exerciseCriteria.choose(exerciseTime, new Scalar(exerciseDate));
        }
        this.lastValuationExerciseTime = exerciseTime;
        RandomVariable numeraireAtEvalTime = model.getNumeraire(evaluationTime);
        RandomVariable monteCarloWeightsAtEvalTime = model.getMonteCarloWeights(evaluationTime);
        value = value.mult(numeraireAtEvalTime).div(monteCarloWeightsAtEvalTime);
        return value;
    }

    public RandomVariable getLastValuationExerciseTime() {
        return this.lastValuationExerciseTime;
    }

    public double[] getExerciseDates() {
        return this.exerciseDates;
    }

    public double[] getNotionals() {
        return this.notionals;
    }

    public double[] getStrikes() {
        return this.strikes;
    }

    private ArrayList<RandomVariable> getRegressionBasisFunctions(RandomVariable underlying) {
        ArrayList<RandomVariable> basisFunctions = new ArrayList<RandomVariable>();
        underlying = new RandomVariableFromDoubleArray(0.0, underlying.getRealizations());
        for (int powerOfRegressionMonomial = 0; powerOfRegressionMonomial <= 4; ++powerOfRegressionMonomial) {
            basisFunctions.add(underlying.pow(powerOfRegressionMonomial));
        }
        return basisFunctions;
    }

    private ArrayList<RandomVariable> getRegressionBasisFunctionsBinning(RandomVariable underlying) {
        ArrayList<RandomVariable> basisFunctions = new ArrayList<RandomVariable>();
        underlying = new RandomVariableFromDoubleArray(0.0, underlying.getRealizations());
        int numberOfBins = 20;
        double[] values = underlying.getRealizations();
        Arrays.sort(values);
        for (int i = 0; i < 20; ++i) {
            double binLeft = values[(int)((double)i / 20.0 * (double)values.length)];
            RandomVariable basisFunction = underlying.sub(binLeft).choose(new RandomVariableFromDoubleArray(1.0), new RandomVariableFromDoubleArray(0.0));
            basisFunctions.add(basisFunction);
        }
        return basisFunctions;
    }

    public static enum ExerciseMethod {
        ESTIMATE_COND_EXPECTATION,
        UPPER_BOUND_METHOD;

    }
}

