/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation.products;

import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.assetderivativevaluation.AssetModelMonteCarloSimulationModel;
import net.finmath.montecarlo.assetderivativevaluation.MonteCarloBlackScholesModel;
import net.finmath.montecarlo.assetderivativevaluation.products.AbstractAssetMonteCarloProduct;
import net.finmath.stochastic.RandomVariable;
import net.finmath.stochastic.RandomVariableAccumulator;

public class EuropeanOptionRhoLikelihood
extends AbstractAssetMonteCarloProduct {
    private final double maturity;
    private final double strike;
    private final boolean isLikelihoodByFiniteDifference = true;

    public EuropeanOptionRhoLikelihood(double maturity, double strike) {
        this.maturity = maturity;
        this.strike = strike;
    }

    public double getValue(AssetModelMonteCarloSimulationModel model) throws CalculationException {
        MonteCarloBlackScholesModel blackScholesModel = null;
        try {
            blackScholesModel = (MonteCarloBlackScholesModel)model;
        }
        catch (Exception e) {
            throw new ClassCastException("This method requires a Black-Scholes type model (MonteCarloBlackScholesModel).");
        }
        RandomVariable underlyingAtMaturity = model.getAssetValue(this.maturity, 0);
        RandomVariable numeraireAtMaturity = model.getNumeraire(this.maturity);
        RandomVariable underlyingAtToday = model.getAssetValue(0.0, 0);
        RandomVariable numeraireAtToday = model.getNumeraire(0);
        RandomVariable monteCarloWeights = model.getMonteCarloWeights(this.maturity);
        double average = 0.0;
        for (int path = 0; path < model.getNumberOfPaths(); ++path) {
            if (!(underlyingAtMaturity.get(path) > this.strike)) continue;
            double T = this.maturity;
            double S0 = underlyingAtToday.get(path);
            double r = blackScholesModel.getModel().getRiskFreeRate().doubleValue();
            double sigma = blackScholesModel.getModel().getVolatility().doubleValue();
            double ST = underlyingAtMaturity.get(path);
            double x = 1.0 / (sigma * Math.sqrt(T)) * (Math.log(ST) - (r * T - 0.5 * sigma * sigma * T + Math.log(S0)));
            double h = 1.0E-6;
            double x1 = 1.0 / (sigma * Math.sqrt(T)) * (Math.log(ST) - (r * T - 0.5 * sigma * sigma * T + Math.log(S0)));
            double logPhi1 = Math.log(1.0 / Math.sqrt(Math.PI * 2) * Math.exp(-x1 * x1 / 2.0) / (ST * sigma * Math.sqrt(T)));
            double x2 = 1.0 / (sigma * Math.sqrt(T)) * (Math.log(ST) - ((r + 1.0E-6) * T - 0.5 * sigma * sigma * T + Math.log(S0)));
            double logPhi2 = Math.log(1.0 / Math.sqrt(Math.PI * 2) * Math.exp(-x2 * x2 / 2.0) / (ST * sigma * Math.sqrt(T)));
            double lr = (logPhi2 - logPhi1) / 1.0E-6;
            double payOff = underlyingAtMaturity.get(path) - this.strike;
            double modifiedPayoff = payOff * (lr - T);
            average += modifiedPayoff / numeraireAtMaturity.get(path) * monteCarloWeights.get(path) * numeraireAtToday.get(path);
        }
        return average;
    }

    @Override
    public RandomVariableAccumulator getValue(double evaluationTime, AssetModelMonteCarloSimulationModel model) {
        throw new RuntimeException("Method not supported.");
    }
}

