/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation.products;

import java.util.HashMap;
import java.util.Map;
import net.finmath.exception.CalculationException;
import net.finmath.modelling.Model;
import net.finmath.montecarlo.assetderivativevaluation.AssetModelMonteCarloSimulationModel;
import net.finmath.montecarlo.assetderivativevaluation.products.AbstractAssetMonteCarloProduct;
import net.finmath.stochastic.RandomVariable;

public class ForwardAgreement
extends AbstractAssetMonteCarloProduct {
    private final double maturity;
    private final double forwardValue;
    private final Integer underlyingIndex;
    private final String nameOfUnderliyng;

    public ForwardAgreement(String underlyingName, double maturity, double forwardValue) {
        this.nameOfUnderliyng = underlyingName;
        this.maturity = maturity;
        this.forwardValue = forwardValue;
        this.underlyingIndex = 0;
    }

    public ForwardAgreement(double maturity, double forwardValue, int underlyingIndex) {
        this.maturity = maturity;
        this.forwardValue = forwardValue;
        this.underlyingIndex = underlyingIndex;
        this.nameOfUnderliyng = null;
    }

    public ForwardAgreement(double maturity, double forwardValue) {
        this(maturity, forwardValue, 0);
    }

    @Override
    public RandomVariable getValue(double evaluationTime, AssetModelMonteCarloSimulationModel model) throws CalculationException {
        RandomVariable underlyingAtMaturity = model.getAssetValue(this.maturity, (int)this.underlyingIndex);
        RandomVariable values = underlyingAtMaturity.sub(this.forwardValue);
        RandomVariable numeraireAtMaturity = model.getNumeraire(this.maturity);
        RandomVariable monteCarloWeights = model.getMonteCarloWeights(this.maturity);
        values = values.div(numeraireAtMaturity).mult(monteCarloWeights);
        RandomVariable numeraireAtEvalTime = model.getNumeraire(evaluationTime);
        RandomVariable monteCarloProbabilitiesAtEvalTime = model.getMonteCarloWeights(evaluationTime);
        values = values.mult(numeraireAtEvalTime).div(monteCarloProbabilitiesAtEvalTime);
        return values;
    }

    @Override
    public Map<String, Object> getValues(double evaluationTime, Model model) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            double value = this.getValue(evaluationTime, (AssetModelMonteCarloSimulationModel)model).getAverage();
            result.put("value", value);
        }
        catch (CalculationException e) {
            result.put("exception", e);
        }
        return result;
    }
}

