/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.automaticdifferentiation.backward.alternative;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleUnaryOperator;
import java.util.function.IntToDoubleFunction;
import java.util.stream.DoubleStream;
import net.finmath.functions.DoubleTernaryOperator;
import net.finmath.montecarlo.RandomVariableFromDoubleArray;
import net.finmath.stochastic.RandomVariable;

public class RandomVariableAAD
implements RandomVariable {
    private static final long serialVersionUID = 2459373647785530657L;
    private static ArrayList<RandomVariableAAD> arrayListOfAllAADRandomVariables = new ArrayList();
    private static AtomicInteger indexOfNextRandomVariable = new AtomicInteger(0);
    private final RandomVariable ownRandomVariable;
    private final int ownIndexInList;
    private final int[] parentIndices;
    private final OperatorType parentOperator;
    private ArrayList<Integer> childrenIndices;
    private boolean isConstant;

    private RandomVariableAAD(int ownIndexInList, RandomVariable ownRandomVariable, int[] parentIndices, OperatorType parentOperator, ArrayList<Integer> childrenIndices, boolean isConstant) {
        this.ownIndexInList = ownIndexInList;
        this.ownRandomVariable = ownRandomVariable;
        this.parentIndices = parentIndices;
        this.parentOperator = parentOperator;
        this.childrenIndices = childrenIndices;
        this.isConstant = isConstant;
    }

    public static RandomVariableAAD constructNewAADRandomVariable(RandomVariable randomVariable, int[] parentIndices, OperatorType parentOperator, ArrayList<Integer> childrenIndices, boolean isConstant) {
        if (!arrayListOfAllAADRandomVariables.isEmpty() && arrayListOfAllAADRandomVariables.get(0).size() != randomVariable.size() && !randomVariable.isDeterministic()) {
            throw new IllegalArgumentException("RandomVariables with different sizes are not supported at the moment!");
        }
        int indexOfThisAADRandomVariable = indexOfNextRandomVariable.getAndIncrement();
        RandomVariableAAD newAADRandomVariable = new RandomVariableAAD(indexOfThisAADRandomVariable, randomVariable, parentIndices, parentOperator, childrenIndices, isConstant);
        arrayListOfAllAADRandomVariables.add(indexOfThisAADRandomVariable, newAADRandomVariable);
        return newAADRandomVariable;
    }

    public static RandomVariableAAD constructNewAADRandomVariable(double value) {
        return RandomVariableAAD.constructNewAADRandomVariable(new RandomVariableFromDoubleArray(value), null, null, null, true);
    }

    public static RandomVariableAAD constructNewAADRandomVariable(RandomVariable randomVariable) {
        return RandomVariableAAD.constructNewAADRandomVariable(randomVariable, null, null, null, false);
    }

    public static RandomVariableAAD constructNewAADRandomVariable(double time, double[] realisations) {
        return RandomVariableAAD.constructNewAADRandomVariable(new RandomVariableFromDoubleArray(time, realisations), null, null, null, false);
    }

    private RandomVariableAAD[] getParentAADRandomVariables() {
        if (this.getParentIDs() == null) {
            return null;
        }
        int[] parentIndices = this.getParentIDs();
        RandomVariableAAD[] parentAADRandomVariables = new RandomVariableAAD[this.getNumberOfParentVariables()];
        for (int i = 0; i < parentAADRandomVariables.length; ++i) {
            parentAADRandomVariables[i] = this.getAADRandomVariableFromList(parentIndices[i]);
        }
        return parentAADRandomVariables;
    }

    private RandomVariable[] getParentRandomVariableInderfaces() {
        RandomVariableAAD[] parentAADRandomVariables = this.getParentAADRandomVariables();
        RandomVariable[] parentRandomVariableInderfaces = new RandomVariable[parentAADRandomVariables.length];
        for (int i = 0; i < parentAADRandomVariables.length; ++i) {
            parentRandomVariableInderfaces[i] = parentAADRandomVariables[i].getRandomVariableInterface();
        }
        return parentRandomVariableInderfaces;
    }

    private RandomVariable apply(OperatorType operator, RandomVariable[] randomVariableInterfaces) {
        RandomVariable resultrandomvariable;
        int[] futureParentIndices;
        RandomVariableAAD[] aadRandomVariables;
        block38: {
            block40: {
                RandomVariable Y;
                RandomVariable X;
                block39: {
                    block37: {
                        aadRandomVariables = new RandomVariableAAD[randomVariableInterfaces.length];
                        futureParentIndices = new int[aadRandomVariables.length];
                        for (int randomVariableIndex = 0; randomVariableIndex < randomVariableInterfaces.length; ++randomVariableIndex) {
                            aadRandomVariables[randomVariableIndex] = randomVariableInterfaces[randomVariableIndex] instanceof RandomVariableAAD ? (RandomVariableAAD)randomVariableInterfaces[randomVariableIndex] : RandomVariableAAD.constructNewAADRandomVariable(randomVariableInterfaces[randomVariableIndex]);
                            futureParentIndices[randomVariableIndex] = aadRandomVariables[randomVariableIndex].getFunctionIndex();
                        }
                        if (randomVariableInterfaces.length != 1) break block37;
                        X = aadRandomVariables[0].getRandomVariableInterface();
                        switch (operator) {
                            case SQUARED: {
                                resultrandomvariable = X.squared();
                                break block38;
                            }
                            case SQRT: {
                                resultrandomvariable = X.sqrt();
                                break block38;
                            }
                            case EXP: {
                                resultrandomvariable = X.exp();
                                break block38;
                            }
                            case LOG: {
                                resultrandomvariable = X.log();
                                break block38;
                            }
                            case SIN: {
                                resultrandomvariable = X.sin();
                                break block38;
                            }
                            case COS: {
                                resultrandomvariable = X.cos();
                                break block38;
                            }
                            case ABS: {
                                resultrandomvariable = X.abs();
                                break block38;
                            }
                            case INVERT: {
                                resultrandomvariable = X.invert();
                                break block38;
                            }
                            case AVERAGE: {
                                resultrandomvariable = new RandomVariableFromDoubleArray(X.getAverage());
                                break block38;
                            }
                            case STDERROR: {
                                resultrandomvariable = new RandomVariableFromDoubleArray(X.getStandardError());
                                break block38;
                            }
                            case STDEV: {
                                resultrandomvariable = new RandomVariableFromDoubleArray(X.getStandardDeviation());
                                break block38;
                            }
                            case VARIANCE: {
                                resultrandomvariable = new RandomVariableFromDoubleArray(X.getVariance());
                                break block38;
                            }
                            case SVARIANCE: {
                                resultrandomvariable = new RandomVariableFromDoubleArray(X.getSampleVariance());
                                break block38;
                            }
                            default: {
                                throw new IllegalArgumentException();
                            }
                        }
                    }
                    if (randomVariableInterfaces.length != 2) break block39;
                    X = aadRandomVariables[0].getRandomVariableInterface();
                    Y = aadRandomVariables[1].getRandomVariableInterface();
                    switch (operator) {
                        case ADD: {
                            resultrandomvariable = X.add(Y);
                            break block38;
                        }
                        case SUB: {
                            resultrandomvariable = X.sub(Y);
                            break block38;
                        }
                        case MULT: {
                            resultrandomvariable = X.mult(Y);
                            break block38;
                        }
                        case DIV: {
                            resultrandomvariable = X.div(Y);
                            break block38;
                        }
                        case CAP: {
                            resultrandomvariable = X.cap(Y.getAverage());
                            break block38;
                        }
                        case FLOOR: {
                            resultrandomvariable = X.floor(Y.getAverage());
                            break block38;
                        }
                        case POW: {
                            resultrandomvariable = X.pow(Y.getAverage());
                            break block38;
                        }
                        case AVERAGE: {
                            resultrandomvariable = new RandomVariableFromDoubleArray(X.getAverage(Y));
                            break block38;
                        }
                        case STDERROR: {
                            resultrandomvariable = new RandomVariableFromDoubleArray(X.getStandardError(Y));
                            break block38;
                        }
                        case STDEV: {
                            resultrandomvariable = new RandomVariableFromDoubleArray(X.getStandardDeviation(Y));
                            break block38;
                        }
                        case VARIANCE: {
                            resultrandomvariable = new RandomVariableFromDoubleArray(X.getVariance(Y));
                            break block38;
                        }
                        default: {
                            throw new IllegalArgumentException();
                        }
                    }
                }
                if (randomVariableInterfaces.length != 3) break block40;
                X = aadRandomVariables[0].getRandomVariableInterface();
                Y = aadRandomVariables[1].getRandomVariableInterface();
                RandomVariable Z = aadRandomVariables[2].getRandomVariableInterface();
                switch (operator) {
                    case ADDPRODUCT: {
                        resultrandomvariable = X.addProduct(Y, Z);
                        break block38;
                    }
                    case ADDRATIO: {
                        resultrandomvariable = X.addRatio(Y, Z);
                        break block38;
                    }
                    case SUBRATIO: {
                        resultrandomvariable = X.subRatio(Y, Z);
                        break block38;
                    }
                    case ACCRUE: {
                        resultrandomvariable = X.accrue(Y, Z.getAverage());
                        break block38;
                    }
                    case DISCOUNT: {
                        resultrandomvariable = X.discount(Y, Z.getAverage());
                        break block38;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            throw new IllegalArgumentException("Operation not supported!\n");
        }
        RandomVariableAAD newRandomVariableAAD = RandomVariableAAD.constructNewAADRandomVariable(resultrandomvariable, futureParentIndices, operator, null, false);
        for (RandomVariableAAD parentRandomVariable : aadRandomVariables) {
            parentRandomVariable.addToChildrenIndices(newRandomVariableAAD.getFunctionIndex());
        }
        return newRandomVariableAAD;
    }

    public String toString() {
        return super.toString() + "\ntime: " + this.getFiltrationTime() + "\nrealizations: " + Arrays.toString(this.getRealizations()) + "\nvariableID: " + this.getFunctionIndex() + "\nparentIDs: " + Arrays.toString(this.getParentIDs()) + (String)(this.getParentIDs() == null ? "" : " type: " + this.parentOperator.name()) + "\nisTrueVariable: " + this.isVariable() + "\n";
    }

    private RandomVariable getPartialDerivative(int functionIndex, int variableIndex) {
        return this.getFunctionList().get(functionIndex).partialDerivativeWithRespectTo(variableIndex);
    }

    private RandomVariable partialDerivativeWithRespectTo(int variableIndex) {
        int[] parentIDsSorted = this.getParentIDs() == null ? new int[]{} : (int[])this.getParentIDs().clone();
        Arrays.sort(parentIDsSorted);
        if (Arrays.binarySearch(parentIDsSorted, variableIndex) < 0 || this.isConstant) {
            return new RandomVariableFromDoubleArray(0.0);
        }
        RandomVariable resultrandomvariable = null;
        if (this.getParentIDs().length == 1) {
            final RandomVariable X = this.getRandomVariableInterfaceOfIndex(this.getParentIDs()[0]);
            switch (this.parentOperator) {
                case SQUARED: {
                    resultrandomvariable = X.mult(2.0);
                    break;
                }
                case SQRT: {
                    resultrandomvariable = X.sqrt().invert().mult(0.5);
                    break;
                }
                case EXP: {
                    resultrandomvariable = X.exp();
                    break;
                }
                case LOG: {
                    resultrandomvariable = X.invert();
                    break;
                }
                case SIN: {
                    resultrandomvariable = X.cos();
                    break;
                }
                case COS: {
                    resultrandomvariable = X.sin().mult(-1.0);
                    break;
                }
                case AVERAGE: {
                    resultrandomvariable = new RandomVariableFromDoubleArray(X.size()).invert();
                    break;
                }
                case VARIANCE: {
                    resultrandomvariable = X.sub(X.getAverage() * (2.0 * (double)X.size() - 1.0) / (double)X.size()).mult(2.0 / (double)X.size());
                    break;
                }
                case STDEV: {
                    resultrandomvariable = X.sub(X.getAverage() * (2.0 * (double)X.size() - 1.0) / (double)X.size()).mult(2.0 / (double)X.size()).mult(0.5).div(Math.sqrt(X.getVariance()));
                    break;
                }
                case MIN: {
                    resultrandomvariable = X.apply(new DoubleUnaryOperator(){

                        @Override
                        public double applyAsDouble(double x) {
                            return x == X.getMin() ? 1.0 : 0.0;
                        }
                    });
                    break;
                }
                case MAX: {
                    resultrandomvariable = X.apply(new DoubleUnaryOperator(){

                        @Override
                        public double applyAsDouble(double x) {
                            return x == X.getMax() ? 1.0 : 0.0;
                        }
                    });
                    break;
                }
                case ABS: {
                    resultrandomvariable = X.apply(new DoubleUnaryOperator(){

                        @Override
                        public double applyAsDouble(double x) {
                            return x > 0.0 ? 1.0 : (x < 0.0 ? -1.0 : 0.0);
                        }
                    });
                    break;
                }
                case STDERROR: {
                    resultrandomvariable = X.sub(X.getAverage() * (2.0 * (double)X.size() - 1.0) / (double)X.size()).mult(2.0 / (double)X.size()).mult(0.5).div(Math.sqrt(X.getVariance() * (double)X.size()));
                    break;
                }
                case SVARIANCE: {
                    resultrandomvariable = X.sub(X.getAverage() * (2.0 * (double)X.size() - 1.0) / (double)X.size()).mult(2.0 / (double)(X.size() - 1));
                    break;
                }
            }
        } else if (this.getParentIDs().length == 2) {
            RandomVariable X = this.getRandomVariableInterfaceOfIndex(this.getParentIDs()[0]);
            final RandomVariable Y = this.getRandomVariableInterfaceOfIndex(this.getParentIDs()[1]);
            switch (this.parentOperator) {
                case ADD: {
                    resultrandomvariable = new RandomVariableFromDoubleArray(1.0);
                    break;
                }
                case SUB: {
                    resultrandomvariable = new RandomVariableFromDoubleArray(variableIndex == this.getParentIDs()[0] ? 1.0 : -1.0);
                    break;
                }
                case MULT: {
                    resultrandomvariable = variableIndex == this.getParentIDs()[0] ? Y : X;
                    break;
                }
                case DIV: {
                    resultrandomvariable = variableIndex == this.getParentIDs()[0] ? Y.invert() : X.div(Y.squared()).mult(-1.0);
                    break;
                }
                case CAP: {
                    resultrandomvariable = X.apply(new DoubleUnaryOperator(){

                        @Override
                        public double applyAsDouble(double x) {
                            return x > Y.getAverage() ? 0.0 : 1.0;
                        }
                    });
                    break;
                }
                case FLOOR: {
                    resultrandomvariable = X.apply(new DoubleUnaryOperator(){

                        @Override
                        public double applyAsDouble(double x) {
                            return x > Y.getAverage() ? 1.0 : 0.0;
                        }
                    });
                    break;
                }
                case AVERAGE: {
                    resultrandomvariable = variableIndex == this.getParentIDs()[0] ? Y : X;
                    break;
                }
                case VARIANCE: {
                    resultrandomvariable = variableIndex == this.getParentIDs()[0] ? Y.mult(2.0).mult(X.mult(Y.add(X.getAverage(Y) * (double)(X.size() - 1)).sub(X.getAverage(Y)))) : X.mult(2.0).mult(Y.mult(X.add(Y.getAverage(X) * (double)(X.size() - 1)).sub(Y.getAverage(X))));
                    break;
                }
                case STDEV: {
                    resultrandomvariable = variableIndex == this.getParentIDs()[0] ? Y.mult(2.0).mult(X.mult(Y.add(X.getAverage(Y) * (double)(X.size() - 1)).sub(X.getAverage(Y)))).div(Math.sqrt(X.getVariance(Y))) : X.mult(2.0).mult(Y.mult(X.add(Y.getAverage(X) * (double)(X.size() - 1)).sub(Y.getAverage(X)))).div(Math.sqrt(Y.getVariance(X)));
                    break;
                }
                case STDERROR: {
                    resultrandomvariable = variableIndex == this.getParentIDs()[0] ? Y.mult(2.0).mult(X.mult(Y.add(X.getAverage(Y) * (double)(X.size() - 1)).sub(X.getAverage(Y)))).div(Math.sqrt(X.getVariance(Y) * (double)X.size())) : X.mult(2.0).mult(Y.mult(X.add(Y.getAverage(X) * (double)(X.size() - 1)).sub(Y.getAverage(X)))).div(Math.sqrt(Y.getVariance(X) * (double)Y.size()));
                    break;
                }
                case POW: {
                    resultrandomvariable = variableIndex == this.getParentIDs()[0] ? Y.mult(X.pow(Y.getAverage() - 1.0)) : new RandomVariableFromDoubleArray(0.0);
                    break;
                }
            }
        } else if (this.getParentIDs().length == 3) {
            RandomVariable X = this.getRandomVariableInterfaceOfIndex(this.getParentIDs()[0]);
            RandomVariable Y = this.getRandomVariableInterfaceOfIndex(this.getParentIDs()[1]);
            RandomVariable Z = this.getRandomVariableInterfaceOfIndex(this.getParentIDs()[2]);
            switch (this.parentOperator) {
                case ADDPRODUCT: {
                    if (variableIndex == this.getParentIDs()[0]) {
                        resultrandomvariable = new RandomVariableFromDoubleArray(1.0);
                        break;
                    }
                    if (variableIndex == this.getParentIDs()[1]) {
                        resultrandomvariable = Z;
                        break;
                    }
                    resultrandomvariable = Y;
                    break;
                }
                case ADDRATIO: {
                    if (variableIndex == this.getParentIDs()[0]) {
                        resultrandomvariable = new RandomVariableFromDoubleArray(1.0);
                        break;
                    }
                    if (variableIndex == this.getParentIDs()[0]) {
                        resultrandomvariable = Z.invert();
                        break;
                    }
                    resultrandomvariable = Y.div(Z.squared());
                    break;
                }
                case SUBRATIO: {
                    if (variableIndex == this.getParentIDs()[0]) {
                        resultrandomvariable = new RandomVariableFromDoubleArray(1.0);
                        break;
                    }
                    if (variableIndex == this.getParentIDs()[1]) {
                        resultrandomvariable = Z.invert().mult(-1.0);
                        break;
                    }
                    resultrandomvariable = Y.div(Z.squared()).mult(-1.0);
                    break;
                }
                case ACCRUE: {
                    if (variableIndex == this.getParentIDs()[0]) {
                        resultrandomvariable = Y.mult(Z).add(1.0);
                        break;
                    }
                    if (variableIndex == this.getParentIDs()[1]) {
                        resultrandomvariable = X.mult(Z);
                        break;
                    }
                    resultrandomvariable = X.mult(Y);
                    break;
                }
                case DISCOUNT: {
                    if (variableIndex == this.getParentIDs()[0]) {
                        resultrandomvariable = Y.mult(Z).add(1.0).invert();
                        break;
                    }
                    if (variableIndex == this.getParentIDs()[1]) {
                        resultrandomvariable = X.mult(Z).div(Y.mult(Z).add(1.0).squared());
                        break;
                    }
                    resultrandomvariable = X.mult(Y).div(Y.mult(Z).add(1.0).squared());
                    break;
                }
                case BARRIER: {
                    if (variableIndex == this.getParentIDs()[0]) {
                        resultrandomvariable = X.apply(new DoubleUnaryOperator(){

                            @Override
                            public double applyAsDouble(double x) {
                                return x == 0.0 ? Double.POSITIVE_INFINITY : 0.0;
                            }
                        });
                        break;
                    }
                    if (variableIndex == this.getParentIDs()[1]) {
                        resultrandomvariable = X.choose(new RandomVariableFromDoubleArray(1.0), new RandomVariableFromDoubleArray(0.0));
                        break;
                    }
                    resultrandomvariable = X.choose(new RandomVariableFromDoubleArray(0.0), new RandomVariableFromDoubleArray(1.0));
                }
            }
        } else {
            throw new IllegalArgumentException("Operation not supported!\n");
        }
        return resultrandomvariable;
    }

    public Map<Integer, RandomVariable> getGradient() {
        int numberOfCalculationSteps = this.getFunctionList().size();
        RandomVariable[] omegaHat = new RandomVariable[numberOfCalculationSteps];
        omegaHat[numberOfCalculationSteps - 1] = new RandomVariableFromDoubleArray(1.0);
        for (int variableIndex = numberOfCalculationSteps - 2; variableIndex >= 0; --variableIndex) {
            omegaHat[variableIndex] = new RandomVariableFromDoubleArray(0.0);
            ArrayList<Integer> childrenList = this.getAADRandomVariableFromList(variableIndex).getChildrenIndices();
            for (int functionIndex : childrenList) {
                RandomVariable D_i_j = this.getPartialDerivative(functionIndex, variableIndex);
                omegaHat[variableIndex] = omegaHat[variableIndex].addProduct(D_i_j, omegaHat[functionIndex]);
            }
        }
        ArrayList<Integer> arrayListOfAllIndicesOfDependentRandomVariables = this.getArrayListOfAllIndicesOfDependentRandomVariables();
        HashMap<Integer, RandomVariable> gradient = new HashMap<Integer, RandomVariable>();
        for (Integer indexOfDependentRandomVariable : arrayListOfAllIndicesOfDependentRandomVariables) {
            gradient.put(indexOfDependentRandomVariable, omegaHat[arrayListOfAllIndicesOfDependentRandomVariables.get(indexOfDependentRandomVariable)]);
        }
        return gradient;
    }

    private ArrayList<Integer> getArrayListOfAllIndicesOfDependentRandomVariables() {
        ArrayList<Integer> arrayListOfAllIndicesOfDependentRandomVariables = new ArrayList<Integer>();
        for (int index = 0; index < this.getNumberOfParentVariables(); ++index) {
            int currentParentIndex = this.getParentIDs()[index];
            if (this.getAADRandomVariableFromList(currentParentIndex).isVariable() && !arrayListOfAllIndicesOfDependentRandomVariables.contains(currentParentIndex)) {
                arrayListOfAllIndicesOfDependentRandomVariables.add(currentParentIndex);
                continue;
            }
            arrayListOfAllIndicesOfDependentRandomVariables.addAll(this.getAADRandomVariableFromList(currentParentIndex).getArrayListOfAllIndicesOfDependentRandomVariables());
        }
        return arrayListOfAllIndicesOfDependentRandomVariables;
    }

    public RandomVariable getAverageAsRandomVariableAAD(RandomVariable probabilities) {
        return this.apply(OperatorType.AVERAGE, new RandomVariable[]{this, probabilities});
    }

    public RandomVariable getVarianceAsRandomVariableAAD(RandomVariable probabilities) {
        return this.apply(OperatorType.VARIANCE, new RandomVariable[]{this, probabilities});
    }

    public RandomVariable getStandardDeviationAsRandomVariableAAD(RandomVariable probabilities) {
        return this.apply(OperatorType.STDEV, new RandomVariable[]{this, probabilities});
    }

    public RandomVariable getStandardErrorAsRandomVariableAAD(RandomVariable probabilities) {
        return this.apply(OperatorType.STDERROR, new RandomVariable[]{this, probabilities});
    }

    public RandomVariable getAverageAsRandomVariableAAD() {
        return this.apply(OperatorType.AVERAGE, new RandomVariable[]{this});
    }

    public RandomVariable getVarianceAsRandomVariableAAD() {
        return this.apply(OperatorType.VARIANCE, new RandomVariable[]{this});
    }

    public RandomVariable getSampleVarianceAsRandomVariableAAD() {
        return this.apply(OperatorType.SVARIANCE, new RandomVariable[]{this});
    }

    public RandomVariable getStandardDeviationAsRandomVariableAAD() {
        return this.apply(OperatorType.STDEV, new RandomVariable[]{this});
    }

    public RandomVariable getStandardErrorAsRandomVariableAAD() {
        return this.apply(OperatorType.STDERROR, new RandomVariable[]{this});
    }

    public RandomVariable getMinAsRandomVariableAAD() {
        return this.apply(OperatorType.MIN, new RandomVariable[]{this});
    }

    public RandomVariable getMaxAsRandomVariableAAD() {
        return this.apply(OperatorType.MAX, new RandomVariable[]{this});
    }

    private OperatorType getParentOperator() {
        return this.parentOperator;
    }

    private boolean isConstant() {
        return this.isConstant;
    }

    private boolean isVariable() {
        return !this.isConstant() && this.getParentIDs() == null;
    }

    private ArrayList<RandomVariableAAD> getFunctionList() {
        return arrayListOfAllAADRandomVariables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetArrayListOfAllAADRandomVariables() {
        ArrayList<RandomVariableAAD> arrayList = arrayListOfAllAADRandomVariables;
        synchronized (arrayList) {
            arrayListOfAllAADRandomVariables = new ArrayList();
            indexOfNextRandomVariable = new AtomicInteger(0);
        }
    }

    public void setIsConstantTo(boolean isConstant) {
        this.isConstant = isConstant;
    }

    private RandomVariable getRandomVariableInterface() {
        return this.ownRandomVariable;
    }

    private RandomVariable getRandomVariableInterfaceOfIndex(int index) {
        return this.getFunctionList().get(index).getRandomVariableInterface();
    }

    private int getFunctionIndex() {
        return this.ownIndexInList;
    }

    private int[] getParentIDs() {
        return this.parentIndices;
    }

    private ArrayList<Integer> getChildrenIndices() {
        if (this.childrenIndices == null) {
            this.childrenIndices = new ArrayList();
        }
        return this.childrenIndices;
    }

    private int getNumberOfParentVariables() {
        if (this.getParentIDs() == null) {
            return 0;
        }
        return this.getParentIDs().length;
    }

    private RandomVariableAAD getAADRandomVariableFromList(int index) {
        return this.getFunctionList().get(index);
    }

    private void addToChildrenIndices(int index) {
        this.getChildrenIndices().add(index);
    }

    @Override
    public boolean equals(RandomVariable randomVariable) {
        return this.getRandomVariableInterface().equals(randomVariable);
    }

    @Override
    public double getFiltrationTime() {
        return this.getRandomVariableInterface().getFiltrationTime();
    }

    @Override
    public int getTypePriority() {
        return 3;
    }

    @Override
    public double get(int pathOrState) {
        return this.getRandomVariableInterface().get(pathOrState);
    }

    @Override
    public int size() {
        return this.getRandomVariableInterface().size();
    }

    @Override
    public boolean isDeterministic() {
        return this.getRandomVariableInterface().isDeterministic();
    }

    @Override
    public double[] getRealizations() {
        return this.getRandomVariableInterface().getRealizations();
    }

    @Override
    public Double doubleValue() {
        return this.getRandomVariableInterface().doubleValue();
    }

    @Override
    public double getMin() {
        return ((RandomVariableAAD)this.getMinAsRandomVariableAAD()).getRandomVariableInterface().getAverage();
    }

    @Override
    public double getMax() {
        return ((RandomVariableAAD)this.getMaxAsRandomVariableAAD()).getRandomVariableInterface().getAverage();
    }

    @Override
    public double getAverage() {
        return ((RandomVariableAAD)this.getAverageAsRandomVariableAAD()).getRandomVariableInterface().getAverage();
    }

    @Override
    public double getAverage(RandomVariable probabilities) {
        return ((RandomVariableAAD)this.getAverageAsRandomVariableAAD(probabilities)).getRandomVariableInterface().getAverage();
    }

    @Override
    public double getVariance() {
        return ((RandomVariableAAD)this.getVarianceAsRandomVariableAAD()).getRandomVariableInterface().getAverage();
    }

    @Override
    public double getVariance(RandomVariable probabilities) {
        return ((RandomVariableAAD)this.getAverageAsRandomVariableAAD(probabilities)).getRandomVariableInterface().getAverage();
    }

    @Override
    public double getSampleVariance() {
        return ((RandomVariableAAD)this.getSampleVarianceAsRandomVariableAAD()).getRandomVariableInterface().getAverage();
    }

    @Override
    public double getStandardDeviation() {
        return ((RandomVariableAAD)this.getStandardDeviationAsRandomVariableAAD()).getRandomVariableInterface().getAverage();
    }

    @Override
    public double getStandardDeviation(RandomVariable probabilities) {
        return ((RandomVariableAAD)this.getStandardDeviationAsRandomVariableAAD(probabilities)).getRandomVariableInterface().getAverage();
    }

    @Override
    public double getStandardError() {
        return ((RandomVariableAAD)this.getStandardErrorAsRandomVariableAAD()).getRandomVariableInterface().getAverage();
    }

    @Override
    public double getStandardError(RandomVariable probabilities) {
        return ((RandomVariableAAD)this.getStandardErrorAsRandomVariableAAD(probabilities)).getRandomVariableInterface().getAverage();
    }

    @Override
    public double getQuantile(double quantile) {
        return ((RandomVariableAAD)this.getRandomVariableInterface()).getRandomVariableInterface().getQuantile(quantile);
    }

    @Override
    public double getQuantile(double quantile, RandomVariable probabilities) {
        return ((RandomVariableAAD)this.getRandomVariableInterface()).getRandomVariableInterface().getQuantile(quantile, probabilities);
    }

    @Override
    public double getQuantileExpectation(double quantileStart, double quantileEnd) {
        return ((RandomVariableAAD)this.getRandomVariableInterface()).getRandomVariableInterface().getQuantileExpectation(quantileStart, quantileEnd);
    }

    @Override
    public double[] getHistogram(double[] intervalPoints) {
        return this.getRandomVariableInterface().getHistogram(intervalPoints);
    }

    @Override
    public double[][] getHistogram(int numberOfPoints, double standardDeviations) {
        return this.getRandomVariableInterface().getHistogram(numberOfPoints, standardDeviations);
    }

    @Override
    public RandomVariable cache() {
        return this;
    }

    @Override
    public RandomVariable cap(double cap) {
        return this.apply(OperatorType.CAP, new RandomVariable[]{this, RandomVariableAAD.constructNewAADRandomVariable(cap)});
    }

    @Override
    public RandomVariable floor(double floor) {
        return this.apply(OperatorType.FLOOR, new RandomVariable[]{this, RandomVariableAAD.constructNewAADRandomVariable(floor)});
    }

    @Override
    public RandomVariable add(double value) {
        return this.apply(OperatorType.ADD, new RandomVariable[]{this, RandomVariableAAD.constructNewAADRandomVariable(value)});
    }

    @Override
    public RandomVariable sub(double value) {
        return this.apply(OperatorType.SUB, new RandomVariable[]{this, RandomVariableAAD.constructNewAADRandomVariable(value)});
    }

    @Override
    public RandomVariable mult(double value) {
        return this.apply(OperatorType.MULT, new RandomVariable[]{this, RandomVariableAAD.constructNewAADRandomVariable(value)});
    }

    @Override
    public RandomVariable div(double value) {
        return this.apply(OperatorType.DIV, new RandomVariable[]{this, RandomVariableAAD.constructNewAADRandomVariable(value)});
    }

    @Override
    public RandomVariable pow(double exponent) {
        return this.apply(OperatorType.POW, new RandomVariable[]{this, RandomVariableAAD.constructNewAADRandomVariable(exponent)});
    }

    @Override
    public RandomVariable average() {
        return this.apply(OperatorType.AVERAGE, new RandomVariable[]{this});
    }

    @Override
    public RandomVariable squared() {
        return this.apply(OperatorType.SQUARED, new RandomVariable[]{this});
    }

    @Override
    public RandomVariable sqrt() {
        return this.apply(OperatorType.SQRT, new RandomVariable[]{this});
    }

    @Override
    public RandomVariable exp() {
        return this.apply(OperatorType.EXP, new RandomVariable[]{this});
    }

    @Override
    public RandomVariable log() {
        return this.apply(OperatorType.LOG, new RandomVariable[]{this});
    }

    @Override
    public RandomVariable sin() {
        return this.apply(OperatorType.SIN, new RandomVariable[]{this});
    }

    @Override
    public RandomVariable cos() {
        return this.apply(OperatorType.COS, new RandomVariable[]{this});
    }

    @Override
    public RandomVariable add(RandomVariable randomVariable) {
        return this.apply(OperatorType.ADD, new RandomVariable[]{this, randomVariable});
    }

    @Override
    public RandomVariable sub(RandomVariable randomVariable) {
        return this.apply(OperatorType.SUB, new RandomVariable[]{this, randomVariable});
    }

    @Override
    public RandomVariable bus(RandomVariable randomVariable) {
        return this.apply(OperatorType.SUB, new RandomVariable[]{randomVariable, this});
    }

    @Override
    public RandomVariable mult(RandomVariable randomVariable) {
        return this.apply(OperatorType.MULT, new RandomVariable[]{this, randomVariable});
    }

    @Override
    public RandomVariable div(RandomVariable randomVariable) {
        return this.apply(OperatorType.DIV, new RandomVariable[]{this, randomVariable});
    }

    @Override
    public RandomVariable vid(RandomVariable randomVariable) {
        return this.apply(OperatorType.DIV, new RandomVariable[]{randomVariable, this});
    }

    @Override
    public RandomVariable cap(RandomVariable cap) {
        return this.apply(OperatorType.CAP, new RandomVariable[]{this, cap});
    }

    @Override
    public RandomVariable floor(RandomVariable floor) {
        return this.apply(OperatorType.FLOOR, new RandomVariable[]{this, floor});
    }

    @Override
    public RandomVariable accrue(RandomVariable rate, double periodLength) {
        return this.apply(OperatorType.ACCRUE, new RandomVariable[]{this, rate, RandomVariableAAD.constructNewAADRandomVariable(periodLength)});
    }

    @Override
    public RandomVariable discount(RandomVariable rate, double periodLength) {
        return this.apply(OperatorType.DISCOUNT, new RandomVariable[]{this, rate, RandomVariableAAD.constructNewAADRandomVariable(periodLength)});
    }

    @Override
    public RandomVariable choose(RandomVariable valueIfTriggerNonNegative, RandomVariable valueIfTriggerNegative) {
        return this.apply(OperatorType.BARRIER, new RandomVariable[]{this, valueIfTriggerNonNegative, valueIfTriggerNegative});
    }

    @Override
    public RandomVariable invert() {
        return this.apply(OperatorType.INVERT, new RandomVariable[]{this});
    }

    @Override
    public RandomVariable abs() {
        return this.apply(OperatorType.ABS, new RandomVariable[]{this});
    }

    @Override
    public RandomVariable addProduct(RandomVariable factor1, double factor2) {
        return this.apply(OperatorType.ADDPRODUCT, new RandomVariable[]{this, factor1, RandomVariableAAD.constructNewAADRandomVariable(factor2)});
    }

    @Override
    public RandomVariable addProduct(RandomVariable factor1, RandomVariable factor2) {
        return this.apply(OperatorType.ADDPRODUCT, new RandomVariable[]{this, factor1, factor2});
    }

    @Override
    public RandomVariable addRatio(RandomVariable numerator, RandomVariable denominator) {
        return this.apply(OperatorType.ADDRATIO, new RandomVariable[]{this, numerator, denominator});
    }

    @Override
    public RandomVariable subRatio(RandomVariable numerator, RandomVariable denominator) {
        return this.apply(OperatorType.SUBRATIO, new RandomVariable[]{this, numerator, denominator});
    }

    @Override
    public RandomVariable isNaN() {
        return this.getRandomVariableInterface().isNaN();
    }

    @Override
    public IntToDoubleFunction getOperator() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public DoubleStream getRealizationsStream() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public RandomVariable apply(DoubleUnaryOperator operator) {
        throw new UnsupportedOperationException("Applying functions is not supported.");
    }

    @Override
    public RandomVariable apply(DoubleBinaryOperator operator, RandomVariable argument) {
        throw new UnsupportedOperationException("Applying functions is not supported.");
    }

    @Override
    public RandomVariable apply(DoubleTernaryOperator operator, RandomVariable argument1, RandomVariable argument2) {
        throw new UnsupportedOperationException("Applying functions is not supported.");
    }

    private static enum OperatorType {
        ADD,
        MULT,
        DIV,
        SUB,
        SQUARED,
        SQRT,
        LOG,
        SIN,
        COS,
        EXP,
        INVERT,
        CAP,
        FLOOR,
        ABS,
        ADDPRODUCT,
        ADDRATIO,
        SUBRATIO,
        BARRIER,
        DISCOUNT,
        ACCRUE,
        POW,
        AVERAGE,
        VARIANCE,
        STDEV,
        MIN,
        MAX,
        STDERROR,
        SVARIANCE;

    }
}

