/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.automaticdifferentiation.backward.alternative;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.IntToDoubleFunction;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import net.finmath.functions.DoubleTernaryOperator;
import net.finmath.montecarlo.RandomVariableFromDoubleArray;
import net.finmath.montecarlo.automaticdifferentiation.RandomVariableDifferentiable;
import net.finmath.stochastic.RandomVariable;

public class RandomVariableDifferentiableAADPathwise
implements RandomVariableDifferentiable {
    private static final long serialVersionUID = 2459373647785530657L;
    private static AtomicLong indexOfNextRandomVariable = new AtomicLong(0L);
    private final RandomVariable values;
    private final OperatorTreeNode operatorTreeNode;

    public static RandomVariableDifferentiableAADPathwise of(double value) {
        return new RandomVariableDifferentiableAADPathwise(value);
    }

    public static RandomVariableDifferentiableAADPathwise of(RandomVariable randomVariable) {
        return new RandomVariableDifferentiableAADPathwise(randomVariable);
    }

    public RandomVariableDifferentiableAADPathwise(double value) {
        this(new RandomVariableFromDoubleArray(value), null, null);
    }

    public RandomVariableDifferentiableAADPathwise(double time, double[] realisations) {
        this(new RandomVariableFromDoubleArray(time, realisations), null, null);
    }

    public RandomVariableDifferentiableAADPathwise(RandomVariable randomVariable) {
        this(randomVariable, null, null);
    }

    private RandomVariableDifferentiableAADPathwise(RandomVariable values, List<RandomVariable> arguments, OperatorType operator) {
        this.values = values;
        this.operatorTreeNode = new OperatorTreeNode(operator, arguments);
    }

    public RandomVariable getRandomVariable() {
        return this.values;
    }

    public OperatorTreeNode getOperatorTreeNode() {
        return this.operatorTreeNode;
    }

    @Override
    public Long getID() {
        return this.getOperatorTreeNode().id;
    }

    @Override
    public Map<Long, RandomVariable> getGradient(Set<Long> independentIDs) {
        HashMap<Long, RandomVariable> derivatives = new HashMap<Long, RandomVariable>();
        derivatives.put(this.getID(), new RandomVariableFromDoubleArray(1.0));
        TreeMap<Long, OperatorTreeNode> independents = new TreeMap<Long, OperatorTreeNode>();
        independents.put(this.getID(), this.getOperatorTreeNode());
        while (independents.size() > 0) {
            Map.Entry independentEntry = independents.lastEntry();
            Long id = (Long)independentEntry.getKey();
            OperatorTreeNode independent = (OperatorTreeNode)independentEntry.getValue();
            List<OperatorTreeNode> arguments = independent.arguments;
            if (arguments != null && arguments.size() > 0) {
                independent.propagateDerivativesFromResultToArgument(derivatives);
                for (OperatorTreeNode argument : arguments) {
                    if (argument == null) continue;
                    Long argumentId = argument.id;
                    independents.put(argumentId, argument);
                }
                derivatives.remove(id);
            }
            independents.remove(id);
        }
        return derivatives;
    }

    @Override
    public Map<Long, RandomVariable> getTangents(Set<Long> dependentIDs) {
        throw new UnsupportedOperationException();
    }

    public RandomVariable getAverageAsRandomVariableAAD(RandomVariable probabilities) {
        return new RandomVariableDifferentiableAADPathwise(new RandomVariableFromDoubleArray(this.getAverage(probabilities)), Arrays.asList(this, new RandomVariableFromDoubleArray(probabilities)), OperatorType.AVERAGE2);
    }

    public RandomVariable getVarianceAsRandomVariableAAD(RandomVariable probabilities) {
        return new RandomVariableDifferentiableAADPathwise(new RandomVariableFromDoubleArray(this.getVariance(probabilities)), Arrays.asList(this, new RandomVariableFromDoubleArray(probabilities)), OperatorType.VARIANCE2);
    }

    public RandomVariable getStandardDeviationAsRandomVariableAAD(RandomVariable probabilities) {
        return new RandomVariableDifferentiableAADPathwise(new RandomVariableFromDoubleArray(this.getStandardDeviation(probabilities)), Arrays.asList(this, new RandomVariableFromDoubleArray(probabilities)), OperatorType.STDEV2);
    }

    public RandomVariable getStandardErrorAsRandomVariableAAD(RandomVariable probabilities) {
        return new RandomVariableDifferentiableAADPathwise(new RandomVariableFromDoubleArray(this.getStandardError(probabilities)), Arrays.asList(this, new RandomVariableFromDoubleArray(probabilities)), OperatorType.STDERROR2);
    }

    public RandomVariable getAverageAsRandomVariableAAD() {
        return new RandomVariableDifferentiableAADPathwise(new RandomVariableFromDoubleArray(this.getAverage()), Arrays.asList(this), OperatorType.AVERAGE);
    }

    public RandomVariable getVarianceAsRandomVariableAAD() {
        return new RandomVariableDifferentiableAADPathwise(new RandomVariableFromDoubleArray(this.getVariance()), Arrays.asList(this), OperatorType.VARIANCE);
    }

    public RandomVariable getSampleVarianceAsRandomVariableAAD() {
        return new RandomVariableDifferentiableAADPathwise(new RandomVariableFromDoubleArray(this.getSampleVariance()), Arrays.asList(this), OperatorType.SVARIANCE);
    }

    public RandomVariable getStandardDeviationAsRandomVariableAAD() {
        return new RandomVariableDifferentiableAADPathwise(new RandomVariableFromDoubleArray(this.getStandardDeviation()), Arrays.asList(this), OperatorType.STDEV);
    }

    public RandomVariable getStandardErrorAsRandomVariableAAD() {
        return new RandomVariableDifferentiableAADPathwise(new RandomVariableFromDoubleArray(this.getStandardError()), Arrays.asList(this), OperatorType.STDERROR);
    }

    public RandomVariable getMinAsRandomVariableAAD() {
        return new RandomVariableDifferentiableAADPathwise(new RandomVariableFromDoubleArray(this.getMin()), Arrays.asList(this), OperatorType.MIN);
    }

    public RandomVariable getMaxAsRandomVariableAAD() {
        return new RandomVariableDifferentiableAADPathwise(new RandomVariableFromDoubleArray(this.getMax()), Arrays.asList(this), OperatorType.MAX);
    }

    @Override
    public RandomVariable getValues() {
        return this.values;
    }

    @Override
    public boolean equals(RandomVariable randomVariable) {
        return this.getValues().equals(randomVariable);
    }

    @Override
    public double getFiltrationTime() {
        return this.getValues().getFiltrationTime();
    }

    @Override
    public int getTypePriority() {
        return 3;
    }

    @Override
    public double get(int pathOrState) {
        return this.getValues().get(pathOrState);
    }

    @Override
    public int size() {
        return this.getValues().size();
    }

    @Override
    public boolean isDeterministic() {
        return this.getValues().isDeterministic();
    }

    @Override
    public double[] getRealizations() {
        return this.getValues().getRealizations();
    }

    @Override
    public Double doubleValue() {
        return this.getValues().doubleValue();
    }

    @Override
    public double getMin() {
        return this.getValues().getMin();
    }

    @Override
    public double getMax() {
        return this.getValues().getMax();
    }

    @Override
    public double getAverage() {
        return this.getValues().getAverage();
    }

    @Override
    public double getAverage(RandomVariable probabilities) {
        return this.getValues().getAverage();
    }

    @Override
    public double getVariance() {
        return this.getValues().getVariance();
    }

    @Override
    public double getVariance(RandomVariable probabilities) {
        return this.getValues().getVariance(probabilities);
    }

    @Override
    public double getSampleVariance() {
        return this.getValues().getSampleVariance();
    }

    @Override
    public double getStandardDeviation() {
        return this.getValues().getStandardDeviation();
    }

    @Override
    public double getStandardDeviation(RandomVariable probabilities) {
        return this.getValues().getStandardDeviation(probabilities);
    }

    @Override
    public double getStandardError() {
        return this.getValues().getStandardError();
    }

    @Override
    public double getStandardError(RandomVariable probabilities) {
        return this.getValues().getStandardError(probabilities);
    }

    @Override
    public double getQuantile(double quantile) {
        return this.getValues().getQuantile(quantile);
    }

    @Override
    public double getQuantile(double quantile, RandomVariable probabilities) {
        return ((RandomVariableDifferentiableAADPathwise)this.getValues()).getValues().getQuantile(quantile, probabilities);
    }

    @Override
    public double getQuantileExpectation(double quantileStart, double quantileEnd) {
        return ((RandomVariableDifferentiableAADPathwise)this.getValues()).getValues().getQuantileExpectation(quantileStart, quantileEnd);
    }

    @Override
    public double[] getHistogram(double[] intervalPoints) {
        return this.getValues().getHistogram(intervalPoints);
    }

    @Override
    public double[][] getHistogram(int numberOfPoints, double standardDeviations) {
        return this.getValues().getHistogram(numberOfPoints, standardDeviations);
    }

    @Override
    public RandomVariable cache() {
        return this;
    }

    @Override
    public RandomVariable cap(double cap) {
        return new RandomVariableDifferentiableAADPathwise(this.getValues().cap(cap), Arrays.asList(this, new RandomVariableFromDoubleArray(cap)), OperatorType.CAP);
    }

    @Override
    public RandomVariable floor(double floor) {
        return new RandomVariableDifferentiableAADPathwise(this.getValues().floor(floor), Arrays.asList(this, new RandomVariableFromDoubleArray(floor)), OperatorType.FLOOR);
    }

    @Override
    public RandomVariable add(double value) {
        return new RandomVariableDifferentiableAADPathwise(this.getValues().add(value), Arrays.asList(this, new RandomVariableFromDoubleArray(value)), OperatorType.ADD);
    }

    @Override
    public RandomVariable sub(double value) {
        return new RandomVariableDifferentiableAADPathwise(this.getValues().sub(value), Arrays.asList(this, new RandomVariableFromDoubleArray(value)), OperatorType.SUB);
    }

    @Override
    public RandomVariable mult(double value) {
        return new RandomVariableDifferentiableAADPathwise(this.getValues().mult(value), Arrays.asList(this, new RandomVariableFromDoubleArray(value)), OperatorType.MULT);
    }

    @Override
    public RandomVariable div(double value) {
        return new RandomVariableDifferentiableAADPathwise(this.getValues().div(value), Arrays.asList(this, new RandomVariableFromDoubleArray(value)), OperatorType.DIV);
    }

    @Override
    public RandomVariable pow(double exponent) {
        return new RandomVariableDifferentiableAADPathwise(this.getValues().pow(exponent), Arrays.asList(this, new RandomVariableFromDoubleArray(exponent)), OperatorType.POW);
    }

    @Override
    public RandomVariable average() {
        return new RandomVariableDifferentiableAADPathwise(this.getValues().average(), Arrays.asList(this), OperatorType.AVERAGE);
    }

    @Override
    public RandomVariable squared() {
        return new RandomVariableDifferentiableAADPathwise(this.getValues().squared(), Arrays.asList(this), OperatorType.SQUARED);
    }

    @Override
    public RandomVariable sqrt() {
        return new RandomVariableDifferentiableAADPathwise(this.getValues().sqrt(), Arrays.asList(this), OperatorType.SQRT);
    }

    @Override
    public RandomVariable exp() {
        return new RandomVariableDifferentiableAADPathwise(this.getValues().exp(), Arrays.asList(this), OperatorType.EXP);
    }

    @Override
    public RandomVariable log() {
        return new RandomVariableDifferentiableAADPathwise(this.getValues().log(), Arrays.asList(this), OperatorType.LOG);
    }

    @Override
    public RandomVariable sin() {
        return new RandomVariableDifferentiableAADPathwise(this.getValues().sin(), Arrays.asList(this), OperatorType.SIN);
    }

    @Override
    public RandomVariable cos() {
        return new RandomVariableDifferentiableAADPathwise(this.getValues().cos(), Arrays.asList(this), OperatorType.COS);
    }

    @Override
    public RandomVariable add(RandomVariable randomVariable) {
        return new RandomVariableDifferentiableAADPathwise(this.getValues().add(randomVariable), Arrays.asList(this, randomVariable), OperatorType.ADD);
    }

    @Override
    public RandomVariable sub(RandomVariable randomVariable) {
        return new RandomVariableDifferentiableAADPathwise(this.getValues().sub(randomVariable), Arrays.asList(this, randomVariable), OperatorType.SUB);
    }

    @Override
    public RandomVariable bus(RandomVariable randomVariable) {
        return new RandomVariableDifferentiableAADPathwise(this.getValues().bus(randomVariable), Arrays.asList(randomVariable, this), OperatorType.SUB);
    }

    @Override
    public RandomVariableDifferentiable mult(RandomVariable randomVariable) {
        return new RandomVariableDifferentiableAADPathwise(this.getValues().mult(randomVariable), Arrays.asList(this, randomVariable), OperatorType.MULT);
    }

    @Override
    public RandomVariable div(RandomVariable randomVariable) {
        return new RandomVariableDifferentiableAADPathwise(this.getValues().div(randomVariable), Arrays.asList(this, randomVariable), OperatorType.DIV);
    }

    @Override
    public RandomVariable vid(RandomVariable randomVariable) {
        return new RandomVariableDifferentiableAADPathwise(this.getValues().vid(randomVariable), Arrays.asList(randomVariable, this), OperatorType.DIV);
    }

    @Override
    public RandomVariable cap(RandomVariable cap) {
        return new RandomVariableDifferentiableAADPathwise(this.getValues().cap(cap), Arrays.asList(this, cap), OperatorType.CAP);
    }

    @Override
    public RandomVariable floor(RandomVariable floor) {
        return new RandomVariableDifferentiableAADPathwise(this.getValues().cap(floor), Arrays.asList(this, floor), OperatorType.FLOOR);
    }

    @Override
    public RandomVariable accrue(RandomVariable rate, double periodLength) {
        return new RandomVariableDifferentiableAADPathwise(this.getValues().accrue(rate, periodLength), Arrays.asList(this, rate, new RandomVariableFromDoubleArray(periodLength)), OperatorType.ACCRUE);
    }

    @Override
    public RandomVariable discount(RandomVariable rate, double periodLength) {
        return new RandomVariableDifferentiableAADPathwise(this.getValues().discount(rate, periodLength), Arrays.asList(this, rate, new RandomVariableFromDoubleArray(periodLength)), OperatorType.DISCOUNT);
    }

    @Override
    public RandomVariable choose(RandomVariable valueIfTriggerNonNegative, RandomVariable valueIfTriggerNegative) {
        return new RandomVariableDifferentiableAADPathwise(this.getValues().choose(valueIfTriggerNonNegative.getValues(), valueIfTriggerNegative.getValues()), Arrays.asList(this, valueIfTriggerNonNegative, valueIfTriggerNegative), OperatorType.BARRIER);
    }

    @Override
    public RandomVariable invert() {
        return new RandomVariableDifferentiableAADPathwise(this.getValues().invert(), Arrays.asList(this), OperatorType.INVERT);
    }

    @Override
    public RandomVariable abs() {
        return new RandomVariableDifferentiableAADPathwise(this.getValues().abs(), Arrays.asList(this), OperatorType.ABS);
    }

    @Override
    public RandomVariable addProduct(RandomVariable factor1, double factor2) {
        return new RandomVariableDifferentiableAADPathwise(this.getValues().addProduct(factor1, factor2), Arrays.asList(this, factor1, new RandomVariableFromDoubleArray(factor2)), OperatorType.ADDPRODUCT);
    }

    @Override
    public RandomVariable addProduct(RandomVariable factor1, RandomVariable factor2) {
        return new RandomVariableDifferentiableAADPathwise(this.getValues().addProduct(factor1, factor2), Arrays.asList(this, factor1, factor2), OperatorType.ADDPRODUCT);
    }

    @Override
    public RandomVariable addRatio(RandomVariable numerator, RandomVariable denominator) {
        return new RandomVariableDifferentiableAADPathwise(this.getValues().addRatio(numerator, denominator), Arrays.asList(this, numerator, denominator), OperatorType.ADDRATIO);
    }

    @Override
    public RandomVariable subRatio(RandomVariable numerator, RandomVariable denominator) {
        return new RandomVariableDifferentiableAADPathwise(this.getValues().subRatio(numerator, denominator), Arrays.asList(this, numerator, denominator), OperatorType.SUBRATIO);
    }

    @Override
    public RandomVariable isNaN() {
        return this.getValues().isNaN();
    }

    @Override
    public IntToDoubleFunction getOperator() {
        return this.getValues().getOperator();
    }

    @Override
    public DoubleStream getRealizationsStream() {
        return this.getValues().getRealizationsStream();
    }

    @Override
    public RandomVariable apply(DoubleUnaryOperator operator) {
        throw new UnsupportedOperationException("Applying functions is not supported.");
    }

    @Override
    public RandomVariable apply(DoubleBinaryOperator operator, RandomVariable argument) {
        throw new UnsupportedOperationException("Applying functions is not supported.");
    }

    @Override
    public RandomVariable apply(DoubleTernaryOperator operator, RandomVariable argument1, RandomVariable argument2) {
        throw new UnsupportedOperationException("Applying functions is not supported.");
    }

    private static class OperatorTreeNode {
        private final Long id = indexOfNextRandomVariable.getAndIncrement();
        private final OperatorType operator;
        private final List<OperatorTreeNode> arguments;
        private final List<RandomVariable> argumentValues;

        OperatorTreeNode(OperatorType operator, List<RandomVariable> arguments) {
            this(operator, arguments != null ? arguments.stream().map(new Function<RandomVariable, OperatorTreeNode>(){

                @Override
                public OperatorTreeNode apply(RandomVariable x) {
                    return x != null && x instanceof RandomVariableDifferentiableAADPathwise ? ((RandomVariableDifferentiableAADPathwise)x).getOperatorTreeNode() : null;
                }
            }).collect(Collectors.toList()) : null, arguments != null ? arguments.stream().map(new Function<RandomVariable, RandomVariable>(){

                @Override
                public RandomVariable apply(RandomVariable x) {
                    return x != null && x instanceof RandomVariableDifferentiableAADPathwise ? ((RandomVariableDifferentiableAADPathwise)x).getValues() : x;
                }
            }).collect(Collectors.toList()) : null);
        }

        OperatorTreeNode(OperatorType operator, List<OperatorTreeNode> arguments, List<RandomVariable> argumentValues) {
            this.operator = operator;
            this.arguments = arguments;
            this.argumentValues = argumentValues;
        }

        private void propagateDerivativesFromResultToArgument(Map<Long, RandomVariable> derivatives) {
            for (OperatorTreeNode argument : this.arguments) {
                if (argument == null) continue;
                Long argumentID = argument.id;
                if (!derivatives.containsKey(argumentID)) {
                    derivatives.put(argumentID, new RandomVariableFromDoubleArray(0.0));
                }
                RandomVariable partialDerivative = this.getPartialDerivative(argument);
                RandomVariable derivative = derivatives.get(this.id);
                RandomVariable argumentDerivative = derivatives.get(argumentID);
                argumentDerivative = argumentDerivative.addProduct(partialDerivative, derivative);
                derivatives.put(argumentID, argumentDerivative);
            }
        }

        private RandomVariable getPartialDerivative(OperatorTreeNode differential) {
            if (!this.arguments.contains(differential)) {
                return new RandomVariableFromDoubleArray(0.0);
            }
            int differentialIndex = this.arguments.indexOf(differential);
            RandomVariable X = this.arguments.size() > 0 && this.argumentValues != null ? this.argumentValues.get(0) : null;
            RandomVariable Y = this.arguments.size() > 1 && this.argumentValues != null ? this.argumentValues.get(1) : null;
            RandomVariable Z = this.arguments.size() > 2 && this.argumentValues != null ? this.argumentValues.get(2) : null;
            RandomVariable resultrandomvariable = null;
            switch (this.operator) {
                case SQUARED: {
                    resultrandomvariable = X.mult(2.0);
                    break;
                }
                case SQRT: {
                    resultrandomvariable = X.sqrt().invert().mult(0.5);
                    break;
                }
                case EXP: {
                    resultrandomvariable = X.exp();
                    break;
                }
                case LOG: {
                    resultrandomvariable = X.invert();
                    break;
                }
                case SIN: {
                    resultrandomvariable = X.cos();
                    break;
                }
                case COS: {
                    resultrandomvariable = X.sin().mult(-1.0);
                    break;
                }
                case AVERAGE: {
                    resultrandomvariable = new RandomVariableFromDoubleArray(X.size()).invert();
                    break;
                }
                case VARIANCE: {
                    resultrandomvariable = X.sub(X.getAverage() * (2.0 * (double)X.size() - 1.0) / (double)X.size()).mult(2.0 / (double)X.size());
                    break;
                }
                case STDEV: {
                    resultrandomvariable = X.sub(X.getAverage() * (2.0 * (double)X.size() - 1.0) / (double)X.size()).mult(2.0 / (double)X.size()).mult(0.5).div(Math.sqrt(X.getVariance()));
                    break;
                }
                case MIN: {
                    final double min = X.getMin();
                    resultrandomvariable = X.apply(new DoubleUnaryOperator(){

                        @Override
                        public double applyAsDouble(double x) {
                            return x == min ? 1.0 : 0.0;
                        }
                    });
                    break;
                }
                case MAX: {
                    final double max = X.getMax();
                    resultrandomvariable = X.apply(new DoubleUnaryOperator(){

                        @Override
                        public double applyAsDouble(double x) {
                            return x == max ? 1.0 : 0.0;
                        }
                    });
                    break;
                }
                case ABS: {
                    resultrandomvariable = X.choose(new RandomVariableFromDoubleArray(1.0), new RandomVariableFromDoubleArray(-1.0));
                    break;
                }
                case STDERROR: {
                    resultrandomvariable = X.sub(X.getAverage() * (2.0 * (double)X.size() - 1.0) / (double)X.size()).mult(2.0 / (double)X.size()).mult(0.5).div(Math.sqrt(X.getVariance() * (double)X.size()));
                    break;
                }
                case SVARIANCE: {
                    resultrandomvariable = X.sub(X.getAverage() * (2.0 * (double)X.size() - 1.0) / (double)X.size()).mult(2.0 / (double)(X.size() - 1));
                    break;
                }
                case ADD: {
                    resultrandomvariable = X.size() > 1 ? new RandomVariableFromDoubleArray(0.0, X.size(), 1.0) : new RandomVariableFromDoubleArray(1.0);
                    break;
                }
                case SUB: {
                    resultrandomvariable = new RandomVariableFromDoubleArray(differentialIndex == 0 ? 1.0 : -1.0);
                    break;
                }
                case MULT: {
                    resultrandomvariable = differentialIndex == 0 ? Y : X;
                    break;
                }
                case DIV: {
                    resultrandomvariable = differentialIndex == 0 ? Y.invert() : X.div(Y.squared()).mult(-1.0);
                    break;
                }
                case CAP: {
                    if (differentialIndex == 0) {
                        resultrandomvariable = X.sub(Y).choose(new RandomVariableFromDoubleArray(0.0), new RandomVariableFromDoubleArray(1.0));
                        break;
                    }
                    resultrandomvariable = X.sub(Y).choose(new RandomVariableFromDoubleArray(1.0), new RandomVariableFromDoubleArray(0.0));
                    break;
                }
                case FLOOR: {
                    if (differentialIndex == 0) {
                        resultrandomvariable = X.sub(Y).choose(new RandomVariableFromDoubleArray(1.0), new RandomVariableFromDoubleArray(0.0));
                        break;
                    }
                    resultrandomvariable = X.sub(Y).choose(new RandomVariableFromDoubleArray(0.0), new RandomVariableFromDoubleArray(1.0));
                    break;
                }
                case AVERAGE2: {
                    resultrandomvariable = differentialIndex == 0 ? Y : X;
                    break;
                }
                case VARIANCE2: {
                    resultrandomvariable = differentialIndex == 0 ? Y.mult(2.0).mult(X.mult(Y.add(X.getAverage(Y) * (double)(X.size() - 1)).sub(X.getAverage(Y)))) : X.mult(2.0).mult(Y.mult(X.add(Y.getAverage(X) * (double)(X.size() - 1)).sub(Y.getAverage(X))));
                    break;
                }
                case STDEV2: {
                    resultrandomvariable = differentialIndex == 0 ? Y.mult(2.0).mult(X.mult(Y.add(X.getAverage(Y) * (double)(X.size() - 1)).sub(X.getAverage(Y)))).div(Math.sqrt(X.getVariance(Y))) : X.mult(2.0).mult(Y.mult(X.add(Y.getAverage(X) * (double)(X.size() - 1)).sub(Y.getAverage(X)))).div(Math.sqrt(Y.getVariance(X)));
                    break;
                }
                case STDERROR2: {
                    resultrandomvariable = differentialIndex == 0 ? Y.mult(2.0).mult(X.mult(Y.add(X.getAverage(Y) * (double)(X.size() - 1)).sub(X.getAverage(Y)))).div(Math.sqrt(X.getVariance(Y) * (double)X.size())) : X.mult(2.0).mult(Y.mult(X.add(Y.getAverage(X) * (double)(X.size() - 1)).sub(Y.getAverage(X)))).div(Math.sqrt(Y.getVariance(X) * (double)Y.size()));
                    break;
                }
                case POW: {
                    resultrandomvariable = differentialIndex == 0 ? Y.mult(X.pow(Y.getAverage() - 1.0)) : new RandomVariableFromDoubleArray(0.0);
                    break;
                }
                case ADDPRODUCT: {
                    if (differentialIndex == 0) {
                        resultrandomvariable = new RandomVariableFromDoubleArray(1.0);
                        break;
                    }
                    if (differentialIndex == 1) {
                        resultrandomvariable = Z;
                        break;
                    }
                    resultrandomvariable = Y;
                    break;
                }
                case ADDRATIO: {
                    if (differentialIndex == 0) {
                        resultrandomvariable = new RandomVariableFromDoubleArray(1.0);
                        break;
                    }
                    if (differentialIndex == 1) {
                        resultrandomvariable = Z.invert();
                        break;
                    }
                    resultrandomvariable = Y.div(Z.squared());
                    break;
                }
                case SUBRATIO: {
                    if (differentialIndex == 0) {
                        resultrandomvariable = new RandomVariableFromDoubleArray(1.0);
                        break;
                    }
                    if (differentialIndex == 1) {
                        resultrandomvariable = Z.invert().mult(-1.0);
                        break;
                    }
                    resultrandomvariable = Y.div(Z.squared()).mult(-1.0);
                    break;
                }
                case ACCRUE: {
                    if (differentialIndex == 0) {
                        resultrandomvariable = Y.mult(Z).add(1.0);
                        break;
                    }
                    if (differentialIndex == 1) {
                        resultrandomvariable = X.mult(Z);
                        break;
                    }
                    resultrandomvariable = X.mult(Y);
                    break;
                }
                case DISCOUNT: {
                    if (differentialIndex == 0) {
                        resultrandomvariable = Y.mult(Z).add(1.0).invert();
                        break;
                    }
                    if (differentialIndex == 1) {
                        resultrandomvariable = X.mult(Z).div(Y.mult(Z).add(1.0).squared());
                        break;
                    }
                    resultrandomvariable = X.mult(Y).div(Y.mult(Z).add(1.0).squared());
                    break;
                }
                case BARRIER: {
                    resultrandomvariable = differentialIndex == 0 ? X.apply(new DoubleUnaryOperator(){

                        @Override
                        public double applyAsDouble(double x) {
                            return x == 0.0 ? Double.POSITIVE_INFINITY : 0.0;
                        }
                    }) : (differentialIndex == 1 ? X.choose(new RandomVariableFromDoubleArray(1.0), new RandomVariableFromDoubleArray(0.0)) : X.choose(new RandomVariableFromDoubleArray(0.0), new RandomVariableFromDoubleArray(1.0)));
                }
            }
            return resultrandomvariable;
        }
    }

    private static enum OperatorType {
        ADD,
        MULT,
        DIV,
        SUB,
        SQUARED,
        SQRT,
        LOG,
        SIN,
        COS,
        EXP,
        INVERT,
        CAP,
        FLOOR,
        ABS,
        ADDPRODUCT,
        ADDRATIO,
        SUBRATIO,
        BARRIER,
        DISCOUNT,
        ACCRUE,
        POW,
        MIN,
        MAX,
        AVERAGE,
        VARIANCE,
        STDEV,
        STDERROR,
        SVARIANCE,
        AVERAGE2,
        VARIANCE2,
        STDEV2,
        STDERROR2;

    }
}

