/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.automaticdifferentiation.backward.alternative;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleUnaryOperator;
import java.util.function.IntToDoubleFunction;
import java.util.stream.DoubleStream;
import net.finmath.functions.DoubleTernaryOperator;
import net.finmath.montecarlo.RandomVariableFromDoubleArray;
import net.finmath.montecarlo.automaticdifferentiation.backward.alternative.RandomVariableUniqueVariableFactory;
import net.finmath.stochastic.RandomVariable;

public class RandomVariableUniqueVariable
implements RandomVariable {
    private static final long serialVersionUID = -2631868286977854016L;
    private final RandomVariableUniqueVariableFactory factory = new RandomVariableUniqueVariableFactory();
    private ArrayList<RandomVariableUniqueVariable> parentsVariables;
    private OperatorType parentOperatorType;
    private int variableID;
    private boolean isConstant;

    public RandomVariableUniqueVariable(int variableID, boolean isConstant, ArrayList<RandomVariableUniqueVariable> parentVariables, OperatorType parentOperatorType) {
        this.variableID = variableID;
        this.isConstant = isConstant;
        this.parentsVariables = parentVariables;
        this.parentOperatorType = parentOperatorType;
    }

    public RandomVariableUniqueVariable(double time, double[] values, boolean isConstant, ArrayList<RandomVariableUniqueVariable> parentVariables, OperatorType parentOperatorType) {
        this.constructRandomVariableUniqueVariable(new RandomVariableFromDoubleArray(time, values), isConstant, parentVariables, parentOperatorType);
    }

    public RandomVariableUniqueVariable(RandomVariable randomVariable, boolean isConstant, ArrayList<RandomVariableUniqueVariable> parentVariables, OperatorType parentOperatorType) {
        this.constructRandomVariableUniqueVariable(randomVariable, isConstant, parentVariables, parentOperatorType);
    }

    public RandomVariableUniqueVariable(double time, double[] values, boolean isConstant) {
        this.constructRandomVariableUniqueVariable(new RandomVariableFromDoubleArray(time, values), isConstant, null, null);
    }

    public RandomVariableUniqueVariable(RandomVariable randomVariable, boolean isConstant) {
        this.constructRandomVariableUniqueVariable(randomVariable, isConstant, null, null);
    }

    public RandomVariableUniqueVariable(double time, double[] values) {
        this.constructRandomVariableUniqueVariable(new RandomVariableFromDoubleArray(time, values), false, null, null);
    }

    public RandomVariableUniqueVariable(RandomVariable randomVariable) {
        this.constructRandomVariableUniqueVariable(randomVariable, false, null, null);
    }

    private void constructRandomVariableUniqueVariable(RandomVariable randomVariable, boolean isConstant, ArrayList<RandomVariableUniqueVariable> parentVariables, OperatorType parentOperatorType) {
        RandomVariable normalrandomvariable = this.factory.createRandomVariable(randomVariable, isConstant, parentVariables, parentOperatorType);
        RandomVariableUniqueVariable newrandomvariableuniquevariable = (RandomVariableUniqueVariable)normalrandomvariable;
        this.variableID = newrandomvariableuniquevariable.getVariableID();
        this.isConstant = newrandomvariableuniquevariable.isConstant();
        this.parentsVariables = newrandomvariableuniquevariable.getParentVariables();
        this.parentOperatorType = newrandomvariableuniquevariable.getParentOperatorType();
    }

    private int[] getParentIDs() {
        if (this.parentsVariables == null) {
            return null;
        }
        int[] parentIDs = new int[this.parentsVariables.size()];
        for (int i = 0; i < this.parentsVariables.size(); ++i) {
            parentIDs[i] = this.parentsVariables.get(i).getVariableID();
        }
        return parentIDs;
    }

    public int getVariableID() {
        return this.variableID;
    }

    private boolean isConstant() {
        return this.isConstant;
    }

    private ArrayList<RandomVariableUniqueVariable> getParentVariables() {
        return this.parentsVariables;
    }

    private OperatorType getParentOperatorType() {
        return this.parentOperatorType;
    }

    private ArrayList<RandomVariable> getListOfAllVariables() {
        return this.factory.getListOfAllVariables();
    }

    private ArrayList<RandomVariable> getParentRandomVariables() {
        ArrayList<RandomVariable> parentrandomvariables = new ArrayList<RandomVariable>();
        for (RandomVariableUniqueVariable parent : this.parentsVariables) {
            parentrandomvariables.add(parent.getRandomVariable());
        }
        return parentrandomvariables;
    }

    private RandomVariable getRandomVariable() {
        return this.getListOfAllVariables().get(this.variableID);
    }

    public boolean isVariable() {
        return this.parentsVariables == null && !this.isConstant();
    }

    @Override
    public boolean equals(RandomVariable randomVariable) {
        return false;
    }

    @Override
    public double getFiltrationTime() {
        return this.getRandomVariable().getFiltrationTime();
    }

    @Override
    public int getTypePriority() {
        return 3;
    }

    @Override
    public double get(int pathOrState) {
        return this.getRandomVariable().get(pathOrState);
    }

    @Override
    public int size() {
        return this.getRandomVariable().size();
    }

    @Override
    public boolean isDeterministic() {
        return this.getRandomVariable().isDeterministic();
    }

    @Override
    public double[] getRealizations() {
        return this.getRandomVariable().getRealizations();
    }

    @Override
    public Double doubleValue() {
        return this.getRandomVariable().doubleValue();
    }

    @Override
    public double getMin() {
        return 0.0;
    }

    @Override
    public double getMax() {
        return 0.0;
    }

    @Override
    public double getAverage() {
        return 0.0;
    }

    @Override
    public double getAverage(RandomVariable probabilities) {
        return 0.0;
    }

    @Override
    public double getVariance() {
        return 0.0;
    }

    @Override
    public double getVariance(RandomVariable probabilities) {
        return 0.0;
    }

    @Override
    public double getSampleVariance() {
        return 0.0;
    }

    @Override
    public double getStandardDeviation() {
        return 0.0;
    }

    @Override
    public double getStandardDeviation(RandomVariable probabilities) {
        return 0.0;
    }

    @Override
    public double getStandardError() {
        return 0.0;
    }

    @Override
    public double getStandardError(RandomVariable probabilities) {
        return 0.0;
    }

    @Override
    public double getQuantile(double quantile) {
        return 0.0;
    }

    @Override
    public double getQuantile(double quantile, RandomVariable probabilities) {
        return 0.0;
    }

    @Override
    public double getQuantileExpectation(double quantileStart, double quantileEnd) {
        return 0.0;
    }

    @Override
    public double[] getHistogram(double[] intervalPoints) {
        return this.getRandomVariable().getHistogram(intervalPoints);
    }

    @Override
    public double[][] getHistogram(int numberOfPoints, double standardDeviations) {
        return this.getRandomVariable().getHistogram(numberOfPoints, standardDeviations);
    }

    @Override
    public RandomVariable cache() {
        return this.getRandomVariable().cache();
    }

    @Override
    public RandomVariable floor(double floor) {
        return null;
    }

    @Override
    public RandomVariable add(double value) {
        return null;
    }

    @Override
    public RandomVariable sub(double value) {
        return null;
    }

    @Override
    public RandomVariable mult(double value) {
        return null;
    }

    @Override
    public RandomVariable div(double value) {
        return null;
    }

    @Override
    public RandomVariable pow(double exponent) {
        return null;
    }

    @Override
    public RandomVariable average() {
        return null;
    }

    @Override
    public RandomVariable squared() {
        return this.apply(OperatorType.SQUARED, new RandomVariable[]{this});
    }

    @Override
    public RandomVariable sqrt() {
        return this.apply(OperatorType.SQRT, new RandomVariable[]{this});
    }

    @Override
    public RandomVariable exp() {
        return this.apply(OperatorType.EXP, new RandomVariable[]{this});
    }

    @Override
    public RandomVariable log() {
        return this.apply(OperatorType.LOG, new RandomVariable[]{this});
    }

    @Override
    public RandomVariable sin() {
        return this.apply(OperatorType.SIN, new RandomVariable[]{this});
    }

    @Override
    public RandomVariable cos() {
        return this.apply(OperatorType.COS, new RandomVariable[]{this});
    }

    @Override
    public RandomVariable add(RandomVariable randomVariable) {
        return this.apply(OperatorType.ADD, new RandomVariable[]{this, randomVariable});
    }

    @Override
    public RandomVariable sub(RandomVariable randomVariable) {
        return this.apply(OperatorType.SUB, new RandomVariable[]{this, randomVariable});
    }

    @Override
    public RandomVariable bus(RandomVariable randomVariable) {
        return this.apply(OperatorType.SUB, new RandomVariable[]{randomVariable, this});
    }

    @Override
    public RandomVariable mult(RandomVariable randomVariable) {
        return this.apply(OperatorType.MULT, new RandomVariable[]{this, randomVariable});
    }

    @Override
    public RandomVariable div(RandomVariable randomVariable) {
        return this.apply(OperatorType.DIV, new RandomVariable[]{this, randomVariable});
    }

    @Override
    public RandomVariable vid(RandomVariable randomVariable) {
        return this.apply(OperatorType.DIV, new RandomVariable[]{randomVariable, this});
    }

    @Override
    public RandomVariable cap(RandomVariable cap) {
        return null;
    }

    @Override
    public RandomVariable floor(RandomVariable floor) {
        return null;
    }

    @Override
    public RandomVariable accrue(RandomVariable rate, double periodLength) {
        return null;
    }

    @Override
    public RandomVariable discount(RandomVariable rate, double periodLength) {
        return null;
    }

    @Override
    public RandomVariable choose(RandomVariable valueIfTriggerNonNegative, RandomVariable valueIfTriggerNegative) {
        return null;
    }

    @Override
    public RandomVariable invert() {
        return null;
    }

    @Override
    public RandomVariable abs() {
        return null;
    }

    @Override
    public RandomVariable addProduct(RandomVariable factor1, double factor2) {
        return null;
    }

    @Override
    public RandomVariable addProduct(RandomVariable factor1, RandomVariable factor2) {
        return null;
    }

    @Override
    public RandomVariable addRatio(RandomVariable numerator, RandomVariable denominator) {
        return null;
    }

    @Override
    public RandomVariable subRatio(RandomVariable numerator, RandomVariable denominator) {
        return null;
    }

    @Override
    public RandomVariable isNaN() {
        return this.getRandomVariable().isNaN();
    }

    private boolean isUpcastableToRandomVariableUniqueVariable(Object obj) {
        return obj instanceof RandomVariableUniqueVariable;
    }

    private RandomVariableUniqueVariable apply(OperatorType operatortype, RandomVariable[] operatorVariables) {
        RandomVariable resultrandomvariable;
        ArrayList<RandomVariableUniqueVariable> parentVariables = new ArrayList<RandomVariableUniqueVariable>();
        for (int i = 0; i < operatorVariables.length; ++i) {
            if (!this.isUpcastableToRandomVariableUniqueVariable(operatorVariables[i])) {
                operatorVariables[i] = new RandomVariableUniqueVariable(operatorVariables[i], true);
            }
            parentVariables.add(i, (RandomVariableUniqueVariable)operatorVariables[i]);
            operatorVariables[i] = ((RandomVariableUniqueVariable)parentVariables.get(i)).getRandomVariable();
        }
        switch (operatortype) {
            case SQUARED: {
                resultrandomvariable = operatorVariables[0].squared();
                break;
            }
            case SQRT: {
                resultrandomvariable = operatorVariables[0].sqrt();
                break;
            }
            case EXP: {
                resultrandomvariable = operatorVariables[0].exp();
                break;
            }
            case LOG: {
                resultrandomvariable = operatorVariables[0].log();
                break;
            }
            case SIN: {
                resultrandomvariable = operatorVariables[0].sin();
                break;
            }
            case COS: {
                resultrandomvariable = operatorVariables[0].cos();
                break;
            }
            case ADD: {
                resultrandomvariable = operatorVariables[0].add(operatorVariables[1]);
                break;
            }
            case SUB: {
                resultrandomvariable = operatorVariables[0].sub(operatorVariables[1]);
                break;
            }
            case MULT: {
                resultrandomvariable = operatorVariables[0].mult(operatorVariables[1]);
                break;
            }
            case DIV: {
                resultrandomvariable = operatorVariables[0].div(operatorVariables[1]);
                break;
            }
            default: {
                throw new IllegalArgumentException("Operation not supported!\n");
            }
        }
        return new RandomVariableUniqueVariable(resultrandomvariable, false, parentVariables, operatortype);
    }

    public RandomVariable[] getGradient() {
        int numberOfVariables = this.getNumberOfVariablesInList();
        int numberOfCalculationSteps = this.factory.getNumberOfEntriesInList();
        RandomVariable[] omega_hat = new RandomVariable[numberOfCalculationSteps];
        omega_hat[numberOfCalculationSteps - 1] = new RandomVariableFromDoubleArray(1.0);
        for (int functionIndex = numberOfCalculationSteps - 2; functionIndex > 0; --functionIndex) {
            omega_hat[functionIndex] = new RandomVariableFromDoubleArray(0.0);
            for (RandomVariableUniqueVariable parent : this.parentsVariables) {
                int variableIndex = parent.getVariableID();
                omega_hat[functionIndex] = omega_hat[functionIndex].add(this.getPartialDerivative(functionIndex, variableIndex).mult(omega_hat[variableIndex]));
            }
        }
        RandomVariable[] gradient = new RandomVariable[numberOfVariables];
        int[] indicesOfVariables = this.getIDsOfVariablesInList();
        for (int i = 0; i < numberOfVariables; ++i) {
            gradient[i] = omega_hat[numberOfCalculationSteps - numberOfVariables + indicesOfVariables[i]];
        }
        return gradient;
    }

    private ArrayList<RandomVariableUniqueVariable> getListOfDependingTrueVariables() {
        ArrayList<RandomVariableUniqueVariable> listOfDependingTrueVariables = new ArrayList<RandomVariableUniqueVariable>();
        for (RandomVariableUniqueVariable parent : this.parentsVariables) {
            if (parent.isVariable() && !listOfDependingTrueVariables.contains(parent)) {
                listOfDependingTrueVariables.add(parent);
                continue;
            }
            if (parent.getParentIDs() == null) continue;
            listOfDependingTrueVariables.addAll(parent.getListOfDependingTrueVariables());
        }
        return listOfDependingTrueVariables;
    }

    private int[] getIDsOfVariablesInList() {
        int[] IDsOfVariablesInList = new int[this.getNumberOfVariablesInList()];
        ArrayList<RandomVariableUniqueVariable> listOfDependingTrueVariables = this.getListOfDependingTrueVariables();
        for (RandomVariableUniqueVariable variable : listOfDependingTrueVariables) {
            IDsOfVariablesInList[listOfDependingTrueVariables.indexOf((Object)variable)] = variable.getVariableID();
        }
        return IDsOfVariablesInList;
    }

    private int getNumberOfVariablesInList() {
        return this.getListOfDependingTrueVariables().size();
    }

    private RandomVariable getPartialDerivative(int functionIndex, int variableIndex) {
        RandomVariable resultrandomvariable;
        if (!Arrays.asList(new int[][]{this.getParentIDs()}).contains(variableIndex)) {
            return new RandomVariableFromDoubleArray(0.0);
        }
        RandomVariableUniqueVariable currentRandomVariable = (RandomVariableUniqueVariable)this.getListOfAllVariables().get(functionIndex);
        ArrayList<RandomVariable> currentParentRandomVariables = currentRandomVariable.getParentRandomVariables();
        switch (currentRandomVariable.getParentOperatorType()) {
            case SQUARED: {
                resultrandomvariable = currentParentRandomVariables.get(0).mult(2.0);
                break;
            }
            case SQRT: {
                resultrandomvariable = currentParentRandomVariables.get(0).sqrt().invert().mult(0.5);
                break;
            }
            case EXP: {
                resultrandomvariable = currentParentRandomVariables.get(0).exp();
                break;
            }
            case LOG: {
                resultrandomvariable = currentParentRandomVariables.get(0).invert();
                break;
            }
            case SIN: {
                resultrandomvariable = currentParentRandomVariables.get(0).cos();
                break;
            }
            case COS: {
                resultrandomvariable = currentParentRandomVariables.get(0).sin().mult(-1.0);
                break;
            }
            case ADD: {
                resultrandomvariable = new RandomVariableFromDoubleArray(1.0);
                break;
            }
            case SUB: {
                resultrandomvariable = new RandomVariableFromDoubleArray(1.0);
                if (variableIndex != currentRandomVariable.getParentIDs()[1]) break;
                resultrandomvariable = resultrandomvariable.mult(-1.0);
                break;
            }
            case MULT: {
                if (variableIndex == currentRandomVariable.getParentIDs()[0]) {
                    resultrandomvariable = currentParentRandomVariables.get(1);
                    break;
                }
                resultrandomvariable = currentParentRandomVariables.get(0);
                break;
            }
            case DIV: {
                if (variableIndex == currentRandomVariable.getParentIDs()[0]) {
                    resultrandomvariable = currentParentRandomVariables.get(1).invert();
                    break;
                }
                resultrandomvariable = currentParentRandomVariables.get(0).div(currentParentRandomVariables.get(1).squared()).mult(-1.0);
                break;
            }
            default: {
                throw new IllegalArgumentException("Operation not supported!\n");
            }
        }
        return resultrandomvariable;
    }

    public String toString() {
        return super.toString() + "\ntime: " + this.getFiltrationTime() + "\nrealizations: " + Arrays.toString(this.getRealizations()) + "\nvariableID: " + this.variableID + "\nparentIDs: " + Arrays.toString(this.getParentIDs()) + (String)(this.getParentIDs() == null ? "" : " type: " + this.parentOperatorType.name()) + "\nisTrueVariable: " + this.isVariable();
    }

    @Override
    public RandomVariable cap(double cap) {
        return null;
    }

    @Override
    public IntToDoubleFunction getOperator() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public DoubleStream getRealizationsStream() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public RandomVariable apply(DoubleUnaryOperator operator) {
        throw new UnsupportedOperationException("Applying functions is not supported.");
    }

    @Override
    public RandomVariable apply(DoubleBinaryOperator operator, RandomVariable argument) {
        throw new UnsupportedOperationException("Applying functions is not supported.");
    }

    @Override
    public RandomVariable apply(DoubleTernaryOperator operator, RandomVariable argument1, RandomVariable argument2) {
        throw new UnsupportedOperationException("Applying functions is not supported.");
    }

    public static enum OperatorType {
        ADD,
        MULT,
        DIV,
        SUB,
        SQUARED,
        SQRT,
        LOG,
        SIN,
        COS,
        EXP;

    }
}

