/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.hybridassetinterestrate;

import java.time.LocalDateTime;
import java.util.Map;
import net.finmath.exception.CalculationException;
import net.finmath.marketdata.model.curves.DiscountCurve;
import net.finmath.montecarlo.BrownianMotion;
import net.finmath.montecarlo.assetderivativevaluation.AssetModelMonteCarloSimulationModel;
import net.finmath.montecarlo.hybridassetinterestrate.HybridAssetLIBORModelMonteCarloSimulation;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.TermStructureModel;
import net.finmath.montecarlo.process.MonteCarloProcess;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.TimeDiscretization;

public class HybridAssetLIBORModelMonteCarloSimulationFromModels
implements HybridAssetLIBORModelMonteCarloSimulation {
    private final LIBORModelMonteCarloSimulationModel liborSimulation;
    private final AssetModelMonteCarloSimulationModel assetSimulation;
    private final DiscountCurve discountCurve;

    public HybridAssetLIBORModelMonteCarloSimulationFromModels(LIBORModelMonteCarloSimulationModel liborSimulation, AssetModelMonteCarloSimulationModel assetSimulation, DiscountCurve discountCurve) {
        this.liborSimulation = liborSimulation;
        this.assetSimulation = assetSimulation;
        this.discountCurve = discountCurve;
        if (!liborSimulation.getTimeDiscretization().equals(assetSimulation.getTimeDiscretization())) {
            throw new IllegalArgumentException("The interest rate simulation and the asset simulation need to share the same simulation time discretization.");
        }
    }

    public HybridAssetLIBORModelMonteCarloSimulationFromModels(LIBORModelMonteCarloSimulationModel liborSimulation, AssetModelMonteCarloSimulationModel assetSimulation) {
        this(liborSimulation, assetSimulation, null);
    }

    @Override
    public int getNumberOfPaths() {
        return this.liborSimulation.getNumberOfPaths();
    }

    @Override
    public LocalDateTime getReferenceDate() {
        return this.liborSimulation.getReferenceDate();
    }

    @Override
    public TimeDiscretization getTimeDiscretization() {
        return this.liborSimulation.getTimeDiscretization();
    }

    @Override
    public int getNumberOfFactors() {
        return this.liborSimulation.getNumberOfFactors();
    }

    @Override
    public double getTime(int timeIndex) {
        return this.liborSimulation.getTime(timeIndex);
    }

    @Override
    public TimeDiscretization getLiborPeriodDiscretization() {
        return this.liborSimulation.getLiborPeriodDiscretization();
    }

    @Override
    public int getTimeIndex(double time) {
        return this.liborSimulation.getTimeIndex(time);
    }

    @Override
    public int getNumberOfLibors() {
        return this.liborSimulation.getNumberOfLibors();
    }

    @Override
    public RandomVariable getRandomVariableForConstant(double value) {
        return this.liborSimulation.getRandomVariableForConstant(value);
    }

    @Override
    public double getLiborPeriod(int timeIndex) {
        return this.liborSimulation.getLiborPeriod(timeIndex);
    }

    @Override
    public int getLiborPeriodIndex(double time) {
        return this.liborSimulation.getLiborPeriodIndex(time);
    }

    @Override
    public RandomVariable getMonteCarloWeights(int timeIndex) throws CalculationException {
        return this.liborSimulation.getMonteCarloWeights(timeIndex);
    }

    @Override
    public RandomVariable getLIBOR(int timeIndex, int liborIndex) throws CalculationException {
        return this.liborSimulation.getLIBOR(timeIndex, liborIndex);
    }

    @Override
    public RandomVariable getMonteCarloWeights(double time) throws CalculationException {
        return this.liborSimulation.getMonteCarloWeights(time);
    }

    @Override
    public RandomVariable getForwardRate(double time, double periodStart, double periodEnd) throws CalculationException {
        return this.liborSimulation.getForwardRate(time, periodStart, periodEnd);
    }

    @Override
    public HybridAssetLIBORModelMonteCarloSimulationFromModels getCloneWithModifiedData(Map<String, Object> dataModified) {
        return null;
    }

    @Override
    public RandomVariable[] getLIBORs(int timeIndex) throws CalculationException {
        return this.liborSimulation.getLIBORs(timeIndex);
    }

    @Override
    public RandomVariable getNumeraire(double time) throws CalculationException {
        RandomVariable numeraire = this.liborSimulation.getNumeraire(time);
        if (this.discountCurve != null) {
            double deterministicNumeraireAdjustment = numeraire.invert().getAverage() / this.discountCurve.getDiscountFactor(time);
            numeraire = numeraire.mult(deterministicNumeraireAdjustment);
        }
        return numeraire;
    }

    @Override
    public RandomVariable getNumeraire(int timeIndex) throws CalculationException {
        return this.getNumeraire(this.getTime(timeIndex));
    }

    @Override
    public BrownianMotion getBrownianMotion() {
        return this.liborSimulation.getBrownianMotion();
    }

    @Override
    public TermStructureModel getModel() {
        return this.liborSimulation.getModel();
    }

    @Override
    public MonteCarloProcess getProcess() {
        return this.liborSimulation.getProcess();
    }

    @Override
    @Deprecated
    public HybridAssetLIBORModelMonteCarloSimulationFromModels getCloneWithModifiedSeed(int seed) {
        return null;
    }

    @Override
    public int getNumberOfAssets() {
        return this.assetSimulation.getNumberOfAssets();
    }

    @Override
    public RandomVariable getAssetValue(int timeIndex, int assetIndex) throws CalculationException {
        RandomVariable asset = this.assetSimulation.getAssetValue(timeIndex, assetIndex);
        RandomVariable changeOfMeasure = this.liborSimulation.getNumeraire(timeIndex).div(this.assetSimulation.getNumeraire(timeIndex));
        return asset.mult(changeOfMeasure);
    }

    @Override
    public RandomVariable getAssetValue(double time, int assetIndex) throws CalculationException {
        int timeIndex = this.getTimeIndex(time);
        if (timeIndex < 0) {
            timeIndex = -timeIndex - 2;
        }
        return this.getAssetValue(timeIndex, assetIndex);
    }

    @Override
    public Map<String, RandomVariable> getModelParameters() {
        throw new UnsupportedOperationException();
    }
}

