/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.BrownianMotion;
import net.finmath.montecarlo.interestrate.LIBORModel;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.TermStructureModel;
import net.finmath.montecarlo.process.MonteCarloProcess;
import net.finmath.montecarlo.process.MonteCarloProcessFromProcessModel;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.TimeDiscretization;

public class LIBORMonteCarloSimulationFromLIBORModel
implements LIBORModelMonteCarloSimulationModel {
    private final LIBORModel model;
    private final MonteCarloProcess process;

    public LIBORMonteCarloSimulationFromLIBORModel(MonteCarloProcess process) {
        this.model = (LIBORModel)process.getModel();
        this.process = process;
    }

    @Deprecated
    public LIBORMonteCarloSimulationFromLIBORModel(LIBORModel model, MonteCarloProcess process) {
        this.model = model;
        this.process = process;
    }

    @Override
    public RandomVariable getMonteCarloWeights(int timeIndex) throws CalculationException {
        return this.process.getMonteCarloWeights(timeIndex);
    }

    @Override
    public RandomVariable getMonteCarloWeights(double time) throws CalculationException {
        int timeIndex = this.getTimeIndex(time);
        if (timeIndex < 0) {
            timeIndex = -timeIndex - 1 - 1;
        }
        return this.process.getMonteCarloWeights(timeIndex);
    }

    @Override
    public int getNumberOfFactors() {
        return this.process.getNumberOfFactors();
    }

    @Override
    public int getNumberOfPaths() {
        return this.process.getNumberOfPaths();
    }

    @Override
    public LocalDateTime getReferenceDate() {
        return this.model.getReferenceDate();
    }

    @Override
    public double getTime(int timeIndex) {
        return this.process.getTime(timeIndex);
    }

    @Override
    public TimeDiscretization getTimeDiscretization() {
        return this.process.getTimeDiscretization();
    }

    @Override
    public int getTimeIndex(double time) {
        return this.process.getTimeIndex(time);
    }

    @Override
    public RandomVariable getRandomVariableForConstant(double value) {
        return this.model.getRandomVariableForConstant(value);
    }

    @Override
    public BrownianMotion getBrownianMotion() {
        return (BrownianMotion)this.process.getStochasticDriver();
    }

    @Override
    public RandomVariable getLIBOR(int timeIndex, int liborIndex) throws CalculationException {
        return this.model.getLIBOR(this.process, timeIndex, liborIndex);
    }

    @Override
    public RandomVariable[] getLIBORs(int timeIndex) throws CalculationException {
        RandomVariable[] randomVariableVector = new RandomVariable[this.getNumberOfComponents()];
        for (int componentIndex = 0; componentIndex < this.getNumberOfComponents(); ++componentIndex) {
            randomVariableVector[componentIndex] = this.getLIBOR(timeIndex, componentIndex);
        }
        return randomVariableVector;
    }

    @Override
    public RandomVariable getForwardRate(double time, double periodStart, double periodEnd) throws CalculationException {
        return this.model.getForwardRate(this.process, time, periodStart, periodEnd);
    }

    @Override
    public double getLiborPeriod(int timeIndex) {
        return this.model.getLiborPeriod(timeIndex);
    }

    @Override
    public TimeDiscretization getLiborPeriodDiscretization() {
        return this.model.getLiborPeriodDiscretization();
    }

    @Override
    public int getLiborPeriodIndex(double time) {
        return this.model.getLiborPeriodIndex(time);
    }

    public int getNumberOfComponents() {
        return this.model.getNumberOfComponents();
    }

    @Override
    public int getNumberOfLibors() {
        return this.model.getNumberOfLibors();
    }

    @Override
    public RandomVariable getNumeraire(double time) throws CalculationException {
        return this.model.getNumeraire(this.process, time);
    }

    @Override
    public LIBORModel getModel() {
        return this.model;
    }

    @Override
    public MonteCarloProcess getProcess() {
        return this.process;
    }

    @Override
    public Object getCloneWithModifiedSeed(int seed) {
        MonteCarloProcessFromProcessModel process = (MonteCarloProcessFromProcessModel)((MonteCarloProcessFromProcessModel)this.getProcess()).getCloneWithModifiedSeed(seed);
        return new LIBORMonteCarloSimulationFromLIBORModel(this.model, process);
    }

    @Override
    public LIBORModelMonteCarloSimulationModel getCloneWithModifiedData(Map<String, Object> dataModified) throws CalculationException {
        TermStructureModel modelClone = this.model.getCloneWithModifiedData((Map)dataModified);
        if (dataModified.containsKey("discountCurve") && dataModified.size() == 1) {
            LIBORMonteCarloSimulationFromLIBORModel lmmSimClone = new LIBORMonteCarloSimulationFromLIBORModel((LIBORModel)modelClone, this.process);
            return lmmSimClone;
        }
        return new LIBORMonteCarloSimulationFromLIBORModel(this.getProcess().getCloneWithModifiedModel(modelClone));
    }

    public LIBORModelMonteCarloSimulationModel getCloneWithModifiedData(String entityKey, Object dataModified) throws CalculationException {
        HashMap<String, Object> dataModifiedMap = new HashMap<String, Object>();
        dataModifiedMap.put(entityKey, dataModified);
        return this.getCloneWithModifiedData(dataModifiedMap);
    }

    @Override
    public Map<String, RandomVariable> getModelParameters() {
        return this.model.getModelParameters();
    }
}

