/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate;

import java.time.LocalDateTime;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.BrownianMotion;
import net.finmath.montecarlo.MonteCarloSimulationModel;
import net.finmath.montecarlo.automaticdifferentiation.IndependentModelParameterProvider;
import net.finmath.montecarlo.interestrate.TermStructureModel;
import net.finmath.montecarlo.process.MonteCarloProcess;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.FloatingpointDate;

public interface TermStructureMonteCarloSimulationModel
extends MonteCarloSimulationModel,
IndependentModelParameterProvider {
    default public RandomVariable getForwardRate(LocalDateTime date, LocalDateTime periodStartDate, LocalDateTime periodEndDate) throws CalculationException {
        LocalDateTime referenceDate = this.getReferenceDate();
        double time = FloatingpointDate.getFloatingPointDateFromDate(referenceDate, date);
        double periodStart = FloatingpointDate.getFloatingPointDateFromDate(referenceDate, periodStartDate);
        double periodEnd = FloatingpointDate.getFloatingPointDateFromDate(referenceDate, periodEndDate);
        return this.getForwardRate(time, periodStart, periodEnd);
    }

    public RandomVariable getForwardRate(double var1, double var3, double var5) throws CalculationException;

    default public RandomVariable getNumeraire(LocalDateTime date) throws CalculationException {
        double time = FloatingpointDate.getFloatingPointDateFromDate(this.getReferenceDate(), date);
        return this.getNumeraire(time);
    }

    public RandomVariable getNumeraire(double var1) throws CalculationException;

    default public RandomVariable getLIBOR(LocalDateTime date, LocalDateTime periodStartDate, LocalDateTime periodEndDate) throws CalculationException {
        return this.getForwardRate(date, periodStartDate, periodEndDate);
    }

    default public RandomVariable getLIBOR(double time, double periodStart, double periodEnd) throws CalculationException {
        return this.getForwardRate(time, periodStart, periodEnd);
    }

    public TermStructureModel getModel();

    public MonteCarloProcess getProcess();

    default public int getNumberOfFactors() {
        return this.getProcess().getNumberOfFactors();
    }

    default public BrownianMotion getBrownianMotion() {
        return (BrownianMotion)this.getProcess().getStochasticDriver();
    }

    @Deprecated
    public Object getCloneWithModifiedSeed(int var1);
}

