/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.models;

import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.TermStructureMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.products.components.AbstractProductComponent;
import net.finmath.stochastic.RandomVariable;
import net.finmath.stochastic.Scalar;

public class FundingCapacity
extends AbstractProductComponent {
    private static final long serialVersionUID = 6863200178588875665L;
    private final SortedMap<Double, Double> instantaneousSurvivalProbability;
    private Double currentTime = 0.0;
    private RandomVariable currentCapacity;

    public FundingCapacity(String currency, RandomVariable intialCapacity, SortedMap<Double, Double> instantaneouseSurvivalProbability) {
        super(currency);
        this.currentCapacity = intialCapacity;
        this.instantaneousSurvivalProbability = instantaneouseSurvivalProbability;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultFactors getDefaultFactors(double time, RandomVariable fundingRequirement) {
        RandomVariable fundingIntervallRight;
        RandomVariable fundingIntervallLeft;
        Double d = this.currentTime;
        synchronized (d) {
            if (time < this.currentTime) {
                throw new IllegalStateException("The method getSurvivalProbabilityRequiredFunding must be called in successive order.");
            }
            this.currentTime = time;
            RandomVariable newCapacity = this.currentCapacity.add(fundingRequirement);
            fundingIntervallLeft = this.currentCapacity.cap(newCapacity);
            fundingIntervallRight = this.currentCapacity.floor(newCapacity);
            this.currentCapacity = newCapacity;
        }
        RandomVariable integratedSurvivalProbability = new Scalar(0.0);
        RandomVariable integratedDefaultCompensation = new Scalar(0.0);
        double previousFundingLevel = -1.7976931348623157E308;
        double previousProvidedLevel = -1.7976931348623157E308;
        for (Map.Entry<Double, Double> entry : this.instantaneousSurvivalProbability.entrySet()) {
            double fundingLevel = entry.getKey();
            double survivalProbability = entry.getValue();
            double providedLevel = Math.max(previousProvidedLevel, 0.0) + (fundingLevel - Math.max(previousFundingLevel, 0.0)) * survivalProbability;
            integratedDefaultCompensation = integratedDefaultCompensation.add(fundingIntervallRight.cap(providedLevel).sub(fundingIntervallLeft.floor(previousProvidedLevel)).floor(0.0).div(survivalProbability));
            integratedSurvivalProbability = integratedSurvivalProbability.add(fundingIntervallRight.cap(fundingLevel).sub(fundingIntervallLeft.floor(previousFundingLevel)).floor(0.0).mult(survivalProbability));
            previousFundingLevel = fundingLevel;
            previousProvidedLevel = providedLevel;
        }
        RandomVariable oneOverFundingAmount = fundingIntervallRight.sub(fundingIntervallLeft).invert().cap(Double.MAX_VALUE);
        integratedSurvivalProbability = integratedSurvivalProbability.mult(oneOverFundingAmount);
        integratedDefaultCompensation = integratedDefaultCompensation.mult(oneOverFundingAmount);
        return new DefaultFactors(integratedSurvivalProbability, integratedDefaultCompensation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RandomVariable getDefaultCompensationForRequiredFunding(double time, RandomVariable fundingRequirement) {
        RandomVariable fundingIntervallRight;
        RandomVariable fundingIntervallLeft;
        Double d = this.currentTime;
        synchronized (d) {
            if (time < this.currentTime) {
                throw new IllegalStateException("The method getSurvivalProbabilityRequiredFunding must be called in successive order.");
            }
            this.currentTime = time;
            RandomVariable newCapacity = this.currentCapacity.add(fundingRequirement);
            fundingIntervallLeft = this.currentCapacity.cap(newCapacity);
            fundingIntervallRight = this.currentCapacity.floor(newCapacity);
            this.currentCapacity = newCapacity;
        }
        RandomVariable integratedSurvivalProbability = new Scalar(0.0);
        double previousFundingLevel = -1.7976931348623157E308;
        double previousProvidedLevel = -1.7976931348623157E308;
        for (Map.Entry<Double, Double> entry : this.instantaneousSurvivalProbability.entrySet()) {
            double fundingLevel = entry.getKey();
            double survivalProbability = entry.getValue();
            double providedLevel = Math.max(-1.7976931348623157E308, 0.0) + (fundingLevel - Math.max(previousFundingLevel, 0.0)) * survivalProbability;
            integratedSurvivalProbability = integratedSurvivalProbability.add(fundingIntervallRight.cap(providedLevel).sub(fundingIntervallLeft.floor(-1.7976931348623157E308)).floor(0.0).div(survivalProbability));
            previousFundingLevel = fundingLevel;
        }
        integratedSurvivalProbability = integratedSurvivalProbability.div(fundingIntervallRight.sub(fundingIntervallLeft));
        return integratedSurvivalProbability;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RandomVariable getSurvivalProbabilityRequiredFunding(double time, RandomVariable fundingRequirement) {
        RandomVariable fundingIntervallRight;
        RandomVariable fundingIntervallLeft;
        Double d = this.currentTime;
        synchronized (d) {
            if (time < this.currentTime) {
                throw new IllegalStateException("The method getSurvivalProbabilityRequiredFunding must be called in successive order.");
            }
            this.currentTime = time;
            RandomVariable newCapacity = this.currentCapacity.add(fundingRequirement);
            fundingIntervallLeft = this.currentCapacity.cap(newCapacity);
            fundingIntervallRight = this.currentCapacity.floor(newCapacity);
            this.currentCapacity = newCapacity;
        }
        RandomVariable integratedSurvivalProbability = new Scalar(0.0);
        double previousFundingLevel = -1.7976931348623157E308;
        for (Map.Entry<Double, Double> entry : this.instantaneousSurvivalProbability.entrySet()) {
            double fundingLevel = entry.getKey();
            double survivalProbability = entry.getValue();
            integratedSurvivalProbability = integratedSurvivalProbability.add(fundingIntervallRight.cap(fundingLevel).sub(fundingIntervallLeft.floor(previousFundingLevel)).floor(0.0).mult(survivalProbability));
            previousFundingLevel = fundingLevel;
        }
        integratedSurvivalProbability = integratedSurvivalProbability.div(fundingIntervallRight.sub(fundingIntervallLeft));
        return integratedSurvivalProbability;
    }

    public RandomVariable getCurrentFundingLevel() {
        return this.currentCapacity;
    }

    @Override
    public Set<String> queryUnderlyings() {
        return null;
    }

    @Override
    public RandomVariable getValue(double evaluationTime, TermStructureMonteCarloSimulationModel model) throws CalculationException {
        throw new UnsupportedOperationException();
    }

    public class DefaultFactors {
        private final RandomVariable survivalProbability;
        private final RandomVariable defaultCompensation;

        public DefaultFactors(RandomVariable survivalProbability, RandomVariable defaultCompensation) {
            this.survivalProbability = survivalProbability;
            this.defaultCompensation = defaultCompensation;
        }

        public RandomVariable getSurvivalProbability() {
            return this.survivalProbability;
        }

        public RandomVariable getDefaultCompensation() {
            return this.defaultCompensation;
        }
    }
}

