/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.models;

import java.util.ArrayList;
import java.util.Map;
import net.finmath.exception.CalculationException;
import net.finmath.functions.AnalyticFormulas;
import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.curves.DiscountCurve;
import net.finmath.marketdata.model.curves.DiscountCurveFromForwardCurve;
import net.finmath.marketdata.model.curves.ForwardCurve;
import net.finmath.marketdata.model.volatilities.SwaptionMarketData;
import net.finmath.marketdata.products.Swap;
import net.finmath.marketdata.products.SwapAnnuity;
import net.finmath.modelling.products.Swaption;
import net.finmath.montecarlo.RandomVariableFactory;
import net.finmath.montecarlo.RandomVariableFromArrayFactory;
import net.finmath.montecarlo.RandomVariableFromDoubleArray;
import net.finmath.montecarlo.interestrate.CalibrationProduct;
import net.finmath.montecarlo.interestrate.LIBORMarketModel;
import net.finmath.montecarlo.interestrate.models.covariance.AbstractLIBORCovarianceModelParametric;
import net.finmath.montecarlo.interestrate.models.covariance.LIBORCovarianceModel;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.montecarlo.interestrate.products.SwaptionAnalyticApproximation;
import net.finmath.montecarlo.interestrate.products.SwaptionSimple;
import net.finmath.montecarlo.model.AbstractProcessModel;
import net.finmath.montecarlo.process.MonteCarloProcess;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.RegularSchedule;
import net.finmath.time.Schedule;
import net.finmath.time.TimeDiscretization;
import net.finmath.time.TimeDiscretizationFromArray;

public class LIBORMarketModelStandard
extends AbstractProcessModel
implements LIBORMarketModel {
    private static final boolean isUseAnalyticApproximation = Boolean.parseBoolean(System.getProperty("net.finmath.montecarlo.interestrate.LIBORMarketModelStandard.isUseAnalyticApproximation", "true"));
    private final TimeDiscretization liborPeriodDiscretization;
    private String forwardCurveName;
    private AnalyticModel curveModel;
    private final ForwardCurve forwardRateCurve;
    private DiscountCurve discountCurve;
    private final RandomVariableFactory randomVariableFactory = new RandomVariableFromArrayFactory();
    private LIBORCovarianceModel covarianceModel;
    private SwaptionMarketData swaptionMarketData;
    private Driftapproximation driftApproximationMethod = Driftapproximation.EULER;
    private Measure measure = Measure.SPOT;
    private double[][][] integratedLIBORCovariance;

    public LIBORMarketModelStandard(TimeDiscretization liborPeriodDiscretization, ForwardCurve forwardRateCurve, LIBORCovarianceModel covarianceModel) {
        this.liborPeriodDiscretization = liborPeriodDiscretization;
        this.forwardRateCurve = forwardRateCurve;
        this.covarianceModel = covarianceModel;
    }

    public LIBORMarketModelStandard(TimeDiscretization liborPeriodDiscretization, ForwardCurve forwardRateCurve, DiscountCurve discountCurve, LIBORCovarianceModel covarianceModel) {
        this.liborPeriodDiscretization = liborPeriodDiscretization;
        this.forwardRateCurve = forwardRateCurve;
        this.discountCurve = discountCurve;
        this.covarianceModel = covarianceModel;
    }

    public LIBORMarketModelStandard(TimeDiscretization liborPeriodDiscretization, ForwardCurve forwardRateCurve, LIBORCovarianceModel covarianceModel, SwaptionMarketData swaptionMarketData) throws CalculationException {
        this(liborPeriodDiscretization, forwardRateCurve, null, covarianceModel, LIBORMarketModelStandard.getCalibrationItems(liborPeriodDiscretization, forwardRateCurve, swaptionMarketData));
    }

    public LIBORMarketModelStandard(TimeDiscretization liborPeriodDiscretization, ForwardCurve forwardRateCurve, DiscountCurve discountCurve, LIBORCovarianceModel covarianceModel, SwaptionMarketData swaptionMarketData) throws CalculationException {
        this(liborPeriodDiscretization, forwardRateCurve, discountCurve, covarianceModel, LIBORMarketModelStandard.getCalibrationItems(liborPeriodDiscretization, forwardRateCurve, swaptionMarketData));
    }

    public LIBORMarketModelStandard(TimeDiscretization liborPeriodDiscretization, ForwardCurve forwardRateCurve, DiscountCurve discountCurve, LIBORCovarianceModel covarianceModel, CalibrationProduct[] calibrationProducts) throws CalculationException {
        this.liborPeriodDiscretization = liborPeriodDiscretization;
        double[] times = new double[liborPeriodDiscretization.getNumberOfTimeSteps()];
        for (int i = 0; i < times.length; ++i) {
            times[i] = liborPeriodDiscretization.getTime(i);
        }
        AbstractLIBORCovarianceModelParametric covarianceModelParametric = null;
        try {
            covarianceModelParametric = (AbstractLIBORCovarianceModelParametric)covarianceModel;
        }
        catch (Exception e) {
            throw new ClassCastException("Calibration is currently restricted to parametric covariance models (AbstractLIBORCovarianceModelParametric).");
        }
        this.forwardRateCurve = forwardRateCurve;
        this.discountCurve = discountCurve;
        this.covarianceModel = covarianceModelParametric.getCloneCalibrated((LIBORMarketModel)this, calibrationProducts, (Map)null);
    }

    private static CalibrationProduct[] getCalibrationItems(TimeDiscretization liborPeriodDiscretization, ForwardCurve forwardCurve, SwaptionMarketData swaptionMarketData) {
        if (swaptionMarketData == null) {
            return null;
        }
        TimeDiscretization optionMaturities = swaptionMarketData.getOptionMaturities();
        TimeDiscretization tenor = swaptionMarketData.getTenor();
        double swapPeriodLength = swaptionMarketData.getSwapPeriodLength();
        ArrayList<CalibrationProduct> calibrationProducts = new ArrayList<CalibrationProduct>();
        for (int exerciseIndex = 0; exerciseIndex <= optionMaturities.getNumberOfTimeSteps(); ++exerciseIndex) {
            for (int tenorIndex = 0; tenorIndex <= tenor.getNumberOfTimeSteps() - exerciseIndex; ++tenorIndex) {
                AbstractLIBORMonteCarloProduct swaption;
                double exerciseDate = optionMaturities.getTime(exerciseIndex);
                double swapLength = tenor.getTime(tenorIndex);
                if (liborPeriodDiscretization.getTimeIndex(exerciseDate) < 0 || liborPeriodDiscretization.getTimeIndex(exerciseDate + swapLength) <= liborPeriodDiscretization.getTimeIndex(exerciseDate)) continue;
                int numberOfPeriods = (int)(swapLength / swapPeriodLength);
                double[] fixingDates = new double[numberOfPeriods];
                double[] paymentDates = new double[numberOfPeriods];
                double[] swapTenorTimes = new double[numberOfPeriods + 1];
                for (int periodStartIndex = 0; periodStartIndex < numberOfPeriods; ++periodStartIndex) {
                    fixingDates[periodStartIndex] = exerciseDate + (double)periodStartIndex * swapPeriodLength;
                    paymentDates[periodStartIndex] = exerciseDate + (double)(periodStartIndex + 1) * swapPeriodLength;
                    swapTenorTimes[periodStartIndex] = exerciseDate + (double)periodStartIndex * swapPeriodLength;
                }
                swapTenorTimes[numberOfPeriods] = exerciseDate + (double)numberOfPeriods * swapPeriodLength;
                RegularSchedule swapTenor = new RegularSchedule(new TimeDiscretizationFromArray(swapTenorTimes));
                double swaprate = Swap.getForwardSwapRate(swapTenor, swapTenor, forwardCurve, null);
                double[] swaprates = new double[numberOfPeriods];
                for (int periodStartIndex = 0; periodStartIndex < numberOfPeriods; ++periodStartIndex) {
                    swaprates[periodStartIndex] = swaprate;
                }
                if (isUseAnalyticApproximation) {
                    swaption = new SwaptionAnalyticApproximation(swaprate, swapTenorTimes, Swaption.ValueUnit.VOLATILITYLOGNORMAL);
                    double impliedVolatility = swaptionMarketData.getVolatility(exerciseDate, swapLength, swaptionMarketData.getSwapPeriodLength(), swaprate);
                    calibrationProducts.add(new CalibrationProduct(swaption, impliedVolatility, 1.0));
                    continue;
                }
                swaption = new SwaptionSimple(swaprate, swapTenorTimes, Swaption.ValueUnit.VALUE);
                double forwardSwaprate = Swap.getForwardSwapRate(swapTenor, swapTenor, forwardCurve);
                double swapAnnuity = SwapAnnuity.getSwapAnnuity((Schedule)swapTenor, forwardCurve);
                double impliedVolatility = swaptionMarketData.getVolatility(exerciseDate, swapLength, swaptionMarketData.getSwapPeriodLength(), swaprate);
                double targetValue = AnalyticFormulas.blackModelSwaptionValue(forwardSwaprate, impliedVolatility, exerciseDate, swaprate, swapAnnuity);
                calibrationProducts.add(new CalibrationProduct(swaption, targetValue, 1.0));
            }
        }
        return calibrationProducts.toArray(new CalibrationProduct[calibrationProducts.size()]);
    }

    @Override
    public RandomVariable getNumeraire(MonteCarloProcess process, double time) throws CalculationException {
        int timeIndex = this.getLiborPeriodIndex(time);
        if (timeIndex < 0) {
            int lowerIndex = -timeIndex - 1;
            int upperIndex = -timeIndex;
            double alpha = (time - this.getLiborPeriod(lowerIndex)) / (this.getLiborPeriod(upperIndex) - this.getLiborPeriod(lowerIndex));
            return this.getNumeraire(process, this.getLiborPeriod(upperIndex)).invert().mult(alpha).add(this.getNumeraire(process, this.getLiborPeriod(lowerIndex)).invert().mult(1.0 - alpha)).invert();
        }
        int firstLiborIndex = this.getLiborPeriodIndex(time);
        if (firstLiborIndex < 0) {
            throw new CalculationException("Simulation time discretization not part of forward rate tenor discretization.");
        }
        int lastLiborIndex = this.liborPeriodDiscretization.getNumberOfTimeSteps() - 1;
        if (this.measure == Measure.SPOT) {
            firstLiborIndex = 0;
            lastLiborIndex = this.getLiborPeriodIndex(time) - 1;
        }
        RandomVariable numeraire = new RandomVariableFromDoubleArray(time, 1.0);
        for (int liborIndex = firstLiborIndex; liborIndex <= lastLiborIndex; ++liborIndex) {
            RandomVariable libor = this.getLIBOR(process, process.getTimeIndex(Math.min(time, this.liborPeriodDiscretization.getTime(liborIndex))), liborIndex);
            double periodLength = this.liborPeriodDiscretization.getTimeStep(liborIndex);
            numeraire = this.measure == Measure.SPOT ? numeraire.accrue(libor, periodLength) : numeraire.discount(libor, periodLength);
        }
        if (this.discountCurve != null) {
            DiscountCurveFromForwardCurve discountcountCurveFromForwardPerformance = new DiscountCurveFromForwardCurve(this.forwardRateCurve);
            double deterministicNumeraireAdjustment = discountcountCurveFromForwardPerformance.getDiscountFactor(time) / this.discountCurve.getDiscountFactor(time);
            numeraire = numeraire.mult(deterministicNumeraireAdjustment);
        }
        return numeraire;
    }

    @Override
    public RandomVariable[] getInitialState(MonteCarloProcess process) {
        double[] liborInitialStates = new double[this.liborPeriodDiscretization.getNumberOfTimeSteps()];
        for (int timeIndex = 0; timeIndex < this.liborPeriodDiscretization.getNumberOfTimeSteps(); ++timeIndex) {
            double rate = this.forwardRateCurve.getForward(null, this.liborPeriodDiscretization.getTime(timeIndex));
            liborInitialStates[timeIndex] = Math.log(rate);
        }
        RandomVariable[] initialStateRandomVariable = new RandomVariable[this.getNumberOfComponents()];
        for (int componentIndex = 0; componentIndex < this.getNumberOfComponents(); ++componentIndex) {
            initialStateRandomVariable[componentIndex] = new RandomVariableFromDoubleArray(liborInitialStates[componentIndex]);
        }
        return initialStateRandomVariable;
    }

    @Override
    public RandomVariable[] getDrift(MonteCarloProcess process, int timeIndex, RandomVariable[] realizationAtTimeIndex, RandomVariable[] realizationPredictor) {
        int componentIndex;
        double time = process.getTime(timeIndex);
        int firstLiborIndex = this.getLiborPeriodIndex(time) + 1;
        if (firstLiborIndex < 0) {
            firstLiborIndex = -firstLiborIndex - 1 + 1;
        }
        RandomVariable[] drift = new RandomVariable[this.getNumberOfComponents()];
        RandomVariable[][] covarianceFactorSums = new RandomVariable[this.getNumberOfComponents()][this.getNumberOfFactors()];
        for (componentIndex = firstLiborIndex; componentIndex < this.getNumberOfComponents(); ++componentIndex) {
            drift[componentIndex] = new RandomVariableFromDoubleArray(0.0);
        }
        for (componentIndex = firstLiborIndex; componentIndex < this.getNumberOfComponents(); ++componentIndex) {
            int factorIndex;
            double periodLength = this.liborPeriodDiscretization.getTimeStep(componentIndex);
            RandomVariable libor = realizationAtTimeIndex[componentIndex];
            RandomVariable oneStepMeasureTransform = libor.discount(libor, periodLength).mult(periodLength);
            RandomVariable[] factorLoading = this.getFactorLoading(process, timeIndex, componentIndex, realizationAtTimeIndex);
            RandomVariable[] covarianceFactors = new RandomVariable[this.getNumberOfFactors()];
            for (factorIndex = 0; factorIndex < this.getNumberOfFactors(); ++factorIndex) {
                covarianceFactors[factorIndex] = factorLoading[factorIndex].mult(oneStepMeasureTransform);
                covarianceFactorSums[componentIndex][factorIndex] = covarianceFactors[factorIndex];
                if (componentIndex <= firstLiborIndex) continue;
                covarianceFactorSums[componentIndex][factorIndex] = covarianceFactorSums[componentIndex][factorIndex].add(covarianceFactorSums[componentIndex - 1][factorIndex]);
            }
            for (factorIndex = 0; factorIndex < this.getNumberOfFactors(); ++factorIndex) {
                drift[componentIndex] = drift[componentIndex].addProduct(covarianceFactorSums[componentIndex][factorIndex], factorLoading[factorIndex]);
            }
        }
        if (this.measure == Measure.TERMINAL) {
            for (componentIndex = firstLiborIndex; componentIndex < this.getNumberOfComponents(); ++componentIndex) {
                drift[componentIndex] = drift[componentIndex].sub(drift[this.getNumberOfComponents() - 1]);
            }
        }
        for (componentIndex = firstLiborIndex; componentIndex < this.getNumberOfComponents(); ++componentIndex) {
            RandomVariable variance = this.covarianceModel.getCovariance(timeIndex, componentIndex, componentIndex, realizationAtTimeIndex);
            drift[componentIndex] = drift[componentIndex].addProduct(variance, -0.5);
        }
        return drift;
    }

    @Override
    public RandomVariable[] getFactorLoading(MonteCarloProcess process, int timeIndex, int componentIndex, RandomVariable[] realizationAtTimeIndex) {
        return this.covarianceModel.getFactorLoading(timeIndex, componentIndex, realizationAtTimeIndex);
    }

    @Override
    public RandomVariable applyStateSpaceTransform(MonteCarloProcess process, int timeIndex, int componentIndex, RandomVariable randomVariable) {
        return randomVariable.exp();
    }

    @Override
    public RandomVariable applyStateSpaceTransformInverse(MonteCarloProcess process, int timeIndex, int componentIndex, RandomVariable randomVariable) {
        return randomVariable.log();
    }

    @Override
    public RandomVariable getRandomVariableForConstant(double value) {
        return this.randomVariableFactory.createRandomVariable(value);
    }

    public Driftapproximation getDriftApproximationMethod() {
        return this.driftApproximationMethod;
    }

    @Override
    public RandomVariable getForwardRate(MonteCarloProcess process, double time, double periodStart, double periodEnd) throws CalculationException {
        int periodStartIndex = this.getLiborPeriodIndex(periodStart);
        int periodEndIndex = this.getLiborPeriodIndex(periodEnd);
        if (periodEndIndex < 0) {
            int previousEndIndex = -periodEndIndex - 1 - 1;
            double previousEndTime = this.getLiborPeriod(previousEndIndex);
            double nextEndTime = this.getLiborPeriod(previousEndIndex + 1);
            RandomVariable liborLongPeriod = this.getForwardRate(process, time, periodStart, nextEndTime);
            RandomVariable liborShortPeriod = this.getForwardRate(process, time, previousEndTime, nextEndTime);
            RandomVariable libor = liborLongPeriod.mult(nextEndTime - periodStart).add(1.0).div(liborShortPeriod.mult(nextEndTime - previousEndTime).add(1.0).log().mult((nextEndTime - periodEnd) / (nextEndTime - previousEndTime)).exp()).sub(1.0).div(periodEnd - periodStart);
            double analyticLibor = this.getForwardRateCurve().getForward(this.getAnalyticModel(), previousEndTime, periodEnd - previousEndTime);
            double analyticLiborShortPeriod = this.getForwardRateCurve().getForward(this.getAnalyticModel(), previousEndTime, nextEndTime - previousEndTime);
            double analyticInterpolatedOnePlusLiborDt = (1.0 + analyticLiborShortPeriod * (nextEndTime - previousEndTime)) / Math.exp(Math.log(1.0 + analyticLiborShortPeriod * (nextEndTime - previousEndTime)) * (nextEndTime - periodEnd) / (nextEndTime - previousEndTime));
            double analyticOnePlusLiborDt = 1.0 + analyticLibor * (periodEnd - previousEndTime);
            double adjustment = analyticOnePlusLiborDt / analyticInterpolatedOnePlusLiborDt;
            libor = libor.mult(periodEnd - periodStart).add(1.0).mult(adjustment).sub(1.0).div(periodEnd - periodStart);
            return libor;
        }
        if (periodStartIndex < 0) {
            int previousStartIndex = -periodStartIndex - 1 - 1;
            double previousStartTime = this.getLiborPeriod(previousStartIndex);
            double nextStartTime = this.getLiborPeriod(previousStartIndex + 1);
            RandomVariable liborLongPeriod = this.getForwardRate(process, time, previousStartTime, periodEnd);
            RandomVariable liborShortPeriod = this.getForwardRate(process, time, previousStartTime, nextStartTime);
            RandomVariable libor = liborLongPeriod.mult(periodEnd - previousStartTime).add(1.0).div(liborShortPeriod.mult(nextStartTime - previousStartTime).add(1.0).log().mult((periodStart - previousStartTime) / (nextStartTime - previousStartTime)).exp()).sub(1.0).div(periodEnd - periodStart);
            double analyticLibor = this.getForwardRateCurve().getForward(this.getAnalyticModel(), previousStartTime, nextStartTime - periodStart);
            double analyticLiborShortPeriod = this.getForwardRateCurve().getForward(this.getAnalyticModel(), previousStartTime, nextStartTime - previousStartTime);
            double analyticInterpolatedOnePlusLiborDt = (1.0 + analyticLiborShortPeriod * (nextStartTime - previousStartTime)) / Math.exp(Math.log(1.0 + analyticLiborShortPeriod * (nextStartTime - previousStartTime)) * (nextStartTime - periodStart) / (nextStartTime - previousStartTime));
            double analyticOnePlusLiborDt = 1.0 + analyticLibor * (periodStart - previousStartTime);
            double adjustment = analyticOnePlusLiborDt / analyticInterpolatedOnePlusLiborDt;
            libor = libor.mult(periodEnd - periodStart).add(1.0).div(adjustment).sub(1.0).div(periodEnd - periodStart);
            return libor;
        }
        if (periodStartIndex < 0 || periodEndIndex < 0) {
            throw new AssertionError((Object)"LIBOR requested outside libor discretization points and interpolation was not performed.");
        }
        int timeIndex = process.getTimeIndex(time = Math.min(time, periodStart));
        if (timeIndex < 0) {
            timeIndex = -timeIndex - 2;
        }
        if (periodStartIndex + 1 == periodEndIndex) {
            return this.getLIBOR(process, timeIndex, periodStartIndex);
        }
        RandomVariable accrualAccount = this.getRandomVariableForConstant(1.0);
        for (int periodIndex = periodStartIndex; periodIndex < periodEndIndex; ++periodIndex) {
            double subPeriodLength = this.getLiborPeriod(periodIndex + 1) - this.getLiborPeriod(periodIndex);
            RandomVariable liborOverSubPeriod = this.getLIBOR(process, timeIndex, periodIndex);
            accrualAccount = accrualAccount.accrue(liborOverSubPeriod, subPeriodLength);
        }
        RandomVariable libor = accrualAccount.sub(1.0).div(periodEnd - periodStart);
        return libor;
    }

    @Override
    public RandomVariable getLIBOR(MonteCarloProcess process, int timeIndex, int liborIndex) throws CalculationException {
        return process.getProcessValue(timeIndex, liborIndex);
    }

    @Override
    public int getNumberOfComponents() {
        return this.getNumberOfLibors();
    }

    @Override
    public int getNumberOfFactors() {
        return this.covarianceModel.getNumberOfFactors();
    }

    @Override
    public int getNumberOfLibors() {
        return this.liborPeriodDiscretization.getNumberOfTimeSteps();
    }

    @Override
    public double getLiborPeriod(int timeIndex) {
        if (timeIndex >= this.liborPeriodDiscretization.getNumberOfTimes()) {
            throw new ArrayIndexOutOfBoundsException("Index for LIBOR period discretization out of bounds.");
        }
        return this.liborPeriodDiscretization.getTime(timeIndex);
    }

    @Override
    public int getLiborPeriodIndex(double time) {
        return this.liborPeriodDiscretization.getTimeIndex(time);
    }

    @Override
    public TimeDiscretization getLiborPeriodDiscretization() {
        return this.liborPeriodDiscretization;
    }

    private RandomVariable getDrift(MonteCarloProcess process, int timeIndex, int componentIndex, RandomVariable[] realizationAtTimeIndex, RandomVariable[] realizationPredictor) {
        if (process.getTime(timeIndex) >= this.getLiborPeriod(componentIndex)) {
            return null;
        }
        if (this.driftApproximationMethod == Driftapproximation.PREDICTOR_CORRECTOR && realizationPredictor != null) {
            RandomVariable drift = this.getDriftEuler(process, timeIndex, componentIndex, realizationAtTimeIndex);
            RandomVariable driftEulerWithPredictor = this.getDriftEuler(process, timeIndex, componentIndex, realizationPredictor);
            drift = drift.add(driftEulerWithPredictor).div(2.0);
            return drift;
        }
        if (this.driftApproximationMethod == Driftapproximation.LINE_INTEGRAL && realizationPredictor != null) {
            return this.getDriftLineIntegral(process, timeIndex, componentIndex, realizationAtTimeIndex, realizationPredictor);
        }
        return this.getDriftEuler(process, timeIndex, componentIndex, realizationAtTimeIndex);
    }

    protected RandomVariable getDriftEuler(MonteCarloProcess process, int timeIndex, int componentIndex, RandomVariable[] liborVectorStart) {
        int lastLiborIndex;
        double time = process.getTime(timeIndex);
        RandomVariable drift = new RandomVariableFromDoubleArray(time, 0.0);
        switch (this.measure) {
            case SPOT: {
                int firstLiborIndex = this.getLiborPeriodIndex(time) + 1;
                if (firstLiborIndex < 0) {
                    firstLiborIndex = -firstLiborIndex - 1 + 1;
                }
                lastLiborIndex = componentIndex;
                break;
            }
            default: {
                int firstLiborIndex = componentIndex + 1;
                lastLiborIndex = this.liborPeriodDiscretization.getNumberOfTimeSteps() - 1;
            }
        }
        for (int liborIndex = firstLiborIndex; liborIndex <= lastLiborIndex; ++liborIndex) {
            double periodLength = this.liborPeriodDiscretization.getTimeStep(liborIndex);
            RandomVariable covariance = this.covarianceModel.getCovariance(timeIndex, componentIndex, liborIndex, (RandomVariable[])null);
            RandomVariable libor = liborVectorStart[liborIndex];
            covariance = covariance.mult(periodLength).mult(libor).discount(libor, periodLength);
            drift = drift.add(covariance);
        }
        if (this.measure == Measure.TERMINAL) {
            drift = drift.mult(-1.0);
        }
        RandomVariable variance = this.covarianceModel.getCovariance(timeIndex, componentIndex, componentIndex, (RandomVariable[])null);
        drift = drift.addProduct(variance, -0.5);
        return drift;
    }

    private RandomVariable getDriftLineIntegral(MonteCarloProcess process, int timeIndex, int componentIndex, RandomVariable[] liborVectorStart, RandomVariable[] liborVectorEnd) {
        int lastLiborIndex;
        double time = process.getTime(timeIndex);
        if (process.getTime(timeIndex) >= this.getLiborPeriod(componentIndex)) {
            return null;
        }
        RandomVariable drift = new RandomVariableFromDoubleArray(time, 0.0);
        switch (this.measure) {
            case SPOT: {
                int firstLiborIndex = this.getLiborPeriodIndex(time) + 1;
                if (firstLiborIndex < 0) {
                    firstLiborIndex = -firstLiborIndex - 1 + 1;
                }
                lastLiborIndex = componentIndex;
                break;
            }
            default: {
                int firstLiborIndex = componentIndex + 1;
                lastLiborIndex = this.liborPeriodDiscretization.getNumberOfTimeSteps() - 1;
            }
        }
        for (int liborIndex = firstLiborIndex; liborIndex <= lastLiborIndex; ++liborIndex) {
            double periodLength = this.liborPeriodDiscretization.getTimeStep(liborIndex);
            RandomVariable covariance = this.covarianceModel.getCovariance(timeIndex, componentIndex, liborIndex, (RandomVariable[])null);
            RandomVariable driftTerm = new RandomVariableFromDoubleArray(1.0);
            driftTerm = driftTerm.accrue(liborVectorEnd[liborIndex], periodLength);
            driftTerm = driftTerm.discount(liborVectorStart[liborIndex], periodLength);
            driftTerm = driftTerm.log();
            driftTerm = driftTerm.mult(covariance);
            driftTerm = driftTerm.div(liborVectorEnd[liborIndex].div(liborVectorStart[liborIndex]).log());
            drift = drift.sub(driftTerm);
        }
        return drift;
    }

    public Measure getMeasure() {
        return this.measure;
    }

    @Override
    public double[][][] getIntegratedLIBORCovariance(TimeDiscretization simulationTimeDiscretization) {
        if (this.integratedLIBORCovariance != null) {
            return this.integratedLIBORCovariance;
        }
        TimeDiscretization liborPeriodDiscretization = this.getLiborPeriodDiscretization();
        this.integratedLIBORCovariance = new double[simulationTimeDiscretization.getNumberOfTimeSteps()][liborPeriodDiscretization.getNumberOfTimeSteps()][liborPeriodDiscretization.getNumberOfTimeSteps()];
        for (int componentIndex1 = 0; componentIndex1 < liborPeriodDiscretization.getNumberOfTimeSteps(); ++componentIndex1) {
            for (int componentIndex2 = componentIndex1; componentIndex2 < liborPeriodDiscretization.getNumberOfTimeSteps(); ++componentIndex2) {
                double integratedLIBORCovarianceValue = 0.0;
                for (int timeIndex = 0; timeIndex < simulationTimeDiscretization.getNumberOfTimeSteps(); ++timeIndex) {
                    double dt = simulationTimeDiscretization.getTimeStep(timeIndex);
                    RandomVariable[] factorLoadingOfComponent1 = this.getCovarianceModel().getFactorLoading(simulationTimeDiscretization.getTime(timeIndex), liborPeriodDiscretization.getTime(componentIndex1), null);
                    RandomVariable[] factorLoadingOfComponent2 = this.getCovarianceModel().getFactorLoading(simulationTimeDiscretization.getTime(timeIndex), liborPeriodDiscretization.getTime(componentIndex2), null);
                    for (int factorIndex = 0; factorIndex < this.getNumberOfFactors(); ++factorIndex) {
                        integratedLIBORCovarianceValue += factorLoadingOfComponent1[factorIndex].get(0) * factorLoadingOfComponent2[factorIndex].get(0) * dt;
                    }
                    this.integratedLIBORCovariance[timeIndex][componentIndex1][componentIndex2] = integratedLIBORCovarianceValue;
                }
            }
        }
        return this.integratedLIBORCovariance;
    }

    public Object clone() {
        return new LIBORMarketModelStandard(this.liborPeriodDiscretization, this.forwardRateCurve, this.covarianceModel);
    }

    public void setDriftApproximationMethod(Driftapproximation driftApproximationMethod) {
        this.driftApproximationMethod = driftApproximationMethod;
    }

    public void setMeasure(Measure measure) {
        this.measure = measure;
    }

    @Override
    public AnalyticModel getAnalyticModel() {
        return this.curveModel;
    }

    @Override
    public DiscountCurve getDiscountCurve() {
        if (this.discountCurve == null) {
            DiscountCurveFromForwardCurve discountCurveFromForwardCurve = new DiscountCurveFromForwardCurve(this.getForwardRateCurve());
            return discountCurveFromForwardCurve;
        }
        return this.discountCurve;
    }

    @Override
    public ForwardCurve getForwardRateCurve() {
        return this.forwardRateCurve;
    }

    public SwaptionMarketData getSwaptionMarketData() {
        return this.swaptionMarketData;
    }

    @Override
    public LIBORCovarianceModel getCovarianceModel() {
        return this.covarianceModel;
    }

    @Override
    public LIBORMarketModelStandard getCloneWithModifiedCovarianceModel(LIBORCovarianceModel covarianceModel) {
        LIBORMarketModelStandard model = (LIBORMarketModelStandard)this.clone();
        model.covarianceModel = covarianceModel;
        return model;
    }

    @Override
    public LIBORMarketModelStandard getCloneWithModifiedData(Map<String, Object> dataModified) throws CalculationException {
        TimeDiscretization liborPeriodDiscretization = this.liborPeriodDiscretization;
        AnalyticModel analyticModel = this.curveModel;
        ForwardCurve forwardRateCurve = this.forwardRateCurve;
        LIBORCovarianceModel covarianceModel = this.covarianceModel;
        SwaptionMarketData swaptionMarketData = null;
        if (dataModified.containsKey("liborPeriodDiscretization")) {
            liborPeriodDiscretization = (TimeDiscretization)dataModified.get("liborPeriodDiscretization");
        }
        if (dataModified.containsKey("forwardRateCurve")) {
            forwardRateCurve = (ForwardCurve)dataModified.get("forwardRateCurve");
        }
        if (dataModified.containsKey("forwardRateShift")) {
            throw new RuntimeException("Forward rate shift clone currently disabled.");
        }
        if (dataModified.containsKey("covarianceModel")) {
            covarianceModel = (LIBORCovarianceModel)dataModified.get("covarianceModel");
        }
        if (dataModified.containsKey("swaptionMarketData")) {
            swaptionMarketData = (SwaptionMarketData)dataModified.get("swaptionMarketData");
        }
        if (swaptionMarketData == null) {
            return new LIBORMarketModelStandard(liborPeriodDiscretization, forwardRateCurve, covarianceModel);
        }
        return new LIBORMarketModelStandard(liborPeriodDiscretization, forwardRateCurve, covarianceModel, swaptionMarketData);
    }

    @Override
    public Map<String, RandomVariable> getModelParameters() {
        throw new UnsupportedOperationException();
    }

    public static enum Measure {
        SPOT,
        TERMINAL;

    }

    public static enum Driftapproximation {
        EULER,
        LINE_INTEGRAL,
        PREDICTOR_CORRECTOR;

    }
}

