/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.models;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.finmath.exception.CalculationException;
import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.curves.DiscountCurve;
import net.finmath.marketdata.model.curves.ForwardCurve;
import net.finmath.montecarlo.RandomVariableFactory;
import net.finmath.montecarlo.RandomVariableFromArrayFactory;
import net.finmath.montecarlo.interestrate.CalibrationProduct;
import net.finmath.montecarlo.interestrate.TermStructureModel;
import net.finmath.montecarlo.interestrate.models.covariance.TermStructureCovarianceModel;
import net.finmath.montecarlo.interestrate.models.covariance.TermStructureCovarianceModelParametric;
import net.finmath.montecarlo.model.AbstractProcessModel;
import net.finmath.montecarlo.process.MonteCarloProcess;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.TimeDiscretization;
import net.finmath.time.TimeDiscretizationFromArray;

public class LIBORMarketModelWithTenorRefinement
extends AbstractProcessModel
implements TermStructureModel {
    private final TimeDiscretization[] liborPeriodDiscretizations;
    private final Integer[] numberOfDiscretizationIntervalls;
    private String forwardCurveName;
    private final AnalyticModel curveModel;
    private final ForwardCurve forwardRateCurve;
    private final DiscountCurve discountCurve;
    private final RandomVariableFactory randomVariableFactory = new RandomVariableFromArrayFactory();
    private TermStructureCovarianceModel covarianceModel;
    private final ConcurrentHashMap<Integer, RandomVariable> numeraires;
    private MonteCarloProcess numerairesProcess = null;

    public LIBORMarketModelWithTenorRefinement(TimeDiscretization[] liborPeriodDiscretizations, Integer[] numberOfDiscretizationIntervalls, AnalyticModel analyticModel, ForwardCurve forwardRateCurve, DiscountCurve discountCurve, TermStructureCovarianceModel covarianceModel, CalibrationProduct[] calibrationProducts, Map<String, ?> properties) throws CalculationException {
        Map calibrationParameters = null;
        if (properties != null && properties.containsKey("calibrationParameters")) {
            calibrationParameters = (Map)properties.get("calibrationParameters");
        }
        this.liborPeriodDiscretizations = liborPeriodDiscretizations;
        this.numberOfDiscretizationIntervalls = numberOfDiscretizationIntervalls;
        this.curveModel = analyticModel;
        this.forwardRateCurve = forwardRateCurve;
        this.discountCurve = discountCurve;
        this.covarianceModel = covarianceModel;
        if (calibrationProducts != null && calibrationProducts.length > 0) {
            TermStructureCovarianceModelParametric covarianceModelParametric = null;
            try {
                covarianceModelParametric = (TermStructureCovarianceModelParametric)covarianceModel;
            }
            catch (Exception e) {
                throw new ClassCastException("Calibration is currently restricted to parametric covariance models (TermStructureCovarianceModelParametricInterface).");
            }
            this.covarianceModel = covarianceModelParametric.getCloneCalibrated(this, calibrationProducts, calibrationParameters);
        }
        this.numeraires = new ConcurrentHashMap();
    }

    @Override
    public RandomVariable getNumeraire(MonteCarloProcess process, double time) throws CalculationException {
        RandomVariable numeraire;
        int timeIndex = this.liborPeriodDiscretizations[0].getTimeIndex(time);
        TimeDiscretization liborPeriodDiscretization = this.liborPeriodDiscretizations[0];
        if (timeIndex < 0) {
            int upperIndex = -timeIndex - 1;
            int lowerIndex = upperIndex - 1;
            if (lowerIndex < 0) {
                throw new IllegalArgumentException("Numeraire requested for time " + time + ". Unsupported");
            }
            double alpha = (time - liborPeriodDiscretization.getTime(lowerIndex)) / (liborPeriodDiscretization.getTime(upperIndex) - liborPeriodDiscretization.getTime(lowerIndex));
            RandomVariable numeraire2 = this.getNumeraire(process, liborPeriodDiscretization.getTime(upperIndex)).log().mult(alpha).add(this.getNumeraire(process, liborPeriodDiscretization.getTime(lowerIndex)).log().mult(1.0 - alpha)).exp();
            if (this.discountCurve != null) {
                double deterministicNumeraireAdjustment = numeraire2.invert().getAverage() / this.discountCurve.getDiscountFactor(this.curveModel, time);
                numeraire2 = numeraire2.mult(deterministicNumeraireAdjustment);
            }
            return numeraire2;
        }
        if (process != this.numerairesProcess) {
            this.numeraires.clear();
            this.numerairesProcess = process;
        }
        if ((numeraire = this.numeraires.get(timeIndex)) == null) {
            if (timeIndex == 0) {
                numeraire = process.getStochasticDriver().getRandomVariableForConstant(1.0);
            } else {
                numeraire = this.getNumeraire(process, this.liborPeriodDiscretizations[0].getTime(timeIndex - 1));
                double periodStart = this.liborPeriodDiscretizations[0].getTime(timeIndex - 1);
                double periodEnd = this.liborPeriodDiscretizations[0].getTime(timeIndex);
                RandomVariable libor = this.getForwardRate(process, periodStart, periodStart, periodEnd);
                numeraire = numeraire.accrue(libor, periodEnd - periodStart);
            }
            this.numeraires.put(timeIndex, numeraire);
        }
        if (this.discountCurve != null) {
            double deterministicNumeraireAdjustment = numeraire.invert().getAverage() / this.discountCurve.getDiscountFactor(this.curveModel, time);
            numeraire = numeraire.mult(deterministicNumeraireAdjustment);
        }
        return numeraire;
    }

    @Override
    public RandomVariable[] getInitialState(MonteCarloProcess process) {
        RandomVariable[] initialStateRandomVariable = new RandomVariable[this.getNumberOfComponents()];
        for (int componentIndex = 0; componentIndex < this.getNumberOfComponents(); ++componentIndex) {
            initialStateRandomVariable[componentIndex] = process.getStochasticDriver().getRandomVariableForConstant(0.0);
        }
        return initialStateRandomVariable;
    }

    @Override
    public RandomVariable[] getDrift(MonteCarloProcess process, int timeIndex, RandomVariable[] realizationAtTimeIndex, RandomVariable[] realizationPredictor) {
        RandomVariable stateVariable;
        RandomVariable stateVariablePrevious;
        double periodLengthPrevious;
        double periodStartPrevious;
        double periodEnd;
        double periodLength;
        double periodStart;
        int componentIndex;
        double time = process.getTime(timeIndex);
        double timeStep = process.getTimeDiscretization().getTimeStep(timeIndex);
        double timeNext = process.getTime(timeIndex + 1);
        RandomVariable zero = process.getStochasticDriver().getRandomVariableForConstant(0.0);
        RandomVariable[] drift = new RandomVariable[this.getNumberOfComponents()];
        for (int componentIndex2 = 0; componentIndex2 < this.getNumberOfComponents(); ++componentIndex2) {
            drift[componentIndex2] = null;
        }
        RandomVariable[] variances = new RandomVariable[this.getNumberOfComponents()];
        for (int componentIndex3 = 0; componentIndex3 < this.getNumberOfComponents(); ++componentIndex3) {
            variances[componentIndex3] = zero;
        }
        RandomVariable[] covarianceFactorSums = new RandomVariable[this.getNumberOfFactors()];
        for (int factorIndex = 0; factorIndex < covarianceFactorSums.length; ++factorIndex) {
            covarianceFactorSums[factorIndex] = zero;
        }
        TimeDiscretization liborPeriodDiscretization = this.getLiborPeriodDiscretization(timeNext);
        for (int componentIndex4 = 0; componentIndex4 < liborPeriodDiscretization.getNumberOfTimeSteps(); ++componentIndex4) {
            drift[componentIndex4] = zero;
            double periodStart2 = liborPeriodDiscretization.getTime(componentIndex4);
            double periodLength2 = liborPeriodDiscretization.getTimeStep(componentIndex4);
            double periodEnd2 = periodStart2 + periodLength2;
            double tenorTime = this.covarianceModel.getScaledTenorTime(periodStart2, periodEnd2);
            RandomVariable[] factorLoading = this.getFactorLoading(process, timeIndex, componentIndex4, realizationAtTimeIndex);
            double weight = this.getWeightForTenorRefinement(periodStart2, periodStart2, periodStart2, periodEnd2);
            for (int factorIndex = 0; factorIndex < factorLoading.length; ++factorIndex) {
                drift[componentIndex4] = drift[componentIndex4].addProduct(covarianceFactorSums[factorIndex].addProduct(factorLoading[factorIndex], weight), factorLoading[factorIndex]);
                variances[componentIndex4] = variances[componentIndex4].addProduct(factorLoading[factorIndex], factorLoading[factorIndex]);
                covarianceFactorSums[factorIndex] = covarianceFactorSums[factorIndex].addProduct(factorLoading[factorIndex], tenorTime);
            }
        }
        TimeDiscretization liborPeriodDiscretizationPrevious = this.getLiborPeriodDiscretization(time);
        for (componentIndex = 0; componentIndex < liborPeriodDiscretization.getNumberOfTimeSteps(); ++componentIndex) {
            periodStart = liborPeriodDiscretization.getTime(componentIndex);
            periodLength = liborPeriodDiscretization.getTimeStep(componentIndex);
            periodEnd = periodStart + periodLength;
            periodStartPrevious = liborPeriodDiscretizationPrevious.getTime(componentIndex);
            periodLengthPrevious = liborPeriodDiscretizationPrevious.getTimeStep(componentIndex);
            double periodEndPrevious = periodStartPrevious + periodLengthPrevious;
            if (periodStartPrevious == periodStart && periodEndPrevious == periodEnd) continue;
            stateVariablePrevious = this.getStateVariable(process, timeIndex, periodStartPrevious, periodEndPrevious);
            stateVariable = this.getStateVariable(process, timeIndex, periodStart, periodEnd);
            if (Double.isNaN(stateVariable.getAverage()) || Double.isNaN(stateVariablePrevious.getAverage())) {
                throw new IllegalArgumentException("The model parameters resulted in a state variable becoming NaN (not a number).");
            }
            drift[componentIndex] = drift[componentIndex].add(stateVariable.sub(stateVariablePrevious).div(timeStep));
        }
        for (componentIndex = 0; componentIndex < liborPeriodDiscretization.getNumberOfTimeSteps(); ++componentIndex) {
            drift[this.getNumberOfLibors() + componentIndex] = variances[componentIndex];
        }
        for (componentIndex = 0; componentIndex < liborPeriodDiscretization.getNumberOfTimeSteps(); ++componentIndex) {
            periodStart = liborPeriodDiscretization.getTime(componentIndex);
            periodLength = liborPeriodDiscretization.getTimeStep(componentIndex);
            periodEnd = periodStart + periodLength;
            periodStartPrevious = liborPeriodDiscretizationPrevious.getTime(componentIndex);
            periodLengthPrevious = liborPeriodDiscretizationPrevious.getTimeStep(componentIndex);
            double periodEndPrevious = periodStartPrevious + periodLengthPrevious;
            if (periodStartPrevious == periodStart && periodEndPrevious == periodEnd) continue;
            stateVariablePrevious = this.getIntegratedVariance(process, timeIndex, periodStartPrevious, periodEndPrevious);
            stateVariable = this.getIntegratedVariance(process, timeIndex, periodStart, periodEnd);
            if (Double.isNaN(stateVariable.getAverage()) || Double.isNaN(stateVariablePrevious.getAverage())) {
                throw new IllegalArgumentException("The model parameters resulted in a state variable becoming NaN (not a number).");
            }
            drift[this.getNumberOfLibors() + componentIndex] = drift[this.getNumberOfLibors() + componentIndex].add(stateVariable.sub(stateVariablePrevious).div(timeStep));
        }
        return drift;
    }

    private RandomVariable getIntegratedVariance(MonteCarloProcess process, int timeIndex, double periodStart, double periodEnd) {
        TimeDiscretization liborPeriodTiscretization = this.getLiborPeriodDiscretization(process.getTime(timeIndex));
        int periodStartIndex = liborPeriodTiscretization.getTimeIndex(periodStart);
        int perirodEndIndex = liborPeriodTiscretization.getTimeIndex(periodEnd);
        if (periodStartIndex < 0) {
            periodStartIndex = -periodStartIndex - 1 - 1;
        }
        if (perirodEndIndex < 0) {
            perirodEndIndex = -perirodEndIndex - 1;
        }
        if (perirodEndIndex != periodStartIndex + 1) {
            throw new IllegalArgumentException();
        }
        RandomVariable integratedVariance = null;
        try {
            integratedVariance = process.getProcessValue(timeIndex, this.getNumberOfLibors() + periodStartIndex);
        }
        catch (CalculationException calculationException) {
            // empty catch block
        }
        return integratedVariance;
    }

    private double getWeightForTenorRefinement(double periodStartPrevious, double periodEndPrevious, double periodStart, double periodEnd) {
        TimeDiscretization numeriareDiscretization = this.liborPeriodDiscretizations[0];
        int periodStartPreviousIndex = numeriareDiscretization.getTimeIndex(periodStartPrevious);
        int periodEndPreviousIndex = numeriareDiscretization.getTimeIndex(periodEndPrevious);
        int periodStartIndex = numeriareDiscretization.getTimeIndex(periodStart);
        int periodEndIndex = numeriareDiscretization.getTimeIndex(periodEnd);
        if (periodStartIndex < 0) {
            periodStartIndex = -periodStartIndex - 1;
        }
        if (periodEndIndex < 0) {
            periodEndIndex = -periodEndIndex - 1 - 1;
        }
        double weight1 = 0.0;
        for (int periodIndex = periodStartPreviousIndex; periodIndex < periodEndPreviousIndex; ++periodIndex) {
            double deltaT = this.covarianceModel.getScaledTenorTime(numeriareDiscretization.getTime(periodIndex), numeriareDiscretization.getTime(periodIndex + 1));
            double deltaTSum = this.covarianceModel.getScaledTenorTime(periodStartPrevious, numeriareDiscretization.getTime(periodIndex + 1));
            weight1 += deltaT * deltaTSum;
        }
        double weight2 = 0.0;
        for (int periodIndex = periodStartIndex; periodIndex < periodEndIndex; ++periodIndex) {
            double deltaT = this.covarianceModel.getScaledTenorTime(numeriareDiscretization.getTime(periodIndex), numeriareDiscretization.getTime(periodIndex + 1));
            double deltaTSum = this.covarianceModel.getScaledTenorTime(periodStartPrevious, numeriareDiscretization.getTime(periodIndex + 1));
            weight2 += deltaT * deltaTSum;
        }
        if (weight1 > 0.0) {
            return weight2 / this.covarianceModel.getScaledTenorTime(periodStart, periodEnd) - weight1 / this.covarianceModel.getScaledTenorTime(periodStartPrevious, periodEndPrevious);
        }
        return weight2 / this.covarianceModel.getScaledTenorTime(periodStart, periodEnd);
    }

    @Override
    public RandomVariable[] getFactorLoading(MonteCarloProcess process, int timeIndex, int componentIndex, RandomVariable[] realizationAtTimeIndex) {
        RandomVariable zero = process.getStochasticDriver().getRandomVariableForConstant(0.0);
        if (componentIndex < this.getNumberOfLibors()) {
            TimeDiscretization liborPeriodDiscretization = this.getLiborPeriodDiscretization(process.getTime(timeIndex));
            TimeDiscretization liborPeriodDiscretizationNext = this.getLiborPeriodDiscretization(process.getTime(timeIndex + 1));
            double periodStart = liborPeriodDiscretizationNext.getTime(componentIndex);
            double periodEnd = liborPeriodDiscretizationNext.getTime(componentIndex + 1);
            RandomVariable[] factorLoadingVector = this.covarianceModel.getFactorLoading(process.getTime(timeIndex), periodStart, periodEnd, liborPeriodDiscretization, realizationAtTimeIndex, this);
            return factorLoadingVector;
        }
        Object[] zeros = new RandomVariable[process.getStochasticDriver().getNumberOfFactors()];
        Arrays.fill(zeros, zero);
        return zeros;
    }

    @Override
    public RandomVariable applyStateSpaceTransform(MonteCarloProcess process, int timeIndex, int componentIndex, RandomVariable randomVariable) {
        return randomVariable;
    }

    @Override
    public RandomVariable applyStateSpaceTransformInverse(MonteCarloProcess process, int timeIndex, int componentIndex, RandomVariable randomVariable) {
        return randomVariable;
    }

    @Override
    public RandomVariable getRandomVariableForConstant(double value) {
        return this.randomVariableFactory.createRandomVariable(value);
    }

    private TimeDiscretization getLiborPeriodDiscretization(double time) {
        double firstTime;
        ArrayList<Double> tenorTimes = new ArrayList<Double>();
        double lastTime = firstTime = this.liborPeriodDiscretizations[0].getTime(this.liborPeriodDiscretizations[0].getTimeIndexNearestLessOrEqual(time));
        tenorTimes.add(firstTime);
        for (int discretizationLevelIndex = 0; discretizationLevelIndex < this.liborPeriodDiscretizations.length; ++discretizationLevelIndex) {
            int tentorIntervallStartIndex = this.liborPeriodDiscretizations[discretizationLevelIndex].getTimeIndexNearestLessOrEqual(lastTime) + 1;
            for (int tenorIntervall = 0; tenorIntervall < this.numberOfDiscretizationIntervalls[discretizationLevelIndex] && tentorIntervallStartIndex + tenorIntervall < this.liborPeriodDiscretizations[discretizationLevelIndex].getNumberOfTimes(); ++tenorIntervall) {
                lastTime = this.liborPeriodDiscretizations[discretizationLevelIndex].getTime(tentorIntervallStartIndex + tenorIntervall);
                lastTime = this.liborPeriodDiscretizations[0].getTime(this.liborPeriodDiscretizations[0].getTimeIndexNearestLessOrEqual(lastTime));
                tenorTimes.add(lastTime);
            }
        }
        return new TimeDiscretizationFromArray(tenorTimes);
    }

    public RandomVariable getStateVariableForPeriod(TimeDiscretization liborPeriodDiscretization, RandomVariable[] stateVariables, double periodStart, double periodEnd) {
        double tenor;
        RandomVariable integratedVariance;
        double tenorRefinementWeight;
        RandomVariable stateVariable;
        int periodStartIndex = liborPeriodDiscretization.getTimeIndex(periodStart);
        int periodEndIndex = liborPeriodDiscretization.getTimeIndex(periodEnd);
        RandomVariable stateVariableSum = this.randomVariableFactory.createRandomVariable(0.0);
        if (periodStartIndex < 0) {
            if ((periodStartIndex = -periodStartIndex - 1) >= liborPeriodDiscretization.getNumberOfTimes()) {
                throw new IllegalArgumentException();
            }
            stateVariable = stateVariables[periodStartIndex - 1];
            double shortPeriodEnd = liborPeriodDiscretization.getTime(periodStartIndex);
            tenorRefinementWeight = this.getWeightForTenorRefinement(liborPeriodDiscretization.getTime(periodStartIndex - 1), shortPeriodEnd, periodStart, shortPeriodEnd);
            integratedVariance = stateVariables[this.getNumberOfLibors() + periodStartIndex - 1];
            tenor = this.covarianceModel.getScaledTenorTime(periodStart, shortPeriodEnd);
            stateVariableSum = stateVariableSum.addProduct(stateVariable.addProduct(integratedVariance, tenorRefinementWeight), tenor);
        }
        if (periodEndIndex < 0) {
            periodEndIndex = -periodEndIndex - 1;
            stateVariable = stateVariables[periodEndIndex - 1];
            double shortPeriodStart = liborPeriodDiscretization.getTime(periodEndIndex - 1);
            tenorRefinementWeight = this.getWeightForTenorRefinement(shortPeriodStart, liborPeriodDiscretization.getTime(periodEndIndex), shortPeriodStart, periodEnd);
            integratedVariance = stateVariables[this.getNumberOfLibors() + periodEndIndex - 1];
            tenor = this.covarianceModel.getScaledTenorTime(shortPeriodStart, periodEnd);
            stateVariableSum = stateVariableSum.addProduct(stateVariable.addProduct(integratedVariance, tenorRefinementWeight), tenor);
            --periodEndIndex;
        }
        for (int periodIndex = periodStartIndex; periodIndex < periodEndIndex; ++periodIndex) {
            RandomVariable stateVariable2 = stateVariables[periodIndex];
            double tenor2 = this.covarianceModel.getScaledTenorTime(liborPeriodDiscretization.getTime(periodIndex), liborPeriodDiscretization.getTime(periodIndex + 1));
            stateVariableSum = stateVariableSum.addProduct(stateVariable2, tenor2);
        }
        double tenor3 = this.covarianceModel.getScaledTenorTime(periodStart, periodEnd);
        stateVariableSum = stateVariableSum.div(tenor3);
        return stateVariableSum;
    }

    public RandomVariable getLIBORForStateVariable(TimeDiscretization liborPeriodDiscretization, RandomVariable[] stateVariables, double periodStart, double periodEnd) {
        RandomVariable stateVariable = this.getStateVariableForPeriod(liborPeriodDiscretization, stateVariables, periodStart, periodEnd);
        stateVariable = stateVariable.mult(periodEnd - periodStart).add(Math.log(1.0 + this.forwardRateCurve.getForward(null, periodStart) * (periodEnd - periodStart)));
        RandomVariable libor = stateVariable.exp().sub(1.0).div(periodEnd - periodStart);
        return null;
    }

    public RandomVariable getStateVariable(MonteCarloProcess process, int timeIndex, double periodStart, double periodEnd) {
        double time = process.getTimeDiscretization().getTime(timeIndex);
        TimeDiscretization liborPeriodDiscretization = this.getLiborPeriodDiscretization(time);
        int periodStartIndex = liborPeriodDiscretization.getTimeIndex(periodStart);
        int periodEndIndex = liborPeriodDiscretization.getTimeIndex(periodEnd);
        RandomVariable stateVariableSum = null;
        try {
            RandomVariable integratedVariance;
            double tenorRefinementWeight;
            RandomVariable stateVariable;
            stateVariableSum = process.getStochasticDriver().getRandomVariableForConstant(0.0);
            if (periodStartIndex < 0) {
                if ((periodStartIndex = -periodStartIndex - 1) >= liborPeriodDiscretization.getNumberOfTimes()) {
                    throw new IllegalArgumentException();
                }
                stateVariable = process.getProcessValue(timeIndex, periodStartIndex - 1);
                double shortPeriodEnd = liborPeriodDiscretization.getTime(periodStartIndex);
                tenorRefinementWeight = this.getWeightForTenorRefinement(liborPeriodDiscretization.getTime(periodStartIndex - 1), shortPeriodEnd, periodStart, shortPeriodEnd);
                integratedVariance = this.getIntegratedVariance(process, timeIndex, liborPeriodDiscretization.getTime(periodStartIndex - 1), liborPeriodDiscretization.getTime(periodStartIndex));
                stateVariableSum = stateVariableSum.addProduct(stateVariable.addProduct(integratedVariance, tenorRefinementWeight), this.covarianceModel.getScaledTenorTime(periodStart, shortPeriodEnd));
            }
            if (periodEndIndex < 0) {
                periodEndIndex = -periodEndIndex - 1;
                stateVariable = process.getProcessValue(timeIndex, periodEndIndex - 1);
                double shortPeriodStart = liborPeriodDiscretization.getTime(periodEndIndex - 1);
                tenorRefinementWeight = this.getWeightForTenorRefinement(shortPeriodStart, liborPeriodDiscretization.getTime(periodEndIndex), shortPeriodStart, periodEnd);
                integratedVariance = this.getIntegratedVariance(process, timeIndex, liborPeriodDiscretization.getTime(periodEndIndex - 1), liborPeriodDiscretization.getTime(periodEndIndex));
                stateVariableSum = stateVariableSum.addProduct(stateVariable.addProduct(integratedVariance, tenorRefinementWeight), this.covarianceModel.getScaledTenorTime(shortPeriodStart, periodEnd));
                --periodEndIndex;
            }
            for (int periodIndex = periodStartIndex; periodIndex < periodEndIndex; ++periodIndex) {
                RandomVariable stateVariable2 = process.getProcessValue(timeIndex, periodIndex);
                stateVariableSum = stateVariableSum.addProduct(stateVariable2, this.covarianceModel.getScaledTenorTime(liborPeriodDiscretization.getTime(periodIndex), liborPeriodDiscretization.getTime(periodIndex + 1)));
            }
            stateVariableSum = stateVariableSum.div(this.covarianceModel.getScaledTenorTime(periodStart, periodEnd));
        }
        catch (CalculationException calculationException) {
            // empty catch block
        }
        return stateVariableSum;
    }

    @Override
    public RandomVariable getForwardRate(MonteCarloProcess process, double time, double periodStart, double periodEnd) {
        int timeIndex = process.getTimeIndex(time);
        if (timeIndex < 0) {
            timeIndex = -timeIndex - 1 - 1;
        }
        return this.getLIBOR(process, timeIndex, periodStart, periodEnd);
    }

    public RandomVariable getLIBOR(MonteCarloProcess process, int timeIndex, double periodStart, double periodEnd) {
        RandomVariable stateVariable = this.getStateVariable(process, timeIndex, periodStart, periodEnd);
        double initialValue = Math.log(1.0 + this.forwardRateCurve.getForward(this.curveModel, periodStart) * this.forwardRateCurve.getPaymentOffset(periodStart)) / this.forwardRateCurve.getPaymentOffset(periodStart);
        double tenorTime = this.covarianceModel.getScaledTenorTime(periodStart, periodEnd);
        stateVariable = stateVariable.mult(tenorTime).add(initialValue * (periodEnd - periodStart));
        RandomVariable libor = stateVariable.exp().sub(1.0).div(periodEnd - periodStart);
        return libor;
    }

    @Override
    public int getNumberOfComponents() {
        return 2 * this.getLiborPeriodDiscretization(0.0).getNumberOfTimeSteps();
    }

    @Override
    public int getNumberOfFactors() {
        return this.covarianceModel.getNumberOfFactors();
    }

    public int getNumberOfLibors() {
        return this.getLiborPeriodDiscretization(0.0).getNumberOfTimeSteps();
    }

    public Object clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public AnalyticModel getAnalyticModel() {
        return this.curveModel;
    }

    @Override
    public DiscountCurve getDiscountCurve() {
        return this.discountCurve;
    }

    @Override
    public ForwardCurve getForwardRateCurve() {
        return this.forwardRateCurve;
    }

    @Override
    public TermStructureModel getCloneWithModifiedData(Map<String, Object> dataModified) throws CalculationException {
        CalibrationProduct[] calibrationItems = null;
        Map<String, ?> properties = null;
        TermStructureCovarianceModel covarianceModel = this.covarianceModel;
        if (dataModified.containsKey("covarianceModel")) {
            covarianceModel = (TermStructureCovarianceModel)dataModified.get("covarianceModel");
        }
        return new LIBORMarketModelWithTenorRefinement(this.liborPeriodDiscretizations, this.numberOfDiscretizationIntervalls, this.curveModel, this.forwardRateCurve, this.discountCurve, covarianceModel, calibrationItems, properties);
    }

    public TermStructureCovarianceModel getCovarianceModel() {
        return this.covarianceModel;
    }

    public static enum Driftapproximation {
        EULER,
        LINE_INTEGRAL,
        PREDICTOR_CORRECTOR;

    }
}

