/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.models.covariance;

import java.util.Map;
import net.finmath.exception.CalculationException;
import net.finmath.marketdata.model.curves.ForwardCurve;
import net.finmath.montecarlo.RandomVariableFactory;
import net.finmath.montecarlo.RandomVariableFromArrayFactory;
import net.finmath.montecarlo.interestrate.models.covariance.AbstractLIBORCovarianceModelParametric;
import net.finmath.montecarlo.interestrate.models.covariance.DisplacedLocalVolatilityModel;
import net.finmath.stochastic.RandomVariable;
import net.finmath.stochastic.Scalar;

public class BlendedLocalVolatilityModel
extends AbstractLIBORCovarianceModelParametric {
    private static final long serialVersionUID = -5042461187735524974L;
    private RandomVariableFactory randomVariableFactory;
    private AbstractLIBORCovarianceModelParametric covarianceModel;
    private RandomVariable displacement;
    private final ForwardCurve forwardCurve;
    private boolean isCalibrateable = false;

    public BlendedLocalVolatilityModel(AbstractLIBORCovarianceModelParametric covarianceModel, ForwardCurve forwardCurve, RandomVariable displacement, boolean isCalibrateable) {
        super(covarianceModel.getTimeDiscretization(), covarianceModel.getLiborPeriodDiscretization(), covarianceModel.getNumberOfFactors());
        this.covarianceModel = covarianceModel;
        this.forwardCurve = forwardCurve;
        this.displacement = displacement;
        this.isCalibrateable = isCalibrateable;
    }

    public BlendedLocalVolatilityModel(RandomVariableFactory randomVariableFactory, AbstractLIBORCovarianceModelParametric covarianceModel, ForwardCurve forwardCurve, double displacement, boolean isCalibrateable) {
        super(covarianceModel.getTimeDiscretization(), covarianceModel.getLiborPeriodDiscretization(), covarianceModel.getNumberOfFactors());
        this.randomVariableFactory = randomVariableFactory != null ? randomVariableFactory : new RandomVariableFromArrayFactory();
        this.covarianceModel = covarianceModel;
        this.forwardCurve = forwardCurve;
        this.displacement = this.randomVariableFactory.createRandomVariable(displacement);
        this.isCalibrateable = isCalibrateable;
    }

    public BlendedLocalVolatilityModel(RandomVariableFactory randomVariableFactory, AbstractLIBORCovarianceModelParametric covarianceModel, double displacement, boolean isCalibrateable) {
        this(randomVariableFactory, covarianceModel, null, displacement, isCalibrateable);
    }

    public BlendedLocalVolatilityModel(AbstractLIBORCovarianceModelParametric covarianceModel, ForwardCurve forwardCurve, double displacement, boolean isCalibrateable) {
        this(new RandomVariableFromArrayFactory(), covarianceModel, forwardCurve, displacement, isCalibrateable);
    }

    public BlendedLocalVolatilityModel(AbstractLIBORCovarianceModelParametric covarianceModel, double displacement, boolean isCalibrateable) {
        this(new RandomVariableFromArrayFactory(), covarianceModel, displacement, isCalibrateable);
    }

    @Override
    public Object clone() {
        return new BlendedLocalVolatilityModel(this.randomVariableFactory, (AbstractLIBORCovarianceModelParametric)this.covarianceModel.clone(), this.forwardCurve, this.displacement.doubleValue(), this.isCalibrateable);
    }

    public AbstractLIBORCovarianceModelParametric getBaseCovarianceModel() {
        return this.covarianceModel;
    }

    @Override
    public RandomVariable[] getParameter() {
        if (!this.isCalibrateable) {
            return this.covarianceModel.getParameter();
        }
        RandomVariable[] covarianceParameters = this.covarianceModel.getParameter();
        if (covarianceParameters == null) {
            return new RandomVariable[]{this.displacement};
        }
        RandomVariable[] jointParameters = new RandomVariable[covarianceParameters.length + 1];
        System.arraycopy(covarianceParameters, 0, jointParameters, 0, covarianceParameters.length);
        jointParameters[covarianceParameters.length] = this.displacement;
        return jointParameters;
    }

    @Override
    public double[] getParameterAsDouble() {
        RandomVariable[] parameters = this.getParameter();
        double[] parametersAsDouble = new double[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            parametersAsDouble[i] = parameters[i].doubleValue();
        }
        return parametersAsDouble;
    }

    @Override
    public AbstractLIBORCovarianceModelParametric getCloneWithModifiedParameters(RandomVariable[] parameters) {
        if (parameters == null || parameters.length == 0) {
            return this;
        }
        if (!this.isCalibrateable) {
            this.covarianceModel = this.covarianceModel.getCloneWithModifiedParameters(parameters);
            return new BlendedLocalVolatilityModel(this.covarianceModel, this.forwardCurve, this.displacement, this.isCalibrateable);
        }
        RandomVariable[] covarianceParameters = new RandomVariable[parameters.length - 1];
        System.arraycopy(parameters, 0, covarianceParameters, 0, covarianceParameters.length);
        this.covarianceModel = this.covarianceModel.getCloneWithModifiedParameters(covarianceParameters);
        this.displacement = parameters[covarianceParameters.length];
        return new BlendedLocalVolatilityModel(this.covarianceModel, this.forwardCurve, this.displacement, this.isCalibrateable);
    }

    @Override
    public AbstractLIBORCovarianceModelParametric getCloneWithModifiedParameters(double[] parameters) {
        return this.getCloneWithModifiedParameters(Scalar.arrayOf(parameters));
    }

    @Override
    public RandomVariable[] getFactorLoading(int timeIndex, int component, RandomVariable[] realizationAtTimeIndex) {
        RandomVariable[] factorLoading = this.covarianceModel.getFactorLoading(timeIndex, component, realizationAtTimeIndex);
        double forward = 1.0;
        if (this.forwardCurve != null) {
            double timeToMaturity = this.getLiborPeriodDiscretization().getTime(component) - this.getTimeDiscretization().getTime(timeIndex);
            forward = this.forwardCurve.getForward(null, Math.max(timeToMaturity, 0.0));
        }
        if (realizationAtTimeIndex != null && realizationAtTimeIndex[component] != null) {
            RandomVariable localVolatilityFactor = realizationAtTimeIndex[component].sub(realizationAtTimeIndex[component].mult(this.displacement)).add(this.displacement.mult(forward));
            for (int factorIndex = 0; factorIndex < factorLoading.length; ++factorIndex) {
                factorLoading[factorIndex] = factorLoading[factorIndex].mult(localVolatilityFactor);
            }
        }
        return factorLoading;
    }

    @Override
    public RandomVariable getFactorLoadingPseudoInverse(int timeIndex, int component, int factor, RandomVariable[] realizationAtTimeIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AbstractLIBORCovarianceModelParametric getCloneWithModifiedData(Map<String, Object> dataModified) throws CalculationException {
        RandomVariableFactory randomVariableFactory = this.randomVariableFactory;
        AbstractLIBORCovarianceModelParametric covarianceModel = this.covarianceModel;
        ForwardCurve forwardCurve = this.forwardCurve;
        double displacement = this.displacement.doubleValue();
        boolean isCalibrateable = this.isCalibrateable;
        if (dataModified != null) {
            if (!dataModified.containsKey("covarianceModel")) {
                covarianceModel = covarianceModel.getCloneWithModifiedData(dataModified);
            }
            covarianceModel = (AbstractLIBORCovarianceModelParametric)dataModified.getOrDefault("covarianceModel", covarianceModel);
            isCalibrateable = (Boolean)dataModified.getOrDefault("isCalibrateable", isCalibrateable);
            randomVariableFactory = (RandomVariableFactory)dataModified.getOrDefault("randomVariableFactory", randomVariableFactory);
            forwardCurve = (ForwardCurve)dataModified.getOrDefault("forwardCurve", forwardCurve);
            displacement = dataModified.getOrDefault("displacement", displacement) instanceof RandomVariable ? ((RandomVariable)dataModified.get("displacement")).doubleValue().doubleValue() : ((Double)dataModified.getOrDefault("displacement", displacement)).doubleValue();
        }
        DisplacedLocalVolatilityModel newModel = new DisplacedLocalVolatilityModel(covarianceModel, displacement, isCalibrateable);
        return newModel;
    }
}

