/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.models.covariance;

import java.util.Map;
import net.finmath.exception.CalculationException;
import net.finmath.marketdata.model.curves.ForwardCurve;
import net.finmath.montecarlo.RandomVariableFactory;
import net.finmath.montecarlo.interestrate.models.covariance.AbstractLIBORCovarianceModelParametric;
import net.finmath.stochastic.RandomVariable;
import net.finmath.stochastic.Scalar;

public class DisplacedLocalVolatilityModel
extends AbstractLIBORCovarianceModelParametric {
    private static final long serialVersionUID = 4522227972747028512L;
    private final AbstractLIBORCovarianceModelParametric covarianceModel;
    private final RandomVariable displacement;
    private ForwardCurve forwardCurve;
    private boolean isCalibrateable = false;

    public DisplacedLocalVolatilityModel(AbstractLIBORCovarianceModelParametric covarianceModel, RandomVariable displacement, boolean isCalibrateable) {
        super(covarianceModel.getTimeDiscretization(), covarianceModel.getLiborPeriodDiscretization(), covarianceModel.getNumberOfFactors());
        this.covarianceModel = covarianceModel;
        this.displacement = displacement;
        this.isCalibrateable = isCalibrateable;
    }

    public DisplacedLocalVolatilityModel(AbstractLIBORCovarianceModelParametric covarianceModel, double displacement, boolean isCalibrateable) {
        super(covarianceModel.getTimeDiscretization(), covarianceModel.getLiborPeriodDiscretization(), covarianceModel.getNumberOfFactors());
        this.covarianceModel = covarianceModel;
        this.displacement = new Scalar(displacement);
        this.isCalibrateable = isCalibrateable;
    }

    @Override
    public Object clone() {
        return new DisplacedLocalVolatilityModel((AbstractLIBORCovarianceModelParametric)this.covarianceModel.clone(), this.displacement, this.isCalibrateable);
    }

    public AbstractLIBORCovarianceModelParametric getBaseCovarianceModel() {
        return this.covarianceModel;
    }

    @Override
    public RandomVariable[] getParameter() {
        if (!this.isCalibrateable) {
            return this.covarianceModel.getParameter();
        }
        RandomVariable[] covarianceParameters = this.covarianceModel.getParameter();
        if (covarianceParameters == null) {
            return new RandomVariable[]{this.displacement};
        }
        RandomVariable[] jointParameters = new RandomVariable[covarianceParameters.length + 1];
        System.arraycopy(covarianceParameters, 0, jointParameters, 0, covarianceParameters.length);
        jointParameters[covarianceParameters.length] = this.displacement;
        return jointParameters;
    }

    @Override
    public double[] getParameterAsDouble() {
        RandomVariable[] parameters = this.getParameter();
        double[] parametersAsDouble = new double[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            parametersAsDouble[i] = parameters[i].doubleValue();
        }
        return parametersAsDouble;
    }

    @Override
    public AbstractLIBORCovarianceModelParametric getCloneWithModifiedParameters(RandomVariable[] parameters) {
        if (parameters == null || parameters.length == 0) {
            return this;
        }
        if (!this.isCalibrateable) {
            return new DisplacedLocalVolatilityModel(this.covarianceModel.getCloneWithModifiedParameters(parameters), this.displacement, this.isCalibrateable);
        }
        RandomVariable[] covarianceParameters = new RandomVariable[parameters.length - 1];
        System.arraycopy(parameters, 0, covarianceParameters, 0, covarianceParameters.length);
        AbstractLIBORCovarianceModelParametric newCovarianceModel = this.covarianceModel.getCloneWithModifiedParameters(covarianceParameters);
        RandomVariable newDisplacement = parameters[covarianceParameters.length];
        return new DisplacedLocalVolatilityModel(newCovarianceModel, newDisplacement, this.isCalibrateable);
    }

    @Override
    public AbstractLIBORCovarianceModelParametric getCloneWithModifiedParameters(double[] parameters) {
        return this.getCloneWithModifiedParameters(Scalar.arrayOf(parameters));
    }

    @Override
    public RandomVariable[] getFactorLoading(int timeIndex, int component, RandomVariable[] realizationAtTimeIndex) {
        RandomVariable[] factorLoading = this.covarianceModel.getFactorLoading(timeIndex, component, realizationAtTimeIndex);
        if (realizationAtTimeIndex != null && realizationAtTimeIndex[component] != null) {
            RandomVariable localVolatilityFactor = realizationAtTimeIndex[component].add(this.displacement);
            for (int factorIndex = 0; factorIndex < factorLoading.length; ++factorIndex) {
                factorLoading[factorIndex] = factorLoading[factorIndex].mult(localVolatilityFactor);
            }
        }
        return factorLoading;
    }

    @Override
    public RandomVariable getFactorLoadingPseudoInverse(int timeIndex, int component, int factor, RandomVariable[] realizationAtTimeIndex) {
        throw new UnsupportedOperationException();
    }

    public RandomVariable getDisplacement() {
        return this.displacement;
    }

    @Override
    public AbstractLIBORCovarianceModelParametric getCloneWithModifiedData(Map<String, Object> dataModified) throws CalculationException {
        RandomVariable displacement = this.displacement;
        boolean isCalibrateable = this.isCalibrateable;
        AbstractLIBORCovarianceModelParametric covarianceModel = this.covarianceModel;
        RandomVariableFactory randomVariableFactory = null;
        if (dataModified != null) {
            if (dataModified.containsKey("randomVariableFactory")) {
                randomVariableFactory = (RandomVariableFactory)dataModified.get("randomVariableFactory");
                displacement = randomVariableFactory.createRandomVariable(displacement.doubleValue());
            }
            if (!dataModified.containsKey("covarianceModel")) {
                covarianceModel = covarianceModel.getCloneWithModifiedData(dataModified);
            }
            covarianceModel = (AbstractLIBORCovarianceModelParametric)dataModified.getOrDefault("covarianceModel", covarianceModel);
            isCalibrateable = (Boolean)dataModified.getOrDefault("isCalibrateable", isCalibrateable);
            displacement = dataModified.getOrDefault("displacement", displacement) instanceof RandomVariable ? (RandomVariable)dataModified.getOrDefault("displacement", displacement) : (randomVariableFactory == null ? new Scalar((Double)dataModified.get("displacement")) : randomVariableFactory.createRandomVariable((Double)dataModified.get("displacement")));
        }
        DisplacedLocalVolatilityModel newModel = new DisplacedLocalVolatilityModel(covarianceModel, displacement, isCalibrateable);
        return newModel;
    }
}

