/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.models.covariance;

import java.util.Map;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.models.covariance.AbstractLIBORCovarianceModelParametric;
import net.finmath.stochastic.RandomVariable;

public class HullWhiteLocalVolatilityModel
extends AbstractLIBORCovarianceModelParametric {
    private static final long serialVersionUID = -4182083344704425769L;
    private final AbstractLIBORCovarianceModelParametric covarianceModel;
    private final double periodLength;

    public HullWhiteLocalVolatilityModel(AbstractLIBORCovarianceModelParametric covarianceModel, double periodLength) {
        super(covarianceModel.getTimeDiscretization(), covarianceModel.getLiborPeriodDiscretization(), covarianceModel.getNumberOfFactors());
        this.covarianceModel = covarianceModel;
        this.periodLength = periodLength;
    }

    @Override
    public Object clone() {
        return new HullWhiteLocalVolatilityModel((AbstractLIBORCovarianceModelParametric)this.covarianceModel.clone(), this.periodLength);
    }

    public AbstractLIBORCovarianceModelParametric getBaseCovarianceModel() {
        return this.covarianceModel;
    }

    @Override
    public double[] getParameterAsDouble() {
        return this.covarianceModel.getParameterAsDouble();
    }

    @Override
    public AbstractLIBORCovarianceModelParametric getCloneWithModifiedParameters(double[] parameters) {
        return new HullWhiteLocalVolatilityModel(this.covarianceModel.getCloneWithModifiedParameters(parameters), this.periodLength);
    }

    @Override
    public RandomVariable[] getFactorLoading(int timeIndex, int component, RandomVariable[] realizationAtTimeIndex) {
        RandomVariable[] factorLoading = this.covarianceModel.getFactorLoading(timeIndex, component, realizationAtTimeIndex);
        if (realizationAtTimeIndex != null && realizationAtTimeIndex[component] != null) {
            RandomVariable localVolatilityFactor = realizationAtTimeIndex[component].mult(this.periodLength).add(1.0);
            for (int factorIndex = 0; factorIndex < factorLoading.length; ++factorIndex) {
                factorLoading[factorIndex] = factorLoading[factorIndex].mult(localVolatilityFactor);
            }
        }
        return factorLoading;
    }

    @Override
    public RandomVariable getFactorLoadingPseudoInverse(int timeIndex, int component, int factor, RandomVariable[] realizationAtTimeIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AbstractLIBORCovarianceModelParametric getCloneWithModifiedData(Map<String, Object> dataModified) throws CalculationException {
        double periodLength = this.periodLength;
        AbstractLIBORCovarianceModelParametric covarianceModel = this.covarianceModel;
        if (dataModified != null) {
            if (!dataModified.containsKey("covarianceModel")) {
                covarianceModel = covarianceModel.getCloneWithModifiedData(dataModified);
            }
            covarianceModel = (AbstractLIBORCovarianceModelParametric)dataModified.getOrDefault("covarianceModel", covarianceModel);
            periodLength = (Double)dataModified.getOrDefault("periodLength", periodLength);
        }
        HullWhiteLocalVolatilityModel newModel = new HullWhiteLocalVolatilityModel(covarianceModel, periodLength);
        return newModel;
    }
}

