/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.models.covariance;

import java.io.Serializable;
import java.util.Map;
import net.finmath.stochastic.RandomVariable;
import net.finmath.stochastic.RandomVariableArrayImplementation;
import net.finmath.time.TimeDiscretization;

public abstract class LIBORCorrelationModel
implements Serializable {
    private static final long serialVersionUID = -6780424108470638825L;
    private final TimeDiscretization timeDiscretization;
    private final TimeDiscretization liborPeriodDiscretization;

    public LIBORCorrelationModel(TimeDiscretization timeDiscretization, TimeDiscretization liborPeriodDiscretization) {
        this.timeDiscretization = timeDiscretization;
        this.liborPeriodDiscretization = liborPeriodDiscretization;
    }

    public abstract RandomVariable[] getParameter();

    public abstract LIBORCorrelationModel getCloneWithModifiedParameter(RandomVariable[] var1);

    public abstract double getFactorLoading(int var1, int var2, int var3);

    public abstract double getCorrelation(int var1, int var2, int var3);

    public abstract int getNumberOfFactors();

    public double[] getParameterAsDouble() {
        return (double[])RandomVariableArrayImplementation.of(this.getParameter()).toDoubleArray();
    }

    public TimeDiscretization getLiborPeriodDiscretization() {
        return this.liborPeriodDiscretization;
    }

    public TimeDiscretization getTimeDiscretization() {
        return this.timeDiscretization;
    }

    public abstract Object clone();

    public abstract LIBORCorrelationModel getCloneWithModifiedData(Map<String, Object> var1);
}

