/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.models.covariance;

import java.util.Map;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.RandomVariableFromDoubleArray;
import net.finmath.montecarlo.interestrate.models.covariance.AbstractLIBORCovarianceModelParametric;
import net.finmath.montecarlo.interestrate.models.covariance.LIBORCorrelationModelThreeParameterExponentialDecay;
import net.finmath.montecarlo.interestrate.models.covariance.LIBORVolatilityModelMaturityDependentFourParameterExponentialForm;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.TimeDiscretization;

public class LIBORCovarianceModelExponentialForm7Param
extends AbstractLIBORCovarianceModelParametric {
    private static final long serialVersionUID = -7980504204664006566L;
    private double[] parameter = new double[7];
    private LIBORVolatilityModelMaturityDependentFourParameterExponentialForm volatilityModel;
    private LIBORCorrelationModelThreeParameterExponentialDecay correlationModel;

    public LIBORCovarianceModelExponentialForm7Param(TimeDiscretization timeDiscretization, TimeDiscretization liborPeriodDiscretization, int numberOfFactors) {
        super(timeDiscretization, liborPeriodDiscretization, numberOfFactors);
        this.parameter[0] = 0.1;
        this.parameter[1] = 0.1;
        this.parameter[2] = 0.1;
        this.parameter[3] = 0.2;
        this.parameter[4] = 0.1;
        this.parameter[5] = 0.1;
        this.parameter[6] = 0.1;
        this.volatilityModel = new LIBORVolatilityModelMaturityDependentFourParameterExponentialForm(this.getTimeDiscretization(), this.getLiborPeriodDiscretization(), this.parameter[0], this.parameter[1], this.parameter[2], this.parameter[3]);
        this.correlationModel = new LIBORCorrelationModelThreeParameterExponentialDecay(this.getLiborPeriodDiscretization(), this.getLiborPeriodDiscretization(), this.getNumberOfFactors(), this.parameter[4], this.parameter[5], this.parameter[6], false);
    }

    @Override
    public Object clone() {
        LIBORCovarianceModelExponentialForm7Param model = new LIBORCovarianceModelExponentialForm7Param(this.getTimeDiscretization(), this.getLiborPeriodDiscretization(), this.getNumberOfFactors());
        model.parameter = this.parameter;
        model.volatilityModel = this.volatilityModel;
        model.correlationModel = this.correlationModel;
        return model;
    }

    @Override
    public AbstractLIBORCovarianceModelParametric getCloneWithModifiedParameters(double[] parameters) {
        LIBORCovarianceModelExponentialForm7Param model = (LIBORCovarianceModelExponentialForm7Param)this.clone();
        model.parameter = parameters;
        if (parameters[0] != this.parameter[0] || parameters[1] != this.parameter[1] || parameters[2] != this.parameter[2] || parameters[3] != this.parameter[3]) {
            model.volatilityModel = new LIBORVolatilityModelMaturityDependentFourParameterExponentialForm(this.getTimeDiscretization(), this.getLiborPeriodDiscretization(), parameters[0], parameters[1], parameters[2], parameters[3]);
        }
        if (parameters[4] != this.parameter[4] || parameters[5] != this.parameter[5] || parameters[6] != this.parameter[6]) {
            model.correlationModel = new LIBORCorrelationModelThreeParameterExponentialDecay(this.getLiborPeriodDiscretization(), this.getLiborPeriodDiscretization(), this.getNumberOfFactors(), parameters[4], parameters[5], parameters[6], false);
        }
        return model;
    }

    @Override
    public double[] getParameterAsDouble() {
        return this.parameter;
    }

    @Override
    public RandomVariable[] getFactorLoading(int timeIndex, int component, RandomVariable[] realizationAtTimeIndex) {
        RandomVariable[] factorLoading = new RandomVariable[this.correlationModel.getNumberOfFactors()];
        for (int factorIndex = 0; factorIndex < factorLoading.length; ++factorIndex) {
            RandomVariable volatility;
            factorLoading[factorIndex] = volatility = this.volatilityModel.getVolatility(timeIndex, component);
            factorLoading[factorIndex] = factorLoading[factorIndex].mult(this.correlationModel.getFactorLoading(timeIndex, factorIndex, component));
        }
        return factorLoading;
    }

    @Override
    public RandomVariableFromDoubleArray getFactorLoadingPseudoInverse(int timeIndex, int component, int factor, RandomVariable[] realizationAtTimeIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AbstractLIBORCovarianceModelParametric getCloneWithModifiedData(Map<String, Object> dataModified) throws CalculationException {
        TimeDiscretization timeDiscretization = this.getTimeDiscretization();
        TimeDiscretization liborPeriodDiscretization = this.getLiborPeriodDiscretization();
        int numberOfFactors = this.getNumberOfFactors();
        if (dataModified != null) {
            timeDiscretization = (TimeDiscretization)dataModified.getOrDefault("timeDiscretization", timeDiscretization);
            liborPeriodDiscretization = (TimeDiscretization)dataModified.getOrDefault("liborPeriodDiscretization", liborPeriodDiscretization);
            numberOfFactors = (Integer)dataModified.getOrDefault("numberOfFactors", numberOfFactors);
        }
        LIBORCovarianceModelExponentialForm7Param newModel = new LIBORCovarianceModelExponentialForm7Param(timeDiscretization, liborPeriodDiscretization, numberOfFactors);
        return newModel;
    }
}

