/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.models.covariance;

import java.io.Serializable;
import java.util.Map;
import net.finmath.stochastic.RandomVariable;
import net.finmath.stochastic.RandomVariableArrayImplementation;
import net.finmath.time.TimeDiscretization;

public abstract class LIBORVolatilityModel
implements Serializable {
    private static final long serialVersionUID = 5481713000841480672L;
    private TimeDiscretization timeDiscretization;
    private TimeDiscretization liborPeriodDiscretization;

    private LIBORVolatilityModel() {
    }

    public LIBORVolatilityModel(TimeDiscretization timeDiscretization, TimeDiscretization liborPeriodDiscretization) {
        this.timeDiscretization = timeDiscretization;
        this.liborPeriodDiscretization = liborPeriodDiscretization;
    }

    public abstract RandomVariable[] getParameter();

    public abstract LIBORVolatilityModel getCloneWithModifiedParameter(RandomVariable[] var1);

    public abstract RandomVariable getVolatility(int var1, int var2);

    public double[] getParameterAsDouble() {
        return (double[])RandomVariableArrayImplementation.of(this.getParameter()).toDoubleArray();
    }

    public TimeDiscretization getLiborPeriodDiscretization() {
        return this.liborPeriodDiscretization;
    }

    public TimeDiscretization getTimeDiscretization() {
        return this.timeDiscretization;
    }

    public abstract Object clone();

    public abstract LIBORVolatilityModel getCloneWithModifiedData(Map<String, Object> var1);
}

