/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.models.covariance;

import java.util.Arrays;
import java.util.Map;
import java.util.function.ToDoubleFunction;
import net.finmath.montecarlo.RandomVariableFactory;
import net.finmath.montecarlo.RandomVariableFromArrayFactory;
import net.finmath.montecarlo.interestrate.models.covariance.LIBORVolatilityModel;
import net.finmath.stochastic.RandomVariable;
import net.finmath.stochastic.Scalar;
import net.finmath.time.TimeDiscretization;

public class LIBORVolatilityModelMaturityDependentFourParameterExponentialForm
extends LIBORVolatilityModel {
    private static final long serialVersionUID = 1412665163004646789L;
    private final RandomVariableFactory randomVariableFactory;
    private final RandomVariable[] a;
    private final RandomVariable[] b;
    private final RandomVariable[] c;
    private final RandomVariable[] d;

    public LIBORVolatilityModelMaturityDependentFourParameterExponentialForm(TimeDiscretization timeDiscretization, TimeDiscretization liborPeriodDiscretization, RandomVariable[] parameterA, RandomVariable[] parameterB, RandomVariable[] parameterC, RandomVariable[] parameterD) {
        super(timeDiscretization, liborPeriodDiscretization);
        this.randomVariableFactory = new RandomVariableFromArrayFactory();
        this.a = parameterA;
        this.b = parameterB;
        this.c = parameterC;
        this.d = parameterD;
    }

    public LIBORVolatilityModelMaturityDependentFourParameterExponentialForm(RandomVariableFactory randomVariableFactory, TimeDiscretization timeDiscretization, TimeDiscretization liborPeriodDiscretization, double[] a, double[] b, double[] c, double[] d) {
        super(timeDiscretization, liborPeriodDiscretization);
        this.randomVariableFactory = randomVariableFactory;
        this.a = randomVariableFactory.createRandomVariableArray(a);
        this.b = randomVariableFactory.createRandomVariableArray(b);
        this.c = randomVariableFactory.createRandomVariableArray(c);
        this.d = randomVariableFactory.createRandomVariableArray(d);
    }

    public LIBORVolatilityModelMaturityDependentFourParameterExponentialForm(RandomVariableFactory randomVariableFactory, TimeDiscretization timeDiscretization, TimeDiscretization liborPeriodDiscretization, double a, double b, double c, double d) {
        super(timeDiscretization, liborPeriodDiscretization);
        this.randomVariableFactory = randomVariableFactory;
        this.a = new RandomVariable[liborPeriodDiscretization.getNumberOfTimeSteps()];
        Arrays.fill(this.a, randomVariableFactory.createRandomVariable(a));
        this.b = new RandomVariable[liborPeriodDiscretization.getNumberOfTimeSteps()];
        Arrays.fill(this.b, randomVariableFactory.createRandomVariable(b));
        this.c = new RandomVariable[liborPeriodDiscretization.getNumberOfTimeSteps()];
        Arrays.fill(this.c, randomVariableFactory.createRandomVariable(c));
        this.d = new RandomVariable[liborPeriodDiscretization.getNumberOfTimeSteps()];
        Arrays.fill(this.d, randomVariableFactory.createRandomVariable(d));
    }

    public LIBORVolatilityModelMaturityDependentFourParameterExponentialForm(TimeDiscretization timeDiscretization, TimeDiscretization liborPeriodDiscretization, double a, double b, double c, double d) {
        this((RandomVariableFactory)new RandomVariableFromArrayFactory(), timeDiscretization, liborPeriodDiscretization, a, b, c, d);
    }

    public LIBORVolatilityModelMaturityDependentFourParameterExponentialForm(TimeDiscretization timeDiscretization, TimeDiscretization liborPeriodDiscretization, double[] a, double[] b, double[] c, double[] d) {
        this((RandomVariableFactory)new RandomVariableFromArrayFactory(), timeDiscretization, liborPeriodDiscretization, a, b, c, d);
    }

    @Override
    public RandomVariable[] getParameter() {
        RandomVariable[] parameter = new RandomVariable[this.a.length + this.b.length + this.c.length + this.d.length];
        System.arraycopy(this.a, 0, parameter, 0, this.a.length);
        System.arraycopy(this.b, 0, parameter, this.a.length, this.b.length);
        System.arraycopy(this.c, 0, parameter, this.a.length + this.b.length, this.c.length);
        System.arraycopy(this.d, 0, parameter, this.a.length + this.b.length + this.c.length, this.d.length);
        return parameter;
    }

    @Override
    public LIBORVolatilityModelMaturityDependentFourParameterExponentialForm getCloneWithModifiedParameter(RandomVariable[] parameter) {
        RandomVariable[] parameterA = new RandomVariable[this.a.length];
        RandomVariable[] parameterB = new RandomVariable[this.b.length];
        RandomVariable[] parameterC = new RandomVariable[this.c.length];
        RandomVariable[] parameterD = new RandomVariable[this.d.length];
        System.arraycopy(parameter, 0, parameterA, 0, this.a.length);
        System.arraycopy(parameter, this.a.length, parameterA, 0, this.b.length);
        System.arraycopy(parameter, this.a.length + this.b.length, parameterA, 0, this.c.length);
        System.arraycopy(parameter, this.a.length + this.b.length + this.c.length, parameterA, 0, this.d.length);
        return new LIBORVolatilityModelMaturityDependentFourParameterExponentialForm(super.getTimeDiscretization(), super.getLiborPeriodDiscretization(), parameterA, parameterB, parameterC, parameterD);
    }

    @Override
    public RandomVariable getVolatility(int timeIndex, int liborIndex) {
        double time = this.getTimeDiscretization().getTime(timeIndex);
        double maturity = this.getLiborPeriodDiscretization().getTime(liborIndex);
        double timeToMaturity = maturity - time;
        RandomVariable volatilityInstanteaneous = timeToMaturity <= 0.0 ? new Scalar(0.0) : this.a[liborIndex].addProduct(this.b[liborIndex], timeToMaturity).mult(this.c[liborIndex].mult(-timeToMaturity).exp()).add(this.d[liborIndex]);
        return volatilityInstanteaneous;
    }

    @Override
    public Object clone() {
        return new LIBORVolatilityModelMaturityDependentFourParameterExponentialForm(super.getTimeDiscretization(), super.getLiborPeriodDiscretization(), this.a, this.b, this.c, this.d);
    }

    @Override
    public LIBORVolatilityModel getCloneWithModifiedData(Map<String, Object> dataModified) {
        RandomVariableFactory randomVariableFactory = this.randomVariableFactory;
        TimeDiscretization timeDiscretization = this.getTimeDiscretization();
        TimeDiscretization liborPeriodDiscretization = this.getLiborPeriodDiscretization();
        double[] a = Arrays.stream(this.a).mapToDouble(new ToDoubleFunction<RandomVariable>(){

            @Override
            public double applyAsDouble(RandomVariable x) {
                return x.doubleValue();
            }
        }).toArray();
        double[] b = Arrays.stream(this.b).mapToDouble(new ToDoubleFunction<RandomVariable>(){

            @Override
            public double applyAsDouble(RandomVariable x) {
                return x.doubleValue();
            }
        }).toArray();
        double[] c = Arrays.stream(this.c).mapToDouble(new ToDoubleFunction<RandomVariable>(){

            @Override
            public double applyAsDouble(RandomVariable x) {
                return x.doubleValue();
            }
        }).toArray();
        double[] d = Arrays.stream(this.d).mapToDouble(new ToDoubleFunction<RandomVariable>(){

            @Override
            public double applyAsDouble(RandomVariable x) {
                return x.doubleValue();
            }
        }).toArray();
        if (dataModified != null) {
            randomVariableFactory = (RandomVariableFactory)dataModified.getOrDefault("randomVariableFactory", randomVariableFactory);
            timeDiscretization = (TimeDiscretization)dataModified.getOrDefault("timeDiscretization", timeDiscretization);
            liborPeriodDiscretization = (TimeDiscretization)dataModified.getOrDefault("liborPeriodDiscretization", liborPeriodDiscretization);
            a = dataModified.getOrDefault("a", a) instanceof RandomVariable[] ? Arrays.stream((RandomVariable[])dataModified.getOrDefault("a", a)).mapToDouble(new ToDoubleFunction<RandomVariable>(){

                @Override
                public double applyAsDouble(RandomVariable param) {
                    return param.doubleValue();
                }
            }).toArray() : (double[])dataModified.get("a");
            b = dataModified.getOrDefault("b", b) instanceof RandomVariable[] ? Arrays.stream((RandomVariable[])dataModified.getOrDefault("b", b)).mapToDouble(new ToDoubleFunction<RandomVariable>(){

                @Override
                public double applyAsDouble(RandomVariable param) {
                    return param.doubleValue();
                }
            }).toArray() : (double[])dataModified.get("b");
            c = dataModified.getOrDefault("c", c) instanceof RandomVariable[] ? Arrays.stream((RandomVariable[])dataModified.getOrDefault("c", c)).mapToDouble(new ToDoubleFunction<RandomVariable>(){

                @Override
                public double applyAsDouble(RandomVariable param) {
                    return param.doubleValue();
                }
            }).toArray() : (double[])dataModified.get("c");
            d = dataModified.getOrDefault("d", d) instanceof RandomVariable[] ? Arrays.stream((RandomVariable[])dataModified.getOrDefault("d", d)).mapToDouble(new ToDoubleFunction<RandomVariable>(){

                @Override
                public double applyAsDouble(RandomVariable param) {
                    return param.doubleValue();
                }
            }).toArray() : (double[])dataModified.get("d");
        }
        LIBORVolatilityModelMaturityDependentFourParameterExponentialForm newModel = new LIBORVolatilityModelMaturityDependentFourParameterExponentialForm(randomVariableFactory, timeDiscretization, liborPeriodDiscretization, a, b, c, d);
        return newModel;
    }
}

