/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.models.covariance;

import net.finmath.montecarlo.interestrate.models.covariance.ShortRateVolatilityModel;
import net.finmath.stochastic.RandomVariable;
import net.finmath.stochastic.Scalar;
import net.finmath.time.TimeDiscretization;

public class ShortRateVolatilityModelAsGiven
implements ShortRateVolatilityModel {
    private static final long serialVersionUID = 2471249188261414930L;
    private final TimeDiscretization timeDiscretization;
    private final double[] volatility;
    private final double[] meanReversion;

    public ShortRateVolatilityModelAsGiven(TimeDiscretization timeDiscretization, double[] volatility, double[] meanReversion) {
        this.timeDiscretization = timeDiscretization;
        this.volatility = volatility;
        this.meanReversion = meanReversion;
    }

    @Override
    public TimeDiscretization getTimeDiscretization() {
        return this.timeDiscretization;
    }

    @Override
    public RandomVariable getVolatility(int timeIndex) {
        return new Scalar(this.volatility[timeIndex]);
    }

    @Override
    public RandomVariable getMeanReversion(int timeIndex) {
        return new Scalar(this.meanReversion[timeIndex]);
    }
}

