/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.models.covariance;

import java.util.Arrays;
import net.finmath.montecarlo.RandomVariableFactory;
import net.finmath.montecarlo.interestrate.models.covariance.AbstractShortRateVolatilityModelParametric;
import net.finmath.montecarlo.interestrate.models.covariance.ShortRateVolatilityModel;
import net.finmath.stochastic.RandomVariable;
import net.finmath.stochastic.Scalar;
import net.finmath.time.TimeDiscretization;

public class ShortRateVolatilityModelPiecewiseConstant
extends AbstractShortRateVolatilityModelParametric
implements ShortRateVolatilityModel {
    private static final long serialVersionUID = 4266489807755944607L;
    private final TimeDiscretization timeDiscretization;
    private final TimeDiscretization volatilityTimeDiscretization;
    private RandomVariable[] volatility;
    private RandomVariable[] meanReversion;
    private final RandomVariableFactory randomVariableFactory;
    private final boolean isVolatilityCalibrateable;
    private final boolean isMeanReversionCalibrateable;

    public ShortRateVolatilityModelPiecewiseConstant(RandomVariableFactory randomVariableFactory, TimeDiscretization timeDiscretization, TimeDiscretization volatilityTimeDiscretization, RandomVariable[] volatility, RandomVariable[] meanReversion, boolean isVolatilityCalibrateable, boolean isMeanReversionCalibrateable) {
        super(timeDiscretization);
        if (volatility.length != volatilityTimeDiscretization.getNumberOfTimes()) {
            throw new IllegalArgumentException("volatility.length should equal volatilityTimeDiscretization.getNumberOfTimes().");
        }
        if (meanReversion.length != volatilityTimeDiscretization.getNumberOfTimes()) {
            throw new IllegalArgumentException("meanReversion.length should equal volatilityTimeDiscretization.getNumberOfTimes().");
        }
        this.timeDiscretization = timeDiscretization;
        this.volatilityTimeDiscretization = volatilityTimeDiscretization;
        this.randomVariableFactory = randomVariableFactory;
        this.volatility = volatility;
        this.meanReversion = meanReversion;
        this.isVolatilityCalibrateable = isVolatilityCalibrateable;
        this.isMeanReversionCalibrateable = isMeanReversionCalibrateable;
    }

    public ShortRateVolatilityModelPiecewiseConstant(RandomVariableFactory randomVariableFactory, TimeDiscretization timeDiscretization, TimeDiscretization volatilityTimeDiscretization, double[] volatility, double[] meanReversion, boolean isVolatilityCalibrateable, boolean isMeanReversionCalibrateable) {
        super(timeDiscretization);
        this.timeDiscretization = timeDiscretization;
        this.volatilityTimeDiscretization = volatilityTimeDiscretization;
        this.randomVariableFactory = randomVariableFactory;
        double maxMaturity = timeDiscretization.getTime(timeDiscretization.getNumberOfTimes() - 1);
        int volatilityIndex = 0;
        for (int volatilityTime = 0; volatilityTime < volatilityTimeDiscretization.getNumberOfTimes(); ++volatilityTime) {
            if (!(volatilityTimeDiscretization.getTime(volatilityTime) <= maxMaturity)) continue;
            ++volatilityIndex;
        }
        if (volatility.length == 1) {
            this.volatility = new RandomVariable[volatilityIndex];
            Arrays.fill(this.volatility, randomVariableFactory.createRandomVariable(volatility[0]));
        } else if (volatility.length == volatilityIndex) {
            this.volatility = randomVariableFactory.createRandomVariableArray(volatility);
        } else {
            throw new IllegalArgumentException("Volatility length (" + volatility.length + ") does not match number of free parameters " + volatilityIndex + ".");
        }
        if (volatilityIndex != this.volatility.length) {
            throw new IllegalArgumentException("volatility.length should equal volatilityTimeDiscretization.getNumberOfTimes().");
        }
        for (int meanReversionIndex = 0; meanReversionIndex < meanReversion.length; ++meanReversionIndex) {
            if (meanReversion[meanReversionIndex] != 0.0) continue;
            throw new IllegalArgumentException("Mean reversion needs to be nonzero");
        }
        if (meanReversion.length == 1) {
            this.meanReversion = new RandomVariable[volatilityIndex];
            Arrays.fill(this.meanReversion, randomVariableFactory.createRandomVariable(meanReversion[0]));
        } else if (meanReversion.length == volatilityIndex) {
            this.meanReversion = randomVariableFactory.createRandomVariableArray(meanReversion);
        } else {
            throw new IllegalArgumentException("Mean reversion length does not match number of free parameters.");
        }
        if (volatilityIndex != this.meanReversion.length) {
            throw new IllegalArgumentException("meanReversion.length should equal volatilityTimeDiscretization.getNumberOfTimes().");
        }
        this.isVolatilityCalibrateable = isVolatilityCalibrateable;
        this.isMeanReversionCalibrateable = isMeanReversionCalibrateable;
    }

    public ShortRateVolatilityModelPiecewiseConstant(RandomVariableFactory randomVariableFactory, TimeDiscretization timeDiscretization, TimeDiscretization volatilityTimeDiscretization, double[] volatility, double[] meanReversion, boolean isVolatilityCalibrateable) {
        this(randomVariableFactory, timeDiscretization, volatilityTimeDiscretization, volatility, meanReversion, isVolatilityCalibrateable, false);
    }

    public ShortRateVolatilityModelPiecewiseConstant(RandomVariableFactory randomVariableFactory, TimeDiscretization timeDiscretization, TimeDiscretization volatilityTimeDiscretization, RandomVariable[] volatility, RandomVariable[] meanReversion, boolean isVolatilityCalibrateable) {
        this(randomVariableFactory, timeDiscretization, volatilityTimeDiscretization, volatility, meanReversion, isVolatilityCalibrateable, false);
    }

    @Override
    public RandomVariable getVolatility(int timeIndex) {
        double time = this.timeDiscretization.getTime(timeIndex);
        int volatilityTimeIndex = this.volatilityTimeDiscretization.getTimeIndexNearestLessOrEqual(time);
        return this.volatility[volatilityTimeIndex];
    }

    public RandomVariable getVolatility(double time) {
        if (time <= 0.0) {
            return new Scalar(0.0);
        }
        int timeIndex = this.volatilityTimeDiscretization.getTimeIndexNearestLessOrEqual(time);
        return this.volatility[timeIndex];
    }

    @Override
    public RandomVariable getMeanReversion(int timeIndex) {
        double time = this.timeDiscretization.getTime(timeIndex);
        int meanReversionTimeIndex = this.volatilityTimeDiscretization.getTimeIndexNearestLessOrEqual(time);
        return this.meanReversion[meanReversionTimeIndex];
    }

    @Override
    public RandomVariable[] getParameter() {
        int volatilityParameterLength = this.isVolatilityCalibrateable ? this.volatility.length : 0;
        int parameterLength = volatilityParameterLength + (this.isMeanReversionCalibrateable ? this.meanReversion.length : 0);
        if (parameterLength == 0) {
            return null;
        }
        RandomVariable[] parameter = new RandomVariable[parameterLength];
        if (this.isVolatilityCalibrateable) {
            System.arraycopy(this.volatility, 0, parameter, 0, this.volatility.length);
        }
        if (this.isMeanReversionCalibrateable) {
            System.arraycopy(this.meanReversion, 0, parameter, volatilityParameterLength, this.meanReversion.length);
        }
        return parameter;
    }

    @Override
    public Object clone() {
        return new ShortRateVolatilityModelPiecewiseConstant(this.randomVariableFactory, super.getTimeDiscretization(), this.volatilityTimeDiscretization, this.volatility, this.meanReversion, this.isVolatilityCalibrateable);
    }

    @Override
    public AbstractShortRateVolatilityModelParametric getCloneWithModifiedParameters(RandomVariable[] parameters) {
        return new ShortRateVolatilityModelPiecewiseConstant(this.randomVariableFactory, super.getTimeDiscretization(), this.volatilityTimeDiscretization, parameters, this.meanReversion, this.isVolatilityCalibrateable);
    }

    @Override
    public AbstractShortRateVolatilityModelParametric getCloneWithModifiedParameters(double[] parameters) {
        RandomVariable[] newVolatility = this.volatility;
        RandomVariable[] newMeanReversion = this.meanReversion;
        if (this.isVolatilityCalibrateable && !this.isMeanReversionCalibrateable) {
            newVolatility = this.randomVariableFactory.createRandomVariableArray(parameters);
        } else if (!this.isVolatilityCalibrateable && this.isMeanReversionCalibrateable) {
            newMeanReversion = this.randomVariableFactory.createRandomVariableArray(parameters);
        } else if (this.isVolatilityCalibrateable && this.isMeanReversionCalibrateable) {
            double[] newVolatilityParameters = new double[this.volatility.length];
            double[] newMeanReversionParameters = new double[this.meanReversion.length];
            System.arraycopy(parameters, 0, newVolatilityParameters, 0, newVolatilityParameters.length);
            System.arraycopy(parameters, newVolatilityParameters.length, newMeanReversionParameters, 0, newMeanReversionParameters.length);
            newVolatility = this.randomVariableFactory.createRandomVariableArray(newVolatilityParameters);
            newMeanReversion = this.randomVariableFactory.createRandomVariableArray(newMeanReversionParameters);
        } else {
            return this;
        }
        return new ShortRateVolatilityModelPiecewiseConstant(this.randomVariableFactory, super.getTimeDiscretization(), this.volatilityTimeDiscretization, newVolatility, newMeanReversion, this.isVolatilityCalibrateable);
    }

    public TimeDiscretization getVolatilityTimeDiscretization() {
        return this.volatilityTimeDiscretization;
    }
}

