/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.models.covariance;

import net.finmath.montecarlo.interestrate.TermStructureModel;
import net.finmath.montecarlo.interestrate.models.LIBORMarketModelWithTenorRefinement;
import net.finmath.montecarlo.interestrate.models.covariance.AbstractLIBORCovarianceModelParametric;
import net.finmath.montecarlo.interestrate.models.covariance.TermStructureFactorLoadingsModel;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.TimeDiscretization;

public class TermStructCovarianceModelFromLIBORCovarianceModel
implements TermStructureFactorLoadingsModel {
    private final AbstractLIBORCovarianceModelParametric covarianceModel;

    public TermStructCovarianceModelFromLIBORCovarianceModel(AbstractLIBORCovarianceModelParametric covarianceModel) {
        this.covarianceModel = covarianceModel;
    }

    @Override
    public RandomVariable[] getFactorLoading(double time, double periodStart, double periodEnd, TimeDiscretization periodDiscretization, RandomVariable[] realizationAtTimeIndex, TermStructureModel model) {
        TimeDiscretization liborPeriodDiscretization = this.covarianceModel.getLiborPeriodDiscretization();
        RandomVariable[] liborAtTimeIndex = new RandomVariable[liborPeriodDiscretization.getNumberOfTimeSteps()];
        for (int componentIndex = 0; componentIndex < liborPeriodDiscretization.getNumberOfTimeSteps(); ++componentIndex) {
            liborAtTimeIndex[componentIndex] = liborPeriodDiscretization.getTime(componentIndex) < time ? null : ((LIBORMarketModelWithTenorRefinement)model).getLIBORForStateVariable(periodDiscretization, realizationAtTimeIndex, liborPeriodDiscretization.getTime(componentIndex), liborPeriodDiscretization.getTime(componentIndex + 1));
        }
        int periodStartIndex = liborPeriodDiscretization.getTimeIndex(periodStart);
        int periodEndIndex = liborPeriodDiscretization.getTimeIndex(periodEnd);
        RandomVariable[] factorLoadings = this.covarianceModel.getFactorLoading(time, periodStartIndex, liborAtTimeIndex);
        if (periodEndIndex > periodStartIndex + 1) {
            int factorIndex;
            for (factorIndex = 0; factorIndex < factorLoadings.length; ++factorIndex) {
                factorLoadings[factorIndex] = factorLoadings[factorIndex].mult(liborPeriodDiscretization.getTimeStep(periodStartIndex));
            }
            for (int periodIndex = periodStartIndex + 1; periodIndex < periodEndIndex; ++periodIndex) {
                RandomVariable[] factorLoadingsForPeriod = this.covarianceModel.getFactorLoading(time, periodStartIndex, liborAtTimeIndex);
                double periodLength = liborPeriodDiscretization.getTimeStep(periodIndex);
                for (int factorIndex2 = 0; factorIndex2 < factorLoadings.length; ++factorIndex2) {
                    factorLoadings[factorIndex2] = factorLoadings[factorIndex2].addProduct(factorLoadingsForPeriod[factorIndex2], periodLength);
                }
            }
            for (factorIndex = 0; factorIndex < factorLoadings.length; ++factorIndex) {
                factorLoadings[factorIndex] = factorLoadings[factorIndex].div(periodEnd - periodStart);
            }
        }
        return factorLoadings;
    }

    @Override
    public int getNumberOfFactors() {
        return this.covarianceModel.getNumberOfFactors();
    }
}

