/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.models.covariance;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.BrownianMotion;
import net.finmath.montecarlo.interestrate.CalibrationProduct;
import net.finmath.montecarlo.interestrate.TermStructureModel;
import net.finmath.montecarlo.interestrate.TermStructureMonteCarloSimulationFromTermStructureModel;
import net.finmath.montecarlo.interestrate.models.covariance.TermStructureCovarianceModel;
import net.finmath.montecarlo.interestrate.models.covariance.TermStructureFactorLoadingsModelParametric;
import net.finmath.montecarlo.interestrate.models.covariance.TermStructureTenorTimeScaling;
import net.finmath.montecarlo.model.ProcessModel;
import net.finmath.montecarlo.process.EulerSchemeFromProcessModel;
import net.finmath.optimizer.Optimizer;
import net.finmath.optimizer.OptimizerFactory;
import net.finmath.optimizer.OptimizerFactoryLevenbergMarquardt;
import net.finmath.optimizer.SolverException;

public abstract class TermStructureCovarianceModelParametric
implements TermStructureCovarianceModel,
TermStructureTenorTimeScaling,
TermStructureFactorLoadingsModelParametric {
    private static final Logger logger = Logger.getLogger("net.finmath");

    @Override
    public abstract double[] getParameter();

    @Override
    public abstract TermStructureCovarianceModelParametric clone();

    @Override
    public abstract TermStructureCovarianceModelParametric getCloneWithModifiedParameters(double[] var1);

    public TermStructureCovarianceModelParametric getCloneCalibrated(final TermStructureModel calibrationModel, final CalibrationProduct[] calibrationProducts, Map<String, Object> calibrationParameters) throws CalculationException {
        if (calibrationParameters == null) {
            calibrationParameters = new HashMap<String, Object>();
        }
        Integer numberOfPathsParameter = (Integer)calibrationParameters.get("numberOfPaths");
        Integer seedParameter = (Integer)calibrationParameters.get("seed");
        Integer maxIterationsParameter = (Integer)calibrationParameters.get("maxIterations");
        Double parameterStepParameter = (Double)calibrationParameters.get("parameterStep");
        Double accuracyParameter = (Double)calibrationParameters.get("accuracy");
        BrownianMotion brownianMotionParameter = (BrownianMotion)calibrationParameters.get("brownianMotion");
        if (brownianMotionParameter == null) {
            throw new IllegalArgumentException("Calibration requires a Brownian motion to be specified under the key 'brownianMotion'.");
        }
        double[] initialParameters = this.getParameter();
        double[] lowerBound = new double[initialParameters.length];
        double[] upperBound = new double[initialParameters.length];
        double[] parameterStep = new double[initialParameters.length];
        double[] zero = new double[calibrationProducts.length];
        Arrays.fill(lowerBound, 0.0);
        Arrays.fill(upperBound, Double.POSITIVE_INFINITY);
        Arrays.fill(parameterStep, parameterStepParameter != null ? parameterStepParameter : 1.0E-4);
        Arrays.fill(zero, 0.0);
        int numberOfThreads = 2;
        OptimizerFactory optimizerFactoryParameter = (OptimizerFactory)calibrationParameters.get("optimizerFactory");
        int numberOfPaths = numberOfPathsParameter != null ? numberOfPathsParameter : 2000;
        int seed = seedParameter != null ? seedParameter : 31415;
        int maxIterations = maxIterationsParameter != null ? maxIterationsParameter : 400;
        double accuracy = accuracyParameter != null ? accuracyParameter : 1.0E-7;
        final BrownianMotion brownianMotion = brownianMotionParameter;
        OptimizerFactory optimizerFactory = optimizerFactoryParameter != null ? optimizerFactoryParameter : new OptimizerFactoryLevenbergMarquardt(maxIterations, accuracy, 2);
        int numberOfThreadsForProductValuation = 2 * Math.max(2, Runtime.getRuntime().availableProcessors());
        final ExecutorService executor = null;
        Optimizer.ObjectiveFunction calibrationError = new Optimizer.ObjectiveFunction(){

            @Override
            public void setValues(double[] parameters, double[] values) throws SolverException {
                int calibrationProductIndex;
                ProcessModel model;
                TermStructureCovarianceModelParametric calibrationCovarianceModel = TermStructureCovarianceModelParametric.this.getCloneWithModifiedParameters(parameters);
                HashMap<String, TermStructureCovarianceModelParametric> data = new HashMap<String, TermStructureCovarianceModelParametric>();
                data.put("covarianceModel", calibrationCovarianceModel);
                try {
                    model = calibrationModel.getCloneWithModifiedData(data);
                }
                catch (CalculationException e) {
                    throw new SolverException(e);
                }
                EulerSchemeFromProcessModel process = new EulerSchemeFromProcessModel(model, brownianMotion);
                final TermStructureMonteCarloSimulationFromTermStructureModel lIBORMonteCarloSimulationFromTermStructureModel = new TermStructureMonteCarloSimulationFromTermStructureModel((TermStructureModel)model, process);
                ArrayList<Future<Double>> valueFutures = new ArrayList<Future<Double>>(calibrationProducts.length);
                for (calibrationProductIndex = 0; calibrationProductIndex < calibrationProducts.length; ++calibrationProductIndex) {
                    final int workerCalibrationProductIndex = calibrationProductIndex;
                    Callable<Double> worker = new Callable<Double>(){

                        @Override
                        public Double call() {
                            try {
                                return calibrationProducts[workerCalibrationProductIndex].getProduct().getValue(0.0, lIBORMonteCarloSimulationFromTermStructureModel).sub(calibrationProducts[workerCalibrationProductIndex].getTargetValue()).mult(calibrationProducts[workerCalibrationProductIndex].getWeight()).getAverage();
                            }
                            catch (Exception e) {
                                return 0.0;
                            }
                        }
                    };
                    if (executor != null) {
                        Future<Double> valueFuture = executor.submit(worker);
                        valueFutures.add(calibrationProductIndex, valueFuture);
                        continue;
                    }
                    FutureTask<Double> valueFutureTask = new FutureTask<Double>(worker);
                    valueFutureTask.run();
                    valueFutures.add(calibrationProductIndex, valueFutureTask);
                }
                for (calibrationProductIndex = 0; calibrationProductIndex < calibrationProducts.length; ++calibrationProductIndex) {
                    try {
                        double value;
                        values[calibrationProductIndex] = value = ((Double)((Future)valueFutures.get(calibrationProductIndex)).get()).doubleValue();
                        continue;
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new SolverException(e);
                    }
                }
                double error = 0.0;
                for (int valueIndex = 0; valueIndex < values.length; ++valueIndex) {
                    double deviation = values[valueIndex];
                    error += deviation * deviation;
                }
                System.out.println(Math.sqrt(error / (double)values.length));
            }
        };
        Optimizer optimizer = optimizerFactory.getOptimizer(calibrationError, initialParameters, lowerBound, upperBound, parameterStep, zero);
        try {
            optimizer.run();
        }
        catch (SolverException e) {
            throw new CalculationException(e);
        }
        finally {
            if (executor != null) {
                executor.shutdown();
            }
        }
        double[] bestParameters = optimizer.getBestFitParameters();
        TermStructureCovarianceModelParametric calibrationCovarianceModel = this.getCloneWithModifiedParameters(bestParameters);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("The solver required " + optimizer.getIterations() + " iterations. The best fit parameters are:");
            Object logString = "Best parameters:";
            for (int i = 0; i < bestParameters.length; ++i) {
                logString = (String)logString + "\tparameter[" + i + "]: " + bestParameters[i];
            }
            logger.fine((String)logString);
        }
        return calibrationCovarianceModel;
    }
}

