/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import java.util.HashMap;
import java.util.Map;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.AbstractMonteCarloProduct;
import net.finmath.montecarlo.MonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.TermStructureMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.products.TermStructureMonteCarloProduct;
import net.finmath.montecarlo.process.component.factortransform.FactorTransform;
import net.finmath.stochastic.RandomVariable;

public abstract class AbstractLIBORMonteCarloProduct
extends AbstractMonteCarloProduct
implements TermStructureMonteCarloProduct {
    public AbstractLIBORMonteCarloProduct(String currency) {
        super(currency);
    }

    public AbstractLIBORMonteCarloProduct() {
        super(null);
    }

    @Override
    public abstract RandomVariable getValue(double var1, TermStructureMonteCarloSimulationModel var3) throws CalculationException;

    public RandomVariable getValueForModifiedData(double evaluationTime, MonteCarloSimulationModel monteCarloSimulationModel, Map<String, Object> dataModified) throws CalculationException {
        return this.getValue(evaluationTime, monteCarloSimulationModel.getCloneWithModifiedData(dataModified));
    }

    @Override
    public Map<String, Object> getValues(double evaluationTime, TermStructureMonteCarloSimulationModel model) throws CalculationException {
        RandomVariable value = this.getValue(evaluationTime, model);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("value", value.getAverage());
        result.put("error", value.getStandardError());
        return result;
    }

    @Override
    public RandomVariable getValue(double evaluationTime, MonteCarloSimulationModel model) throws CalculationException {
        if (model == null || model instanceof LIBORModelMonteCarloSimulationModel) {
            return this.getValue(evaluationTime, (LIBORModelMonteCarloSimulationModel)model);
        }
        throw new IllegalArgumentException("The product " + this.getClass() + " cannot be valued against a model " + model.getClass() + ".It requires a model of type " + LIBORModelMonteCarloSimulationModel.class + ".");
    }

    @Override
    public FactorTransform getFactorDrift(LIBORModelMonteCarloSimulationModel referenceScheme, LIBORModelMonteCarloSimulationModel targetScheme) {
        throw new UnsupportedOperationException("Method not implemented.");
    }
}

