/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.MonteCarloSimulationModel;
import net.finmath.montecarlo.RandomVariableFromDoubleArray;
import net.finmath.montecarlo.conditionalexpectation.MonteCarloConditionalExpectationRegression;
import net.finmath.montecarlo.conditionalexpectation.RegressionBasisFunctionsProvider;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.TermStructureMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.montecarlo.interestrate.products.SimpleSwap;
import net.finmath.stochastic.ConditionalExpectationEstimator;
import net.finmath.stochastic.RandomVariable;
import net.finmath.stochastic.Scalar;

public class BermudanSwaption
extends AbstractLIBORMonteCarloProduct
implements RegressionBasisFunctionsProvider {
    private final boolean[] isPeriodStartDateExerciseDate;
    private final double[] fixingDates;
    private final double[] periodLengths;
    private final double[] paymentDates;
    private final double[] periodNotionals;
    private final double[] swaprates;
    private final boolean isCallable;
    private final RegressionBasisFunctionsProvider regressionBasisFunctionsProvider;

    public BermudanSwaption(boolean[] isPeriodStartDateExerciseDate, double[] fixingDates, double[] periodLength, double[] paymentDates, double[] periodNotionals, double[] swaprates, boolean isCallable, RegressionBasisFunctionsProvider regressionBasisFunctionsProvider) {
        this.isPeriodStartDateExerciseDate = isPeriodStartDateExerciseDate;
        this.fixingDates = fixingDates;
        this.periodLengths = periodLength;
        this.paymentDates = paymentDates;
        this.periodNotionals = periodNotionals;
        this.swaprates = swaprates;
        this.isCallable = isCallable;
        this.regressionBasisFunctionsProvider = regressionBasisFunctionsProvider;
    }

    public BermudanSwaption(boolean[] isPeriodStartDateExerciseDate, double[] fixingDates, double[] periodLength, double[] paymentDates, double[] periodNotionals, double[] swaprates, boolean isCallable) {
        this(isPeriodStartDateExerciseDate, fixingDates, periodLength, paymentDates, periodNotionals, swaprates, isCallable, null);
    }

    public BermudanSwaption(boolean[] isPeriodStartDateExerciseDate, double[] fixingDates, double[] periodLength, double[] paymentDates, double[] periodNotionals, double[] swaprates) {
        this(isPeriodStartDateExerciseDate, fixingDates, periodLength, paymentDates, periodNotionals, swaprates, true);
    }

    @Override
    public Map<String, Object> getValues(double evaluationTime, TermStructureMonteCarloSimulationModel model) throws CalculationException {
        RandomVariable values = model.getRandomVariableForConstant(0.0);
        RandomVariable valuesUnderlying = model.getRandomVariableForConstant(0.0);
        RandomVariable exerciseTime = model.getRandomVariableForConstant(Double.POSITIVE_INFINITY);
        for (int period = this.fixingDates.length - 1; period >= 0; --period) {
            double fixingDate;
            double exerciseDate = fixingDate = this.fixingDates[period];
            double periodLength = this.periodLengths[period];
            double paymentDate = this.paymentDates[period];
            double notional = this.periodNotionals[period];
            double swaprate = this.swaprates[period];
            RandomVariable libor = model.getForwardRate(fixingDate, fixingDate, fixingDate + periodLength);
            RandomVariable payoff = libor.sub(swaprate).mult(periodLength).mult(notional);
            RandomVariable numeraire = model.getNumeraire(paymentDate);
            RandomVariable monteCarloProbabilities = model.getMonteCarloWeights(paymentDate);
            payoff = payoff.div(numeraire).mult(monteCarloProbabilities);
            if (this.isCallable) {
                valuesUnderlying = valuesUnderlying.add(payoff);
            } else {
                values = values.add(payoff);
            }
            if (!this.isPeriodStartDateExerciseDate[period]) continue;
            RandomVariable triggerValuesDiscounted = values.sub(valuesUnderlying);
            ConditionalExpectationEstimator conditionalExpectationOperator = this.getConditionalExpectationEstimator(fixingDate, model);
            RandomVariable triggerValues = triggerValuesDiscounted.getConditionalExpectation(conditionalExpectationOperator);
            values = triggerValues.choose(values, valuesUnderlying);
            exerciseTime = triggerValues.choose(exerciseTime, new Scalar(exerciseDate));
        }
        RandomVariable numeraireAtZero = model.getNumeraire(evaluationTime);
        RandomVariable monteCarloProbabilitiesAtZero = model.getMonteCarloWeights(evaluationTime);
        values = values.mult(numeraireAtZero).div(monteCarloProbabilitiesAtZero);
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put("value", values);
        results.put("error", values.getStandardError());
        results.put("exerciseTime", exerciseTime);
        return results;
    }

    @Override
    public RandomVariable getValue(double evaluationTime, TermStructureMonteCarloSimulationModel model) throws CalculationException {
        return (RandomVariable)this.getValues(evaluationTime, model).get("value");
    }

    public ConditionalExpectationEstimator getConditionalExpectationEstimator(double fixingDate, TermStructureMonteCarloSimulationModel model) throws CalculationException {
        RandomVariable[] regressionBasisFunctions = this.regressionBasisFunctionsProvider != null ? this.regressionBasisFunctionsProvider.getBasisFunctions(fixingDate, model) : this.getBasisFunctions(fixingDate, model);
        MonteCarloConditionalExpectationRegression condExpEstimator = new MonteCarloConditionalExpectationRegression(regressionBasisFunctions);
        return condExpEstimator;
    }

    @Override
    public RandomVariable[] getBasisFunctions(double fixingDate, MonteCarloSimulationModel model) throws CalculationException {
        if (model instanceof LIBORModelMonteCarloSimulationModel) {
            return this.getBasisFunctions(fixingDate, (LIBORModelMonteCarloSimulationModel)model);
        }
        throw new IllegalArgumentException("Requires model to implement LIBORModelMonteCarloSimulationModel.");
    }

    public RandomVariable[] getBasisFunctions(double fixingDate, LIBORModelMonteCarloSimulationModel model) throws CalculationException {
        ArrayList<RandomVariable> basisFunctions = new ArrayList<RandomVariable>();
        RandomVariableFromDoubleArray basisFunction = new RandomVariableFromDoubleArray(1.0);
        basisFunctions.add(basisFunction);
        int fixingDateIndex = Arrays.binarySearch(this.fixingDates, fixingDate);
        if (fixingDateIndex < 0) {
            fixingDateIndex = -fixingDateIndex;
        }
        if (fixingDateIndex >= this.fixingDates.length) {
            fixingDateIndex = this.fixingDates.length - 1;
        }
        RandomVariable rateShort = model.getForwardRate(fixingDate, fixingDate, this.paymentDates[fixingDateIndex]);
        RandomVariable discountShort = rateShort.mult(this.paymentDates[fixingDateIndex] - fixingDate).add(1.0).invert();
        basisFunctions.add(discountShort);
        basisFunctions.add(discountShort.pow(2.0));
        RandomVariable rateLong = model.getForwardRate(fixingDate, this.fixingDates[fixingDateIndex], this.paymentDates[this.paymentDates.length - 1]);
        RandomVariable discountLong = rateLong.mult(this.paymentDates[this.paymentDates.length - 1] - this.fixingDates[fixingDateIndex]).add(1.0).invert();
        basisFunctions.add(discountLong);
        basisFunctions.add(discountLong.pow(2.0));
        RandomVariable numeraire = model.getNumeraire(fixingDate).invert();
        basisFunctions.add(numeraire);
        return basisFunctions.toArray(new RandomVariable[basisFunctions.size()]);
    }

    public double[] getExerciseTimes() {
        ArrayList<Double> exerciseTimes = new ArrayList<Double>();
        for (int i = 0; i < this.isPeriodStartDateExerciseDate.length; ++i) {
            if (!this.isPeriodStartDateExerciseDate[i]) continue;
            exerciseTimes.add(this.fixingDates[i]);
        }
        double[] times = new double[exerciseTimes.size()];
        for (int i = 0; i < times.length; ++i) {
            times[i] = (Double)exerciseTimes.get(i);
        }
        return times;
    }

    public double[] getFixingDates(double evaluationTime) {
        ArrayList<Double> remainingFixingTimes = new ArrayList<Double>();
        for (int i = 0; i < this.fixingDates.length; ++i) {
            if (!(this.fixingDates[i] >= evaluationTime)) continue;
            remainingFixingTimes.add(this.fixingDates[i]);
        }
        double[] times = new double[remainingFixingTimes.size()];
        for (int i = 0; i < times.length; ++i) {
            times[i] = (Double)remainingFixingTimes.get(i);
        }
        return times;
    }

    public SimpleSwap getSwap() {
        return new SimpleSwap(this.fixingDates, this.paymentDates, this.swaprates, true, this.periodNotionals);
    }

    public double[] getPaymentDates() {
        return this.paymentDates;
    }

    public double[] getPeriodNotionals() {
        return this.periodNotionals;
    }

    public double[] getSwapRates() {
        return this.swaprates;
    }

    public double[] getPeriodLengths() {
        return this.periodLengths;
    }

    public double getFinalMaturity() {
        return this.paymentDates[this.paymentDates.length - 1];
    }

    public boolean getIsCallable() {
        return this.isCallable;
    }
}

