/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import java.time.LocalDateTime;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.TermStructureMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.FloatingpointDate;

public class Bond
extends AbstractLIBORMonteCarloProduct {
    private LocalDateTime referenceDate;
    private double maturity;

    public Bond(LocalDateTime referenceDate, double maturity) {
        this.referenceDate = referenceDate;
        this.maturity = maturity;
    }

    public Bond(double maturity) {
        this.maturity = maturity;
    }

    @Override
    public RandomVariable getValue(double evaluationTime, TermStructureMonteCarloSimulationModel model) throws CalculationException {
        double productToModelTimeOffset = 0.0;
        try {
            if (this.referenceDate != null) {
                productToModelTimeOffset = FloatingpointDate.getFloatingPointDateFromDate(model.getReferenceDate(), this.referenceDate);
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        RandomVariable numeraire = model.getNumeraire(productToModelTimeOffset + this.maturity);
        RandomVariable monteCarloProbabilities = model.getMonteCarloWeights(productToModelTimeOffset + this.maturity);
        RandomVariable values = model.getRandomVariableForConstant(1.0);
        values = values.div(numeraire).mult(monteCarloProbabilities);
        RandomVariable numeraireAtEvaluationTime = model.getNumeraire(evaluationTime);
        RandomVariable monteCarloProbabilitiesAtEvaluationTime = model.getMonteCarloWeights(evaluationTime);
        values = values.mult(numeraireAtEvaluationTime).div(monteCarloProbabilitiesAtEvaluationTime);
        return values;
    }

    public double getMaturity() {
        return this.maturity;
    }

    public void setMaturity(double maturity) {
        this.maturity = maturity;
    }

    @Override
    public String toString() {
        return super.toString() + "\nmaturity: " + this.maturity;
    }
}

