/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import java.util.ArrayList;
import java.util.Arrays;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.RandomVariableFromDoubleArray;
import net.finmath.montecarlo.conditionalexpectation.MonteCarloConditionalExpectationRegression;
import net.finmath.montecarlo.interestrate.TermStructureMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.stochastic.ConditionalExpectationEstimator;
import net.finmath.stochastic.RandomVariable;
import net.finmath.stochastic.Scalar;

public class CancelableSwap
extends AbstractLIBORMonteCarloProduct {
    private final boolean[] isPeriodStartDateExerciseDate;
    private final double[] fixingDates;
    private final double[] periodLengths;
    private final double[] paymentDates;
    private final double[] periodNotionals;
    private final double[] swaprates;

    public CancelableSwap(boolean[] isPeriodStartDateExerciseDate, double[] fixingDates, double[] periodLength, double[] paymentDates, double[] periodNotionals, double[] swaprates) {
        this.isPeriodStartDateExerciseDate = isPeriodStartDateExerciseDate;
        this.fixingDates = fixingDates;
        this.periodLengths = periodLength;
        this.paymentDates = paymentDates;
        this.periodNotionals = periodNotionals;
        this.swaprates = swaprates;
    }

    @Override
    public RandomVariable getValue(double evaluationTime, TermStructureMonteCarloSimulationModel model) throws CalculationException {
        RandomVariable values = new RandomVariableFromDoubleArray(this.fixingDates[this.fixingDates.length - 1], 0.0);
        for (int period = this.fixingDates.length - 1; period >= 0; --period) {
            double fixingDate = this.fixingDates[period];
            double periodLength = this.periodLengths[period];
            double paymentDate = this.paymentDates[period];
            double notional = this.periodNotionals[period];
            double swaprate = this.swaprates[period];
            RandomVariable libor = model.getForwardRate(fixingDate, fixingDate, fixingDate + periodLength);
            RandomVariable numeraire = model.getNumeraire(paymentDate);
            RandomVariable monteCarloProbabilities = model.getMonteCarloWeights(paymentDate);
            RandomVariable payoff = libor.sub(swaprate).mult(periodLength).mult(notional);
            payoff = payoff.div(numeraire).mult(monteCarloProbabilities);
            values = values.add(payoff);
            if (!this.isPeriodStartDateExerciseDate[period]) continue;
            ConditionalExpectationEstimator condExpEstimator = this.getConditionalExpectationEstimator(period, model);
            RandomVariable valueIfExcercised = condExpEstimator.getConditionalExpectation(values);
            values = valueIfExcercised.choose(values, new Scalar(0.0));
        }
        RandomVariable numeraireAtZero = model.getNumeraire(evaluationTime);
        RandomVariable monteCarloProbabilitiesAtZero = model.getMonteCarloWeights(evaluationTime);
        values = values.mult(numeraireAtZero).div(monteCarloProbabilitiesAtZero);
        return values;
    }

    private ConditionalExpectationEstimator getConditionalExpectationEstimator(int fixingDateIndex, TermStructureMonteCarloSimulationModel model) throws CalculationException {
        MonteCarloConditionalExpectationRegression condExpEstimator = new MonteCarloConditionalExpectationRegression(this.getRegressionBasisFunctions(this.fixingDates[fixingDateIndex], model));
        return condExpEstimator;
    }

    private RandomVariable[] getRegressionBasisFunctions(double fixingDate, TermStructureMonteCarloSimulationModel model) throws CalculationException {
        ArrayList<RandomVariable> basisFunctions = new ArrayList<RandomVariable>();
        RandomVariableFromDoubleArray basisFunction = new RandomVariableFromDoubleArray(1.0);
        basisFunctions.add(basisFunction);
        int fixingDateIndex = Arrays.binarySearch(this.fixingDates, fixingDate);
        if (fixingDateIndex < 0) {
            fixingDateIndex = -fixingDateIndex;
        }
        if (fixingDateIndex >= this.fixingDates.length) {
            fixingDateIndex = this.fixingDates.length - 1;
        }
        RandomVariable rateShort = model.getForwardRate(fixingDate, fixingDate, this.paymentDates[fixingDateIndex + 1]);
        RandomVariable bondShort = rateShort.mult(this.paymentDates[fixingDateIndex + 1] - fixingDate).add(1.0).invert();
        basisFunctions.add(bondShort);
        basisFunctions.add(bondShort.pow(2.0));
        basisFunctions.add(bondShort.pow(3.0));
        RandomVariable rateLong = model.getForwardRate(fixingDate, this.fixingDates[fixingDateIndex], this.paymentDates[this.paymentDates.length - 1]);
        RandomVariable bondLong = rateLong.mult(this.paymentDates[this.paymentDates.length - 1] - this.fixingDates[fixingDateIndex]).add(1.0).invert();
        basisFunctions.add(bondLong);
        basisFunctions.add(bondLong.pow(2.0));
        basisFunctions.add(bondLong.pow(3.0));
        RandomVariable numeraire = model.getNumeraire(fixingDate);
        basisFunctions.add(numeraire);
        basisFunctions.add(numeraire.pow(2.0));
        basisFunctions.add(numeraire.pow(3.0));
        basisFunctions.add(rateLong.mult(numeraire));
        return basisFunctions.toArray(new RandomVariable[basisFunctions.size()]);
    }
}

