/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import net.finmath.montecarlo.RandomVariableFromDoubleArray;
import net.finmath.montecarlo.interestrate.LIBORMarketModel;
import net.finmath.montecarlo.interestrate.TermStructureModel;
import net.finmath.montecarlo.interestrate.TermStructureMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.models.covariance.LIBORCovarianceModel;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.stochastic.RandomVariable;

public class ForwardRateVolatilitySurfaceCurvature
extends AbstractLIBORMonteCarloProduct {
    private double tolerance = 0.0;

    public ForwardRateVolatilitySurfaceCurvature() {
    }

    public ForwardRateVolatilitySurfaceCurvature(double tolerance) {
        this.tolerance = tolerance;
    }

    @Override
    public RandomVariable getValue(double evaluationTime, TermStructureMonteCarloSimulationModel model) {
        TermStructureModel modelBase = model.getModel();
        if (modelBase instanceof LIBORMarketModel) {
            return this.getValues(evaluationTime, (LIBORMarketModel)modelBase);
        }
        throw new IllegalArgumentException("This product requires a simulation where the underlying model is of type LIBORMarketModel.");
    }

    public RandomVariable getValues(double evaluationTime, LIBORMarketModel model) {
        if (evaluationTime > 0.0) {
            throw new RuntimeException("Forward start evaluation currently not supported.");
        }
        LIBORCovarianceModel covarianceModel = model.getCovarianceModel();
        int numberOfComponents = covarianceModel.getLiborPeriodDiscretization().getNumberOfTimeSteps();
        RandomVariable integratedLIBORCurvature = new RandomVariableFromDoubleArray(0.0);
        for (int componentIndex = 0; componentIndex < numberOfComponents; ++componentIndex) {
            double timeEnd = covarianceModel.getLiborPeriodDiscretization().getTime(componentIndex);
            int timeEndIndex = covarianceModel.getTimeDiscretization().getTimeIndex(timeEnd);
            if (timeEndIndex < 0) {
                timeEndIndex = -timeEndIndex - 2;
            }
            RandomVariable integratedLIBORCurvatureCurrentRate = new RandomVariableFromDoubleArray(0.0);
            for (int timeIndex = 0; timeIndex < timeEndIndex - 2; ++timeIndex) {
                double timeStep1 = covarianceModel.getTimeDiscretization().getTimeStep(timeIndex);
                double timeStep2 = covarianceModel.getTimeDiscretization().getTimeStep(timeIndex + 1);
                RandomVariable covarianceLeft = covarianceModel.getCovariance(timeIndex + 0, componentIndex, componentIndex, (RandomVariable[])null);
                RandomVariable covarianceCenter = covarianceModel.getCovariance(timeIndex + 1, componentIndex, componentIndex, (RandomVariable[])null);
                RandomVariable covarianceRight = covarianceModel.getCovariance(timeIndex + 2, componentIndex, componentIndex, (RandomVariable[])null);
                RandomVariable curvatureSquared = covarianceRight.sub(covarianceCenter.mult(2.0)).add(covarianceLeft);
                curvatureSquared = curvatureSquared.div(timeStep1 * timeStep2);
                curvatureSquared = curvatureSquared.squared();
                integratedLIBORCurvatureCurrentRate = integratedLIBORCurvatureCurrentRate.add(curvatureSquared.mult(timeStep1));
            }
            if (timeEnd == 0.0) continue;
            integratedLIBORCurvatureCurrentRate = integratedLIBORCurvatureCurrentRate.div(timeEnd);
            integratedLIBORCurvatureCurrentRate = integratedLIBORCurvatureCurrentRate.sqrt();
            integratedLIBORCurvature = integratedLIBORCurvature.add(integratedLIBORCurvatureCurrentRate);
        }
        integratedLIBORCurvature = integratedLIBORCurvature.div(numberOfComponents);
        return integratedLIBORCurvature.sub(this.tolerance).floor(0.0);
    }
}

