/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import java.util.Set;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.RandomVariableFromDoubleArray;
import net.finmath.montecarlo.interestrate.TermStructureMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.montecarlo.interestrate.products.TermStructureMonteCarloProduct;
import net.finmath.montecarlo.interestrate.products.components.AbstractProductComponent;
import net.finmath.stochastic.RandomVariable;

public class Portfolio
extends AbstractProductComponent {
    private static final long serialVersionUID = -1360506093081238482L;
    private final AbstractLIBORMonteCarloProduct[] products;
    private final double[] weights;

    public Portfolio(AbstractLIBORMonteCarloProduct product, double weight) {
        super(product.getCurrency());
        this.products = new AbstractLIBORMonteCarloProduct[]{product};
        this.weights = new double[]{weight};
    }

    public Portfolio(AbstractLIBORMonteCarloProduct[] products, double[] weights) {
        String currency = products[0].getCurrency();
        for (AbstractLIBORMonteCarloProduct product : products) {
            if (currency == null || currency.equals(product.getCurrency())) continue;
            throw new IllegalArgumentException("Product currencies do not match. Please use a constructor providing the currency of the result.");
        }
        this.products = products;
        this.weights = weights;
    }

    public Portfolio(String currency, AbstractLIBORMonteCarloProduct[] products, double[] weights) {
        super(currency);
        for (AbstractLIBORMonteCarloProduct product : products) {
            if (currency.equals(product.getCurrency())) continue;
            throw new IllegalArgumentException("Product currencies do not match. Currency conversion (via model FX) is not supported yet.");
        }
        this.products = products;
        this.weights = weights;
    }

    @Override
    public String getCurrency() {
        return this.products != null && this.products.length > 0 ? this.products[0].getCurrency() : null;
    }

    @Override
    public Set<String> queryUnderlyings() {
        Set<String> underlyingNames = null;
        for (AbstractLIBORMonteCarloProduct product : this.products) {
            if (!(product instanceof AbstractProductComponent)) {
                throw new IllegalArgumentException("Underlying cannot be queried for underlyings.");
            }
            Set<String> productUnderlyingNames = ((AbstractProductComponent)product).queryUnderlyings();
            if (productUnderlyingNames == null) continue;
            if (underlyingNames == null) {
                underlyingNames = productUnderlyingNames;
                continue;
            }
            underlyingNames.addAll(productUnderlyingNames);
        }
        return underlyingNames;
    }

    @Override
    public RandomVariable getValue(double evaluationTime, TermStructureMonteCarloSimulationModel model) throws CalculationException {
        RandomVariable values = new RandomVariableFromDoubleArray(0.0);
        for (int productIndex = 0; productIndex < this.products.length; ++productIndex) {
            RandomVariable valueOfProduct = this.products[productIndex].getValue(evaluationTime, model);
            double weightOfProduct = this.weights[productIndex];
            values = values.addProduct(valueOfProduct, weightOfProduct);
        }
        return values;
    }

    public TermStructureMonteCarloProduct[] getProducts() {
        return (TermStructureMonteCarloProduct[])this.products.clone();
    }

    public double[] getWeights() {
        return (double[])this.weights.clone();
    }
}

