/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.TermStructureMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.montecarlo.interestrate.products.components.AbstractProductComponent;
import net.finmath.montecarlo.interestrate.products.components.AccruingNotional;
import net.finmath.montecarlo.interestrate.products.components.Notional;
import net.finmath.montecarlo.interestrate.products.components.Period;
import net.finmath.montecarlo.interestrate.products.components.ProductCollection;
import net.finmath.montecarlo.interestrate.products.indices.AbstractIndex;
import net.finmath.montecarlo.interestrate.products.indices.FixedCoupon;
import net.finmath.montecarlo.interestrate.products.indices.LinearCombinationIndex;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.Schedule;

public class SwapLeg
extends AbstractLIBORMonteCarloProduct {
    private final ProductCollection components;

    public SwapLeg(Schedule legSchedule, Notional notional, AbstractIndex index, double spread, boolean couponFlow, boolean isNotionalExchanged, boolean isNotionalAccruing) {
        LocalDateTime referenceDate = legSchedule.getReferenceDate() != null ? legSchedule.getReferenceDate().atStartOfDay() : null;
        ArrayList<AbstractProductComponent> periods = new ArrayList<AbstractProductComponent>();
        for (int periodIndex = 0; periodIndex < legSchedule.getNumberOfPeriods(); ++periodIndex) {
            double fixingDate = legSchedule.getFixing(periodIndex);
            double paymentDate = legSchedule.getPayment(periodIndex);
            double periodLength = legSchedule.getPeriodLength(periodIndex);
            if (periodLength == 0.0) continue;
            AbstractIndex coupon = index != null ? (spread != 0.0 ? new LinearCombinationIndex(1.0, index, 1.0, new FixedCoupon(spread)) : index) : new FixedCoupon(spread);
            Period period = new Period(referenceDate, fixingDate, paymentDate, fixingDate, paymentDate, notional, coupon, periodLength, couponFlow, isNotionalExchanged, false, false);
            periods.add(period);
            if (!isNotionalAccruing) continue;
            notional = new AccruingNotional(notional, period);
        }
        this.components = new ProductCollection(periods);
    }

    public SwapLeg(Schedule legSchedule, Notional[] notionals, AbstractIndex index, double[] spreads, boolean couponFlow, boolean isNotionalExchanged) {
        if (legSchedule.getNumberOfPeriods() != notionals.length) {
            throw new IllegalArgumentException("Number of notionals (" + notionals.length + ") must match number of periods (" + legSchedule.getNumberOfPeriods() + ").");
        }
        ArrayList<AbstractProductComponent> periods = new ArrayList<AbstractProductComponent>();
        for (int periodIndex = 0; periodIndex < legSchedule.getNumberOfPeriods(); ++periodIndex) {
            LocalDateTime referenceDate = LocalDateTime.of(legSchedule.getReferenceDate(), LocalTime.of(0, 0));
            double periodStart = legSchedule.getPeriodStart(periodIndex);
            double periodEnd = legSchedule.getPeriodEnd(periodIndex);
            double fixingDate = legSchedule.getFixing(periodIndex);
            double paymentDate = legSchedule.getPayment(periodIndex);
            double periodLength = legSchedule.getPeriodLength(periodIndex);
            if (periodLength == 0.0) continue;
            AbstractIndex coupon = index != null ? (spreads[periodIndex] != 0.0 ? new LinearCombinationIndex(1.0, index, 1.0, new FixedCoupon(spreads[periodIndex])) : index) : new FixedCoupon(spreads[periodIndex]);
            Period period = new Period(referenceDate, periodStart, periodEnd, fixingDate, paymentDate, notionals[periodIndex], coupon, periodLength, couponFlow, isNotionalExchanged, false, false);
            periods.add(period);
        }
        this.components = new ProductCollection(periods);
    }

    public SwapLeg(Schedule legSchedule, Notional notional, AbstractIndex index, double spread, boolean isNotionalExchanged) {
        this(legSchedule, notional, index, spread, true, isNotionalExchanged, false);
    }

    @Override
    public RandomVariable getValue(double evaluationTime, TermStructureMonteCarloSimulationModel model) throws CalculationException {
        return this.components.getValue(evaluationTime, model);
    }
}

