/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import java.time.LocalDateTime;
import java.time.LocalTime;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.TermStructureMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.models.FundingCapacity;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.montecarlo.interestrate.products.indices.AbstractIndex;
import net.finmath.stochastic.RandomVariable;
import net.finmath.stochastic.Scalar;
import net.finmath.time.FloatingpointDate;
import net.finmath.time.Period;
import net.finmath.time.Schedule;

public class SwapLegWithFundingProvider
extends AbstractLIBORMonteCarloProduct {
    private final Schedule legSchedule;
    private final double[] notionals;
    private final AbstractIndex index;
    private final double[] spreads;
    private final FundingCapacity fundingCapacity;

    public SwapLegWithFundingProvider(Schedule legSchedule, double[] notionals, AbstractIndex index, double[] spreads, FundingCapacity fundingCapacity) {
        if (legSchedule.getNumberOfPeriods() != notionals.length) {
            throw new IllegalArgumentException("Number of notionals (" + notionals.length + ") must match number of periods (" + legSchedule.getNumberOfPeriods() + ").");
        }
        this.legSchedule = legSchedule;
        this.notionals = notionals;
        this.index = index;
        this.spreads = spreads;
        this.fundingCapacity = fundingCapacity;
    }

    @Override
    public RandomVariable getValue(double evaluationTime, TermStructureMonteCarloSimulationModel model) throws CalculationException {
        LocalDateTime referenceDate = LocalDateTime.of(this.legSchedule.getReferenceDate(), LocalTime.of(0, 0));
        double productToModelTimeOffset = 0.0;
        try {
            if (referenceDate != null && model.getReferenceDate() != null) {
                productToModelTimeOffset = FloatingpointDate.getFloatingPointDateFromDate(model.getReferenceDate(), referenceDate);
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        RandomVariable values = new Scalar(0.0);
        for (int periodIndex = 0; periodIndex < this.legSchedule.getNumberOfPeriods(); ++periodIndex) {
            Period period = this.legSchedule.getPeriod(periodIndex);
            double periodStart = this.legSchedule.getPeriodStart(periodIndex);
            double periodEnd = this.legSchedule.getPeriodEnd(periodIndex);
            double fixingDate = this.legSchedule.getFixing(periodIndex);
            double paymentDate = this.legSchedule.getPayment(periodIndex);
            double periodLength = this.legSchedule.getPeriodLength(periodIndex);
            if (periodLength == 0.0) continue;
            double notionalAtPeriodStart = this.notionals[periodIndex];
            RandomVariable numeraire = model.getNumeraire(productToModelTimeOffset + paymentDate);
            RandomVariable payoff = this.index.getValue(productToModelTimeOffset + fixingDate, model).add(this.spreads[periodIndex]).mult(periodLength);
            payoff = payoff.mult(notionalAtPeriodStart);
            RandomVariable survivalProbility = this.fundingCapacity.getDefaultFactors(productToModelTimeOffset + periodEnd, payoff).getSurvivalProbability();
            payoff = payoff.mult(survivalProbility);
            payoff = payoff.div(numeraire);
            values = values.add(payoff);
        }
        RandomVariable numeraireAtEval = model.getNumeraire(evaluationTime);
        values = values.mult(numeraireAtEval);
        return values;
    }
}

