/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import net.finmath.functions.AnalyticFormulas;
import net.finmath.marketdata.model.AnalyticModelFromCurvesAndVols;
import net.finmath.marketdata.model.curves.Curve;
import net.finmath.marketdata.model.curves.DiscountCurve;
import net.finmath.marketdata.model.curves.DiscountCurveFromForwardCurve;
import net.finmath.marketdata.model.curves.ForwardCurve;
import net.finmath.marketdata.products.Swap;
import net.finmath.marketdata.products.SwapAnnuity;
import net.finmath.modelling.products.Swaption;
import net.finmath.montecarlo.interestrate.LIBORMarketModel;
import net.finmath.montecarlo.interestrate.TermStructureModel;
import net.finmath.montecarlo.interestrate.TermStructureMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.stochastic.RandomVariable;
import net.finmath.stochastic.Scalar;
import net.finmath.time.TimeDiscretization;
import net.finmath.time.TimeDiscretizationFromArray;

public class SwaptionAnalyticApproximation
extends AbstractLIBORMonteCarloProduct
implements Swaption {
    private final double swaprate;
    private final double[] swapTenor;
    private final Swaption.ValueUnit valueUnit;
    private Map<String, double[]> cachedLogSwaprateDerivative;
    private WeakReference<TimeDiscretization> cachedLogSwaprateDerivativeTimeDiscretization;
    private WeakReference<DiscountCurve> cachedLogSwaprateDerivativeDiscountCurve;
    private WeakReference<ForwardCurve> cachedLogSwaprateDerivativeForwardCurve;
    private final Object cachedLogSwaprateDerivativeLock = new Object();

    public SwaptionAnalyticApproximation(double swaprate, TimeDiscretization swapTenor) {
        this(swaprate, swapTenor.getAsDoubleArray(), Swaption.ValueUnit.VALUE);
    }

    public SwaptionAnalyticApproximation(double swaprate, double[] swapTenor, Swaption.ValueUnit valueUnit) {
        this.swaprate = swaprate;
        this.swapTenor = swapTenor;
        this.valueUnit = valueUnit;
    }

    @Override
    public RandomVariable getValue(double evaluationTime, TermStructureMonteCarloSimulationModel model) {
        TermStructureModel modelBase = model.getModel();
        if (modelBase instanceof LIBORMarketModel) {
            return this.getValues(evaluationTime, model.getTimeDiscretization(), (LIBORMarketModel)modelBase);
        }
        throw new IllegalArgumentException("This product requires a simulation where the underlying model is of type LIBORMarketModel.");
    }

    public RandomVariable getValues(double evaluationTime, TimeDiscretization timeDiscretization, LIBORMarketModel model) {
        if (evaluationTime > 0.0) {
            throw new RuntimeException("Forward start evaluation currently not supported.");
        }
        double swapStart = this.swapTenor[0];
        double swapEnd = this.swapTenor[this.swapTenor.length - 1];
        int swapStartIndex = model.getLiborPeriodIndex(swapStart);
        int swapEndIndex = model.getLiborPeriodIndex(swapEnd);
        int optionMaturityIndex = model.getCovarianceModel().getTimeDiscretization().getTimeIndex(swapStart) - 1;
        Map<String, double[]> logSwaprateDerivative = this.getLogSwaprateDerivative(model.getLiborPeriodDiscretization(), model.getDiscountCurve(), model.getForwardRateCurve());
        double[] swapCovarianceWeights = logSwaprateDerivative.get("values");
        double[][] integratedLIBORCovariance = model.getIntegratedLIBORCovariance(timeDiscretization)[optionMaturityIndex];
        double integratedSwapRateVariance = 0.0;
        for (int componentIndex1 = swapStartIndex; componentIndex1 < swapEndIndex; ++componentIndex1) {
            for (int componentIndex2 = componentIndex1 + 1; componentIndex2 < swapEndIndex; ++componentIndex2) {
                integratedSwapRateVariance += 2.0 * swapCovarianceWeights[componentIndex1 - swapStartIndex] * swapCovarianceWeights[componentIndex2 - swapStartIndex] * integratedLIBORCovariance[componentIndex1][componentIndex2];
            }
            integratedSwapRateVariance += swapCovarianceWeights[componentIndex1 - swapStartIndex] * swapCovarianceWeights[componentIndex1 - swapStartIndex] * integratedLIBORCovariance[componentIndex1][componentIndex1];
        }
        if (this.valueUnit == Swaption.ValueUnit.INTEGRATEDVARIANCELOGNORMAL || this.valueUnit == Swaption.ValueUnit.INTEGRATEDVARIANCE) {
            return new Scalar(integratedSwapRateVariance);
        }
        double volatility = Math.sqrt(integratedSwapRateVariance / swapStart);
        if (this.valueUnit == Swaption.ValueUnit.VOLATILITYLOGNORMAL || this.valueUnit == Swaption.ValueUnit.VOLATILITY) {
            return new Scalar(volatility);
        }
        if (this.valueUnit == Swaption.ValueUnit.VALUE) {
            double parSwaprate = Swap.getForwardSwapRate(new TimeDiscretizationFromArray(this.swapTenor), new TimeDiscretizationFromArray(this.swapTenor), model.getForwardRateCurve(), model.getDiscountCurve());
            double swapAnnuity = SwapAnnuity.getSwapAnnuity((TimeDiscretization)new TimeDiscretizationFromArray(this.swapTenor), model.getDiscountCurve());
            double optionMaturity = swapStart;
            double valueSwaption = AnalyticFormulas.blackModelSwaptionValue(parSwaprate, volatility, optionMaturity, this.swaprate, swapAnnuity);
            return new Scalar(valueSwaption);
        }
        throw new IllegalArgumentException("Unknown valueUnit: " + this.valueUnit.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, double[]> getLogSwaprateDerivative(TimeDiscretization liborPeriodDiscretization, DiscountCurve discountCurve, ForwardCurve forwardCurve) {
        Object object = this.cachedLogSwaprateDerivativeLock;
        synchronized (object) {
            if (this.cachedLogSwaprateDerivative != null && liborPeriodDiscretization == this.cachedLogSwaprateDerivativeTimeDiscretization.get() && discountCurve == this.cachedLogSwaprateDerivativeDiscountCurve.get() && forwardCurve == this.cachedLogSwaprateDerivativeForwardCurve.get()) {
                return this.cachedLogSwaprateDerivative;
            }
            this.cachedLogSwaprateDerivativeTimeDiscretization = new WeakReference<TimeDiscretization>(liborPeriodDiscretization);
            this.cachedLogSwaprateDerivativeDiscountCurve = new WeakReference<DiscountCurve>(discountCurve);
            this.cachedLogSwaprateDerivativeForwardCurve = new WeakReference<ForwardCurve>(forwardCurve);
            if (discountCurve == null) {
                discountCurve = new DiscountCurveFromForwardCurve(forwardCurve.getName());
            }
            AnalyticModelFromCurvesAndVols model = new AnalyticModelFromCurvesAndVols(new Curve[]{forwardCurve, discountCurve});
            double swapStart = this.swapTenor[0];
            double swapEnd = this.swapTenor[this.swapTenor.length - 1];
            int swapStartIndex = liborPeriodDiscretization.getTimeIndex(swapStart);
            int swapEndIndex = liborPeriodDiscretization.getTimeIndex(swapEnd);
            double[] forwardRates = new double[swapEndIndex - swapStartIndex + 1];
            double[] discountFactors = new double[swapEndIndex - swapStartIndex + 1];
            discountFactors[0] = discountCurve.getDiscountFactor(model, swapStart);
            for (int liborPeriodIndex = swapStartIndex; liborPeriodIndex < swapEndIndex; ++liborPeriodIndex) {
                double libor;
                forwardRates[liborPeriodIndex - swapStartIndex] = libor = forwardCurve.getForward(model, liborPeriodDiscretization.getTime(liborPeriodIndex));
                discountFactors[liborPeriodIndex - swapStartIndex + 1] = discountCurve.getDiscountFactor(model, liborPeriodDiscretization.getTime(liborPeriodIndex + 1));
            }
            double[] swapAnnuities = new double[this.swapTenor.length - 1];
            double swapAnnuity = 0.0;
            for (int swapPeriodIndex = this.swapTenor.length - 2; swapPeriodIndex >= 0; --swapPeriodIndex) {
                int periodEndIndex = liborPeriodDiscretization.getTimeIndex(this.swapTenor[swapPeriodIndex + 1]);
                swapAnnuities[swapPeriodIndex] = swapAnnuity += discountFactors[periodEndIndex - swapStartIndex] * (this.swapTenor[swapPeriodIndex + 1] - this.swapTenor[swapPeriodIndex]);
            }
            double[] swapCovarianceWeights = new double[swapEndIndex - swapStartIndex];
            double valueFloatLeg = 0.0;
            for (int liborPeriodIndex = swapStartIndex; liborPeriodIndex < swapEndIndex; ++liborPeriodIndex) {
                double liborPeriodLength = liborPeriodDiscretization.getTimeStep(liborPeriodIndex);
                valueFloatLeg += forwardRates[liborPeriodIndex - swapStartIndex] * discountFactors[liborPeriodIndex - swapStartIndex + 1] * liborPeriodLength;
            }
            int swapPeriodIndex = 0;
            double valueFloatLegUpToSwapStart = 0.0;
            for (int liborPeriodIndex = swapStartIndex; liborPeriodIndex < swapEndIndex; ++liborPeriodIndex) {
                if (liborPeriodDiscretization.getTime(liborPeriodIndex) >= this.swapTenor[swapPeriodIndex + 1]) {
                    ++swapPeriodIndex;
                }
                double libor = forwardRates[liborPeriodIndex - swapStartIndex];
                double liborPeriodLength = liborPeriodDiscretization.getTimeStep(liborPeriodIndex);
                double discountFactorAtPeriodEnd = discountCurve.getDiscountFactor(model, liborPeriodDiscretization.getTime(liborPeriodIndex + 1));
                double derivativeFloatLeg = (discountFactorAtPeriodEnd + (valueFloatLegUpToSwapStart += forwardRates[liborPeriodIndex - swapStartIndex] * discountFactors[liborPeriodIndex - swapStartIndex + 1] * liborPeriodLength) - valueFloatLeg) * liborPeriodLength / (1.0 + libor * liborPeriodLength) / valueFloatLeg;
                double derivativeFixLeg = -swapAnnuities[swapPeriodIndex] / swapAnnuity * liborPeriodLength / (1.0 + libor * liborPeriodLength);
                swapCovarianceWeights[liborPeriodIndex - swapStartIndex] = (derivativeFloatLeg - derivativeFixLeg) * libor;
            }
            HashMap<String, double[]> results = new HashMap<String, double[]>();
            results.put("values", swapCovarianceWeights);
            results.put("discountFactors", discountFactors);
            results.put("swapAnnuities", swapAnnuities);
            this.cachedLogSwaprateDerivative = results;
            return results;
        }
    }
}

