/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.finmath.exception.CalculationException;
import net.finmath.functions.AnalyticFormulas;
import net.finmath.marketdata.products.Swap;
import net.finmath.marketdata.products.SwapAnnuity;
import net.finmath.modelling.products.Swaption;
import net.finmath.montecarlo.interestrate.TermStructureMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.montecarlo.process.ProcessTimeDiscretizationProvider;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.FloatingpointDate;
import net.finmath.time.Period;
import net.finmath.time.Schedule;
import net.finmath.time.TimeDiscretization;
import net.finmath.time.TimeDiscretizationFromArray;

public class SwaptionFromSwapSchedules
extends AbstractLIBORMonteCarloProduct
implements ProcessTimeDiscretizationProvider,
Swaption {
    private final SwaptionType swaptionType;
    private final LocalDate exerciseDate;
    private final Schedule scheduleFixedLeg;
    private final Schedule scheduleFloatLeg;
    private final double swaprate;
    private final double notional;
    private final Swaption.ValueUnit valueUnit;
    private final LocalDateTime referenceDate;

    public SwaptionFromSwapSchedules(LocalDateTime referenceDate, SwaptionType swaptionType, LocalDate exerciseDate, Schedule scheduleFixedLeg, Schedule scheduleFloatLeg, double swaprate, double notional, Swaption.ValueUnit valueUnit) {
        this.referenceDate = referenceDate;
        this.swaptionType = swaptionType;
        this.exerciseDate = exerciseDate;
        this.scheduleFixedLeg = scheduleFixedLeg;
        this.scheduleFloatLeg = scheduleFloatLeg;
        this.swaprate = swaprate;
        this.notional = notional;
        this.valueUnit = valueUnit;
    }

    @Override
    public RandomVariable getValue(double evaluationTime, TermStructureMonteCarloSimulationModel model) throws CalculationException {
        double atmSwaprate;
        RandomVariable values;
        LocalDate modelReferenceDate = null;
        try {
            modelReferenceDate = model.getReferenceDate().toLocalDate();
            if (modelReferenceDate == null) {
                modelReferenceDate = this.referenceDate.toLocalDate();
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        double exerciseTime = FloatingpointDate.getFloatingPointDateFromDate(modelReferenceDate, this.exerciseDate);
        RandomVariable discountedCashflowFixLeg = SwaptionFromSwapSchedules.getValueOfLegAnalytic(exerciseTime, model, this.scheduleFixedLeg, false, this.swaprate, this.notional);
        RandomVariable discountedCashflowFloatingLeg = SwaptionFromSwapSchedules.getValueOfLegAnalytic(exerciseTime, model, this.scheduleFloatLeg, true, 0.0, this.notional);
        if (this.swaptionType.equals((Object)SwaptionType.PAYER)) {
            values = discountedCashflowFloatingLeg.sub(discountedCashflowFixLeg);
        } else if (this.swaptionType.equals((Object)SwaptionType.RECEIVER)) {
            values = discountedCashflowFixLeg.sub(discountedCashflowFloatingLeg);
        } else {
            throw new IllegalArgumentException("Unkown swaptionType " + this.swaptionType);
        }
        values = values.floor(0.0);
        RandomVariable numeraire = model.getNumeraire(exerciseTime);
        RandomVariable monteCarloProbabilities = model.getMonteCarloWeights(exerciseTime);
        values = values.div(numeraire).mult(monteCarloProbabilities);
        RandomVariable numeraireAtZero = model.getNumeraire(evaluationTime);
        RandomVariable monteCarloProbabilitiesAtZero = model.getMonteCarloWeights(evaluationTime);
        values = values.mult(numeraireAtZero).div(monteCarloProbabilitiesAtZero);
        if (this.valueUnit == Swaption.ValueUnit.VALUE) {
            return values;
        }
        double forward = atmSwaprate = Swap.getForwardSwapRate(this.scheduleFixedLeg, this.scheduleFloatLeg, model.getModel().getForwardRateCurve(), model.getModel().getAnalyticModel());
        double optionStrike = this.swaprate;
        double optionMaturity = FloatingpointDate.getFloatingPointDateFromDate(modelReferenceDate, this.exerciseDate);
        double[] swapTenor = new double[this.scheduleFixedLeg.getNumberOfPeriods() + 1];
        for (int i = 0; i < this.scheduleFixedLeg.getNumberOfPeriods(); ++i) {
            swapTenor[i] = this.scheduleFixedLeg.getFixing(i);
        }
        swapTenor[this.scheduleFixedLeg.getNumberOfPeriods()] = this.scheduleFixedLeg.getPayment(this.scheduleFixedLeg.getNumberOfPeriods() - 1);
        double swapAnnuity = SwapAnnuity.getSwapAnnuity((TimeDiscretization)new TimeDiscretizationFromArray(swapTenor), model.getModel().getDiscountCurve());
        switch (this.valueUnit) {
            case VALUE: {
                return values;
            }
            case VOLATILITYNORMAL: {
                double volatitliy = AnalyticFormulas.bachelierOptionImpliedVolatility(forward, optionMaturity, optionStrike, swapAnnuity, values.getAverage());
                return model.getRandomVariableForConstant(volatitliy);
            }
            case VOLATILITYLOGNORMAL: {
                return model.getRandomVariableForConstant(AnalyticFormulas.blackScholesOptionImpliedVolatility(forward, optionMaturity, optionStrike, swapAnnuity, values.getAverage()));
            }
            case VOLATILITYNORMALATM: {
                RandomVariable annuity = SwaptionFromSwapSchedules.getValueOfLegAnalytic(evaluationTime, model, this.scheduleFixedLeg, false, 1.0, this.notional);
                annuity = annuity.div(numeraire).mult(monteCarloProbabilities).mult(numeraireAtZero).div(monteCarloProbabilitiesAtZero);
                return values.div(Math.sqrt(optionMaturity / Math.PI / 2.0)).div(annuity.average());
            }
        }
        throw new IllegalArgumentException("Unsupported valueUnit " + this.valueUnit.name());
    }

    @Override
    public TimeDiscretization getProcessTimeDiscretization(final LocalDateTime referenceDate) {
        HashSet<Double> times = new HashSet<Double>();
        times.add(FloatingpointDate.getFloatingPointDateFromDate(referenceDate, this.exerciseDate.atStartOfDay()));
        Function<Period, Double> periodToTime = new Function<Period, Double>(){

            @Override
            public Double apply(Period period) {
                return FloatingpointDate.getFloatingPointDateFromDate(referenceDate, period.getPayment().atStartOfDay());
            }
        };
        times.addAll(this.scheduleFixedLeg.getPeriods().stream().map(periodToTime).collect(Collectors.toList()));
        times.addAll(this.scheduleFloatLeg.getPeriods().stream().map(periodToTime).collect(Collectors.toList()));
        return new TimeDiscretizationFromArray(times);
    }

    public LocalDate getExerciseDate() {
        return this.exerciseDate;
    }

    public static RandomVariable getValueOfLegAnalytic(double evaluationTime, TermStructureMonteCarloSimulationModel model, Schedule schedule, boolean paysFloatingRate, double fixRate, double notional) throws CalculationException {
        LocalDate modelReferenceDate = null;
        try {
            modelReferenceDate = model.getReferenceDate().toLocalDate();
            if (modelReferenceDate == null) {
                modelReferenceDate = schedule.getReferenceDate();
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        RandomVariable discountedCashflowFloatingLeg = model.getRandomVariableForConstant(0.0);
        for (int peridIndex = schedule.getNumberOfPeriods() - 1; peridIndex >= 0; --peridIndex) {
            Period period = schedule.getPeriod(peridIndex);
            double paymentTime = FloatingpointDate.getFloatingPointDateFromDate(modelReferenceDate, period.getPayment());
            double fixingTime = FloatingpointDate.getFloatingPointDateFromDate(modelReferenceDate, period.getFixing());
            double periodLength = schedule.getPeriodLength(peridIndex);
            RandomVariable discountBond = model.getModel().getForwardDiscountBond(model.getProcess(), evaluationTime, paymentTime);
            if (paysFloatingRate) {
                RandomVariable libor = model.getForwardRate(evaluationTime, fixingTime, paymentTime);
                RandomVariable periodCashFlow = libor.mult(periodLength).mult(notional);
                discountedCashflowFloatingLeg = discountedCashflowFloatingLeg.add(periodCashFlow.mult(discountBond));
            }
            if (fixRate == 0.0) continue;
            RandomVariable periodCashFlow = model.getRandomVariableForConstant(fixRate * periodLength * notional);
            discountedCashflowFloatingLeg = discountedCashflowFloatingLeg.add(periodCashFlow.mult(discountBond));
        }
        return discountedCashflowFloatingLeg;
    }

    @Override
    public String toString() {
        return "SwaptionConditionalAnalytic [swaptionType=" + this.swaptionType + ", referenceDate=" + this.referenceDate + ", exerciseDate=" + this.exerciseDate + ", swaprate=" + this.swaprate + ", valueUnit=" + this.valueUnit + ", fixMetaSchedule=" + this.scheduleFixedLeg + ", floatMetaSchedule=" + this.scheduleFloatLeg + ", notional=" + this.notional + "]";
    }

    public static enum SwaptionType {
        PAYER,
        RECEIVER;

    }
}

