/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import net.finmath.exception.CalculationException;
import net.finmath.functions.AnalyticFormulas;
import net.finmath.marketdata.model.curves.DiscountCurve;
import net.finmath.marketdata.model.curves.ForwardCurve;
import net.finmath.marketdata.products.Swap;
import net.finmath.marketdata.products.SwapAnnuity;
import net.finmath.modelling.products.Swaption;
import net.finmath.montecarlo.interestrate.TermStructureMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.montecarlo.interestrate.products.Swaption;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.RegularSchedule;
import net.finmath.time.TimeDiscretization;
import net.finmath.time.TimeDiscretizationFromArray;

public class SwaptionSimple
extends AbstractLIBORMonteCarloProduct
implements net.finmath.modelling.products.Swaption {
    private final TimeDiscretization tenor;
    private final double swaprate;
    private final Swaption swaption;
    private final Swaption.ValueUnit valueUnit;

    public SwaptionSimple(double swaprate, TimeDiscretization swapTenor) {
        this(swaprate, swapTenor.getAsDoubleArray(), Swaption.ValueUnit.VALUE);
    }

    public SwaptionSimple(double swaprate, double[] swapTenor, Swaption.ValueUnit valueUnit) {
        this.tenor = new TimeDiscretizationFromArray(swapTenor);
        this.swaprate = swaprate;
        this.swaption = new Swaption(swapTenor[0], this.tenor, swaprate);
        this.valueUnit = valueUnit;
    }

    @Override
    public RandomVariable getValue(double evaluationTime, TermStructureMonteCarloSimulationModel model) throws CalculationException {
        double swapAnnuity;
        RandomVariable value = this.swaption.getValue(evaluationTime, model);
        if (this.valueUnit == Swaption.ValueUnit.VALUE) {
            return value;
        }
        ForwardCurve forwardCurve = model.getModel().getForwardRateCurve();
        DiscountCurve discountCurve = model.getModel().getAnalyticModel() != null ? model.getModel().getAnalyticModel().getDiscountCurve(forwardCurve.getDiscountCurveName()) : null;
        double parSwaprate = Swap.getForwardSwapRate(new RegularSchedule(this.tenor), new RegularSchedule(this.tenor), forwardCurve, model.getModel().getAnalyticModel());
        double optionMaturity = this.tenor.getTime(0);
        double strikeSwaprate = this.swaprate;
        double d = swapAnnuity = discountCurve != null ? SwapAnnuity.getSwapAnnuity(this.tenor, discountCurve) : SwapAnnuity.getSwapAnnuity(this.tenor, forwardCurve);
        if (this.valueUnit == Swaption.ValueUnit.VOLATILITYLOGNORMAL || this.valueUnit == Swaption.ValueUnit.VOLATILITY) {
            double volatility = AnalyticFormulas.blackScholesOptionImpliedVolatility(parSwaprate, optionMaturity, strikeSwaprate, swapAnnuity, value.getAverage());
            return model.getRandomVariableForConstant(volatility);
        }
        if (this.valueUnit == Swaption.ValueUnit.VOLATILITYNORMAL) {
            double volatility = AnalyticFormulas.bachelierOptionImpliedVolatility(parSwaprate, optionMaturity, strikeSwaprate, swapAnnuity, value.getAverage());
            return model.getRandomVariableForConstant(volatility);
        }
        if (this.valueUnit == Swaption.ValueUnit.INTEGRATEDVARIANCELOGNORMAL || this.valueUnit == Swaption.ValueUnit.INTEGRATEDVARIANCE || this.valueUnit == Swaption.ValueUnit.INTEGRATEDLOGNORMALVARIANCE) {
            double volatility = AnalyticFormulas.blackScholesOptionImpliedVolatility(parSwaprate, optionMaturity, strikeSwaprate, swapAnnuity, value.getAverage());
            return model.getRandomVariableForConstant(volatility * volatility * optionMaturity);
        }
        if (this.valueUnit == Swaption.ValueUnit.INTEGRATEDVARIANCENORMAL || this.valueUnit == Swaption.ValueUnit.INTEGRATEDNORMALVARIANCE) {
            double volatility = AnalyticFormulas.bachelierOptionImpliedVolatility(parSwaprate, optionMaturity, strikeSwaprate, swapAnnuity, value.getAverage());
            return model.getRandomVariableForConstant(volatility * volatility * optionMaturity);
        }
        throw new UnsupportedOperationException("Provided valueUnit not implemented.");
    }

    @Override
    public String toString() {
        return "SwaptionSimple [tenor=" + this.tenor + ", swaprate=" + this.swaprate + ", valueUnit=" + this.valueUnit + "]";
    }
}

