/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products.components;

import java.util.Set;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.TermStructureMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.products.components.AbstractProductComponent;
import net.finmath.montecarlo.interestrate.products.indices.AbstractIndex;
import net.finmath.montecarlo.interestrate.products.indices.AnalyticModelIndex;
import net.finmath.stochastic.RandomVariable;

public class AccrualAccount
extends AbstractProductComponent {
    private static final long serialVersionUID = 188297603697240319L;
    private AnalyticModelIndex pastFixings = null;
    private final AbstractIndex accrualIndex;
    private final double accrualPeriod;

    public AccrualAccount(String currency, AnalyticModelIndex pastFixings, AbstractIndex accrualIndex, double accrualPeriod) {
        super(currency);
        this.pastFixings = pastFixings;
        this.accrualIndex = accrualIndex;
        this.accrualPeriod = accrualPeriod;
    }

    @Override
    public Set<String> queryUnderlyings() {
        return this.accrualIndex.queryUnderlyings();
    }

    @Override
    public RandomVariable getValue(double evaluationTime, TermStructureMonteCarloSimulationModel model) throws CalculationException {
        if (evaluationTime <= 0.0) {
            return this.pastFixings.getValue(evaluationTime, model);
        }
        RandomVariable value = this.pastFixings.getValue(0.0, model);
        for (double time = 0.0; time < evaluationTime; time += this.accrualPeriod) {
            RandomVariable forwardRate = this.accrualIndex.getValue(time, model);
            double currentAccrualPeriod = Math.min(this.accrualPeriod, evaluationTime - time);
            value = value.accrue(forwardRate, currentAccrualPeriod);
        }
        return value;
    }
}

