/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products.components;

import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.TermStructureMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.products.components.AbstractPeriod;
import net.finmath.montecarlo.interestrate.products.components.Notional;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.FloatingpointDate;

public class AccruingNotional
implements Notional {
    private final Notional previousPeriodNotional;
    private final AbstractPeriod previousPeriod;

    public AccruingNotional(Notional previousPeriodNotional, AbstractPeriod previousPeriod) {
        this.previousPeriodNotional = previousPeriodNotional;
        this.previousPeriod = previousPeriod;
    }

    @Override
    public String getCurrency() {
        return this.previousPeriodNotional.getCurrency();
    }

    @Override
    public RandomVariable getNotionalAtPeriodStart(AbstractPeriod period, TermStructureMonteCarloSimulationModel model) throws CalculationException {
        double productToModelTimeOffset = 0.0;
        try {
            if (this.previousPeriod.getReferenceDate() != null) {
                productToModelTimeOffset = FloatingpointDate.getFloatingPointDateFromDate(model.getReferenceDate(), this.previousPeriod.getReferenceDate());
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        RandomVariable previousPeriodCoupon = this.previousPeriod.getCoupon(productToModelTimeOffset + this.previousPeriod.getFixingDate(), model);
        return this.previousPeriodNotional.getNotionalAtPeriodEnd(this.previousPeriod, model).mult(previousPeriodCoupon.add(1.0));
    }

    @Override
    public RandomVariable getNotionalAtPeriodEnd(AbstractPeriod period, TermStructureMonteCarloSimulationModel model) throws CalculationException {
        return this.getNotionalAtPeriodStart(period, model);
    }
}

